/*
 * Decompiled with CFR 0.152.
 */
package io.tidb.bigdata.tidb;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Base64;

final class Serialization {
    Serialization() {
    }

    static <T extends Serializable> String serialize(T o) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(o);
            oos.close();
            return Base64.getEncoder().encodeToString(baos.toByteArray());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    static <T extends Serializable> T deserialize(String base64) {
        try {
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(Base64.getDecoder().decode(base64)));
            return (T)((Serializable)ois.readObject());
        }
        catch (IOException | ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }
}

