/*
 * Decompiled with CFR 0.152.
 */
package io.tidb.bigdata.tidb;

import com.google.common.base.MoreObjects;
import io.tidb.bigdata.tidb.Base64KeyRange;
import io.tidb.bigdata.tidb.ClientSession;
import io.tidb.bigdata.tidb.SplitInternal;
import io.tidb.bigdata.tidb.TableHandleInternal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class SplitManagerInternal {
    private final ClientSession session;

    public SplitManagerInternal(ClientSession session) {
        this.session = Objects.requireNonNull(session, "session is null");
    }

    public List<SplitInternal> getSplits(TableHandleInternal tableHandle) {
        List splits = this.session.getTableRanges(tableHandle).stream().map(range -> new SplitInternal(tableHandle, (Base64KeyRange)range)).collect(Collectors.toCollection(ArrayList::new));
        Collections.shuffle(splits);
        return Collections.unmodifiableList(splits);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("session", (Object)this.session).toString();
    }
}

