/*
 * Decompiled with CFR 0.152.
 */
package io.tidb.bigdata.tidb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class SqlUtils {
    public static final String QUERY_PD_SQL = "SELECT `INSTANCE` FROM `INFORMATION_SCHEMA`.`CLUSTER_INFO` WHERE `TYPE` = 'pd'";

    private static List<String> concatNameType(List<String> columnNames, List<String> columnTypes, List<String> primaryKeyColumns, List<String> uniqueKeyColumns) {
        ArrayList<String> nameType = new ArrayList<String>(columnNames.size() + 1);
        for (int i = 0; i < columnNames.size(); ++i) {
            nameType.add(String.format("`%s` %s", columnNames.get(i), columnTypes.get(i)));
        }
        if (primaryKeyColumns != null && primaryKeyColumns.size() != 0) {
            nameType.add(String.format("PRIMARY KEY(%s)", primaryKeyColumns.stream().map(pk -> "`" + pk + "`").collect(Collectors.joining(","))));
        }
        if (uniqueKeyColumns != null && uniqueKeyColumns.size() != 0) {
            nameType.add(String.format("UNIQUE KEY(%s)", uniqueKeyColumns.stream().map(uk -> "`" + uk + "`").collect(Collectors.joining(","))));
        }
        return nameType;
    }

    public static String getCreateTableSql(String databaseName, String tableName, List<String> columnNames, List<String> columnTypes, List<String> primaryKeyColumns, List<String> uniqueKeyColumns, boolean ignoreIfExists) {
        return String.format("CREATE TABLE %s `%s`.`%s`(\n%s\n)", ignoreIfExists ? "IF NOT EXISTS" : "", databaseName, tableName, String.join((CharSequence)",\n", SqlUtils.concatNameType(columnNames, columnTypes, primaryKeyColumns, uniqueKeyColumns)));
    }

    public static String getInsertSql(String databaseName, String tableName, List<String> columnNames) {
        return String.format("INSERT INTO `%s`.`%s`(%s) VALUES(%s)", databaseName, tableName, columnNames.stream().map(name -> String.format("`%s`", name)).collect(Collectors.joining(",")), String.join((CharSequence)",", Collections.nCopies(columnNames.size(), "?")));
    }

    public static String getUpsertSql(String databaseName, String tableName, List<String> columnNames) {
        String insertSql = SqlUtils.getInsertSql(databaseName, tableName, columnNames);
        return String.format("%s ON DUPLICATE KEY UPDATE %s", insertSql, columnNames.stream().map(columnName -> String.format("`%s`=VALUES(`%s`)", columnName, columnName)).collect(Collectors.joining(",")));
    }
}

