/*
 * Decompiled with CFR 0.152.
 */
package io.tidb.bigdata.tidb;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Objects;

public class TableHandleInternal
implements Serializable {
    private final String connectorId;
    private final String schemaName;
    private final String tableName;

    public TableHandleInternal(String connectorId, String schemaName, String tableName) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
    }

    public String getSchemaTableName() {
        return Joiner.on((String)".").join((Object)this.getSchemaName(), (Object)this.getTableName(), new Object[0]);
    }

    public String getConnectorId() {
        return this.connectorId;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public int hashCode() {
        return Objects.hash(this.connectorId, this.schemaName, this.tableName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TableHandleInternal other = (TableHandleInternal)obj;
        return Objects.equals(this.connectorId, other.connectorId) && Objects.equals(this.schemaName, other.schemaName) && Objects.equals(this.tableName, other.tableName);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("connectorId", (Object)this.connectorId).add("schema", (Object)this.schemaName).add("table", (Object)this.tableName).toString();
    }
}

