/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.eam.boot.starter.config;

import io.tiklab.eam.author.Authenticator;
import io.tiklab.eam.boot.starter.config.EamClientCondition;
import io.tiklab.eam.electron.ElectronService;
import io.tiklab.eam.passport.dingding.service.DingDingPassportService;
import io.tiklab.eam.passport.ldap.service.LdapPassportService;
import io.tiklab.eam.passport.user.service.UserPassportService;
import io.tiklab.eam.passport.wechat.service.WeChatPassportService;
import io.tiklab.rpc.client.RpcClient;
import io.tiklab.rpc.client.config.RpcClientConfig;
import io.tiklab.rpc.client.router.lookup.FixedLookup;
import io.tiklab.rpc.client.router.lookup.Lookup;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.config.annotation.WebSocketConfigurer;

@Conditional(value={EamClientCondition.class})
@Configuration
@ComponentScan(value={"io.tiklab.eam.client", "io.tiklab.eam.author.controller", "io.tiklab.eam.electron.controller"})
public class EamClientAutoConfiguration {
    @Value(value="${eas.address:null}")
    String easAddress;

    RpcClient rpcClient() {
        RpcClientConfig rpcClientConfig = RpcClientConfig.instance();
        return new RpcClient(rpcClientConfig);
    }

    @Bean
    Authenticator authenticator() {
        return (Authenticator)this.rpcClient().getBean(Authenticator.class, (Lookup)new FixedLookup(this.easAddress));
    }

    @Bean
    WeChatPassportService weChatPassportService() {
        return (WeChatPassportService)this.rpcClient().getBean(WeChatPassportService.class, (Lookup)new FixedLookup(this.easAddress));
    }

    @Bean
    WebSocketHandler webSocketHandler() {
        return (WebSocketHandler)this.rpcClient().getBean(WebSocketHandler.class, (Lookup)new FixedLookup(this.easAddress));
    }

    @Bean
    ElectronService electronService() {
        return (ElectronService)this.rpcClient().getBean(ElectronService.class, (Lookup)new FixedLookup(this.easAddress));
    }

    @Bean
    WebSocketConfigurer webSocketConfigurer() {
        return (WebSocketConfigurer)this.rpcClient().getBean(WebSocketConfigurer.class, (Lookup)new FixedLookup(this.easAddress));
    }

    @Bean
    UserPassportService userPassportService() {
        return (UserPassportService)this.rpcClient().getBean(UserPassportService.class, (Lookup)new FixedLookup(this.easAddress));
    }

    @Bean
    LdapPassportService ldapPassportService() {
        return (LdapPassportService)this.rpcClient().getBean(LdapPassportService.class, (Lookup)new FixedLookup(this.easAddress));
    }

    @Bean
    DingDingPassportService dingDingPassportService() {
        return (DingDingPassportService)this.rpcClient().getBean(DingDingPassportService.class, (Lookup)new FixedLookup(this.easAddress));
    }
}

