/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.form.field.controller;

import io.tiklab.core.Result;
import io.tiklab.core.page.Pagination;
import io.tiklab.dal.jdbc.support.sort.model.Sort;
import io.tiklab.dal.jdbc.support.sort.processor.SortProcessor;
import io.tiklab.form.field.model.FieldEx;
import io.tiklab.form.field.model.FieldQuery;
import io.tiklab.form.field.service.FieldService;
import io.tiklab.postin.annotation.ApiMethod;
import io.tiklab.postin.annotation.ApiParam;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/field"})
public class FieldController {
    private static Logger logger = LoggerFactory.getLogger(FieldController.class);
    @Autowired
    private FieldService fieldService;
    @Autowired
    private SortProcessor sortProcessor;

    @RequestMapping(path={"/createField"}, method={RequestMethod.POST})
    @ApiMethod(name="createField", desc="\u521b\u5efa\u5b57\u6bb5")
    @ApiParam(name="field", desc="field", required=true)
    public Result<String> createField(@RequestBody @NotNull @Validated(value={FieldEx.Insert.class}) FieldEx field) {
        String id = this.fieldService.createFieldWithNest(field);
        return Result.ok((Object)id);
    }

    @RequestMapping(path={"/isExists"}, method={RequestMethod.POST})
    @ApiMethod(name="isExists", desc="\u68c0\u67e5\u540d\u79f0\u662f\u5426\u5df2\u7ecf\u5b58\u5728")
    @ApiParam(name="name", desc="name", required=true)
    public Result<Boolean> isExists(@NotNull String name) {
        boolean isExists = this.fieldService.isExists(name);
        return Result.ok((Object)isExists);
    }

    @RequestMapping(path={"/updateField"}, method={RequestMethod.POST})
    @ApiMethod(name="updateField", desc="\u66f4\u65b0\u5b57\u6bb5")
    @ApiParam(name="field", desc="field", required=true)
    public Result<Void> updateField(@RequestBody @NotNull @Validated(value={FieldEx.Update.class}) FieldEx field) {
        this.fieldService.updateField(field);
        return Result.ok();
    }

    @RequestMapping(path={"/deleteField"}, method={RequestMethod.POST})
    @ApiMethod(name="deleteField", desc="\u5220\u9664\u5b57\u6bb5")
    @ApiParam(name="id", desc="id", required=true)
    public Result<Void> deleteField(@NotNull String id) {
        this.fieldService.deleteField(id);
        return Result.ok();
    }

    @RequestMapping(path={"/findReferences"}, method={RequestMethod.POST})
    @ApiMethod(name="findReferences", desc="\u67e5\u627e\u5f15\u7528")
    @ApiParam(name="id", desc="id", required=true)
    public Result<Integer> findReferences(@NotNull String id) {
        int count = this.fieldService.findReferences(id);
        return Result.ok((Object)count);
    }

    @RequestMapping(path={"/findField"}, method={RequestMethod.POST})
    @ApiMethod(name="findField", desc="\u67e5\u627e\u5b57\u6bb5")
    @ApiParam(name="id", desc="id", required=true)
    public Result<FieldEx> findField(@NotNull String id) {
        FieldEx field = this.fieldService.findField(id);
        return Result.ok((Object)field);
    }

    @RequestMapping(path={"/findAllField"}, method={RequestMethod.POST})
    @ApiMethod(name="findAllField", desc="\u67e5\u627e\u6240\u6709\u5b57\u6bb5")
    public Result<List<FieldEx>> findAllField() {
        List fieldList = this.fieldService.findAllField();
        return Result.ok((Object)fieldList);
    }

    @RequestMapping(path={"/findFieldList"}, method={RequestMethod.POST})
    @ApiMethod(name="findFieldList", desc="\u6839\u636e\u67e5\u8be2\u5bf9\u8c61\u67e5\u627e\u5b57\u6bb5\u5217\u8868")
    @ApiParam(name="fieldQuery", desc="fieldQuery", required=true)
    public Result<List<FieldEx>> findFieldList(@RequestBody @NotNull @Valid FieldQuery fieldQuery) {
        List fieldList = this.fieldService.findFieldList(fieldQuery);
        return Result.ok((Object)fieldList);
    }

    @RequestMapping(path={"/findFieldPage"}, method={RequestMethod.POST})
    @ApiMethod(name="findFieldPage", desc="\u6839\u636e\u67e5\u8be2\u5bf9\u8c61\u6309\u5206\u9875\u67e5\u627e\u5b57\u6bb5\u5217\u8868")
    @ApiParam(name="fieldQuery", desc="fieldQuery", required=true)
    public Result<Pagination<FieldEx>> findFieldPage(@RequestBody @NotNull @Valid FieldQuery fieldQuery) {
        Pagination pagination = this.fieldService.findFieldPage(fieldQuery);
        return Result.ok((Object)pagination);
    }

    @RequestMapping(path={"/exchange"}, method={RequestMethod.POST})
    @ApiMethod(name="exchange", desc="\u4ea4\u6362\u6392\u5e8f")
    @ApiParam(name="exchange", desc="\u4ea4\u6362\u6392\u5e8fDTO", required=true)
    public Result<Void> exchange(@RequestBody @NotNull @Valid Sort sort) {
        this.sortProcessor.sort("foc_field", "id", "sort", sort);
        return Result.ok();
    }
}

