/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.form.field.controller;

import io.tiklab.core.Result;
import io.tiklab.core.page.Pagination;
import io.tiklab.form.field.model.FieldType;
import io.tiklab.form.field.model.FieldTypeQuery;
import io.tiklab.form.field.service.FieldTypeService;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/fieldType"})
public class FieldTypeController {
    private static Logger logger = LoggerFactory.getLogger(FieldTypeController.class);
    @Autowired
    private FieldTypeService fieldTypeService;

    @RequestMapping(path={"/createFieldType"}, method={RequestMethod.POST})
    public Result<String> createFieldType(@RequestBody @NotNull @Valid FieldType fieldType) {
        FieldTypeQuery fieldTypeQuery = new FieldTypeQuery();
        fieldTypeQuery.setCode(fieldType.getCode());
        fieldTypeQuery.setGroup(fieldType.getGroup());
        List fieldTypeList = this.fieldTypeService.findFieldTypeList(fieldTypeQuery);
        if (fieldTypeList.size() > 0) {
            return Result.error((int)6000, (String)("\u5b58\u5728" + fieldType.getGroup() + "\u7c7b\u578b\u4e2dcode\u503c:" + fieldType.getCode()));
        }
        String id = this.fieldTypeService.createFieldType(fieldType);
        return Result.ok((Object)id);
    }

    @RequestMapping(path={"/updateFieldType"}, method={RequestMethod.POST})
    public Result<Void> updateFieldType(@RequestBody @NotNull @Valid FieldType fieldType) {
        FieldTypeQuery fieldTypeQuery = new FieldTypeQuery();
        fieldTypeQuery.setCode(fieldType.getCode());
        fieldTypeQuery.setGroup(fieldType.getGroup());
        List fieldTypeList = this.fieldTypeService.findFieldTypeList(fieldTypeQuery);
        this.fieldTypeService.updateFieldType(fieldType);
        return Result.ok();
    }

    @RequestMapping(path={"/deleteFieldType"}, method={RequestMethod.POST})
    public Result<Void> deleteFieldType(@NotNull String id) {
        this.fieldTypeService.deleteFieldType(id);
        return Result.ok();
    }

    @RequestMapping(path={"/findFieldType"}, method={RequestMethod.POST})
    public Result<FieldType> findFieldType(@NotNull String id) {
        FieldType fieldType = this.fieldTypeService.findFieldType(id);
        return Result.ok((Object)fieldType);
    }

    @RequestMapping(path={"/findAllFieldType"}, method={RequestMethod.POST})
    public Result<List<FieldType>> findAllFieldType() {
        List fieldTypeList = this.fieldTypeService.findAllFieldType();
        return Result.ok((Object)fieldTypeList);
    }

    @RequestMapping(path={"/findFieldTypeList"}, method={RequestMethod.POST})
    public Result<List<FieldType>> findFieldTypeList(@RequestBody @Valid @NotNull FieldTypeQuery fieldTypeQuery) {
        List fieldTypeList = this.fieldTypeService.findFieldTypeList(fieldTypeQuery);
        return Result.ok((Object)fieldTypeList);
    }

    @RequestMapping(path={"/findFieldTypePage"}, method={RequestMethod.POST})
    public Result<Pagination<FieldType>> findFieldTypePage(@RequestBody @Valid @NotNull FieldTypeQuery fieldTypeQuery) {
        Pagination pagination = this.fieldTypeService.findFieldTypePage(fieldTypeQuery);
        return Result.ok((Object)pagination);
    }
}

