/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.form.field.controller;

import io.tiklab.core.Result;
import io.tiklab.core.page.Pagination;
import io.tiklab.form.field.model.SelectItem;
import io.tiklab.form.field.model.SelectItemQuery;
import io.tiklab.form.field.service.SelectItemService;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/selectItem"})
public class SelectItemController {
    private static Logger logger = LoggerFactory.getLogger(SelectItemController.class);
    @Autowired
    private SelectItemService selectItemService;

    @RequestMapping(path={"/createSelectItem"}, method={RequestMethod.POST})
    public Result<String> createSelectItem(@RequestBody @NotNull @Valid SelectItem selectItem) {
        String id = this.selectItemService.createSelectItem(selectItem);
        return Result.ok((Object)id);
    }

    @RequestMapping(path={"/updateSelectItem"}, method={RequestMethod.POST})
    public Result<Void> updateSelectItem(@RequestBody @NotNull @Valid SelectItem selectItem) {
        this.selectItemService.updateSelectItem(selectItem);
        return Result.ok();
    }

    @RequestMapping(path={"/deleteSelectItem"}, method={RequestMethod.POST})
    public Result<Void> deleteSelectItem(@NotNull String id) {
        this.selectItemService.deleteSelectItem(id);
        return Result.ok();
    }

    @RequestMapping(path={"/findSelectItem"}, method={RequestMethod.POST})
    public Result<SelectItem> findSelectItem(@NotNull String id) {
        SelectItem selectItem = this.selectItemService.findSelectItem(id);
        return Result.ok((Object)selectItem);
    }

    @RequestMapping(path={"/findAllSelectItem"}, method={RequestMethod.POST})
    public Result<List<SelectItem>> findAllSelectItem() {
        List selectItemList = this.selectItemService.findAllSelectItem();
        return Result.ok((Object)selectItemList);
    }

    @RequestMapping(path={"/findSelectItemList"}, method={RequestMethod.POST})
    public Result<List<SelectItem>> findSelectItemList(@RequestBody @Valid @NotNull SelectItemQuery selectItemQuery) {
        List selectItemList = this.selectItemService.findSelectItemList(selectItemQuery);
        return Result.ok((Object)selectItemList);
    }

    @RequestMapping(path={"/findSelectItemPage"}, method={RequestMethod.POST})
    public Result<Pagination<SelectItem>> findSelectItemPage(@RequestBody @Valid @NotNull SelectItemQuery selectItemQuery) {
        Pagination pagination = this.selectItemService.findSelectItemPage(selectItemQuery);
        return Result.ok((Object)pagination);
    }
}

