/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.form.field.dao;

import io.tiklab.core.page.Pagination;
import io.tiklab.dal.jpa.JpaTemplate;
import io.tiklab.dal.jpa.criterial.condition.QueryCondition;
import io.tiklab.dal.jpa.criterial.conditionbuilder.QueryBuilders;
import io.tiklab.form.field.entity.FieldExEntity;
import io.tiklab.form.field.model.FieldQuery;
import io.tiklab.form.form.entity.FormFieldEntity;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class FieldDao {
    private static Logger logger = LoggerFactory.getLogger(FieldDao.class);
    @Autowired
    JpaTemplate jpaTemplate;

    public String createField(FieldExEntity fieldEntity) {
        return (String)this.jpaTemplate.save((Object)fieldEntity, String.class);
    }

    public boolean isExists(String name) {
        QueryCondition queryCondition = QueryBuilders.createQuery(FieldExEntity.class).eq("name", (Object)name).count("name").get();
        Integer count = (Integer)this.jpaTemplate.findObject(queryCondition, Integer.class);
        return count > 0;
    }

    public void updateField(FieldExEntity fieldEntity) {
        this.jpaTemplate.update((Object)fieldEntity);
    }

    public void deleteField(String id) {
        this.jpaTemplate.delete(FieldExEntity.class, (Object)id);
    }

    public int findReferences(String id) {
        QueryCondition queryCondition = QueryBuilders.createQuery(FieldExEntity.class, (String)"f").leftJoin(FormFieldEntity.class, "ff", "f.id=ff.fieldId").count("f.id").get();
        Integer count = (Integer)this.jpaTemplate.findObject(queryCondition, Integer.class);
        return count;
    }

    public FieldExEntity findField(String id) {
        return (FieldExEntity)this.jpaTemplate.findOne(FieldExEntity.class, (Object)id);
    }

    public List<FieldExEntity> findAllField() {
        return this.jpaTemplate.findAll(FieldExEntity.class);
    }

    public List<FieldExEntity> findFieldList(List<String> idList) {
        return this.jpaTemplate.findList(FieldExEntity.class, idList);
    }

    public List<FieldExEntity> findFieldList(FieldQuery fieldQuery) {
        QueryCondition queryCondition = QueryBuilders.createQuery(FieldExEntity.class).like("name", (Object)fieldQuery.getName()).eq("code", (Object)fieldQuery.getCode()).eq("fieldType", (Object)fieldQuery.getFieldType()).orders(fieldQuery.getOrderParams()).get();
        return this.jpaTemplate.findList(queryCondition, FieldExEntity.class);
    }

    public Integer findFieldLists(FieldQuery fieldQuery) {
        String fieldType = fieldQuery.getFieldType();
        String sql = new String();
        sql = "select count(1) as sum from pcs_foc_field fi where fi.field_type = ?";
        Integer sum = (Integer)this.jpaTemplate.getJdbcTemplate().queryForObject(sql, (Object[])new String[]{fieldType}, Integer.class);
        return sum;
    }

    public Pagination<FieldExEntity> findFieldPage(FieldQuery fieldQuery) {
        QueryCondition queryCondition = QueryBuilders.createQuery(FieldExEntity.class).like("name", (Object)fieldQuery.getName()).eq("code", (Object)fieldQuery.getCode()).pagination(fieldQuery.getPageParam()).orders(fieldQuery.getOrderParams()).get();
        return this.jpaTemplate.findPage(queryCondition, FieldExEntity.class);
    }
}

