/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.form.field.dao;

import io.tiklab.core.page.Pagination;
import io.tiklab.dal.jpa.JpaTemplate;
import io.tiklab.dal.jpa.criterial.condition.QueryCondition;
import io.tiklab.dal.jpa.criterial.conditionbuilder.QueryBuilders;
import io.tiklab.form.field.entity.FieldTypeEntity;
import io.tiklab.form.field.model.FieldTypeQuery;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class FieldTypeDao {
    private static Logger logger = LoggerFactory.getLogger(FieldTypeDao.class);
    @Autowired
    JpaTemplate jpaTemplate;

    public String createFieldType(FieldTypeEntity fieldTypeEntity) {
        return (String)this.jpaTemplate.save((Object)fieldTypeEntity, String.class);
    }

    public void updateFieldType(FieldTypeEntity fieldTypeEntity) {
        this.jpaTemplate.update((Object)fieldTypeEntity);
    }

    public void deleteFieldType(String id) {
        this.jpaTemplate.delete(FieldTypeEntity.class, (Object)id);
    }

    public FieldTypeEntity findFieldType(String id) {
        return (FieldTypeEntity)this.jpaTemplate.findOne(FieldTypeEntity.class, (Object)id);
    }

    public List<FieldTypeEntity> findAllFieldType() {
        return this.jpaTemplate.findAll(FieldTypeEntity.class);
    }

    public List<FieldTypeEntity> findFieldTypeList(List<String> idList) {
        return this.jpaTemplate.findList(FieldTypeEntity.class, idList);
    }

    public List<FieldTypeEntity> findFieldTypeList(FieldTypeQuery fieldTypeQuery) {
        QueryCondition queryCondition = QueryBuilders.createQuery(FieldTypeEntity.class).like("name", (Object)fieldTypeQuery.getName()).eq("code", (Object)fieldTypeQuery.getCode()).eq("group", (Object)fieldTypeQuery.getGroup()).orders(fieldTypeQuery.getOrderParams()).get();
        return this.jpaTemplate.findList(queryCondition, FieldTypeEntity.class);
    }

    public Pagination<FieldTypeEntity> findFieldTypePage(FieldTypeQuery fieldTypeQuery) {
        QueryCondition queryCondition = QueryBuilders.createQuery(FieldTypeEntity.class).like("name", (Object)fieldTypeQuery.getName()).eq("code", (Object)fieldTypeQuery.getCode()).eq("group", (Object)fieldTypeQuery.getGroup()).pagination(fieldTypeQuery.getPageParam()).orders(fieldTypeQuery.getOrderParams()).get();
        return this.jpaTemplate.findPage(queryCondition, FieldTypeEntity.class);
    }
}

