/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.form.field.dao;

import io.tiklab.core.page.Pagination;
import io.tiklab.dal.jpa.JpaTemplate;
import io.tiklab.dal.jpa.criterial.condition.DeleteCondition;
import io.tiklab.dal.jpa.criterial.condition.QueryCondition;
import io.tiklab.dal.jpa.criterial.conditionbuilder.QueryBuilders;
import io.tiklab.form.field.entity.SelectItemEntity;
import io.tiklab.form.field.model.SelectItemQuery;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class SelectItemDao {
    private static Logger logger = LoggerFactory.getLogger(SelectItemDao.class);
    @Autowired
    JpaTemplate jpaTemplate;

    public String createSelectItem(SelectItemEntity selectItemEntity) {
        return (String)this.jpaTemplate.save((Object)selectItemEntity, String.class);
    }

    public void updateSelectItem(SelectItemEntity selectItemEntity) {
        this.jpaTemplate.update((Object)selectItemEntity);
    }

    public void deleteSelectItem(String id) {
        this.jpaTemplate.delete(SelectItemEntity.class, (Object)id);
    }

    public void deleteSelectItem(DeleteCondition deleteCondition) {
        this.jpaTemplate.delete(deleteCondition);
    }

    public SelectItemEntity findSelectItem(String id) {
        return (SelectItemEntity)this.jpaTemplate.findOne(SelectItemEntity.class, (Object)id);
    }

    public List<SelectItemEntity> findAllSelectItem() {
        return this.jpaTemplate.findAll(SelectItemEntity.class);
    }

    public List<SelectItemEntity> findSelectItemList(List<String> idList) {
        return this.jpaTemplate.findList(SelectItemEntity.class, idList);
    }

    public List<SelectItemEntity> findSelectItemList(SelectItemQuery selectItemQuery) {
        QueryCondition queryCondition = QueryBuilders.createQuery(SelectItemEntity.class).like("name", (Object)selectItemQuery.getName()).eq("fieldId", (Object)selectItemQuery.getFieldId()).orders(selectItemQuery.getOrderParams()).get();
        return this.jpaTemplate.findList(queryCondition, SelectItemEntity.class);
    }

    public Pagination<SelectItemEntity> findSelectItemPage(SelectItemQuery selectItemQuery) {
        QueryCondition queryCondition = QueryBuilders.createQuery(SelectItemEntity.class).like("name", (Object)selectItemQuery.getName()).eq("fieldId", (Object)selectItemQuery.getFieldId()).pagination(selectItemQuery.getPageParam()).orders(selectItemQuery.getOrderParams()).get();
        return this.jpaTemplate.findPage(queryCondition, SelectItemEntity.class);
    }
}

