/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.form.field.service;

import io.tiklab.beans.BeanMapper;
import io.tiklab.core.page.Pagination;
import io.tiklab.core.page.PaginationBuilder;
import io.tiklab.form.field.dao.FieldDao;
import io.tiklab.form.field.entity.FieldExEntity;
import io.tiklab.form.field.model.FieldEx;
import io.tiklab.form.field.model.FieldQuery;
import io.tiklab.form.field.model.SelectItem;
import io.tiklab.form.field.model.SelectItemQuery;
import io.tiklab.form.field.service.FieldService;
import io.tiklab.form.field.service.SelectItemService;
import io.tiklab.form.form.model.FormFieldQuery;
import io.tiklab.form.form.service.FormFieldService;
import io.tiklab.join.JoinTemplate;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class FieldServiceImpl
implements FieldService {
    @Autowired
    FieldDao fieldDao;
    @Autowired
    JoinTemplate joinTemplate;
    @Autowired
    SelectItemService selectItemService;
    @Autowired
    FormFieldService formFieldService;

    public String createField(@NotNull @Valid FieldEx field) {
        FieldExEntity fieldPo = (FieldExEntity)BeanMapper.map((Object)field, FieldExEntity.class);
        return this.fieldDao.createField(fieldPo);
    }

    public String createFieldWithNest(FieldEx field) {
        String id = this.createField(field);
        List selectItemList = field.getSelectItemList();
        if (selectItemList != null) {
            for (SelectItem selectItem : selectItemList) {
                selectItem.setField(new FieldEx().setId(id));
                this.selectItemService.createSelectItem(selectItem);
            }
        }
        return id;
    }

    public boolean isExists(String name) {
        return this.fieldDao.isExists(name);
    }

    public void updateField(@NotNull @Valid FieldEx field) {
        FieldExEntity fieldPo = (FieldExEntity)BeanMapper.map((Object)field, FieldExEntity.class);
        this.fieldDao.updateField(fieldPo);
    }

    public void deleteField(@NotNull String id) {
        this.fieldDao.deleteField(id);
        SelectItemQuery selectItemQuery = new SelectItemQuery();
        selectItemQuery.setFieldId(id);
        List selectItemList = this.selectItemService.findSelectItemList(selectItemQuery);
        if (selectItemList != null) {
            for (SelectItem selectItem : selectItemList) {
                this.selectItemService.deleteSelectItem(selectItem.getId());
            }
        }
    }

    public int findReferences(String id) {
        return this.fieldDao.findReferences(id);
    }

    public FieldEx findOne(String id) {
        FieldExEntity fieldPo = this.fieldDao.findField(id);
        FieldEx field = (FieldEx)BeanMapper.map((Object)fieldPo, FieldEx.class);
        return field;
    }

    public List<FieldEx> findList(List<String> idList) {
        List<FieldExEntity> fieldPoList = this.fieldDao.findFieldList(idList);
        List fieldList = BeanMapper.mapList(fieldPoList, FieldEx.class);
        return fieldList;
    }

    public FieldEx findField(@NotNull String id) {
        FieldEx field = this.findOne(id);
        if (field == null) {
            return null;
        }
        this.joinTemplate.joinQuery((Object)field);
        SelectItemQuery selectItemQuery = new SelectItemQuery();
        selectItemQuery.setFieldId(id);
        List selectItemList = this.selectItemService.findSelectItemList(selectItemQuery);
        if (selectItemList != null) {
            field.setSelectItemList(selectItemList);
        }
        return field;
    }

    public List<FieldEx> findAllField() {
        List<FieldExEntity> fieldPoList = this.fieldDao.findAllField();
        List fieldList = BeanMapper.mapList(fieldPoList, FieldEx.class);
        this.joinTemplate.joinQuery(fieldList);
        return fieldList;
    }

    public List<FieldEx> findFieldList(FieldQuery fieldQuery) {
        List<FieldExEntity> fieldPoList = this.fieldDao.findFieldList(fieldQuery);
        List fieldList = BeanMapper.mapList(fieldPoList, FieldEx.class);
        this.joinTemplate.joinQuery(fieldList);
        if (StringUtils.isEmpty((Object)fieldQuery.getCode())) {
            return fieldList;
        }
        for (FieldEx fieldEx : fieldList) {
            SelectItemQuery selectItemQuery = new SelectItemQuery();
            selectItemQuery.setFieldId(fieldEx.getId());
            List selectItemList = this.selectItemService.findSelectItemList(selectItemQuery);
            fieldEx.setSelectItemList(selectItemList);
        }
        return fieldList;
    }

    public Integer findFieldLists(FieldQuery fieldQuery) {
        Integer sum = this.fieldDao.findFieldLists(fieldQuery);
        return sum;
    }

    public Pagination<FieldEx> findFieldPage(FieldQuery fieldQuery) {
        Pagination<FieldExEntity> pagination = this.fieldDao.findFieldPage(fieldQuery);
        List fieldList = BeanMapper.mapList((List)pagination.getDataList(), FieldEx.class);
        for (FieldEx fieldEx : fieldList) {
            FormFieldQuery formFieldQuery = new FormFieldQuery();
            formFieldQuery.setFieldId(fieldEx.getId());
            Integer formFieldNum = this.formFieldService.findFormFieldLists(formFieldQuery);
            fieldEx.setFormRelationNum(formFieldNum);
        }
        this.joinTemplate.joinQuery(fieldList);
        return PaginationBuilder.build(pagination, (List)fieldList);
    }
}

