/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.form.field.service;

import io.tiklab.beans.BeanMapper;
import io.tiklab.core.page.Pagination;
import io.tiklab.core.page.PaginationBuilder;
import io.tiklab.form.field.dao.FieldTypeDao;
import io.tiklab.form.field.entity.FieldTypeEntity;
import io.tiklab.form.field.model.FieldQuery;
import io.tiklab.form.field.model.FieldType;
import io.tiklab.form.field.model.FieldTypeQuery;
import io.tiklab.form.field.service.FieldService;
import io.tiklab.form.field.service.FieldTypeService;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FieldTypeServiceImpl
implements FieldTypeService {
    @Autowired
    FieldTypeDao fieldTypeDao;
    @Autowired
    FieldService fieldService;

    public String createFieldType(@NotNull @Valid FieldType fieldType) {
        FieldTypeEntity fieldTypePo = (FieldTypeEntity)BeanMapper.map((Object)fieldType, FieldTypeEntity.class);
        return this.fieldTypeDao.createFieldType(fieldTypePo);
    }

    public void updateFieldType(@NotNull @Valid FieldType fieldType) {
        FieldTypeEntity fieldTypePo = (FieldTypeEntity)BeanMapper.map((Object)fieldType, FieldTypeEntity.class);
        this.fieldTypeDao.updateFieldType(fieldTypePo);
    }

    public void deleteFieldType(@NotNull String id) {
        this.fieldTypeDao.deleteFieldType(id);
    }

    public FieldType findOne(String id) {
        FieldTypeEntity fieldTypePo = this.fieldTypeDao.findFieldType(id);
        return (FieldType)BeanMapper.map((Object)fieldTypePo, FieldType.class);
    }

    public List<FieldType> findList(List<String> idList) {
        List<FieldTypeEntity> fieldTypePoList = this.fieldTypeDao.findFieldTypeList(idList);
        return BeanMapper.mapList(fieldTypePoList, FieldType.class);
    }

    public FieldType findFieldType(@NotNull String id) {
        return this.findOne(id);
    }

    public List<FieldType> findAllFieldType() {
        List<FieldTypeEntity> fieldTypePoList = this.fieldTypeDao.findAllFieldType();
        return BeanMapper.mapList(fieldTypePoList, FieldType.class);
    }

    public List<FieldType> findFieldTypeList(FieldTypeQuery fieldTypeQuery) {
        List<FieldTypeEntity> fieldTypePoList = this.fieldTypeDao.findFieldTypeList(fieldTypeQuery);
        List fieldTypes = BeanMapper.mapList(fieldTypePoList, FieldType.class);
        for (FieldType fieldType : fieldTypes) {
            String id = fieldType.getId();
            FieldQuery fieldQuery = new FieldQuery();
            fieldQuery.setFieldType(id);
            Integer fieldNum = this.fieldService.findFieldLists(fieldQuery);
            fieldType.setFieldRelationNum(fieldNum);
        }
        return fieldTypes;
    }

    public Pagination<FieldType> findFieldTypePage(FieldTypeQuery fieldTypeQuery) {
        Pagination<FieldTypeEntity> pagination = this.fieldTypeDao.findFieldTypePage(fieldTypeQuery);
        List fieldTypeList = BeanMapper.mapList((List)pagination.getDataList(), FieldType.class);
        return PaginationBuilder.build(pagination, (List)fieldTypeList);
    }
}

