/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.form.field.service;

import io.tiklab.beans.BeanMapper;
import io.tiklab.core.page.Pagination;
import io.tiklab.core.page.PaginationBuilder;
import io.tiklab.form.field.dao.SelectItemDao;
import io.tiklab.form.field.entity.SelectItemEntity;
import io.tiklab.form.field.model.SelectItem;
import io.tiklab.form.field.model.SelectItemQuery;
import io.tiklab.form.field.service.SelectItemService;
import io.tiklab.join.JoinTemplate;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SelectItemServiceImpl
implements SelectItemService {
    @Autowired
    SelectItemDao selectItemDao;
    @Autowired
    JoinTemplate joinTemplate;

    public String createSelectItem(@NotNull @Valid SelectItem selectItem) {
        SelectItemEntity selectItemPo = (SelectItemEntity)BeanMapper.map((Object)selectItem, SelectItemEntity.class);
        return this.selectItemDao.createSelectItem(selectItemPo);
    }

    public void updateSelectItem(@NotNull @Valid SelectItem selectItem) {
        SelectItemEntity selectItemPo = (SelectItemEntity)BeanMapper.map((Object)selectItem, SelectItemEntity.class);
        this.selectItemDao.updateSelectItem(selectItemPo);
    }

    public void deleteSelectItem(@NotNull String id) {
        this.selectItemDao.deleteSelectItem(id);
    }

    public SelectItem findOne(String id) {
        SelectItemEntity selectItemPo = this.selectItemDao.findSelectItem(id);
        SelectItem selectItem = (SelectItem)BeanMapper.map((Object)selectItemPo, SelectItem.class);
        return selectItem;
    }

    public List<SelectItem> findList(List<String> idList) {
        List<SelectItemEntity> selectItemPoList = this.selectItemDao.findSelectItemList(idList);
        List selectItemList = BeanMapper.mapList(selectItemPoList, SelectItem.class);
        return selectItemList;
    }

    public SelectItem findSelectItem(@NotNull String id) {
        SelectItem selectItem = this.findOne(id);
        this.joinTemplate.joinQuery((Object)selectItem);
        return selectItem;
    }

    public List<SelectItem> findAllSelectItem() {
        List<SelectItemEntity> selectItemPoList = this.selectItemDao.findAllSelectItem();
        List selectItemList = BeanMapper.mapList(selectItemPoList, SelectItem.class);
        this.joinTemplate.joinQuery(selectItemList);
        return selectItemList;
    }

    public List<SelectItem> findSelectItemList(SelectItemQuery selectItemQuery) {
        List<SelectItemEntity> selectItemPoList = this.selectItemDao.findSelectItemList(selectItemQuery);
        List selectItemList = BeanMapper.mapList(selectItemPoList, SelectItem.class);
        this.joinTemplate.joinQuery(selectItemList);
        return selectItemList;
    }

    public Pagination<SelectItem> findSelectItemPage(SelectItemQuery selectItemQuery) {
        Pagination<SelectItemEntity> pagination = this.selectItemDao.findSelectItemPage(selectItemQuery);
        List selectItemList = BeanMapper.mapList((List)pagination.getDataList(), SelectItem.class);
        this.joinTemplate.joinQuery(selectItemList);
        return PaginationBuilder.build(pagination, (List)selectItemList);
    }
}

