/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.form.form.controller;

import io.tiklab.core.Result;
import io.tiklab.core.page.Pagination;
import io.tiklab.form.form.model.DmForm;
import io.tiklab.form.form.model.DmFormQuery;
import io.tiklab.form.form.service.DmFormService;
import io.tiklab.postin.annotation.ApiMethod;
import io.tiklab.postin.annotation.ApiParam;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dmForm"})
public class DmFormController {
    private static Logger logger = LoggerFactory.getLogger(DmFormController.class);
    @Autowired
    private DmFormService dmFormService;

    @RequestMapping(path={"/createDmForm"}, method={RequestMethod.POST})
    @ApiMethod(name="createDmForm", desc="\u521b\u5efa\u9879\u76ee\u57df\u8868\u5355")
    @ApiParam(name="dmForm", desc="dmForm", required=true)
    public Result<String> createDmForm(@RequestBody @NotNull @Valid DmForm dmForm) {
        String id = this.dmFormService.createDmForm(dmForm);
        return Result.ok((Object)id);
    }

    @RequestMapping(path={"/updateDmForm"}, method={RequestMethod.POST})
    @ApiMethod(name="updateDmForm", desc="\u66f4\u65b0\u9879\u76ee\u57df\u8868\u5355")
    @ApiParam(name="dmForm", desc="dmForm", required=true)
    public Result<Void> updateDmForm(@RequestBody @NotNull @Valid DmForm dmForm) {
        this.dmFormService.updateDmForm(dmForm);
        return Result.ok();
    }

    @RequestMapping(path={"/deleteDmForm"}, method={RequestMethod.POST})
    @ApiMethod(name="deleteDmForm", desc="\u5220\u9664\u9879\u76ee\u57df\u8868\u5355")
    @ApiParam(name="id", desc="id", required=true)
    public Result<Void> deleteDmForm(@NotNull String id) {
        this.dmFormService.deleteDmForm(id);
        return Result.ok();
    }

    @RequestMapping(path={"/findDmForm"}, method={RequestMethod.POST})
    @ApiMethod(name="findDmForm", desc="\u67e5\u8be2\u9879\u76ee\u57df\u8868\u5355")
    @ApiParam(name="id", desc="id", required=true)
    public Result<DmForm> findDmForm(@NotNull String id) {
        DmForm dmForm = this.dmFormService.findDmForm(id);
        return Result.ok((Object)dmForm);
    }

    @RequestMapping(path={"/findAllDmForm"}, method={RequestMethod.POST})
    @ApiMethod(name="findAllDmForm", desc="\u67e5\u8be2\u6240\u6709\u9879\u76ee\u57df\u8868\u5355")
    public Result<List<DmForm>> findAllDmForm() {
        List dmFormList = this.dmFormService.findAllDmForm();
        return Result.ok((Object)dmFormList);
    }

    @RequestMapping(path={"/findDmFormList"}, method={RequestMethod.POST})
    @ApiMethod(name="findDmFormList", desc="\u67e5\u8be2\u9879\u76ee\u57df\u8868\u5355\u5217\u8868")
    @ApiParam(name="dmFormQuery", desc="dmFormQuery", required=true)
    public Result<List<DmForm>> findDmFormList(@RequestBody @Valid @NotNull DmFormQuery dmFormQuery) {
        List dmFormList = this.dmFormService.findDmFormList(dmFormQuery);
        return Result.ok((Object)dmFormList);
    }

    @RequestMapping(path={"/findDmFormPage"}, method={RequestMethod.POST})
    @ApiMethod(name="findDmFormPage", desc="\u5206\u9875\u67e5\u8be2\u9879\u76ee\u57df\u8868\u5355\u5217\u8868")
    @ApiParam(name="dmFormQuery", desc="dmFormQuery", required=true)
    public Result<Pagination<DmForm>> findDmFormPage(@RequestBody @Valid @NotNull DmFormQuery dmFormQuery) {
        Pagination pagination = this.dmFormService.findDmFormPage(dmFormQuery);
        return Result.ok((Object)pagination);
    }

    @RequestMapping(path={"/initDmFormsFromGlobal"}, method={RequestMethod.POST})
    @ApiMethod(name="initDmFormsFromGlobal", desc="\u6839\u636e\u5168\u5c40\u914d\u7f6e\u521d\u59cb\u5316\u9879\u76ee\u7ea7\u8868\u5355\u9879")
    @ApiParam(name="domainId", desc="\u4e1a\u52a1\u57dfID", required=true)
    public Result<Void> initDmFormsFromGlobal(@NotNull String domainId) {
        this.dmFormService.initDmForms(domainId);
        return Result.ok();
    }
}

