/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.form.form.controller;

import io.tiklab.core.Result;
import io.tiklab.core.page.Pagination;
import io.tiklab.form.form.model.Form;
import io.tiklab.form.form.model.FormQuery;
import io.tiklab.form.form.service.FormService;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/form"})
public class FormController {
    private static Logger logger = LoggerFactory.getLogger(FormController.class);
    @Autowired
    private FormService formService;

    @RequestMapping(path={"/createForm"}, method={RequestMethod.POST})
    public Result<String> createForm(@RequestBody @NotNull @Valid Form form) {
        String id = this.formService.createForm(form);
        return Result.ok((Object)id);
    }

    @RequestMapping(path={"/updateForm"}, method={RequestMethod.POST})
    public Result<Void> updateForm(@RequestBody @NotNull @Valid Form form) {
        this.formService.updateForm(form);
        return Result.ok();
    }

    @RequestMapping(path={"/setNormalForm"}, method={RequestMethod.POST})
    public Result<Void> setNormalForm(@NotNull String formId) {
        this.formService.setNormalForm(formId);
        return Result.ok();
    }

    @RequestMapping(path={"/setDefaultForm"}, method={RequestMethod.POST})
    public Result<Void> setDefaultForm(@NotNull String formId) {
        this.formService.setDefaultForm(formId);
        return Result.ok();
    }

    @RequestMapping(path={"/deleteForm"}, method={RequestMethod.POST})
    public Result<Void> deleteForm(@NotNull String id) {
        this.formService.deleteForm(id);
        return Result.ok();
    }

    @RequestMapping(path={"/findForm"}, method={RequestMethod.POST})
    public Result<Form> findForm(@NotNull String id) {
        Form form = this.formService.findForm(id);
        return Result.ok((Object)form);
    }

    @RequestMapping(path={"/findAllForm"}, method={RequestMethod.POST})
    public Result<List<Form>> findAllForm() {
        List formList = this.formService.findAllForm();
        return Result.ok((Object)formList);
    }

    @RequestMapping(path={"/findFormList"}, method={RequestMethod.POST})
    public Result<List<Form>> findFormList(@RequestBody @Valid @NotNull FormQuery formQuery) {
        List formList = this.formService.findFormList(formQuery);
        return Result.ok((Object)formList);
    }

    @RequestMapping(path={"/findFormPage"}, method={RequestMethod.POST})
    public Result<Pagination<Form>> findFormPage(@RequestBody @Valid @NotNull FormQuery formQuery) {
        Pagination pagination = this.formService.findFormPage(formQuery);
        return Result.ok((Object)pagination);
    }

    @RequestMapping(path={"/cloneForm"}, method={RequestMethod.POST})
    public Result<String> cloneForm(@NotNull String formId, @NotNull String formName) {
        String id = this.formService.cloneForm(formId, formName);
        return Result.ok((Object)id);
    }
}

