/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.form.form.controller;

import io.tiklab.core.Result;
import io.tiklab.core.page.Pagination;
import io.tiklab.dal.jdbc.support.sort.model.Sort;
import io.tiklab.dal.jdbc.support.sort.processor.SortProcessor;
import io.tiklab.form.form.model.FormField;
import io.tiklab.form.form.model.FormFieldQuery;
import io.tiklab.form.form.service.FormFieldService;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/formField"})
public class FormFieldController {
    private static Logger logger = LoggerFactory.getLogger(FormFieldController.class);
    @Autowired
    private FormFieldService formFieldService;
    @Autowired
    SortProcessor sortProcessor;

    @RequestMapping(path={"/createFormField"}, method={RequestMethod.POST})
    public Result<String> createFormField(@RequestBody @NotNull @Valid FormField formField) {
        String id = this.formFieldService.createFormField(formField);
        return Result.ok((Object)id);
    }

    @RequestMapping(path={"/updateFormField"}, method={RequestMethod.POST})
    public Result<Void> updateFormField(@RequestBody @NotNull @Valid FormField formField) {
        this.formFieldService.updateFormField(formField);
        return Result.ok();
    }

    @RequestMapping(path={"/deleteFormField"}, method={RequestMethod.POST})
    public Result<Void> deleteFormField(@NotNull String id) {
        this.formFieldService.deleteFormField(id);
        return Result.ok();
    }

    @RequestMapping(path={"/findFormField"}, method={RequestMethod.POST})
    public Result<FormField> findFormField(@NotNull String id) {
        FormField formField = this.formFieldService.findFormField(id);
        return Result.ok((Object)formField);
    }

    @RequestMapping(path={"/findAllFormField"}, method={RequestMethod.POST})
    public Result<List<FormField>> findAllFormField() {
        List formFieldList = this.formFieldService.findAllFormField();
        return Result.ok((Object)formFieldList);
    }

    @RequestMapping(path={"/findFormFieldList"}, method={RequestMethod.POST})
    public Result<List<FormField>> findFormFieldList(@RequestBody @Valid @NotNull FormFieldQuery formFieldQuery) {
        List formFieldList = this.formFieldService.findFormFieldList(formFieldQuery);
        return Result.ok((Object)formFieldList);
    }

    @RequestMapping(path={"/findFormFieldPage"}, method={RequestMethod.POST})
    public Result<Pagination<FormField>> findFormFieldPage(@RequestBody @Valid @NotNull FormFieldQuery formFieldQuery) {
        Pagination pagination = this.formFieldService.findFormFieldPage(formFieldQuery);
        return Result.ok((Object)pagination);
    }

    @RequestMapping(path={"/exchange"}, method={RequestMethod.POST})
    public Result<Void> exchange(@RequestBody @Valid @NotNull Sort sort) {
        this.sortProcessor.sort("foc_form_field", "id", "sort", sort);
        return Result.ok();
    }
}

