/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.form.form.dao;

import io.tiklab.core.order.Order;
import io.tiklab.core.order.OrderTypeEnum;
import io.tiklab.core.page.Pagination;
import io.tiklab.dal.jpa.JpaTemplate;
import io.tiklab.form.form.entity.DmFormEntity;
import io.tiklab.form.form.model.DmFormQuery;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class DmFormDao {
    private static Logger logger = LoggerFactory.getLogger(DmFormDao.class);
    @Autowired
    JpaTemplate jpaTemplate;

    public String createDmForm(DmFormEntity dmFormEntity) {
        return (String)this.jpaTemplate.save((Object)dmFormEntity, String.class);
    }

    public void updateDmForm(DmFormEntity dmFormEntity) {
        this.jpaTemplate.update((Object)dmFormEntity);
    }

    public void deleteDmForm(String id) {
        this.jpaTemplate.delete(DmFormEntity.class, (Object)id);
    }

    public DmFormEntity findDmForm(String id) {
        return (DmFormEntity)this.jpaTemplate.findOne(DmFormEntity.class, (Object)id);
    }

    public List<DmFormEntity> findAllDmForm() {
        return this.jpaTemplate.findAll(DmFormEntity.class);
    }

    public List<DmFormEntity> findDmFormList(List<String> idList) {
        return this.jpaTemplate.findList(DmFormEntity.class, idList);
    }

    public List<DmFormEntity> findDmFormList(DmFormQuery dmFormQuery) {
        Object sql = "SELECT dm.* FROM pcs_foc_dm_form AS dm LEFT JOIN pcs_foc_form AS f ON dm.form_id = f.id WHERE 1=1";
        ArrayList<Object> objects = new ArrayList<Object>();
        if (!StringUtils.isEmpty((Object)dmFormQuery.getDomainId())) {
            sql = (String)sql + " AND dm.domain_id = ?";
            objects.add(dmFormQuery.getDomainId());
        }
        if (!StringUtils.isEmpty((Object)dmFormQuery.getGlobalFormId())) {
            sql = (String)sql + " AND dm.global_form_id = ?";
            objects.add(dmFormQuery.getGlobalFormId());
        }
        if (!StringUtils.isEmpty((Object)dmFormQuery.getGroup())) {
            sql = (String)sql + " AND f.group = ?";
            objects.add(dmFormQuery.getGroup());
        }
        if (dmFormQuery.getDefaults() != null) {
            sql = (String)sql + " AND f.defaults = ?";
            objects.add(dmFormQuery.getDefaults());
        }
        if (!StringUtils.isEmpty((Object)dmFormQuery.getName())) {
            sql = (String)sql + " AND f.name LIKE ?";
            objects.add("%" + dmFormQuery.getName() + "%");
        }
        if (dmFormQuery.getOrderParams() != null & dmFormQuery.getOrderParams().size() > 0) {
            sql = (String)sql + " ORDER BY " + this.sqlOrderBy(dmFormQuery.getOrderParams());
        }
        Object[] questionIds = new Object[objects.size()];
        Object[] arg = objects.toArray(questionIds);
        List list = this.jpaTemplate.getJdbcTemplate().query((String)sql, arg, (RowMapper)new BeanPropertyRowMapper(DmFormEntity.class));
        return list;
    }

    public Pagination<DmFormEntity> findDmFormPage(DmFormQuery dmFormQuery) {
        Object sql = "SELECT domain.* FROM pcs_foc_dm_form AS domain LEFT JOIN pcs_foc_form AS f ON domain.form_id = f.id WHERE 1=1";
        ArrayList<Object> objects = new ArrayList<Object>();
        if (!StringUtils.isEmpty((Object)dmFormQuery.getDomainId())) {
            sql = (String)sql + " AND domain.domain_id = ?";
            objects.add(dmFormQuery.getDomainId());
        }
        if (!StringUtils.isEmpty((Object)dmFormQuery.getGroup())) {
            sql = (String)sql + " AND f.group = ?";
            objects.add(dmFormQuery.getGroup());
        }
        if (dmFormQuery.getDefaults() != null) {
            sql = (String)sql + " AND f.defaults = ?";
            objects.add(dmFormQuery.getDefaults());
        }
        if (!StringUtils.isEmpty((Object)dmFormQuery.getName())) {
            sql = (String)sql + " AND f.name LIKE ?";
            objects.add("%" + dmFormQuery.getName() + "%");
        }
        if (dmFormQuery.getOrderParams() != null & dmFormQuery.getOrderParams().size() > 0) {
            sql = (String)sql + " ORDER BY " + this.sqlOrderBy(dmFormQuery.getOrderParams());
        }
        Object[] questionIds = new Object[objects.size()];
        Object[] arg = objects.toArray(questionIds);
        return this.jpaTemplate.getJdbcTemplate().findPage((String)sql, arg, dmFormQuery.getPageParam(), (RowMapper)new BeanPropertyRowMapper(DmFormEntity.class));
    }

    public String sqlOrderBy(List<Order> orders) {
        StringBuilder sqldesc = new StringBuilder();
        for (int i = 0; i < orders.size(); ++i) {
            Order order1 = orders.get(i);
            String key = order1.getName();
            OrderTypeEnum orderType = order1.getOrderType();
            if (i + 1 == orders.size()) {
                sqldesc.append(key).append(" ").append(orderType);
                continue;
            }
            sqldesc.append(key).append(" ").append(orderType).append(',');
        }
        return sqldesc.toString();
    }
}

