/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.form.form.dao;

import io.tiklab.core.page.Pagination;
import io.tiklab.dal.jdbc.JdbcTemplate;
import io.tiklab.dal.jpa.JpaTemplate;
import io.tiklab.dal.jpa.criterial.condition.QueryCondition;
import io.tiklab.dal.jpa.criterial.conditionbuilder.QueryBuilders;
import io.tiklab.form.form.entity.FormEntity;
import io.tiklab.form.form.model.FormQuery;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class FormDao {
    private static Logger logger = LoggerFactory.getLogger(FormDao.class);
    @Autowired
    JpaTemplate jpaTemplate;

    public String createForm(FormEntity formEntity) {
        return (String)this.jpaTemplate.save((Object)formEntity, String.class);
    }

    public void updateForm(FormEntity formEntity) {
        this.jpaTemplate.update((Object)formEntity);
    }

    public void setDefaultForm(String formId) {
        JdbcTemplate jdbcTemplate = this.jpaTemplate.getJdbcTemplate();
        String sql = "update pcs_foc_form t set t.defaults=0 where 1=1";
        jdbcTemplate.update(sql);
        sql = "update pcs_foc_form t set t.defaults=1 where t.id=?";
        jdbcTemplate.update(sql, new Object[]{formId});
    }

    public void setNormalForm(String formId) {
        JdbcTemplate jdbcTemplate = this.jpaTemplate.getJdbcTemplate();
        String sql = "update pcs_foc_form t set t.defaults=2 where t.id=?";
        jdbcTemplate.update(sql, new Object[]{formId});
    }

    public void deleteForm(String id) {
        this.jpaTemplate.delete(FormEntity.class, (Object)id);
    }

    public FormEntity findForm(String id) {
        return (FormEntity)this.jpaTemplate.findOne(FormEntity.class, (Object)id);
    }

    public List<FormEntity> findAllForm() {
        return this.jpaTemplate.findAll(FormEntity.class);
    }

    public List<FormEntity> findFormList(List<String> idList) {
        return this.jpaTemplate.findList(FormEntity.class, idList);
    }

    public List<FormEntity> findFormList(FormQuery formQuery) {
        QueryCondition queryCondition = QueryBuilders.createQuery(FormEntity.class).like("name", (Object)formQuery.getName()).eq("group", (Object)formQuery.getGroup()).eq("defaults", (Object)formQuery.getDefaults()).eq("scope", (Object)formQuery.getScope()).orders(formQuery.getOrderParams()).get();
        return this.jpaTemplate.findList(queryCondition, FormEntity.class);
    }

    public Pagination<FormEntity> findFormPage(FormQuery formQuery) {
        QueryCondition queryCondition = QueryBuilders.createQuery(FormEntity.class).like("name", (Object)formQuery.getName()).eq("group", (Object)formQuery.getGroup()).eq("defaults", (Object)formQuery.getDefaults()).eq("scope", (Object)formQuery.getScope()).pagination(formQuery.getPageParam()).orders(formQuery.getOrderParams()).get();
        return this.jpaTemplate.findPage(queryCondition, FormEntity.class);
    }
}

