/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.form.form.dao;

import io.tiklab.core.page.Pagination;
import io.tiklab.dal.jpa.JpaTemplate;
import io.tiklab.dal.jpa.criterial.condition.DeleteCondition;
import io.tiklab.dal.jpa.criterial.condition.QueryCondition;
import io.tiklab.dal.jpa.criterial.conditionbuilder.QueryBuilders;
import io.tiklab.form.field.entity.FieldExEntity;
import io.tiklab.form.form.entity.FormFieldEntity;
import io.tiklab.form.form.model.FormFieldQuery;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class FormFieldDao {
    private static Logger logger = LoggerFactory.getLogger(FormFieldDao.class);
    @Autowired
    JpaTemplate jpaTemplate;

    public String createFormField(FormFieldEntity formFieldEntity) {
        Integer max = this.findMax(formFieldEntity.getFormId());
        formFieldEntity.setSort(max + 1);
        return (String)this.jpaTemplate.save((Object)formFieldEntity, String.class);
    }

    Integer findMax(String formId) {
        QueryCondition queryCondition = QueryBuilders.createQuery(FormFieldEntity.class).eq("formId", (Object)formId).max("sort").get();
        Integer max = (Integer)this.jpaTemplate.findObject(queryCondition, Integer.class);
        if (max == null) {
            return 0;
        }
        return max;
    }

    public void updateFormField(FormFieldEntity formFieldEntity) {
        this.jpaTemplate.update((Object)formFieldEntity);
    }

    public void deleteFormField(String id) {
        this.jpaTemplate.delete(FormFieldEntity.class, (Object)id);
    }

    public void deleteFormFieldList(DeleteCondition deleteCondition) {
        this.jpaTemplate.delete(deleteCondition);
    }

    public FormFieldEntity findFormField(String id) {
        return (FormFieldEntity)this.jpaTemplate.findOne(FormFieldEntity.class, (Object)id);
    }

    public List<FormFieldEntity> findAllFormField() {
        return this.jpaTemplate.findAll(FormFieldEntity.class);
    }

    public List<FormFieldEntity> findFormFieldList(FormFieldQuery formFieldQuery) {
        QueryCondition queryCondition = QueryBuilders.createQuery(FormFieldEntity.class, (String)"ff").leftJoin(FieldExEntity.class, "f", "ff.fieldId=f.id").eq("ff.formId", (Object)formFieldQuery.getFormId()).orders(formFieldQuery.getOrderParams()).get();
        return this.jpaTemplate.findList(queryCondition, FormFieldEntity.class);
    }

    public Integer findFormFieldLists(FormFieldQuery formFieldQuery) {
        String fieldId = formFieldQuery.getFieldId();
        String sql = new String();
        sql = "select count(1) as sum from pcs_foc_form_field fm where fm.field_id = ?";
        Integer sum = (Integer)this.jpaTemplate.getJdbcTemplate().queryForObject(sql, (Object[])new String[]{fieldId}, Integer.class);
        return sum;
    }

    public Pagination<FormFieldEntity> findFormFieldPage(FormFieldQuery formFieldQuery) {
        QueryCondition queryCondition = QueryBuilders.createQuery(FormFieldEntity.class, (String)"ff").leftJoin(FieldExEntity.class, "f", "ff.fieldId=f.id").eq("ff.formId", (Object)formFieldQuery.getFormId()).pagination(formFieldQuery.getPageParam()).orders(formFieldQuery.getOrderParams()).get();
        return this.jpaTemplate.findPage(queryCondition, FormFieldEntity.class);
    }
}

