/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.form.form.service;

import io.tiklab.beans.BeanMapper;
import io.tiklab.core.exception.ApplicationException;
import io.tiklab.core.page.Pagination;
import io.tiklab.core.page.PaginationBuilder;
import io.tiklab.form.field.model.FieldEx;
import io.tiklab.form.form.dao.DmFormDao;
import io.tiklab.form.form.entity.DmFormEntity;
import io.tiklab.form.form.model.DmForm;
import io.tiklab.form.form.model.DmFormQuery;
import io.tiklab.form.form.model.Form;
import io.tiklab.form.form.model.FormField;
import io.tiklab.form.form.model.FormFieldQuery;
import io.tiklab.form.form.model.FormQuery;
import io.tiklab.form.form.service.DmFormService;
import io.tiklab.form.form.service.FormFieldService;
import io.tiklab.form.form.service.FormService;
import io.tiklab.join.JoinTemplate;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class DmFormServiceImpl
implements DmFormService {
    @Autowired
    DmFormDao dmFormDao;
    @Autowired
    JoinTemplate joinTemplate;
    @Autowired
    FormService formService;
    @Autowired
    FormFieldService formFieldService;

    public String createDmForm(@NotNull @Valid DmForm dmForm) {
        Form form = dmForm.getForm();
        form.setScope(Integer.valueOf(2));
        form.setGroup("custom");
        String formId = this.formService.createForm(form);
        Form form1 = new Form();
        form1.setId(formId);
        dmForm.setForm(form1);
        DmFormEntity dmFormPo = (DmFormEntity)BeanMapper.map((Object)dmForm, DmFormEntity.class);
        String id = this.dmFormDao.createDmForm(dmFormPo);
        String normalForm = form.getNormalForm();
        if (!StringUtils.isEmpty((Object)normalForm)) {
            FormField formField1 = new FormField();
            Form form2 = new Form();
            form2.setId(id);
            formField1.setForm(form2);
            FormFieldQuery formFieldQuery = new FormFieldQuery();
            formFieldQuery.setFormId(normalForm);
            List formFieldList = this.formFieldService.findFormFieldList(formFieldQuery);
            for (FormField formField : formFieldList) {
                FieldEx field = formField.getField();
                String group = field.getGroup();
                if (!Objects.equals(group, "system")) continue;
                FieldEx fieldEx = new FieldEx();
                fieldEx.setId(field.getId());
                formField1.setField(fieldEx);
                this.formFieldService.createFormField(formField1);
            }
        }
        return id;
    }

    public void updateDmForm(@NotNull @Valid DmForm dmForm) {
        this.formService.updateForm(dmForm.getForm());
    }

    public void deleteDmForm(@NotNull String id) {
        DmForm dmForm = this.findOne(id);
        Form form = dmForm.getForm();
        this.formService.deleteForm(form.getId());
        this.dmFormDao.deleteDmForm(id);
    }

    public DmForm findOne(String id) {
        DmFormEntity dmFormPo = this.dmFormDao.findDmForm(id);
        DmForm dmForm = (DmForm)BeanMapper.map((Object)dmFormPo, DmForm.class);
        return dmForm;
    }

    public List<DmForm> findList(List<String> idList) {
        List<DmFormEntity> dmFormPoList = this.dmFormDao.findDmFormList(idList);
        List dmFormList = BeanMapper.mapList(dmFormPoList, DmForm.class);
        return dmFormList;
    }

    public DmForm findDmForm(@NotNull String id) {
        DmForm dmForm = this.findOne(id);
        this.joinTemplate.joinQuery((Object)dmForm);
        return dmForm;
    }

    public List<DmForm> findAllDmForm() {
        List<DmFormEntity> dmFormPoList = this.dmFormDao.findAllDmForm();
        List dmFormList = BeanMapper.mapList(dmFormPoList, DmForm.class);
        this.joinTemplate.joinQuery(dmFormList);
        return dmFormList;
    }

    public List<DmForm> findDmFormList(DmFormQuery dmFormQuery) {
        List<DmFormEntity> dmFormPoList = this.dmFormDao.findDmFormList(dmFormQuery);
        List dmFormList = BeanMapper.mapList(dmFormPoList, DmForm.class);
        this.joinTemplate.joinQuery(dmFormList);
        return dmFormList;
    }

    public Pagination<DmForm> findDmFormPage(DmFormQuery dmFormQuery) {
        Pagination<DmFormEntity> pagination = this.dmFormDao.findDmFormPage(dmFormQuery);
        List dmFormList = BeanMapper.mapList((List)pagination.getDataList(), DmForm.class);
        this.joinTemplate.joinQuery(dmFormList);
        return PaginationBuilder.build(pagination, (List)dmFormList);
    }

    public void initDmForms(String domainId) {
        FormQuery formQuery = new FormQuery();
        formQuery.setGroup("system");
        List formList = this.formService.findFormList(formQuery);
        if (formList == null || formList.size() == 0) {
            return;
        }
        for (Form form : formList) {
            Form newForm = this.cloneForm(form);
            DmForm dmForm = new DmForm();
            dmForm.setDomainId(domainId);
            dmForm.setForm(newForm);
            dmForm.setGlobalFormId(form.getId());
            DmFormEntity dmFormPo = (DmFormEntity)BeanMapper.map((Object)dmForm, DmFormEntity.class);
            this.dmFormDao.createDmForm(dmFormPo);
        }
    }

    public Form cloneForm(Form form) {
        String formId = form.getId();
        Form newForm = form;
        newForm.setId(null);
        newForm.setScope(Integer.valueOf(2));
        String newFormId = this.formService.createForm(newForm);
        newForm.setId(newFormId);
        FormFieldQuery formFieldQuery = new FormFieldQuery();
        formFieldQuery.setFormId(formId);
        List formFieldList = this.formFieldService.findFormFieldList(formFieldQuery);
        if (formFieldList == null || formFieldList.size() == 0) {
            return newForm;
        }
        Iterator iterator = formFieldList.iterator();
        while (iterator.hasNext()) {
            FormField formField;
            FormField newFormField = formField = (FormField)iterator.next();
            newFormField.setId(null);
            newFormField.setForm(newForm);
            this.formFieldService.createFormField(newFormField);
        }
        return newForm;
    }

    public String cloneFormById(String formId, String domainId) {
        Form newForm = this.formService.findForm(formId);
        newForm.setId(null);
        newForm.setScope(Integer.valueOf(2));
        String newFormId = this.formService.createForm(newForm);
        newForm.setId(newFormId);
        FormFieldQuery formFieldQuery = new FormFieldQuery();
        formFieldQuery.setFormId(formId);
        List formFieldList = this.formFieldService.findFormFieldList(formFieldQuery);
        Iterator iterator = formFieldList.iterator();
        while (iterator.hasNext()) {
            FormField formField;
            FormField newFormField = formField = (FormField)iterator.next();
            newFormField.setId(null);
            newFormField.setForm(newForm);
            this.formFieldService.createFormField(newFormField);
        }
        DmForm dmForm = new DmForm();
        dmForm.setDomainId(domainId);
        dmForm.setForm(newForm);
        dmForm.setGlobalFormId(formId);
        DmFormEntity dmFormPo = (DmFormEntity)BeanMapper.map((Object)dmForm, DmFormEntity.class);
        this.dmFormDao.createDmForm(dmFormPo);
        return formId;
    }

    public DmForm existDmForm(DmFormQuery dmFormQuery) {
        if (StringUtils.isEmpty((Object)dmFormQuery.getGlobalFormId()) && StringUtils.isEmpty((Object)dmFormQuery.getDomainId())) {
            throw new ApplicationException(5000, "\u7f3a\u5931 globalFormId, domainId");
        }
        List<DmForm> dmFormList = this.findDmFormList(dmFormQuery);
        if (dmFormList.size() > 0) {
            DmForm dmForm = dmFormList.get(0);
            return dmForm;
        }
        return null;
    }
}

