/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.form.form.service;

import io.tiklab.beans.BeanMapper;
import io.tiklab.core.page.Pagination;
import io.tiklab.core.page.PaginationBuilder;
import io.tiklab.dal.jpa.criterial.condition.DeleteCondition;
import io.tiklab.dal.jpa.criterial.conditionbuilder.DeleteBuilders;
import io.tiklab.form.field.model.FieldEx;
import io.tiklab.form.form.dao.FormFieldDao;
import io.tiklab.form.form.entity.FormFieldEntity;
import io.tiklab.form.form.model.Form;
import io.tiklab.form.form.model.FormField;
import io.tiklab.form.form.model.FormFieldQuery;
import io.tiklab.form.form.service.FormFieldService;
import io.tiklab.join.JoinTemplate;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FormFieldServiceImpl
implements FormFieldService {
    @Autowired
    FormFieldDao formFieldDao;
    @Autowired
    JoinTemplate joinTemplate;

    public String createFormField(@NotNull @Valid FormField formField) {
        FormFieldEntity formFieldPo = (FormFieldEntity)BeanMapper.map((Object)formField, FormFieldEntity.class);
        return this.formFieldDao.createFormField(formFieldPo);
    }

    public void updateFormField(@NotNull @Valid FormField formField) {
        FormFieldEntity formFieldPo = (FormFieldEntity)BeanMapper.map((Object)formField, FormFieldEntity.class);
        this.formFieldDao.updateFormField(formFieldPo);
    }

    public void deleteFormField(@NotNull String id) {
        this.formFieldDao.deleteFormField(id);
    }

    public void deleteFormFieldByFormId(String formId) {
        DeleteCondition deleteCondition = DeleteBuilders.createDelete(FormFieldEntity.class).eq("formId", (Object)formId).get();
        this.formFieldDao.deleteFormFieldList(deleteCondition);
    }

    public FormField findFormField(@NotNull String id) {
        FormFieldEntity formFieldPo = this.formFieldDao.findFormField(id);
        FormField formField = (FormField)BeanMapper.map((Object)formFieldPo, FormField.class);
        this.joinTemplate.joinQuery((Object)formField);
        return formField;
    }

    public List<FormField> findAllFormField() {
        List<FormFieldEntity> formFieldPoList = this.formFieldDao.findAllFormField();
        List formFieldList = BeanMapper.mapList(formFieldPoList, FormField.class);
        this.joinTemplate.joinQuery(formFieldList);
        return formFieldList;
    }

    public List<FormField> findFormFieldList(FormFieldQuery formFieldQuery) {
        List<FormFieldEntity> formFieldPoList = this.formFieldDao.findFormFieldList(formFieldQuery);
        List formFieldList = BeanMapper.mapList(formFieldPoList, FormField.class);
        this.joinTemplate.joinQuery(formFieldList);
        if (formFieldList != null) {
            for (FormField formField : formFieldList) {
                FieldEx field = formField.getField();
                this.joinTemplate.joinQuery((Object)field);
            }
        }
        return formFieldList;
    }

    public Integer findFormFieldLists(FormFieldQuery formFieldQuery) {
        Integer formFieldNum = this.formFieldDao.findFormFieldLists(formFieldQuery);
        return formFieldNum;
    }

    public Pagination<FormField> findFormFieldPage(FormFieldQuery formFieldQuery) {
        Pagination<FormFieldEntity> pagination = this.formFieldDao.findFormFieldPage(formFieldQuery);
        List formFieldList = BeanMapper.mapList((List)pagination.getDataList(), FormField.class);
        this.joinTemplate.joinQuery(formFieldList);
        if (formFieldList != null) {
            for (FormField formField : formFieldList) {
                Form form = formField.getForm();
                this.joinTemplate.joinQuery((Object)form);
            }
        }
        return PaginationBuilder.build(pagination, (List)formFieldList);
    }
}

