/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.form.form.service;

import io.tiklab.beans.BeanMapper;
import io.tiklab.core.page.Pagination;
import io.tiklab.core.page.PaginationBuilder;
import io.tiklab.form.field.model.FieldEx;
import io.tiklab.form.field.service.FieldService;
import io.tiklab.form.form.dao.FormDao;
import io.tiklab.form.form.entity.FormEntity;
import io.tiklab.form.form.model.Form;
import io.tiklab.form.form.model.FormField;
import io.tiklab.form.form.model.FormFieldQuery;
import io.tiklab.form.form.model.FormQuery;
import io.tiklab.form.form.service.FormFieldService;
import io.tiklab.form.form.service.FormService;
import io.tiklab.join.JoinTemplate;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class FormServiceImpl
implements FormService {
    public static final String GROUP_SYSTEM = "system";
    public static final String GROUP_CUSTOM = "custom";
    @Autowired
    FormDao formDao;
    @Autowired
    FormFieldService formFieldService;
    @Autowired
    FieldService fieldService;
    @Autowired
    JoinTemplate joinTemplate;

    public String createForm(@NotNull @Valid Form form) {
        FormEntity formPo = (FormEntity)BeanMapper.map((Object)form, FormEntity.class);
        String id = this.formDao.createForm(formPo);
        String normalForm = form.getNormalForm();
        if (!StringUtils.isEmpty((Object)normalForm)) {
            FormField formField1 = new FormField();
            Form form1 = new Form();
            form1.setId(id);
            formField1.setForm(form1);
            FormFieldQuery formFieldQuery = new FormFieldQuery();
            formFieldQuery.setFormId(normalForm);
            List formFieldList = this.formFieldService.findFormFieldList(formFieldQuery);
            for (FormField formField : formFieldList) {
                FieldEx field = formField.getField();
                String group = field.getGroup();
                if (!Objects.equals(group, GROUP_SYSTEM)) continue;
                FieldEx fieldEx = new FieldEx();
                fieldEx.setId(field.getId());
                formField1.setField(fieldEx);
                this.formFieldService.createFormField(formField1);
            }
        }
        return id;
    }

    public void updateForm(@NotNull @Valid Form form) {
        FormEntity formPo = (FormEntity)BeanMapper.map((Object)form, FormEntity.class);
        this.formDao.updateForm(formPo);
    }

    public void setDefaultForm(String formId) {
        this.formDao.setDefaultForm(formId);
    }

    public void setNormalForm(String formId) {
        this.formDao.setNormalForm(formId);
    }

    public void deleteForm(@NotNull String id) {
        this.formDao.deleteForm(id);
        this.formFieldService.deleteFormFieldByFormId(id);
    }

    public Form findOne(String id) {
        FormEntity formPo = this.formDao.findForm(id);
        return (Form)BeanMapper.map((Object)formPo, Form.class);
    }

    public List<Form> findList(List<String> idList) {
        List<FormEntity> formPoList = this.formDao.findFormList(idList);
        return BeanMapper.mapList(formPoList, Form.class);
    }

    public Form findForm(@NotNull String id) {
        return this.findOne(id);
    }

    public Form findFormWithNest(FormQuery formQuery) {
        String id = formQuery.getId();
        if (StringUtils.isEmpty((Object)id)) {
            return null;
        }
        Form form = this.findForm(id);
        if (form == null) {
            return null;
        }
        FormFieldQuery formFieldQuery = new FormFieldQuery();
        formFieldQuery.setFormId(id);
        List formFieldList = this.formFieldService.findFormFieldList(formFieldQuery);
        if (formFieldList == null || formFieldList.size() == 0) {
            return form;
        }
        block8: for (FormField formField : formFieldList) {
            FieldEx fieldWithItems;
            FieldEx field = formField.getField();
            if (field == null || (fieldWithItems = this.fieldService.findField(field.getId())) == null) continue;
            String group = formQuery.getGroup();
            String fieldTypeGroup = fieldWithItems.getGroup();
            switch (group) {
                case "system": {
                    if (!Objects.equals(fieldTypeGroup, GROUP_SYSTEM)) continue block8;
                    form.getFieldList().add(fieldWithItems);
                    continue block8;
                }
                case "custom": {
                    if (!Objects.equals(fieldTypeGroup, GROUP_CUSTOM)) continue block8;
                    form.getCustomFieldList().add(fieldWithItems);
                    continue block8;
                }
            }
            form.getFieldList().add(fieldWithItems);
            if (!GROUP_CUSTOM.equalsIgnoreCase(fieldWithItems.getGroup())) continue;
            form.getCustomFieldList().add(fieldWithItems);
        }
        return form;
    }

    public List<Form> findAllForm() {
        List<FormEntity> formPoList = this.formDao.findAllForm();
        return BeanMapper.mapList(formPoList, Form.class);
    }

    public List<Form> findFormList(FormQuery formQuery) {
        List<FormEntity> formPoList = this.formDao.findFormList(formQuery);
        return BeanMapper.mapList(formPoList, Form.class);
    }

    public Pagination<Form> findFormPage(FormQuery formQuery) {
        Pagination<FormEntity> pagination = this.formDao.findFormPage(formQuery);
        List formList = BeanMapper.mapList((List)pagination.getDataList(), Form.class);
        return PaginationBuilder.build(pagination, (List)formList);
    }

    public String cloneForm(String formId, String formName) {
        Form form = this.findForm(formId);
        form.setDefaults(Integer.valueOf(0));
        form.setName(formName);
        String newFormId = this.createForm(form);
        FormFieldQuery formFieldQuery = new FormFieldQuery();
        formFieldQuery.setFormId(formId);
        List formFieldList = this.formFieldService.findFormFieldList(formFieldQuery);
        if (formFieldList != null) {
            for (FormField formField : formFieldList) {
                formField.setForm(new Form().setId(newFormId));
                this.formFieldService.createFormField(formField);
            }
        }
        return newFormId;
    }
}

