
CREATE TABLE pcs_foc_field_type(
        id VARCHAR(8) PRIMARY KEY,
        name VARCHAR(64) NOT NULL,
        code VARCHAR(64) NOT NULL ,
        grouper VARCHAR(12) NOT NULL,
        sort int
);
COMMENT ON COLUMN pcs_foc_field_type.name IS '字段类型名称';
COMMENT ON COLUMN pcs_foc_field_type.code IS '字段类型名称';
COMMENT ON COLUMN pcs_foc_field_type.grouper IS '类别:system,custom';
COMMENT ON COLUMN pcs_foc_field_type.sort IS '排序';

CREATE TABLE  pcs_foc_field(
        id VARCHAR(8) PRIMARY KEY,
        name VARCHAR(64) NOT NULL,
        code VARCHAR(64) NOT NULL,
        field_type VARCHAR(8) NOT NULL,
        grouper VARCHAR(12) NOT NULL,
        is_edit_col int DEFAULT 0,
        sort int
);

COMMENT ON COLUMN pcs_foc_field.name IS '名称';
COMMENT ON COLUMN pcs_foc_field.code IS '编码';
COMMENT ON COLUMN pcs_foc_field.field_type IS '字段类型';
COMMENT ON COLUMN pcs_foc_field.grouper IS '类别:system,custom';
COMMENT ON COLUMN pcs_foc_field.is_edit_col IS '可编辑列, 0:不可编辑系统级列，1：可编辑系统级列 ';


CREATE TABLE  pcs_foc_select_item(
        id VARCHAR(8) PRIMARY KEY,
        name VARCHAR(64) NOT NULL,
        field_id VARCHAR(8) NOT NULL,
        value varchar(64),
        sort int
);

COMMENT ON COLUMN pcs_foc_select_item.name IS '选项名称';
COMMENT ON COLUMN pcs_foc_select_item.field_id IS '所属字段id';
COMMENT ON COLUMN pcs_foc_select_item.value IS '选项值';

CREATE TABLE  pcs_foc_form(
        id VARCHAR(8) PRIMARY KEY,
        name VARCHAR(64) NOT NULL,
        description VARCHAR(128),
        grouper VARCHAR(12) NOT NULL,
        scope INT DEFAULT 1,
        defaults int
);
COMMENT ON COLUMN pcs_foc_form.name IS '表单名称';
COMMENT ON COLUMN pcs_foc_form.description IS '描述';
COMMENT ON COLUMN pcs_foc_form.grouper IS '类别,系统:system;自定义:custom';
COMMENT ON COLUMN pcs_foc_form.scope IS '作用域， 1:系统 2：项目域的角色';
COMMENT ON COLUMN pcs_foc_form.defaults IS '默认表单,1:默认;其它:非默认';

CREATE TABLE  pcs_foc_form_field(
        id VARCHAR(8) PRIMARY KEY,
        form_id VARCHAR(8) NOT NULL,
        field_id VARCHAR(8) NOT NULL,
        required int NOT NULL,
        sort int
);
COMMENT ON COLUMN pcs_foc_form_field.form_id IS '字段id';
COMMENT ON COLUMN pcs_foc_form_field.field_id IS '字段id';
COMMENT ON COLUMN pcs_foc_form_field.required IS '是否必须,1:必须;0:非必须';

CREATE TABLE  pcs_foc_dm_form(
        id VARCHAR(8) PRIMARY KEY,
        domain_id VARCHAR(12) NOT NULL,
        form_id VARCHAR(8) NOT NULL,
        global_form_id VARCHAR(8)
);

COMMENT ON COLUMN pcs_foc_dm_form.domain_id IS '域ID';
COMMENT ON COLUMN pcs_foc_dm_form.form_id IS '表单id';
COMMENT ON COLUMN pcs_foc_dm_form.global_form_id IS '全局表单id';