/*
 * TileDB Storage Platform API
 * TileDB Storage Platform REST API
 *
 * The version of the OpenAPI document: 2.2.19
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.tiledb.cloud.rest_api;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.bind.util.ISO8601Utils;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.google.gson.JsonElement;
import io.gsonfire.GsonFireBuilder;

import io.tiledb.cloud.rest_api.model.*;
import io.tiledb.cloud.rest_api.model.Error;
import okio.ByteString;

import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Map;

/*
 * A JSON utility class
 *
 * NOTE: in the future, this class may be converted to static, which may break
 *       backward-compatibility
 */
public class JSON {
    private static Gson gson;
    private static boolean isLenientOnJson = false;
    private static DateTypeAdapter dateTypeAdapter = new DateTypeAdapter();
    private static SqlDateTypeAdapter sqlDateTypeAdapter = new SqlDateTypeAdapter();
    private static OffsetDateTimeTypeAdapter offsetDateTimeTypeAdapter = new OffsetDateTimeTypeAdapter();
    private static LocalDateTypeAdapter localDateTypeAdapter = new LocalDateTypeAdapter();
    private static ByteArrayAdapter byteArrayAdapter = new ByteArrayAdapter();

    @SuppressWarnings("unchecked")
    public static GsonBuilder createGson() {
        GsonFireBuilder fireBuilder = new GsonFireBuilder()
        ;
        GsonBuilder builder = fireBuilder.createGsonBuilder();
        return builder;
    }

    private static String getDiscriminatorValue(JsonElement readElement, String discriminatorField) {
        JsonElement element = readElement.getAsJsonObject().get(discriminatorField);
        if (null == element) {
            throw new IllegalArgumentException("missing discriminator field: <" + discriminatorField + ">");
        }
        return element.getAsString();
    }

    /**
     * Returns the Java class that implements the OpenAPI schema for the specified discriminator value.
     *
     * @param classByDiscriminatorValue The map of discriminator values to Java classes.
     * @param discriminatorValue The value of the OpenAPI discriminator in the input data.
     * @return The Java class that implements the OpenAPI schema
     */
    private static Class getClassByDiscriminator(Map classByDiscriminatorValue, String discriminatorValue) {
        Class clazz = (Class) classByDiscriminatorValue.get(discriminatorValue);
        if (null == clazz) {
            throw new IllegalArgumentException("cannot determine model class of name: <" + discriminatorValue + ">");
        }
        return clazz;
    }

    {
        GsonBuilder gsonBuilder = createGson();
        gsonBuilder.registerTypeAdapter(Date.class, dateTypeAdapter);
        gsonBuilder.registerTypeAdapter(java.sql.Date.class, sqlDateTypeAdapter);
        gsonBuilder.registerTypeAdapter(OffsetDateTime.class, offsetDateTimeTypeAdapter);
        gsonBuilder.registerTypeAdapter(LocalDate.class, localDateTypeAdapter);
        gsonBuilder.registerTypeAdapter(byte[].class, byteArrayAdapter);
        gsonBuilder.registerTypeAdapterFactory(new AWSAccessCredentials.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new Array.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ArrayActivityLog.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ArrayBrowserData.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ArrayBrowserSidebar.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ArrayEndTimestampData.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ArrayFavorite.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ArrayFavoritesData.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ArrayInfo.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ArrayInfoUpdate.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ArrayMetadata.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ArrayMetadataEntry.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ArraySample.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ArraySchema.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ArraySharing.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ArrayTask.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ArrayTaskBrowserSidebar.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ArrayTaskData.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ArrayTaskLog.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new Attribute.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new AttributeBufferHeader.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new AttributeBufferSize.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new Dimension.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new DimensionCoordinate.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new DimensionTileExtent.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new Domain.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new DomainArray.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new Error.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new FileCreate.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new FileCreated.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new FileExport.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new FileExported.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new FileUploaded.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new Filter.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new FilterData.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new FilterPipeline.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new GenericUDF.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new GetTiledbStats200Response.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new GroupBrowserData.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new GroupBrowserFilterData.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new GroupChanges.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new GroupContents.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new GroupContentsFilterData.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new GroupCreate.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new GroupEntry.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new GroupInfo.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new GroupMember.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new GroupRegister.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new GroupSharing.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new GroupSharingRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new GroupUpdate.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new Invitation.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new InvitationArrayShareEmail.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new InvitationData.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new InvitationOrganizationJoinEmail.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new LastAccessedArray.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new MLModelFavorite.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new MLModelFavoritesData.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new MaxBufferSizes.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new MultiArrayUDF.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new NonEmptyDomain.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new NotebookCopied.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new NotebookCopy.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new NotebookFavorite.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new NotebookFavoritesData.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new NotebookStatus.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new Organization.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new OrganizationUser.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new PaginationMetadata.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new Pricing.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new Query.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new QueryJson.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new QueryRanges.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new QueryReader.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ReadState.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new RegisteredTaskGraph.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new RegisteredTaskGraphNode.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new ResetUserPasswordRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new SQLParameters.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new Subarray.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new SubarrayPartitioner.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new SubarrayPartitionerCurrent.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new SubarrayPartitionerState.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new SubarrayRanges.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new Subscription.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new TGInputNodeData.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new TGSQLNodeData.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new TGUDFArgument.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new TGUDFEnvironment.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new TGUDFNodeData.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new TaskGraphClientNodeStatus.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new TaskGraphLog.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new TaskGraphLogsData.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new TaskGraphNodeMetadata.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new TaskGraphSharing.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new TileDBConfig.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new Token.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new TokenRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new UDFArrayDetails.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new UDFCopied.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new UDFCopy.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new UDFFavorite.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new UDFFavoritesData.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new UDFImage.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new UDFImageVersion.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new UDFInfo.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new UDFInfoUpdate.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new UDFSharing.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new UDFSubarray.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new UDFSubarrayRange.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new User.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new Writer.CustomTypeAdapterFactory());
        gson = gsonBuilder.create();
    }

    /**
     * Get Gson.
     *
     * @return Gson
     */
    public static Gson getGson() {
        return gson;
    }

    /**
     * Set Gson.
     *
     * @param gson Gson
     */
    public static void setGson(Gson gson) {
        JSON.gson = gson;
    }

    public static void setLenientOnJson(boolean lenientOnJson) {
        isLenientOnJson = lenientOnJson;
    }

    /**
     * Serialize the given Java object into JSON string.
     *
     * @param obj Object
     * @return String representation of the JSON
     */
    public static String serialize(Object obj) {
        return gson.toJson(obj);
    }

    /**
     * Deserialize the given JSON string to Java object.
     *
     * @param <T>        Type
     * @param body       The JSON string
     * @param returnType The type to deserialize into
     * @return The deserialized Java object
     */
    @SuppressWarnings("unchecked")
    public static <T> T deserialize(String body, Type returnType) {
        try {
            if (isLenientOnJson) {
                JsonReader jsonReader = new JsonReader(new StringReader(body));
                // see https://google-gson.googlecode.com/svn/trunk/gson/docs/javadocs/com/google/gson/stream/JsonReader.html#setLenient(boolean)
                jsonReader.setLenient(true);
                return gson.fromJson(jsonReader, returnType);
            } else {
                return gson.fromJson(body, returnType);
            }
        } catch (JsonParseException e) {
            // Fallback processing when failed to parse JSON form response body:
            // return the response body string directly for the String return type;
            if (returnType.equals(String.class)) {
                return (T) body;
            } else {
                throw (e);
            }
        }
    }

    /**
     * Gson TypeAdapter for Byte Array type
     */
    public static class ByteArrayAdapter extends TypeAdapter<byte[]> {

        @Override
        public void write(JsonWriter out, byte[] value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                out.value(ByteString.of(value).base64());
            }
        }

        @Override
        public byte[] read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL:
                    in.nextNull();
                    return null;
                default:
                    String bytesAsBase64 = in.nextString();
                    ByteString byteString = ByteString.decodeBase64(bytesAsBase64);
                    return byteString.toByteArray();
            }
        }
    }

    /**
     * Gson TypeAdapter for JSR310 OffsetDateTime type
     */
    public static class OffsetDateTimeTypeAdapter extends TypeAdapter<OffsetDateTime> {

        private DateTimeFormatter formatter;

        public OffsetDateTimeTypeAdapter() {
            this(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        }

        public OffsetDateTimeTypeAdapter(DateTimeFormatter formatter) {
            this.formatter = formatter;
        }

        public void setFormat(DateTimeFormatter dateFormat) {
            this.formatter = dateFormat;
        }

        @Override
        public void write(JsonWriter out, OffsetDateTime date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                out.value(formatter.format(date));
            }
        }

        @Override
        public OffsetDateTime read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL:
                    in.nextNull();
                    return null;
                default:
                    String date = in.nextString();
                    if (date.endsWith("+0000")) {
                        date = date.substring(0, date.length()-5) + "Z";
                    }
                    return OffsetDateTime.parse(date, formatter);
            }
        }
    }

    /**
     * Gson TypeAdapter for JSR310 LocalDate type
     */
    public static class LocalDateTypeAdapter extends TypeAdapter<LocalDate> {

        private DateTimeFormatter formatter;

        public LocalDateTypeAdapter() {
            this(DateTimeFormatter.ISO_LOCAL_DATE);
        }

        public LocalDateTypeAdapter(DateTimeFormatter formatter) {
            this.formatter = formatter;
        }

        public void setFormat(DateTimeFormatter dateFormat) {
            this.formatter = dateFormat;
        }

        @Override
        public void write(JsonWriter out, LocalDate date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                out.value(formatter.format(date));
            }
        }

        @Override
        public LocalDate read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL:
                    in.nextNull();
                    return null;
                default:
                    String date = in.nextString();
                    return LocalDate.parse(date, formatter);
            }
        }
    }

    public static void setOffsetDateTimeFormat(DateTimeFormatter dateFormat) {
        offsetDateTimeTypeAdapter.setFormat(dateFormat);
    }

    public static void setLocalDateFormat(DateTimeFormatter dateFormat) {
        localDateTypeAdapter.setFormat(dateFormat);
    }

    /**
     * Gson TypeAdapter for java.sql.Date type
     * If the dateFormat is null, a simple "yyyy-MM-dd" format will be used
     * (more efficient than SimpleDateFormat).
     */
    public static class SqlDateTypeAdapter extends TypeAdapter<java.sql.Date> {

        private DateFormat dateFormat;

        public SqlDateTypeAdapter() {}

        public SqlDateTypeAdapter(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        public void setFormat(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        @Override
        public void write(JsonWriter out, java.sql.Date date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                String value;
                if (dateFormat != null) {
                    value = dateFormat.format(date);
                } else {
                    value = date.toString();
                }
                out.value(value);
            }
        }

        @Override
        public java.sql.Date read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL:
                    in.nextNull();
                    return null;
                default:
                    String date = in.nextString();
                    try {
                        if (dateFormat != null) {
                            return new java.sql.Date(dateFormat.parse(date).getTime());
                        }
                        return new java.sql.Date(ISO8601Utils.parse(date, new ParsePosition(0)).getTime());
                    } catch (ParseException e) {
                        throw new JsonParseException(e);
                    }
            }
        }
    }

    /**
     * Gson TypeAdapter for java.util.Date type
     * If the dateFormat is null, ISO8601Utils will be used.
     */
    public static class DateTypeAdapter extends TypeAdapter<Date> {

        private DateFormat dateFormat;

        public DateTypeAdapter() {}

        public DateTypeAdapter(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        public void setFormat(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        @Override
        public void write(JsonWriter out, Date date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                String value;
                if (dateFormat != null) {
                    value = dateFormat.format(date);
                } else {
                    value = ISO8601Utils.format(date, true);
                }
                out.value(value);
            }
        }

        @Override
        public Date read(JsonReader in) throws IOException {
            try {
                switch (in.peek()) {
                    case NULL:
                        in.nextNull();
                        return null;
                    default:
                        String date = in.nextString();
                        try {
                            if (dateFormat != null) {
                                return dateFormat.parse(date);
                            }
                            return ISO8601Utils.parse(date, new ParsePosition(0));
                        } catch (ParseException e) {
                            throw new JsonParseException(e);
                        }
                }
            } catch (IllegalArgumentException e) {
                throw new JsonParseException(e);
            }
        }
    }

    public static void setDateFormat(DateFormat dateFormat) {
        dateTypeAdapter.setFormat(dateFormat);
    }

    public static void setSqlDateFormat(DateFormat dateFormat) {
        sqlDateTypeAdapter.setFormat(dateFormat);
    }
}
