/*
 * TileDB Storage Platform API
 * TileDB Storage Platform REST API
 *
 * The version of the OpenAPI document: 2.2.19
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.tiledb.cloud.rest_api.api;

import io.tiledb.cloud.rest_api.ApiClient;
import io.tiledb.cloud.rest_api.ApiException;
import io.tiledb.cloud.rest_api.ApiResponse;
import io.tiledb.cloud.rest_api.Pair;
import io.tiledb.cloud.rest_api.ApiCallback;
import io.tiledb.cloud.rest_api.Configuration;

import com.google.gson.reflect.TypeToken;


import io.tiledb.cloud.rest_api.model.GroupBrowserData;
import io.tiledb.cloud.rest_api.model.GroupBrowserFilterData;
import io.tiledb.cloud.rest_api.model.GroupChanges;
import io.tiledb.cloud.rest_api.model.GroupContents;
import io.tiledb.cloud.rest_api.model.GroupContentsFilterData;
import io.tiledb.cloud.rest_api.model.GroupCreate;
import io.tiledb.cloud.rest_api.model.GroupInfo;
import io.tiledb.cloud.rest_api.model.GroupRegister;
import io.tiledb.cloud.rest_api.model.GroupSharing;
import io.tiledb.cloud.rest_api.model.GroupSharingRequest;
import io.tiledb.cloud.rest_api.model.GroupUpdate;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GroupsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public GroupsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public GroupsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    /**
     * Build call for changeGroupContents
     * @param groupNamespace The namespace of the group (required)
     * @param groupName The unique name or id of the group (required)
     * @param groupChanges  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> all changes applied successfully </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call changeGroupContentsCall(String groupNamespace, String groupName, GroupChanges groupChanges, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = groupChanges;

        // create path and map variables
        String localVarPath = "/groups/{group_namespace}/{group_name}/contents"
            .replaceAll("\\{" + "group_namespace" + "\\}", localVarApiClient.escapeString(groupNamespace.toString()))
            .replaceAll("\\{" + "group_name" + "\\}", localVarApiClient.escapeString(groupName.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call changeGroupContentsValidateBeforeCall(String groupNamespace, String groupName, GroupChanges groupChanges, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'groupNamespace' is set
        if (groupNamespace == null) {
            throw new ApiException("Missing the required parameter 'groupNamespace' when calling changeGroupContents(Async)");
        }
        
        // verify the required parameter 'groupName' is set
        if (groupName == null) {
            throw new ApiException("Missing the required parameter 'groupName' when calling changeGroupContents(Async)");
        }
        

        okhttp3.Call localVarCall = changeGroupContentsCall(groupNamespace, groupName, groupChanges, _callback);
        return localVarCall;

    }

    /**
     * 
     * Changes the contents of the group by adding/removing members.
     * @param groupNamespace The namespace of the group (required)
     * @param groupName The unique name or id of the group (required)
     * @param groupChanges  (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> all changes applied successfully </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public void changeGroupContents(String groupNamespace, String groupName, GroupChanges groupChanges) throws ApiException {
        changeGroupContentsWithHttpInfo(groupNamespace, groupName, groupChanges);
    }

    /**
     * 
     * Changes the contents of the group by adding/removing members.
     * @param groupNamespace The namespace of the group (required)
     * @param groupName The unique name or id of the group (required)
     * @param groupChanges  (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> all changes applied successfully </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> changeGroupContentsWithHttpInfo(String groupNamespace, String groupName, GroupChanges groupChanges) throws ApiException {
        okhttp3.Call localVarCall = changeGroupContentsValidateBeforeCall(groupNamespace, groupName, groupChanges, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     *  (asynchronously)
     * Changes the contents of the group by adding/removing members.
     * @param groupNamespace The namespace of the group (required)
     * @param groupName The unique name or id of the group (required)
     * @param groupChanges  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> all changes applied successfully </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call changeGroupContentsAsync(String groupNamespace, String groupName, GroupChanges groupChanges, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = changeGroupContentsValidateBeforeCall(groupNamespace, groupName, groupChanges, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for createGroup
     * @param namespace The namespace of the group (required)
     * @param groupCreate  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> group created successfully </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createGroupCall(String namespace, GroupCreate groupCreate, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = groupCreate;

        // create path and map variables
        String localVarPath = "/groups/{namespace}/create"
            .replaceAll("\\{" + "namespace" + "\\}", localVarApiClient.escapeString(namespace.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createGroupValidateBeforeCall(String namespace, GroupCreate groupCreate, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'namespace' is set
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling createGroup(Async)");
        }
        

        okhttp3.Call localVarCall = createGroupCall(namespace, groupCreate, _callback);
        return localVarCall;

    }

    /**
     * 
     * Creates a new group in the namespace.
     * @param namespace The namespace of the group (required)
     * @param groupCreate  (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> group created successfully </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public void createGroup(String namespace, GroupCreate groupCreate) throws ApiException {
        createGroupWithHttpInfo(namespace, groupCreate);
    }

    /**
     * 
     * Creates a new group in the namespace.
     * @param namespace The namespace of the group (required)
     * @param groupCreate  (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> group created successfully </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> createGroupWithHttpInfo(String namespace, GroupCreate groupCreate) throws ApiException {
        okhttp3.Call localVarCall = createGroupValidateBeforeCall(namespace, groupCreate, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     *  (asynchronously)
     * Creates a new group in the namespace.
     * @param namespace The namespace of the group (required)
     * @param groupCreate  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> group created successfully </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createGroupAsync(String namespace, GroupCreate groupCreate, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = createGroupValidateBeforeCall(namespace, groupCreate, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteGroup
     * @param groupNamespace The namespace of the group (required)
     * @param groupName The unique name or id of the group (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> group deleted successfully </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteGroupCall(String groupNamespace, String groupName, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/groups/{group_namespace}/{group_name}"
            .replaceAll("\\{" + "group_namespace" + "\\}", localVarApiClient.escapeString(groupNamespace.toString()))
            .replaceAll("\\{" + "group_name" + "\\}", localVarApiClient.escapeString(groupName.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteGroupValidateBeforeCall(String groupNamespace, String groupName, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'groupNamespace' is set
        if (groupNamespace == null) {
            throw new ApiException("Missing the required parameter 'groupNamespace' when calling deleteGroup(Async)");
        }
        
        // verify the required parameter 'groupName' is set
        if (groupName == null) {
            throw new ApiException("Missing the required parameter 'groupName' when calling deleteGroup(Async)");
        }
        

        okhttp3.Call localVarCall = deleteGroupCall(groupNamespace, groupName, _callback);
        return localVarCall;

    }

    /**
     * 
     * Deletes the group. The assets are not deleted nor are not relocated to any other group
     * @param groupNamespace The namespace of the group (required)
     * @param groupName The unique name or id of the group (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> group deleted successfully </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public void deleteGroup(String groupNamespace, String groupName) throws ApiException {
        deleteGroupWithHttpInfo(groupNamespace, groupName);
    }

    /**
     * 
     * Deletes the group. The assets are not deleted nor are not relocated to any other group
     * @param groupNamespace The namespace of the group (required)
     * @param groupName The unique name or id of the group (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> group deleted successfully </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deleteGroupWithHttpInfo(String groupNamespace, String groupName) throws ApiException {
        okhttp3.Call localVarCall = deleteGroupValidateBeforeCall(groupNamespace, groupName, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     *  (asynchronously)
     * Deletes the group. The assets are not deleted nor are not relocated to any other group
     * @param groupNamespace The namespace of the group (required)
     * @param groupName The unique name or id of the group (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> group deleted successfully </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteGroupAsync(String groupNamespace, String groupName, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteGroupValidateBeforeCall(groupNamespace, groupName, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for getGroup
     * @param groupNamespace The namespace of the group (required)
     * @param groupName The unique name or id of the group (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> the group metadata </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getGroupCall(String groupNamespace, String groupName, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/groups/{group_namespace}/{group_name}"
            .replaceAll("\\{" + "group_namespace" + "\\}", localVarApiClient.escapeString(groupNamespace.toString()))
            .replaceAll("\\{" + "group_name" + "\\}", localVarApiClient.escapeString(groupName.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getGroupValidateBeforeCall(String groupNamespace, String groupName, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'groupNamespace' is set
        if (groupNamespace == null) {
            throw new ApiException("Missing the required parameter 'groupNamespace' when calling getGroup(Async)");
        }
        
        // verify the required parameter 'groupName' is set
        if (groupName == null) {
            throw new ApiException("Missing the required parameter 'groupName' when calling getGroup(Async)");
        }
        

        okhttp3.Call localVarCall = getGroupCall(groupNamespace, groupName, _callback);
        return localVarCall;

    }

    /**
     * 
     * Returns the the group
     * @param groupNamespace The namespace of the group (required)
     * @param groupName The unique name or id of the group (required)
     * @return GroupInfo
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> the group metadata </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public GroupInfo getGroup(String groupNamespace, String groupName) throws ApiException {
        ApiResponse<GroupInfo> localVarResp = getGroupWithHttpInfo(groupNamespace, groupName);
        return localVarResp.getData();
    }

    /**
     * 
     * Returns the the group
     * @param groupNamespace The namespace of the group (required)
     * @param groupName The unique name or id of the group (required)
     * @return ApiResponse&lt;GroupInfo&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> the group metadata </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<GroupInfo> getGroupWithHttpInfo(String groupNamespace, String groupName) throws ApiException {
        okhttp3.Call localVarCall = getGroupValidateBeforeCall(groupNamespace, groupName, null);
        Type localVarReturnType = new TypeToken<GroupInfo>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Returns the the group
     * @param groupNamespace The namespace of the group (required)
     * @param groupName The unique name or id of the group (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> the group metadata </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getGroupAsync(String groupNamespace, String groupName, final ApiCallback<GroupInfo> _callback) throws ApiException {

        okhttp3.Call localVarCall = getGroupValidateBeforeCall(groupNamespace, groupName, _callback);
        Type localVarReturnType = new TypeToken<GroupInfo>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getGroupContents
     * @param groupNamespace The namespace of the group (required)
     * @param groupName The unique name or id of the group (required)
     * @param page pagination offset for assets (optional)
     * @param perPage pagination limit for assets (optional)
     * @param namespace namespace to search for (optional)
     * @param search search string that will look at name, namespace or description fields (optional)
     * @param orderby sort by which field valid values include last_accessed, size, name (optional)
     * @param tag tag to search for, more than one can be included (optional)
     * @param excludeTag tags to exclude matching array in results, more than one can be included (optional)
     * @param memberType member type to search for, more than one can be included (optional)
     * @param excludeMemberType member type to exclude matching groups in results, more than one can be included (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> the group contents </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getGroupContentsCall(String groupNamespace, String groupName, Integer page, Integer perPage, String namespace, String search, String orderby, List<String> tag, List<String> excludeTag, List<String> memberType, List<String> excludeMemberType, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/groups/{group_namespace}/{group_name}/contents"
            .replaceAll("\\{" + "group_namespace" + "\\}", localVarApiClient.escapeString(groupNamespace.toString()))
            .replaceAll("\\{" + "group_name" + "\\}", localVarApiClient.escapeString(groupName.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (perPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("per_page", perPage));
        }

        if (namespace != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("namespace", namespace));
        }

        if (search != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("search", search));
        }

        if (orderby != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("orderby", orderby));
        }

        if (tag != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "tag", tag));
        }

        if (excludeTag != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "exclude_tag", excludeTag));
        }

        if (memberType != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "member_type", memberType));
        }

        if (excludeMemberType != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "exclude_member_type", excludeMemberType));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getGroupContentsValidateBeforeCall(String groupNamespace, String groupName, Integer page, Integer perPage, String namespace, String search, String orderby, List<String> tag, List<String> excludeTag, List<String> memberType, List<String> excludeMemberType, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'groupNamespace' is set
        if (groupNamespace == null) {
            throw new ApiException("Missing the required parameter 'groupNamespace' when calling getGroupContents(Async)");
        }
        
        // verify the required parameter 'groupName' is set
        if (groupName == null) {
            throw new ApiException("Missing the required parameter 'groupName' when calling getGroupContents(Async)");
        }
        

        okhttp3.Call localVarCall = getGroupContentsCall(groupNamespace, groupName, page, perPage, namespace, search, orderby, tag, excludeTag, memberType, excludeMemberType, _callback);
        return localVarCall;

    }

    /**
     * 
     * Returns the contents of the group
     * @param groupNamespace The namespace of the group (required)
     * @param groupName The unique name or id of the group (required)
     * @param page pagination offset for assets (optional)
     * @param perPage pagination limit for assets (optional)
     * @param namespace namespace to search for (optional)
     * @param search search string that will look at name, namespace or description fields (optional)
     * @param orderby sort by which field valid values include last_accessed, size, name (optional)
     * @param tag tag to search for, more than one can be included (optional)
     * @param excludeTag tags to exclude matching array in results, more than one can be included (optional)
     * @param memberType member type to search for, more than one can be included (optional)
     * @param excludeMemberType member type to exclude matching groups in results, more than one can be included (optional)
     * @return GroupContents
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> the group contents </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public GroupContents getGroupContents(String groupNamespace, String groupName, Integer page, Integer perPage, String namespace, String search, String orderby, List<String> tag, List<String> excludeTag, List<String> memberType, List<String> excludeMemberType) throws ApiException {
        ApiResponse<GroupContents> localVarResp = getGroupContentsWithHttpInfo(groupNamespace, groupName, page, perPage, namespace, search, orderby, tag, excludeTag, memberType, excludeMemberType);
        return localVarResp.getData();
    }

    /**
     * 
     * Returns the contents of the group
     * @param groupNamespace The namespace of the group (required)
     * @param groupName The unique name or id of the group (required)
     * @param page pagination offset for assets (optional)
     * @param perPage pagination limit for assets (optional)
     * @param namespace namespace to search for (optional)
     * @param search search string that will look at name, namespace or description fields (optional)
     * @param orderby sort by which field valid values include last_accessed, size, name (optional)
     * @param tag tag to search for, more than one can be included (optional)
     * @param excludeTag tags to exclude matching array in results, more than one can be included (optional)
     * @param memberType member type to search for, more than one can be included (optional)
     * @param excludeMemberType member type to exclude matching groups in results, more than one can be included (optional)
     * @return ApiResponse&lt;GroupContents&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> the group contents </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<GroupContents> getGroupContentsWithHttpInfo(String groupNamespace, String groupName, Integer page, Integer perPage, String namespace, String search, String orderby, List<String> tag, List<String> excludeTag, List<String> memberType, List<String> excludeMemberType) throws ApiException {
        okhttp3.Call localVarCall = getGroupContentsValidateBeforeCall(groupNamespace, groupName, page, perPage, namespace, search, orderby, tag, excludeTag, memberType, excludeMemberType, null);
        Type localVarReturnType = new TypeToken<GroupContents>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Returns the contents of the group
     * @param groupNamespace The namespace of the group (required)
     * @param groupName The unique name or id of the group (required)
     * @param page pagination offset for assets (optional)
     * @param perPage pagination limit for assets (optional)
     * @param namespace namespace to search for (optional)
     * @param search search string that will look at name, namespace or description fields (optional)
     * @param orderby sort by which field valid values include last_accessed, size, name (optional)
     * @param tag tag to search for, more than one can be included (optional)
     * @param excludeTag tags to exclude matching array in results, more than one can be included (optional)
     * @param memberType member type to search for, more than one can be included (optional)
     * @param excludeMemberType member type to exclude matching groups in results, more than one can be included (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> the group contents </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getGroupContentsAsync(String groupNamespace, String groupName, Integer page, Integer perPage, String namespace, String search, String orderby, List<String> tag, List<String> excludeTag, List<String> memberType, List<String> excludeMemberType, final ApiCallback<GroupContents> _callback) throws ApiException {

        okhttp3.Call localVarCall = getGroupContentsValidateBeforeCall(groupNamespace, groupName, page, perPage, namespace, search, orderby, tag, excludeTag, memberType, excludeMemberType, _callback);
        Type localVarReturnType = new TypeToken<GroupContents>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getGroupSharingPolicies
     * @param groupNamespace The namespace of the group (required)
     * @param groupName The unique name or id of the group (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List of all specific sharing policies </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Group does not exist or user does not have permissions to view group-sharing policies </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getGroupSharingPoliciesCall(String groupNamespace, String groupName, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/groups/{group_namespace}/{group_name}/share"
            .replaceAll("\\{" + "group_namespace" + "\\}", localVarApiClient.escapeString(groupNamespace.toString()))
            .replaceAll("\\{" + "group_name" + "\\}", localVarApiClient.escapeString(groupName.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getGroupSharingPoliciesValidateBeforeCall(String groupNamespace, String groupName, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'groupNamespace' is set
        if (groupNamespace == null) {
            throw new ApiException("Missing the required parameter 'groupNamespace' when calling getGroupSharingPolicies(Async)");
        }
        
        // verify the required parameter 'groupName' is set
        if (groupName == null) {
            throw new ApiException("Missing the required parameter 'groupName' when calling getGroupSharingPolicies(Async)");
        }
        

        okhttp3.Call localVarCall = getGroupSharingPoliciesCall(groupNamespace, groupName, _callback);
        return localVarCall;

    }

    /**
     * 
     * Get all sharing details of the group
     * @param groupNamespace The namespace of the group (required)
     * @param groupName The unique name or id of the group (required)
     * @return List&lt;GroupSharing&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List of all specific sharing policies </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Group does not exist or user does not have permissions to view group-sharing policies </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public List<GroupSharing> getGroupSharingPolicies(String groupNamespace, String groupName) throws ApiException {
        ApiResponse<List<GroupSharing>> localVarResp = getGroupSharingPoliciesWithHttpInfo(groupNamespace, groupName);
        return localVarResp.getData();
    }

    /**
     * 
     * Get all sharing details of the group
     * @param groupNamespace The namespace of the group (required)
     * @param groupName The unique name or id of the group (required)
     * @return ApiResponse&lt;List&lt;GroupSharing&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List of all specific sharing policies </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Group does not exist or user does not have permissions to view group-sharing policies </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<GroupSharing>> getGroupSharingPoliciesWithHttpInfo(String groupNamespace, String groupName) throws ApiException {
        okhttp3.Call localVarCall = getGroupSharingPoliciesValidateBeforeCall(groupNamespace, groupName, null);
        Type localVarReturnType = new TypeToken<List<GroupSharing>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Get all sharing details of the group
     * @param groupNamespace The namespace of the group (required)
     * @param groupName The unique name or id of the group (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List of all specific sharing policies </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Group does not exist or user does not have permissions to view group-sharing policies </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getGroupSharingPoliciesAsync(String groupNamespace, String groupName, final ApiCallback<List<GroupSharing>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getGroupSharingPoliciesValidateBeforeCall(groupNamespace, groupName, _callback);
        Type localVarReturnType = new TypeToken<List<GroupSharing>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for groupsBrowserOwnedFiltersGet
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Filter data </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call groupsBrowserOwnedFiltersGetCall(final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/groups/browser/owned/filters";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call groupsBrowserOwnedFiltersGetValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = groupsBrowserOwnedFiltersGetCall(_callback);
        return localVarCall;

    }

    /**
     * 
     * Fetch data to initialize filters for the groups browser
     * @return GroupBrowserFilterData
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Filter data </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public GroupBrowserFilterData groupsBrowserOwnedFiltersGet() throws ApiException {
        ApiResponse<GroupBrowserFilterData> localVarResp = groupsBrowserOwnedFiltersGetWithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * 
     * Fetch data to initialize filters for the groups browser
     * @return ApiResponse&lt;GroupBrowserFilterData&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Filter data </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<GroupBrowserFilterData> groupsBrowserOwnedFiltersGetWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = groupsBrowserOwnedFiltersGetValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<GroupBrowserFilterData>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Fetch data to initialize filters for the groups browser
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Filter data </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call groupsBrowserOwnedFiltersGetAsync(final ApiCallback<GroupBrowserFilterData> _callback) throws ApiException {

        okhttp3.Call localVarCall = groupsBrowserOwnedFiltersGetValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<GroupBrowserFilterData>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for groupsBrowserPublicFiltersGet
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Filter data </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call groupsBrowserPublicFiltersGetCall(final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/groups/browser/public/filters";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call groupsBrowserPublicFiltersGetValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = groupsBrowserPublicFiltersGetCall(_callback);
        return localVarCall;

    }

    /**
     * 
     * Fetch data to initialize filters for the groups browser
     * @return GroupBrowserFilterData
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Filter data </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public GroupBrowserFilterData groupsBrowserPublicFiltersGet() throws ApiException {
        ApiResponse<GroupBrowserFilterData> localVarResp = groupsBrowserPublicFiltersGetWithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * 
     * Fetch data to initialize filters for the groups browser
     * @return ApiResponse&lt;GroupBrowserFilterData&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Filter data </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<GroupBrowserFilterData> groupsBrowserPublicFiltersGetWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = groupsBrowserPublicFiltersGetValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<GroupBrowserFilterData>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Fetch data to initialize filters for the groups browser
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Filter data </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call groupsBrowserPublicFiltersGetAsync(final ApiCallback<GroupBrowserFilterData> _callback) throws ApiException {

        okhttp3.Call localVarCall = groupsBrowserPublicFiltersGetValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<GroupBrowserFilterData>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for groupsBrowserSharedFiltersGet
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Filter data </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call groupsBrowserSharedFiltersGetCall(final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/groups/browser/shared/filters";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call groupsBrowserSharedFiltersGetValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = groupsBrowserSharedFiltersGetCall(_callback);
        return localVarCall;

    }

    /**
     * 
     * Fetch data to initialize filters for the groups browser
     * @return GroupBrowserFilterData
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Filter data </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public GroupBrowserFilterData groupsBrowserSharedFiltersGet() throws ApiException {
        ApiResponse<GroupBrowserFilterData> localVarResp = groupsBrowserSharedFiltersGetWithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * 
     * Fetch data to initialize filters for the groups browser
     * @return ApiResponse&lt;GroupBrowserFilterData&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Filter data </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<GroupBrowserFilterData> groupsBrowserSharedFiltersGetWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = groupsBrowserSharedFiltersGetValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<GroupBrowserFilterData>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Fetch data to initialize filters for the groups browser
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Filter data </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call groupsBrowserSharedFiltersGetAsync(final ApiCallback<GroupBrowserFilterData> _callback) throws ApiException {

        okhttp3.Call localVarCall = groupsBrowserSharedFiltersGetValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<GroupBrowserFilterData>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for groupsGroupNamespaceGroupNameContentsFiltersGet
     * @param groupNamespace The namespace of the group (required)
     * @param groupName The unique name or id of the group (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Filter data </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call groupsGroupNamespaceGroupNameContentsFiltersGetCall(String groupNamespace, String groupName, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/groups/{group_namespace}/{group_name}/contents/filters"
            .replaceAll("\\{" + "group_namespace" + "\\}", localVarApiClient.escapeString(groupNamespace.toString()))
            .replaceAll("\\{" + "group_name" + "\\}", localVarApiClient.escapeString(groupName.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call groupsGroupNamespaceGroupNameContentsFiltersGetValidateBeforeCall(String groupNamespace, String groupName, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'groupNamespace' is set
        if (groupNamespace == null) {
            throw new ApiException("Missing the required parameter 'groupNamespace' when calling groupsGroupNamespaceGroupNameContentsFiltersGet(Async)");
        }
        
        // verify the required parameter 'groupName' is set
        if (groupName == null) {
            throw new ApiException("Missing the required parameter 'groupName' when calling groupsGroupNamespaceGroupNameContentsFiltersGet(Async)");
        }
        

        okhttp3.Call localVarCall = groupsGroupNamespaceGroupNameContentsFiltersGetCall(groupNamespace, groupName, _callback);
        return localVarCall;

    }

    /**
     * 
     * Fetch data to initialize filters for the group contents
     * @param groupNamespace The namespace of the group (required)
     * @param groupName The unique name or id of the group (required)
     * @return GroupContentsFilterData
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Filter data </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public GroupContentsFilterData groupsGroupNamespaceGroupNameContentsFiltersGet(String groupNamespace, String groupName) throws ApiException {
        ApiResponse<GroupContentsFilterData> localVarResp = groupsGroupNamespaceGroupNameContentsFiltersGetWithHttpInfo(groupNamespace, groupName);
        return localVarResp.getData();
    }

    /**
     * 
     * Fetch data to initialize filters for the group contents
     * @param groupNamespace The namespace of the group (required)
     * @param groupName The unique name or id of the group (required)
     * @return ApiResponse&lt;GroupContentsFilterData&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Filter data </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<GroupContentsFilterData> groupsGroupNamespaceGroupNameContentsFiltersGetWithHttpInfo(String groupNamespace, String groupName) throws ApiException {
        okhttp3.Call localVarCall = groupsGroupNamespaceGroupNameContentsFiltersGetValidateBeforeCall(groupNamespace, groupName, null);
        Type localVarReturnType = new TypeToken<GroupContentsFilterData>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Fetch data to initialize filters for the group contents
     * @param groupNamespace The namespace of the group (required)
     * @param groupName The unique name or id of the group (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Filter data </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call groupsGroupNamespaceGroupNameContentsFiltersGetAsync(String groupNamespace, String groupName, final ApiCallback<GroupContentsFilterData> _callback) throws ApiException {

        okhttp3.Call localVarCall = groupsGroupNamespaceGroupNameContentsFiltersGetValidateBeforeCall(groupNamespace, groupName, _callback);
        Type localVarReturnType = new TypeToken<GroupContentsFilterData>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listOwnedGroups
     * @param page pagination offset (optional)
     * @param perPage pagination limit (optional)
     * @param search search string that will look at name, namespace or description fields (optional)
     * @param namespace namespace (optional)
     * @param orderby sort by which field valid values include last_accessed, size, name (optional)
     * @param permissions permissions valid values include read, read_write, write, admin (optional)
     * @param tag tag to search for, more than one can be included (optional)
     * @param excludeTag tags to exclude matching array in results, more than one can be included (optional)
     * @param flat if true, ignores the nesting of groups and searches all of them (optional)
     * @param parent search only the children of the groups with this uuid (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> the group contents </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listOwnedGroupsCall(Integer page, Integer perPage, String search, String namespace, String orderby, String permissions, List<String> tag, List<String> excludeTag, Boolean flat, String parent, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/groups/browser/owned";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (perPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("per_page", perPage));
        }

        if (search != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("search", search));
        }

        if (namespace != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("namespace", namespace));
        }

        if (orderby != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("orderby", orderby));
        }

        if (permissions != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("permissions", permissions));
        }

        if (tag != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "tag", tag));
        }

        if (excludeTag != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "exclude_tag", excludeTag));
        }

        if (flat != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("flat", flat));
        }

        if (parent != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("parent", parent));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listOwnedGroupsValidateBeforeCall(Integer page, Integer perPage, String search, String namespace, String orderby, String permissions, List<String> tag, List<String> excludeTag, Boolean flat, String parent, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = listOwnedGroupsCall(page, perPage, search, namespace, orderby, permissions, tag, excludeTag, flat, parent, _callback);
        return localVarCall;

    }

    /**
     * 
     * Returns one page of owned groups.
     * @param page pagination offset (optional)
     * @param perPage pagination limit (optional)
     * @param search search string that will look at name, namespace or description fields (optional)
     * @param namespace namespace (optional)
     * @param orderby sort by which field valid values include last_accessed, size, name (optional)
     * @param permissions permissions valid values include read, read_write, write, admin (optional)
     * @param tag tag to search for, more than one can be included (optional)
     * @param excludeTag tags to exclude matching array in results, more than one can be included (optional)
     * @param flat if true, ignores the nesting of groups and searches all of them (optional)
     * @param parent search only the children of the groups with this uuid (optional)
     * @return GroupBrowserData
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> the group contents </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public GroupBrowserData listOwnedGroups(Integer page, Integer perPage, String search, String namespace, String orderby, String permissions, List<String> tag, List<String> excludeTag, Boolean flat, String parent) throws ApiException {
        ApiResponse<GroupBrowserData> localVarResp = listOwnedGroupsWithHttpInfo(page, perPage, search, namespace, orderby, permissions, tag, excludeTag, flat, parent);
        return localVarResp.getData();
    }

    /**
     * 
     * Returns one page of owned groups.
     * @param page pagination offset (optional)
     * @param perPage pagination limit (optional)
     * @param search search string that will look at name, namespace or description fields (optional)
     * @param namespace namespace (optional)
     * @param orderby sort by which field valid values include last_accessed, size, name (optional)
     * @param permissions permissions valid values include read, read_write, write, admin (optional)
     * @param tag tag to search for, more than one can be included (optional)
     * @param excludeTag tags to exclude matching array in results, more than one can be included (optional)
     * @param flat if true, ignores the nesting of groups and searches all of them (optional)
     * @param parent search only the children of the groups with this uuid (optional)
     * @return ApiResponse&lt;GroupBrowserData&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> the group contents </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<GroupBrowserData> listOwnedGroupsWithHttpInfo(Integer page, Integer perPage, String search, String namespace, String orderby, String permissions, List<String> tag, List<String> excludeTag, Boolean flat, String parent) throws ApiException {
        okhttp3.Call localVarCall = listOwnedGroupsValidateBeforeCall(page, perPage, search, namespace, orderby, permissions, tag, excludeTag, flat, parent, null);
        Type localVarReturnType = new TypeToken<GroupBrowserData>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Returns one page of owned groups.
     * @param page pagination offset (optional)
     * @param perPage pagination limit (optional)
     * @param search search string that will look at name, namespace or description fields (optional)
     * @param namespace namespace (optional)
     * @param orderby sort by which field valid values include last_accessed, size, name (optional)
     * @param permissions permissions valid values include read, read_write, write, admin (optional)
     * @param tag tag to search for, more than one can be included (optional)
     * @param excludeTag tags to exclude matching array in results, more than one can be included (optional)
     * @param flat if true, ignores the nesting of groups and searches all of them (optional)
     * @param parent search only the children of the groups with this uuid (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> the group contents </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listOwnedGroupsAsync(Integer page, Integer perPage, String search, String namespace, String orderby, String permissions, List<String> tag, List<String> excludeTag, Boolean flat, String parent, final ApiCallback<GroupBrowserData> _callback) throws ApiException {

        okhttp3.Call localVarCall = listOwnedGroupsValidateBeforeCall(page, perPage, search, namespace, orderby, permissions, tag, excludeTag, flat, parent, _callback);
        Type localVarReturnType = new TypeToken<GroupBrowserData>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listPublicGroups
     * @param page pagination offset (optional)
     * @param perPage pagination limit (optional)
     * @param search search string that will look at name, namespace or description fields (optional)
     * @param namespace namespace (optional)
     * @param orderby sort by which field valid values include last_accessed, size, name (optional)
     * @param permissions permissions valid values include read, read_write, write, admin (optional)
     * @param tag tag to search for, more than one can be included (optional)
     * @param excludeTag tags to exclude matching array in results, more than one can be included (optional)
     * @param flat if true, ignores the nesting of groups and searches all of them (optional)
     * @param parent search only the children of the groups with this uuid (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> the group contents </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listPublicGroupsCall(Integer page, Integer perPage, String search, String namespace, String orderby, String permissions, List<String> tag, List<String> excludeTag, Boolean flat, String parent, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/groups/browser/public";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (perPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("per_page", perPage));
        }

        if (search != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("search", search));
        }

        if (namespace != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("namespace", namespace));
        }

        if (orderby != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("orderby", orderby));
        }

        if (permissions != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("permissions", permissions));
        }

        if (tag != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "tag", tag));
        }

        if (excludeTag != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "exclude_tag", excludeTag));
        }

        if (flat != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("flat", flat));
        }

        if (parent != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("parent", parent));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listPublicGroupsValidateBeforeCall(Integer page, Integer perPage, String search, String namespace, String orderby, String permissions, List<String> tag, List<String> excludeTag, Boolean flat, String parent, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = listPublicGroupsCall(page, perPage, search, namespace, orderby, permissions, tag, excludeTag, flat, parent, _callback);
        return localVarCall;

    }

    /**
     * 
     * Returns one page of public groups.
     * @param page pagination offset (optional)
     * @param perPage pagination limit (optional)
     * @param search search string that will look at name, namespace or description fields (optional)
     * @param namespace namespace (optional)
     * @param orderby sort by which field valid values include last_accessed, size, name (optional)
     * @param permissions permissions valid values include read, read_write, write, admin (optional)
     * @param tag tag to search for, more than one can be included (optional)
     * @param excludeTag tags to exclude matching array in results, more than one can be included (optional)
     * @param flat if true, ignores the nesting of groups and searches all of them (optional)
     * @param parent search only the children of the groups with this uuid (optional)
     * @return GroupBrowserData
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> the group contents </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public GroupBrowserData listPublicGroups(Integer page, Integer perPage, String search, String namespace, String orderby, String permissions, List<String> tag, List<String> excludeTag, Boolean flat, String parent) throws ApiException {
        ApiResponse<GroupBrowserData> localVarResp = listPublicGroupsWithHttpInfo(page, perPage, search, namespace, orderby, permissions, tag, excludeTag, flat, parent);
        return localVarResp.getData();
    }

    /**
     * 
     * Returns one page of public groups.
     * @param page pagination offset (optional)
     * @param perPage pagination limit (optional)
     * @param search search string that will look at name, namespace or description fields (optional)
     * @param namespace namespace (optional)
     * @param orderby sort by which field valid values include last_accessed, size, name (optional)
     * @param permissions permissions valid values include read, read_write, write, admin (optional)
     * @param tag tag to search for, more than one can be included (optional)
     * @param excludeTag tags to exclude matching array in results, more than one can be included (optional)
     * @param flat if true, ignores the nesting of groups and searches all of them (optional)
     * @param parent search only the children of the groups with this uuid (optional)
     * @return ApiResponse&lt;GroupBrowserData&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> the group contents </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<GroupBrowserData> listPublicGroupsWithHttpInfo(Integer page, Integer perPage, String search, String namespace, String orderby, String permissions, List<String> tag, List<String> excludeTag, Boolean flat, String parent) throws ApiException {
        okhttp3.Call localVarCall = listPublicGroupsValidateBeforeCall(page, perPage, search, namespace, orderby, permissions, tag, excludeTag, flat, parent, null);
        Type localVarReturnType = new TypeToken<GroupBrowserData>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Returns one page of public groups.
     * @param page pagination offset (optional)
     * @param perPage pagination limit (optional)
     * @param search search string that will look at name, namespace or description fields (optional)
     * @param namespace namespace (optional)
     * @param orderby sort by which field valid values include last_accessed, size, name (optional)
     * @param permissions permissions valid values include read, read_write, write, admin (optional)
     * @param tag tag to search for, more than one can be included (optional)
     * @param excludeTag tags to exclude matching array in results, more than one can be included (optional)
     * @param flat if true, ignores the nesting of groups and searches all of them (optional)
     * @param parent search only the children of the groups with this uuid (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> the group contents </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listPublicGroupsAsync(Integer page, Integer perPage, String search, String namespace, String orderby, String permissions, List<String> tag, List<String> excludeTag, Boolean flat, String parent, final ApiCallback<GroupBrowserData> _callback) throws ApiException {

        okhttp3.Call localVarCall = listPublicGroupsValidateBeforeCall(page, perPage, search, namespace, orderby, permissions, tag, excludeTag, flat, parent, _callback);
        Type localVarReturnType = new TypeToken<GroupBrowserData>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listSharedGroups
     * @param page pagination offset (optional)
     * @param perPage pagination limit (optional)
     * @param search search string that will look at name, namespace or description fields (optional)
     * @param namespace namespace (optional)
     * @param orderby sort by which field valid values include last_accessed, size, name (optional)
     * @param permissions permissions valid values include read, read_write, write, admin (optional)
     * @param tag tag to search for, more than one can be included (optional)
     * @param excludeTag tags to exclude matching array in results, more than one can be included (optional)
     * @param flat if true, ignores the nesting of groups and searches all of them (optional)
     * @param parent search only the children of the groups with this uuid (optional)
     * @param sharedTo namespaces to filter results of where there groups were shared to (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> the group contents </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listSharedGroupsCall(Integer page, Integer perPage, String search, String namespace, String orderby, String permissions, List<String> tag, List<String> excludeTag, Boolean flat, String parent, List<String> sharedTo, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/groups/browser/shared";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (perPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("per_page", perPage));
        }

        if (search != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("search", search));
        }

        if (namespace != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("namespace", namespace));
        }

        if (orderby != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("orderby", orderby));
        }

        if (permissions != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("permissions", permissions));
        }

        if (tag != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "tag", tag));
        }

        if (excludeTag != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "exclude_tag", excludeTag));
        }

        if (flat != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("flat", flat));
        }

        if (parent != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("parent", parent));
        }

        if (sharedTo != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "shared_to", sharedTo));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listSharedGroupsValidateBeforeCall(Integer page, Integer perPage, String search, String namespace, String orderby, String permissions, List<String> tag, List<String> excludeTag, Boolean flat, String parent, List<String> sharedTo, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = listSharedGroupsCall(page, perPage, search, namespace, orderby, permissions, tag, excludeTag, flat, parent, sharedTo, _callback);
        return localVarCall;

    }

    /**
     * 
     * Returns one page of shared groups.
     * @param page pagination offset (optional)
     * @param perPage pagination limit (optional)
     * @param search search string that will look at name, namespace or description fields (optional)
     * @param namespace namespace (optional)
     * @param orderby sort by which field valid values include last_accessed, size, name (optional)
     * @param permissions permissions valid values include read, read_write, write, admin (optional)
     * @param tag tag to search for, more than one can be included (optional)
     * @param excludeTag tags to exclude matching array in results, more than one can be included (optional)
     * @param flat if true, ignores the nesting of groups and searches all of them (optional)
     * @param parent search only the children of the groups with this uuid (optional)
     * @param sharedTo namespaces to filter results of where there groups were shared to (optional)
     * @return GroupBrowserData
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> the group contents </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public GroupBrowserData listSharedGroups(Integer page, Integer perPage, String search, String namespace, String orderby, String permissions, List<String> tag, List<String> excludeTag, Boolean flat, String parent, List<String> sharedTo) throws ApiException {
        ApiResponse<GroupBrowserData> localVarResp = listSharedGroupsWithHttpInfo(page, perPage, search, namespace, orderby, permissions, tag, excludeTag, flat, parent, sharedTo);
        return localVarResp.getData();
    }

    /**
     * 
     * Returns one page of shared groups.
     * @param page pagination offset (optional)
     * @param perPage pagination limit (optional)
     * @param search search string that will look at name, namespace or description fields (optional)
     * @param namespace namespace (optional)
     * @param orderby sort by which field valid values include last_accessed, size, name (optional)
     * @param permissions permissions valid values include read, read_write, write, admin (optional)
     * @param tag tag to search for, more than one can be included (optional)
     * @param excludeTag tags to exclude matching array in results, more than one can be included (optional)
     * @param flat if true, ignores the nesting of groups and searches all of them (optional)
     * @param parent search only the children of the groups with this uuid (optional)
     * @param sharedTo namespaces to filter results of where there groups were shared to (optional)
     * @return ApiResponse&lt;GroupBrowserData&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> the group contents </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<GroupBrowserData> listSharedGroupsWithHttpInfo(Integer page, Integer perPage, String search, String namespace, String orderby, String permissions, List<String> tag, List<String> excludeTag, Boolean flat, String parent, List<String> sharedTo) throws ApiException {
        okhttp3.Call localVarCall = listSharedGroupsValidateBeforeCall(page, perPage, search, namespace, orderby, permissions, tag, excludeTag, flat, parent, sharedTo, null);
        Type localVarReturnType = new TypeToken<GroupBrowserData>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Returns one page of shared groups.
     * @param page pagination offset (optional)
     * @param perPage pagination limit (optional)
     * @param search search string that will look at name, namespace or description fields (optional)
     * @param namespace namespace (optional)
     * @param orderby sort by which field valid values include last_accessed, size, name (optional)
     * @param permissions permissions valid values include read, read_write, write, admin (optional)
     * @param tag tag to search for, more than one can be included (optional)
     * @param excludeTag tags to exclude matching array in results, more than one can be included (optional)
     * @param flat if true, ignores the nesting of groups and searches all of them (optional)
     * @param parent search only the children of the groups with this uuid (optional)
     * @param sharedTo namespaces to filter results of where there groups were shared to (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> the group contents </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listSharedGroupsAsync(Integer page, Integer perPage, String search, String namespace, String orderby, String permissions, List<String> tag, List<String> excludeTag, Boolean flat, String parent, List<String> sharedTo, final ApiCallback<GroupBrowserData> _callback) throws ApiException {

        okhttp3.Call localVarCall = listSharedGroupsValidateBeforeCall(page, perPage, search, namespace, orderby, permissions, tag, excludeTag, flat, parent, sharedTo, _callback);
        Type localVarReturnType = new TypeToken<GroupBrowserData>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for registerGroup
     * @param namespace The namespace of the group (required)
     * @param array The unique name or id of the group (required)
     * @param groupRegister  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> group created successfully </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call registerGroupCall(String namespace, String array, GroupRegister groupRegister, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = groupRegister;

        // create path and map variables
        String localVarPath = "/groups/{namespace}/{array}/register"
            .replaceAll("\\{" + "namespace" + "\\}", localVarApiClient.escapeString(namespace.toString()))
            .replaceAll("\\{" + "array" + "\\}", localVarApiClient.escapeString(array.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call registerGroupValidateBeforeCall(String namespace, String array, GroupRegister groupRegister, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'namespace' is set
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling registerGroup(Async)");
        }
        
        // verify the required parameter 'array' is set
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling registerGroup(Async)");
        }
        

        okhttp3.Call localVarCall = registerGroupCall(namespace, array, groupRegister, _callback);
        return localVarCall;

    }

    /**
     * 
     * Registers an existing group in the namespace.
     * @param namespace The namespace of the group (required)
     * @param array The unique name or id of the group (required)
     * @param groupRegister  (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> group created successfully </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public void registerGroup(String namespace, String array, GroupRegister groupRegister) throws ApiException {
        registerGroupWithHttpInfo(namespace, array, groupRegister);
    }

    /**
     * 
     * Registers an existing group in the namespace.
     * @param namespace The namespace of the group (required)
     * @param array The unique name or id of the group (required)
     * @param groupRegister  (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> group created successfully </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> registerGroupWithHttpInfo(String namespace, String array, GroupRegister groupRegister) throws ApiException {
        okhttp3.Call localVarCall = registerGroupValidateBeforeCall(namespace, array, groupRegister, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     *  (asynchronously)
     * Registers an existing group in the namespace.
     * @param namespace The namespace of the group (required)
     * @param array The unique name or id of the group (required)
     * @param groupRegister  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> group created successfully </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call registerGroupAsync(String namespace, String array, GroupRegister groupRegister, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = registerGroupValidateBeforeCall(namespace, array, groupRegister, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for shareGroup
     * @param groupNamespace The namespace of the group (required)
     * @param groupName The unique name or id of the group (required)
     * @param groupSharingRequest Namespace and list of permissions to share with. Sharing is recursive, it is applied to all reachable subgroups and arrays of the group. An empty list of permissions will remove the namespace; if permissions already exist they will be deleted then new ones added. In the event of a failure, the new policies will be rolled back to prevent partial policies, and it&#39;s likely the group will not be shared with the namespace at all. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Group shared successfully </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Group does not exist or user does not have permissions to share group </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call shareGroupCall(String groupNamespace, String groupName, GroupSharingRequest groupSharingRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = groupSharingRequest;

        // create path and map variables
        String localVarPath = "/groups/{group_namespace}/{group_name}/share"
            .replaceAll("\\{" + "group_namespace" + "\\}", localVarApiClient.escapeString(groupNamespace.toString()))
            .replaceAll("\\{" + "group_name" + "\\}", localVarApiClient.escapeString(groupName.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call shareGroupValidateBeforeCall(String groupNamespace, String groupName, GroupSharingRequest groupSharingRequest, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'groupNamespace' is set
        if (groupNamespace == null) {
            throw new ApiException("Missing the required parameter 'groupNamespace' when calling shareGroup(Async)");
        }
        
        // verify the required parameter 'groupName' is set
        if (groupName == null) {
            throw new ApiException("Missing the required parameter 'groupName' when calling shareGroup(Async)");
        }
        
        // verify the required parameter 'groupSharingRequest' is set
        if (groupSharingRequest == null) {
            throw new ApiException("Missing the required parameter 'groupSharingRequest' when calling shareGroup(Async)");
        }
        

        okhttp3.Call localVarCall = shareGroupCall(groupNamespace, groupName, groupSharingRequest, _callback);
        return localVarCall;

    }

    /**
     * 
     * Share a group with a namespace
     * @param groupNamespace The namespace of the group (required)
     * @param groupName The unique name or id of the group (required)
     * @param groupSharingRequest Namespace and list of permissions to share with. Sharing is recursive, it is applied to all reachable subgroups and arrays of the group. An empty list of permissions will remove the namespace; if permissions already exist they will be deleted then new ones added. In the event of a failure, the new policies will be rolled back to prevent partial policies, and it&#39;s likely the group will not be shared with the namespace at all. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Group shared successfully </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Group does not exist or user does not have permissions to share group </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public void shareGroup(String groupNamespace, String groupName, GroupSharingRequest groupSharingRequest) throws ApiException {
        shareGroupWithHttpInfo(groupNamespace, groupName, groupSharingRequest);
    }

    /**
     * 
     * Share a group with a namespace
     * @param groupNamespace The namespace of the group (required)
     * @param groupName The unique name or id of the group (required)
     * @param groupSharingRequest Namespace and list of permissions to share with. Sharing is recursive, it is applied to all reachable subgroups and arrays of the group. An empty list of permissions will remove the namespace; if permissions already exist they will be deleted then new ones added. In the event of a failure, the new policies will be rolled back to prevent partial policies, and it&#39;s likely the group will not be shared with the namespace at all. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Group shared successfully </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Group does not exist or user does not have permissions to share group </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> shareGroupWithHttpInfo(String groupNamespace, String groupName, GroupSharingRequest groupSharingRequest) throws ApiException {
        okhttp3.Call localVarCall = shareGroupValidateBeforeCall(groupNamespace, groupName, groupSharingRequest, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     *  (asynchronously)
     * Share a group with a namespace
     * @param groupNamespace The namespace of the group (required)
     * @param groupName The unique name or id of the group (required)
     * @param groupSharingRequest Namespace and list of permissions to share with. Sharing is recursive, it is applied to all reachable subgroups and arrays of the group. An empty list of permissions will remove the namespace; if permissions already exist they will be deleted then new ones added. In the event of a failure, the new policies will be rolled back to prevent partial policies, and it&#39;s likely the group will not be shared with the namespace at all. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Group shared successfully </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Group does not exist or user does not have permissions to share group </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call shareGroupAsync(String groupNamespace, String groupName, GroupSharingRequest groupSharingRequest, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = shareGroupValidateBeforeCall(groupNamespace, groupName, groupSharingRequest, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateGroup
     * @param groupNamespace The namespace of the group (required)
     * @param groupName The unique name or id of the group (required)
     * @param groupUpdate  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> attributes changed successfully </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateGroupCall(String groupNamespace, String groupName, GroupUpdate groupUpdate, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = groupUpdate;

        // create path and map variables
        String localVarPath = "/groups/{group_namespace}/{group_name}"
            .replaceAll("\\{" + "group_namespace" + "\\}", localVarApiClient.escapeString(groupNamespace.toString()))
            .replaceAll("\\{" + "group_name" + "\\}", localVarApiClient.escapeString(groupName.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateGroupValidateBeforeCall(String groupNamespace, String groupName, GroupUpdate groupUpdate, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'groupNamespace' is set
        if (groupNamespace == null) {
            throw new ApiException("Missing the required parameter 'groupNamespace' when calling updateGroup(Async)");
        }
        
        // verify the required parameter 'groupName' is set
        if (groupName == null) {
            throw new ApiException("Missing the required parameter 'groupName' when calling updateGroup(Async)");
        }
        

        okhttp3.Call localVarCall = updateGroupCall(groupNamespace, groupName, groupUpdate, _callback);
        return localVarCall;

    }

    /**
     * 
     * Changes attributes of the group
     * @param groupNamespace The namespace of the group (required)
     * @param groupName The unique name or id of the group (required)
     * @param groupUpdate  (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> attributes changed successfully </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public void updateGroup(String groupNamespace, String groupName, GroupUpdate groupUpdate) throws ApiException {
        updateGroupWithHttpInfo(groupNamespace, groupName, groupUpdate);
    }

    /**
     * 
     * Changes attributes of the group
     * @param groupNamespace The namespace of the group (required)
     * @param groupName The unique name or id of the group (required)
     * @param groupUpdate  (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> attributes changed successfully </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> updateGroupWithHttpInfo(String groupNamespace, String groupName, GroupUpdate groupUpdate) throws ApiException {
        okhttp3.Call localVarCall = updateGroupValidateBeforeCall(groupNamespace, groupName, groupUpdate, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     *  (asynchronously)
     * Changes attributes of the group
     * @param groupNamespace The namespace of the group (required)
     * @param groupName The unique name or id of the group (required)
     * @param groupUpdate  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> attributes changed successfully </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateGroupAsync(String groupNamespace, String groupName, GroupUpdate groupUpdate, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateGroupValidateBeforeCall(groupNamespace, groupName, groupUpdate, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}
