/*
 * TileDB Storage Platform API
 * TileDB Storage Platform REST API
 *
 * The version of the OpenAPI document: 2.2.19
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.tiledb.cloud.rest_api.api;

import io.tiledb.cloud.rest_api.ApiCallback;
import io.tiledb.cloud.rest_api.ApiClient;
import io.tiledb.cloud.rest_api.ApiException;
import io.tiledb.cloud.rest_api.ApiResponse;
import io.tiledb.cloud.rest_api.Configuration;
import io.tiledb.cloud.rest_api.Pair;

import com.google.gson.reflect.TypeToken;


import io.tiledb.cloud.rest_api.model.InvitationArrayShareEmail;
import io.tiledb.cloud.rest_api.model.InvitationData;
import io.tiledb.cloud.rest_api.model.InvitationOrganizationJoinEmail;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InvitationApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public InvitationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public InvitationApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    /**
     * Build call for acceptInvitation
     * @param invitation the ID of invitation about to be accepted (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Invitation was accepted successfully </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Could not find invitation identifier </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call acceptInvitationCall(String invitation, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/invitations/{invitation}"
            .replaceAll("\\{" + "invitation" + "\\}", localVarApiClient.escapeString(invitation.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call acceptInvitationValidateBeforeCall(String invitation, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'invitation' is set
        if (invitation == null) {
            throw new ApiException("Missing the required parameter 'invitation' when calling acceptInvitation(Async)");
        }
        

        okhttp3.Call localVarCall = acceptInvitationCall(invitation, _callback);
        return localVarCall;

    }

    /**
     * 
     * Accepts invitation
     * @param invitation the ID of invitation about to be accepted (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Invitation was accepted successfully </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Could not find invitation identifier </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public void acceptInvitation(String invitation) throws ApiException {
        acceptInvitationWithHttpInfo(invitation);
    }

    /**
     * 
     * Accepts invitation
     * @param invitation the ID of invitation about to be accepted (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Invitation was accepted successfully </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Could not find invitation identifier </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> acceptInvitationWithHttpInfo(String invitation) throws ApiException {
        okhttp3.Call localVarCall = acceptInvitationValidateBeforeCall(invitation, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     *  (asynchronously)
     * Accepts invitation
     * @param invitation the ID of invitation about to be accepted (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Invitation was accepted successfully </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Could not find invitation identifier </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call acceptInvitationAsync(String invitation, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = acceptInvitationValidateBeforeCall(invitation, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for cancelJoinOrganization
     * @param invitation the ID of invitation about to be cancelled (required)
     * @param organization name or UUID of organization (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Invitation cancelled successfully </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No invitation was found to cancel </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call cancelJoinOrganizationCall(String invitation, String organization, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/invitations/{invitation}/{organization}/join"
            .replaceAll("\\{" + "invitation" + "\\}", localVarApiClient.escapeString(invitation.toString()))
            .replaceAll("\\{" + "organization" + "\\}", localVarApiClient.escapeString(organization.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call cancelJoinOrganizationValidateBeforeCall(String invitation, String organization, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'invitation' is set
        if (invitation == null) {
            throw new ApiException("Missing the required parameter 'invitation' when calling cancelJoinOrganization(Async)");
        }
        
        // verify the required parameter 'organization' is set
        if (organization == null) {
            throw new ApiException("Missing the required parameter 'organization' when calling cancelJoinOrganization(Async)");
        }
        

        okhttp3.Call localVarCall = cancelJoinOrganizationCall(invitation, organization, _callback);
        return localVarCall;

    }

    /**
     * 
     * Cancels join organization invitation
     * @param invitation the ID of invitation about to be cancelled (required)
     * @param organization name or UUID of organization (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Invitation cancelled successfully </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No invitation was found to cancel </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public void cancelJoinOrganization(String invitation, String organization) throws ApiException {
        cancelJoinOrganizationWithHttpInfo(invitation, organization);
    }

    /**
     * 
     * Cancels join organization invitation
     * @param invitation the ID of invitation about to be cancelled (required)
     * @param organization name or UUID of organization (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Invitation cancelled successfully </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No invitation was found to cancel </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> cancelJoinOrganizationWithHttpInfo(String invitation, String organization) throws ApiException {
        okhttp3.Call localVarCall = cancelJoinOrganizationValidateBeforeCall(invitation, organization, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     *  (asynchronously)
     * Cancels join organization invitation
     * @param invitation the ID of invitation about to be cancelled (required)
     * @param organization name or UUID of organization (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Invitation cancelled successfully </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No invitation was found to cancel </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call cancelJoinOrganizationAsync(String invitation, String organization, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = cancelJoinOrganizationValidateBeforeCall(invitation, organization, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for cancelShareArrayByInvite
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param invitation the ID of invitation about to be cancelled (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Invitation cancelled successfully </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No invitation was found to cancel </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call cancelShareArrayByInviteCall(String namespace, String invitation, String array, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/invitations/{invitation}/{namespace}/{array}/share"
            .replaceAll("\\{" + "namespace" + "\\}", localVarApiClient.escapeString(namespace.toString()))
            .replaceAll("\\{" + "invitation" + "\\}", localVarApiClient.escapeString(invitation.toString()))
            .replaceAll("\\{" + "array" + "\\}", localVarApiClient.escapeString(array.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call cancelShareArrayByInviteValidateBeforeCall(String namespace, String invitation, String array, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'namespace' is set
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling cancelShareArrayByInvite(Async)");
        }
        
        // verify the required parameter 'invitation' is set
        if (invitation == null) {
            throw new ApiException("Missing the required parameter 'invitation' when calling cancelShareArrayByInvite(Async)");
        }
        
        // verify the required parameter 'array' is set
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling cancelShareArrayByInvite(Async)");
        }
        

        okhttp3.Call localVarCall = cancelShareArrayByInviteCall(namespace, invitation, array, _callback);
        return localVarCall;

    }

    /**
     * 
     * Cancels array sharing invitation
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param invitation the ID of invitation about to be cancelled (required)
     * @param array name/uri of array that is url-encoded (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Invitation cancelled successfully </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No invitation was found to cancel </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public void cancelShareArrayByInvite(String namespace, String invitation, String array) throws ApiException {
        cancelShareArrayByInviteWithHttpInfo(namespace, invitation, array);
    }

    /**
     * 
     * Cancels array sharing invitation
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param invitation the ID of invitation about to be cancelled (required)
     * @param array name/uri of array that is url-encoded (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Invitation cancelled successfully </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No invitation was found to cancel </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> cancelShareArrayByInviteWithHttpInfo(String namespace, String invitation, String array) throws ApiException {
        okhttp3.Call localVarCall = cancelShareArrayByInviteValidateBeforeCall(namespace, invitation, array, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     *  (asynchronously)
     * Cancels array sharing invitation
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param invitation the ID of invitation about to be cancelled (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Invitation cancelled successfully </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No invitation was found to cancel </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call cancelShareArrayByInviteAsync(String namespace, String invitation, String array, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = cancelShareArrayByInviteValidateBeforeCall(namespace, invitation, array, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for fetchInvitations
     * @param organization name or ID of organization to filter (optional)
     * @param array name/uri of array that is url-encoded to filter (optional)
     * @param start start time for tasks to filter by (optional)
     * @param end end time for tasks to filter by (optional)
     * @param page pagination offset (optional)
     * @param perPage pagination limit (optional)
     * @param type invitation type, \&quot;ARRAY_SHARE\&quot;, \&quot;JOIN_ORGANIZATION\&quot; (optional)
     * @param status Filter to only return \&quot;PENDING\&quot;, \&quot;ACCEPTED\&quot; (optional)
     * @param orderby sort by which field valid values include timestamp, array_name, organization_name (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List of invitations and pagination metadata </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call fetchInvitationsCall(String organization, String array, Integer start, Integer end, Integer page, Integer perPage, String type, String status, String orderby, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/invitations";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (organization != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("organization", organization));
        }

        if (array != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("array", array));
        }

        if (start != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("start", start));
        }

        if (end != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("end", end));
        }

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (perPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("per_page", perPage));
        }

        if (type != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("type", type));
        }

        if (status != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("status", status));
        }

        if (orderby != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("orderby", orderby));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call fetchInvitationsValidateBeforeCall(String organization, String array, Integer start, Integer end, Integer page, Integer perPage, String type, String status, String orderby, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = fetchInvitationsCall(organization, array, start, end, page, perPage, type, status, orderby, _callback);
        return localVarCall;

    }

    /**
     * 
     * Fetch a list of invitations
     * @param organization name or ID of organization to filter (optional)
     * @param array name/uri of array that is url-encoded to filter (optional)
     * @param start start time for tasks to filter by (optional)
     * @param end end time for tasks to filter by (optional)
     * @param page pagination offset (optional)
     * @param perPage pagination limit (optional)
     * @param type invitation type, \&quot;ARRAY_SHARE\&quot;, \&quot;JOIN_ORGANIZATION\&quot; (optional)
     * @param status Filter to only return \&quot;PENDING\&quot;, \&quot;ACCEPTED\&quot; (optional)
     * @param orderby sort by which field valid values include timestamp, array_name, organization_name (optional)
     * @return InvitationData
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List of invitations and pagination metadata </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public InvitationData fetchInvitations(String organization, String array, Integer start, Integer end, Integer page, Integer perPage, String type, String status, String orderby) throws ApiException {
        ApiResponse<InvitationData> localVarResp = fetchInvitationsWithHttpInfo(organization, array, start, end, page, perPage, type, status, orderby);
        return localVarResp.getData();
    }

    /**
     * 
     * Fetch a list of invitations
     * @param organization name or ID of organization to filter (optional)
     * @param array name/uri of array that is url-encoded to filter (optional)
     * @param start start time for tasks to filter by (optional)
     * @param end end time for tasks to filter by (optional)
     * @param page pagination offset (optional)
     * @param perPage pagination limit (optional)
     * @param type invitation type, \&quot;ARRAY_SHARE\&quot;, \&quot;JOIN_ORGANIZATION\&quot; (optional)
     * @param status Filter to only return \&quot;PENDING\&quot;, \&quot;ACCEPTED\&quot; (optional)
     * @param orderby sort by which field valid values include timestamp, array_name, organization_name (optional)
     * @return ApiResponse&lt;InvitationData&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List of invitations and pagination metadata </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<InvitationData> fetchInvitationsWithHttpInfo(String organization, String array, Integer start, Integer end, Integer page, Integer perPage, String type, String status, String orderby) throws ApiException {
        okhttp3.Call localVarCall = fetchInvitationsValidateBeforeCall(organization, array, start, end, page, perPage, type, status, orderby, null);
        Type localVarReturnType = new TypeToken<InvitationData>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Fetch a list of invitations
     * @param organization name or ID of organization to filter (optional)
     * @param array name/uri of array that is url-encoded to filter (optional)
     * @param start start time for tasks to filter by (optional)
     * @param end end time for tasks to filter by (optional)
     * @param page pagination offset (optional)
     * @param perPage pagination limit (optional)
     * @param type invitation type, \&quot;ARRAY_SHARE\&quot;, \&quot;JOIN_ORGANIZATION\&quot; (optional)
     * @param status Filter to only return \&quot;PENDING\&quot;, \&quot;ACCEPTED\&quot; (optional)
     * @param orderby sort by which field valid values include timestamp, array_name, organization_name (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List of invitations and pagination metadata </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call fetchInvitationsAsync(String organization, String array, Integer start, Integer end, Integer page, Integer perPage, String type, String status, String orderby, final ApiCallback<InvitationData> _callback) throws ApiException {

        okhttp3.Call localVarCall = fetchInvitationsValidateBeforeCall(organization, array, start, end, page, perPage, type, status, orderby, _callback);
        Type localVarReturnType = new TypeToken<InvitationData>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for joinOrganization
     * @param organization name or UUID of organization (required)
     * @param emailInvite list of email recipients (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Email sent successfully to user for email confirmation link </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Could not reach one or more recipients </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call joinOrganizationCall(String organization, InvitationOrganizationJoinEmail emailInvite, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = emailInvite;

        // create path and map variables
        String localVarPath = "/invitations/{organization}/join"
            .replaceAll("\\{" + "organization" + "\\}", localVarApiClient.escapeString(organization.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call joinOrganizationValidateBeforeCall(String organization, InvitationOrganizationJoinEmail emailInvite, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'organization' is set
        if (organization == null) {
            throw new ApiException("Missing the required parameter 'organization' when calling joinOrganization(Async)");
        }
        
        // verify the required parameter 'emailInvite' is set
        if (emailInvite == null) {
            throw new ApiException("Missing the required parameter 'emailInvite' when calling joinOrganization(Async)");
        }
        

        okhttp3.Call localVarCall = joinOrganizationCall(organization, emailInvite, _callback);
        return localVarCall;

    }

    /**
     * 
     * Sends email to multiple recipients with joining information regarding an organization
     * @param organization name or UUID of organization (required)
     * @param emailInvite list of email recipients (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Email sent successfully to user for email confirmation link </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Could not reach one or more recipients </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public void joinOrganization(String organization, InvitationOrganizationJoinEmail emailInvite) throws ApiException {
        joinOrganizationWithHttpInfo(organization, emailInvite);
    }

    /**
     * 
     * Sends email to multiple recipients with joining information regarding an organization
     * @param organization name or UUID of organization (required)
     * @param emailInvite list of email recipients (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Email sent successfully to user for email confirmation link </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Could not reach one or more recipients </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> joinOrganizationWithHttpInfo(String organization, InvitationOrganizationJoinEmail emailInvite) throws ApiException {
        okhttp3.Call localVarCall = joinOrganizationValidateBeforeCall(organization, emailInvite, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     *  (asynchronously)
     * Sends email to multiple recipients with joining information regarding an organization
     * @param organization name or UUID of organization (required)
     * @param emailInvite list of email recipients (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Email sent successfully to user for email confirmation link </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Could not reach one or more recipients </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call joinOrganizationAsync(String organization, InvitationOrganizationJoinEmail emailInvite, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = joinOrganizationValidateBeforeCall(organization, emailInvite, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for shareArrayByInvite
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param emailInvite list of email recipients (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Email sent successfully to user for email confirmation link </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Could not reach one or more recipients </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call shareArrayByInviteCall(String namespace, String array, InvitationArrayShareEmail emailInvite, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = emailInvite;

        // create path and map variables
        String localVarPath = "/invitations/{namespace}/{array}/share"
            .replaceAll("\\{" + "namespace" + "\\}", localVarApiClient.escapeString(namespace.toString()))
            .replaceAll("\\{" + "array" + "\\}", localVarApiClient.escapeString(array.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call shareArrayByInviteValidateBeforeCall(String namespace, String array, InvitationArrayShareEmail emailInvite, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'namespace' is set
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling shareArrayByInvite(Async)");
        }
        
        // verify the required parameter 'array' is set
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling shareArrayByInvite(Async)");
        }
        
        // verify the required parameter 'emailInvite' is set
        if (emailInvite == null) {
            throw new ApiException("Missing the required parameter 'emailInvite' when calling shareArrayByInvite(Async)");
        }
        

        okhttp3.Call localVarCall = shareArrayByInviteCall(namespace, array, emailInvite, _callback);
        return localVarCall;

    }

    /**
     * 
     * Sends email to multiple recipients with sharing information regarding an array
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param emailInvite list of email recipients (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Email sent successfully to user for email confirmation link </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Could not reach one or more recipients </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public void shareArrayByInvite(String namespace, String array, InvitationArrayShareEmail emailInvite) throws ApiException {
        shareArrayByInviteWithHttpInfo(namespace, array, emailInvite);
    }

    /**
     * 
     * Sends email to multiple recipients with sharing information regarding an array
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param emailInvite list of email recipients (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Email sent successfully to user for email confirmation link </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Could not reach one or more recipients </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> shareArrayByInviteWithHttpInfo(String namespace, String array, InvitationArrayShareEmail emailInvite) throws ApiException {
        okhttp3.Call localVarCall = shareArrayByInviteValidateBeforeCall(namespace, array, emailInvite, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     *  (asynchronously)
     * Sends email to multiple recipients with sharing information regarding an array
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param emailInvite list of email recipients (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Email sent successfully to user for email confirmation link </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Could not reach one or more recipients </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call shareArrayByInviteAsync(String namespace, String array, InvitationArrayShareEmail emailInvite, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = shareArrayByInviteValidateBeforeCall(namespace, array, emailInvite, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}
