/*
 * TileDB Storage Platform API
 * TileDB Storage Platform REST API
 *
 * The version of the OpenAPI document: 2.2.19
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.tiledb.cloud.rest_api.api;

import io.tiledb.cloud.rest_api.ApiCallback;
import io.tiledb.cloud.rest_api.ApiClient;
import io.tiledb.cloud.rest_api.ApiException;
import io.tiledb.cloud.rest_api.ApiResponse;
import io.tiledb.cloud.rest_api.Configuration;
import io.tiledb.cloud.rest_api.Pair;

import com.google.gson.reflect.TypeToken;


import io.tiledb.cloud.rest_api.model.ArrayInfoUpdate;

import java.io.File;
import io.tiledb.cloud.rest_api.model.FileUploaded;
import io.tiledb.cloud.rest_api.model.NotebookCopied;
import io.tiledb.cloud.rest_api.model.NotebookCopy;
import io.tiledb.cloud.rest_api.model.NotebookStatus;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NotebookApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public NotebookApi() {
        this(Configuration.getDefaultApiClient());
    }

    public NotebookApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    /**
     * Build call for getNotebookServerStatus
     * @param namespace namespace notebook is in (an organization name or user&#39;s username) (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> status of running notebook </td><td>  -  </td></tr>
        <tr><td> 202 </td><td> Notebook server is pending </td><td>  -  </td></tr>
        <tr><td> 402 </td><td> Payment required </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Notebook is not running </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getNotebookServerStatusCall(String namespace, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/notebooks/server/{namespace}/status"
            .replaceAll("\\{" + "namespace" + "\\}", localVarApiClient.escapeString(namespace.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getNotebookServerStatusValidateBeforeCall(String namespace, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'namespace' is set
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling getNotebookServerStatus(Async)");
        }
        

        okhttp3.Call localVarCall = getNotebookServerStatusCall(namespace, _callback);
        return localVarCall;

    }

    /**
     * 
     * Get status of the notebook server
     * @param namespace namespace notebook is in (an organization name or user&#39;s username) (required)
     * @return NotebookStatus
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> status of running notebook </td><td>  -  </td></tr>
        <tr><td> 202 </td><td> Notebook server is pending </td><td>  -  </td></tr>
        <tr><td> 402 </td><td> Payment required </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Notebook is not running </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public NotebookStatus getNotebookServerStatus(String namespace) throws ApiException {
        ApiResponse<NotebookStatus> localVarResp = getNotebookServerStatusWithHttpInfo(namespace);
        return localVarResp.getData();
    }

    /**
     * 
     * Get status of the notebook server
     * @param namespace namespace notebook is in (an organization name or user&#39;s username) (required)
     * @return ApiResponse&lt;NotebookStatus&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> status of running notebook </td><td>  -  </td></tr>
        <tr><td> 202 </td><td> Notebook server is pending </td><td>  -  </td></tr>
        <tr><td> 402 </td><td> Payment required </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Notebook is not running </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<NotebookStatus> getNotebookServerStatusWithHttpInfo(String namespace) throws ApiException {
        okhttp3.Call localVarCall = getNotebookServerStatusValidateBeforeCall(namespace, null);
        Type localVarReturnType = new TypeToken<NotebookStatus>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Get status of the notebook server
     * @param namespace namespace notebook is in (an organization name or user&#39;s username) (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> status of running notebook </td><td>  -  </td></tr>
        <tr><td> 202 </td><td> Notebook server is pending </td><td>  -  </td></tr>
        <tr><td> 402 </td><td> Payment required </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Notebook is not running </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getNotebookServerStatusAsync(String namespace, final ApiCallback<NotebookStatus> _callback) throws ApiException {

        okhttp3.Call localVarCall = getNotebookServerStatusValidateBeforeCall(namespace, _callback);
        Type localVarReturnType = new TypeToken<NotebookStatus>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for handleCopyNotebook
     * @param namespace The namespace of the notebook (required)
     * @param array The name of the notebook (required)
     * @param notebookCopy Input/Output information to create a new TileDB file (required)
     * @param X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME Optional registered access credentials to use for creation (optional)
     * @param endTimestamp Milliseconds since Unix epoch, copy will use open_at functionality to copy notebook created at the specific timestamp (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Notebook copied </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call handleCopyNotebookCall(String namespace, String array, NotebookCopy notebookCopy, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, Integer endTimestamp, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = notebookCopy;

        // create path and map variables
        String localVarPath = "/notebooks/{namespace}/{array}/copy"
            .replaceAll("\\{" + "namespace" + "\\}", localVarApiClient.escapeString(namespace.toString()))
            .replaceAll("\\{" + "array" + "\\}", localVarApiClient.escapeString(array.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (endTimestamp != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("end_timestamp", endTimestamp));
        }

        if (X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME != null) {
            localVarHeaderParams.put("X-TILEDB-CLOUD-ACCESS-CREDENTIALS-NAME", localVarApiClient.parameterToString(X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call handleCopyNotebookValidateBeforeCall(String namespace, String array, NotebookCopy notebookCopy, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, Integer endTimestamp, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'namespace' is set
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling handleCopyNotebook(Async)");
        }
        
        // verify the required parameter 'array' is set
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling handleCopyNotebook(Async)");
        }
        
        // verify the required parameter 'notebookCopy' is set
        if (notebookCopy == null) {
            throw new ApiException("Missing the required parameter 'notebookCopy' when calling handleCopyNotebook(Async)");
        }
        

        okhttp3.Call localVarCall = handleCopyNotebookCall(namespace, array, notebookCopy, X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, endTimestamp, _callback);
        return localVarCall;

    }

    /**
     * 
     * Copy a tiledb notebook at the specified location
     * @param namespace The namespace of the notebook (required)
     * @param array The name of the notebook (required)
     * @param notebookCopy Input/Output information to create a new TileDB file (required)
     * @param X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME Optional registered access credentials to use for creation (optional)
     * @param endTimestamp Milliseconds since Unix epoch, copy will use open_at functionality to copy notebook created at the specific timestamp (optional)
     * @return NotebookCopied
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Notebook copied </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public NotebookCopied handleCopyNotebook(String namespace, String array, NotebookCopy notebookCopy, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, Integer endTimestamp) throws ApiException {
        ApiResponse<NotebookCopied> localVarResp = handleCopyNotebookWithHttpInfo(namespace, array, notebookCopy, X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, endTimestamp);
        return localVarResp.getData();
    }

    /**
     * 
     * Copy a tiledb notebook at the specified location
     * @param namespace The namespace of the notebook (required)
     * @param array The name of the notebook (required)
     * @param notebookCopy Input/Output information to create a new TileDB file (required)
     * @param X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME Optional registered access credentials to use for creation (optional)
     * @param endTimestamp Milliseconds since Unix epoch, copy will use open_at functionality to copy notebook created at the specific timestamp (optional)
     * @return ApiResponse&lt;NotebookCopied&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Notebook copied </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<NotebookCopied> handleCopyNotebookWithHttpInfo(String namespace, String array, NotebookCopy notebookCopy, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, Integer endTimestamp) throws ApiException {
        okhttp3.Call localVarCall = handleCopyNotebookValidateBeforeCall(namespace, array, notebookCopy, X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, endTimestamp, null);
        Type localVarReturnType = new TypeToken<NotebookCopied>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Copy a tiledb notebook at the specified location
     * @param namespace The namespace of the notebook (required)
     * @param array The name of the notebook (required)
     * @param notebookCopy Input/Output information to create a new TileDB file (required)
     * @param X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME Optional registered access credentials to use for creation (optional)
     * @param endTimestamp Milliseconds since Unix epoch, copy will use open_at functionality to copy notebook created at the specific timestamp (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Notebook copied </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call handleCopyNotebookAsync(String namespace, String array, NotebookCopy notebookCopy, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, Integer endTimestamp, final ApiCallback<NotebookCopied> _callback) throws ApiException {

        okhttp3.Call localVarCall = handleCopyNotebookValidateBeforeCall(namespace, array, notebookCopy, X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, endTimestamp, _callback);
        Type localVarReturnType = new TypeToken<NotebookCopied>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for handleUploadNotebook
     * @param namespace The namespace of the notebook (required)
     * @param inputFile the notebook to upload (required)
     * @param X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME Optional registered access credentials to use for creation (optional)
     * @param outputUri output location of the TileDB File (optional)
     * @param name name to set for registered file (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> File uploaded </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call handleUploadNotebookCall(String namespace, File inputFile, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, String outputUri, String name, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/notebooks/{namespace}/upload"
            .replaceAll("\\{" + "namespace" + "\\}", localVarApiClient.escapeString(namespace.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (inputFile != null) {
            localVarFormParams.put("input_file", inputFile);
        }

        if (outputUri != null) {
            localVarFormParams.put("output_uri", outputUri);
        }

        if (name != null) {
            localVarFormParams.put("name", name);
        }

        if (X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME != null) {
            localVarHeaderParams.put("X-TILEDB-CLOUD-ACCESS-CREDENTIALS-NAME", localVarApiClient.parameterToString(X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "multipart/form-data"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call handleUploadNotebookValidateBeforeCall(String namespace, File inputFile, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, String outputUri, String name, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'namespace' is set
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling handleUploadNotebook(Async)");
        }
        
        // verify the required parameter 'inputFile' is set
        if (inputFile == null) {
            throw new ApiException("Missing the required parameter 'inputFile' when calling handleUploadNotebook(Async)");
        }
        

        okhttp3.Call localVarCall = handleUploadNotebookCall(namespace, inputFile, X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, outputUri, name, _callback);
        return localVarCall;

    }

    /**
     * 
     * Upload a notebook at the specified location
     * @param namespace The namespace of the notebook (required)
     * @param inputFile the notebook to upload (required)
     * @param X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME Optional registered access credentials to use for creation (optional)
     * @param outputUri output location of the TileDB File (optional)
     * @param name name to set for registered file (optional)
     * @return FileUploaded
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> File uploaded </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public FileUploaded handleUploadNotebook(String namespace, File inputFile, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, String outputUri, String name) throws ApiException {
        ApiResponse<FileUploaded> localVarResp = handleUploadNotebookWithHttpInfo(namespace, inputFile, X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, outputUri, name);
        return localVarResp.getData();
    }

    /**
     * 
     * Upload a notebook at the specified location
     * @param namespace The namespace of the notebook (required)
     * @param inputFile the notebook to upload (required)
     * @param X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME Optional registered access credentials to use for creation (optional)
     * @param outputUri output location of the TileDB File (optional)
     * @param name name to set for registered file (optional)
     * @return ApiResponse&lt;FileUploaded&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> File uploaded </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<FileUploaded> handleUploadNotebookWithHttpInfo(String namespace, File inputFile, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, String outputUri, String name) throws ApiException {
        okhttp3.Call localVarCall = handleUploadNotebookValidateBeforeCall(namespace, inputFile, X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, outputUri, name, null);
        Type localVarReturnType = new TypeToken<FileUploaded>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Upload a notebook at the specified location
     * @param namespace The namespace of the notebook (required)
     * @param inputFile the notebook to upload (required)
     * @param X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME Optional registered access credentials to use for creation (optional)
     * @param outputUri output location of the TileDB File (optional)
     * @param name name to set for registered file (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> File uploaded </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call handleUploadNotebookAsync(String namespace, File inputFile, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, String outputUri, String name, final ApiCallback<FileUploaded> _callback) throws ApiException {

        okhttp3.Call localVarCall = handleUploadNotebookValidateBeforeCall(namespace, inputFile, X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, outputUri, name, _callback);
        Type localVarReturnType = new TypeToken<FileUploaded>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for shutdownNotebookServer
     * @param namespace namespace notebook is in (an organization name or user&#39;s username) (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Notebook shutdown successfully </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Notebook is not running </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call shutdownNotebookServerCall(String namespace, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/notebooks/server/{namespace}"
            .replaceAll("\\{" + "namespace" + "\\}", localVarApiClient.escapeString(namespace.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call shutdownNotebookServerValidateBeforeCall(String namespace, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'namespace' is set
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling shutdownNotebookServer(Async)");
        }
        

        okhttp3.Call localVarCall = shutdownNotebookServerCall(namespace, _callback);
        return localVarCall;

    }

    /**
     * 
     * Shutdown a notebook server
     * @param namespace namespace notebook is in (an organization name or user&#39;s username) (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Notebook shutdown successfully </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Notebook is not running </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public void shutdownNotebookServer(String namespace) throws ApiException {
        shutdownNotebookServerWithHttpInfo(namespace);
    }

    /**
     * 
     * Shutdown a notebook server
     * @param namespace namespace notebook is in (an organization name or user&#39;s username) (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Notebook shutdown successfully </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Notebook is not running </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> shutdownNotebookServerWithHttpInfo(String namespace) throws ApiException {
        okhttp3.Call localVarCall = shutdownNotebookServerValidateBeforeCall(namespace, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     *  (asynchronously)
     * Shutdown a notebook server
     * @param namespace namespace notebook is in (an organization name or user&#39;s username) (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Notebook shutdown successfully </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Notebook is not running </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call shutdownNotebookServerAsync(String namespace, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = shutdownNotebookServerValidateBeforeCall(namespace, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateNotebookName
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of notebook (array) that is url-encoded (required)
     * @param notebookMetadata notebook (array) metadata to update (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> notebook name updated successfully </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateNotebookNameCall(String namespace, String array, ArrayInfoUpdate notebookMetadata, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = notebookMetadata;

        // create path and map variables
        String localVarPath = "/notebooks/{namespace}/{array}/rename"
            .replaceAll("\\{" + "namespace" + "\\}", localVarApiClient.escapeString(namespace.toString()))
            .replaceAll("\\{" + "array" + "\\}", localVarApiClient.escapeString(array.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateNotebookNameValidateBeforeCall(String namespace, String array, ArrayInfoUpdate notebookMetadata, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'namespace' is set
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling updateNotebookName(Async)");
        }
        
        // verify the required parameter 'array' is set
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling updateNotebookName(Async)");
        }
        
        // verify the required parameter 'notebookMetadata' is set
        if (notebookMetadata == null) {
            throw new ApiException("Missing the required parameter 'notebookMetadata' when calling updateNotebookName(Async)");
        }
        

        okhttp3.Call localVarCall = updateNotebookNameCall(namespace, array, notebookMetadata, _callback);
        return localVarCall;

    }

    /**
     * 
     * update name on a notebok, moving related S3 object to new location
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of notebook (array) that is url-encoded (required)
     * @param notebookMetadata notebook (array) metadata to update (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> notebook name updated successfully </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public void updateNotebookName(String namespace, String array, ArrayInfoUpdate notebookMetadata) throws ApiException {
        updateNotebookNameWithHttpInfo(namespace, array, notebookMetadata);
    }

    /**
     * 
     * update name on a notebok, moving related S3 object to new location
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of notebook (array) that is url-encoded (required)
     * @param notebookMetadata notebook (array) metadata to update (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> notebook name updated successfully </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> updateNotebookNameWithHttpInfo(String namespace, String array, ArrayInfoUpdate notebookMetadata) throws ApiException {
        okhttp3.Call localVarCall = updateNotebookNameValidateBeforeCall(namespace, array, notebookMetadata, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     *  (asynchronously)
     * update name on a notebok, moving related S3 object to new location
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of notebook (array) that is url-encoded (required)
     * @param notebookMetadata notebook (array) metadata to update (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> notebook name updated successfully </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateNotebookNameAsync(String namespace, String array, ArrayInfoUpdate notebookMetadata, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateNotebookNameValidateBeforeCall(namespace, array, notebookMetadata, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}
