/*
 * TileDB Storage Platform API
 * TileDB Storage Platform REST API
 *
 * The version of the OpenAPI document: 2.2.19
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.tiledb.cloud.rest_api.api;

import io.tiledb.cloud.rest_api.ApiClient;
import io.tiledb.cloud.rest_api.ApiException;
import io.tiledb.cloud.rest_api.ApiResponse;
import io.tiledb.cloud.rest_api.Pair;
import io.tiledb.cloud.rest_api.ApiCallback;
import io.tiledb.cloud.rest_api.Configuration;

import com.google.gson.reflect.TypeToken;


import java.io.File;
import io.tiledb.cloud.rest_api.model.Query;
import io.tiledb.cloud.rest_api.model.QueryJson;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QueryApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public QueryApi() {
        this(Configuration.getDefaultApiClient());
    }

    public QueryApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    /**
     * Build call for finalizeQuery
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param type type of query (required)
     * @param contentType Content Type of input and return mime (required)
     * @param query query to run (required)
     * @param xPayer Name of organization or user who should be charged for this request (optional)
     * @param openAt open_at for array in unix epoch (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> query completed and results are returned in query object </td><td>  * X-TILEDB-CLOUD-TASK-ID - Task ID for just completed request <br>  </td></tr>
        <tr><td> 204 </td><td> query completed successfully with no return </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call finalizeQueryCall(String namespace, String array, String type, String contentType, Query query, String xPayer, Integer openAt, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = query;

        // create path and map variables
        String localVarPath = "/arrays/{namespace}/{array}/query/finalize"
            .replaceAll("\\{" + "namespace" + "\\}", localVarApiClient.escapeString(namespace.toString()))
            .replaceAll("\\{" + "array" + "\\}", localVarApiClient.escapeString(array.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (type != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("type", type));
        }

        if (openAt != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("open_at", openAt));
        }

        if (contentType != null) {
            localVarHeaderParams.put("Content-Type", localVarApiClient.parameterToString(contentType));
        }

        if (xPayer != null) {
            localVarHeaderParams.put("X-Payer", localVarApiClient.parameterToString(xPayer));
        }

        final String[] localVarAccepts = {
            "application/json", "application/capnp"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json", "application/capnp"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call finalizeQueryValidateBeforeCall(String namespace, String array, String type, String contentType, Query query, String xPayer, Integer openAt, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'namespace' is set
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling finalizeQuery(Async)");
        }
        
        // verify the required parameter 'array' is set
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling finalizeQuery(Async)");
        }
        
        // verify the required parameter 'type' is set
        if (type == null) {
            throw new ApiException("Missing the required parameter 'type' when calling finalizeQuery(Async)");
        }
        
        // verify the required parameter 'contentType' is set
        if (contentType == null) {
            throw new ApiException("Missing the required parameter 'contentType' when calling finalizeQuery(Async)");
        }
        
        // verify the required parameter 'query' is set
        if (query == null) {
            throw new ApiException("Missing the required parameter 'query' when calling finalizeQuery(Async)");
        }
        

        okhttp3.Call localVarCall = finalizeQueryCall(namespace, array, type, contentType, query, xPayer, openAt, _callback);
        return localVarCall;

    }

    /**
     * 
     * send a query to run against a specified array/URI registered to a group/project
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param type type of query (required)
     * @param contentType Content Type of input and return mime (required)
     * @param query query to run (required)
     * @param xPayer Name of organization or user who should be charged for this request (optional)
     * @param openAt open_at for array in unix epoch (optional)
     * @return Query
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> query completed and results are returned in query object </td><td>  * X-TILEDB-CLOUD-TASK-ID - Task ID for just completed request <br>  </td></tr>
        <tr><td> 204 </td><td> query completed successfully with no return </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public Query finalizeQuery(String namespace, String array, String type, String contentType, Query query, String xPayer, Integer openAt) throws ApiException {
        ApiResponse<Query> localVarResp = finalizeQueryWithHttpInfo(namespace, array, type, contentType, query, xPayer, openAt);
        return localVarResp.getData();
    }

    /**
     * 
     * send a query to run against a specified array/URI registered to a group/project
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param type type of query (required)
     * @param contentType Content Type of input and return mime (required)
     * @param query query to run (required)
     * @param xPayer Name of organization or user who should be charged for this request (optional)
     * @param openAt open_at for array in unix epoch (optional)
     * @return ApiResponse&lt;Query&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> query completed and results are returned in query object </td><td>  * X-TILEDB-CLOUD-TASK-ID - Task ID for just completed request <br>  </td></tr>
        <tr><td> 204 </td><td> query completed successfully with no return </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Query> finalizeQueryWithHttpInfo(String namespace, String array, String type, String contentType, Query query, String xPayer, Integer openAt) throws ApiException {
        okhttp3.Call localVarCall = finalizeQueryValidateBeforeCall(namespace, array, type, contentType, query, xPayer, openAt, null);
        Type localVarReturnType = new TypeToken<Query>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * send a query to run against a specified array/URI registered to a group/project
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param type type of query (required)
     * @param contentType Content Type of input and return mime (required)
     * @param query query to run (required)
     * @param xPayer Name of organization or user who should be charged for this request (optional)
     * @param openAt open_at for array in unix epoch (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> query completed and results are returned in query object </td><td>  * X-TILEDB-CLOUD-TASK-ID - Task ID for just completed request <br>  </td></tr>
        <tr><td> 204 </td><td> query completed successfully with no return </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call finalizeQueryAsync(String namespace, String array, String type, String contentType, Query query, String xPayer, Integer openAt, final ApiCallback<Query> _callback) throws ApiException {

        okhttp3.Call localVarCall = finalizeQueryValidateBeforeCall(namespace, array, type, contentType, query, xPayer, openAt, _callback);
        Type localVarReturnType = new TypeToken<Query>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getEstResultSizes
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param type type of query (required)
     * @param contentType Content Type of input and return mime (required)
     * @param query query to run (required)
     * @param xPayer Name of organization or user who should be charged for this request (optional)
     * @param openAt open_at for array in unix epoch (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> query est result size computed and results are returned in query object </td><td>  * X-TILEDB-CLOUD-TASK-ID - Task ID for just completed request <br>  </td></tr>
        <tr><td> 204 </td><td> query completed successfully with no return </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getEstResultSizesCall(String namespace, String array, String type, String contentType, Query query, String xPayer, Integer openAt, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = query;

        // create path and map variables
        String localVarPath = "/arrays/{namespace}/{array}/query/est_result_sizes"
            .replaceAll("\\{" + "namespace" + "\\}", localVarApiClient.escapeString(namespace.toString()))
            .replaceAll("\\{" + "array" + "\\}", localVarApiClient.escapeString(array.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (type != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("type", type));
        }

        if (openAt != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("open_at", openAt));
        }

        if (contentType != null) {
            localVarHeaderParams.put("Content-Type", localVarApiClient.parameterToString(contentType));
        }

        if (xPayer != null) {
            localVarHeaderParams.put("X-Payer", localVarApiClient.parameterToString(xPayer));
        }

        final String[] localVarAccepts = {
            "application/json", "application/capnp"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json", "application/capnp"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getEstResultSizesValidateBeforeCall(String namespace, String array, String type, String contentType, Query query, String xPayer, Integer openAt, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'namespace' is set
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling getEstResultSizes(Async)");
        }
        
        // verify the required parameter 'array' is set
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling getEstResultSizes(Async)");
        }
        
        // verify the required parameter 'type' is set
        if (type == null) {
            throw new ApiException("Missing the required parameter 'type' when calling getEstResultSizes(Async)");
        }
        
        // verify the required parameter 'contentType' is set
        if (contentType == null) {
            throw new ApiException("Missing the required parameter 'contentType' when calling getEstResultSizes(Async)");
        }
        
        // verify the required parameter 'query' is set
        if (query == null) {
            throw new ApiException("Missing the required parameter 'query' when calling getEstResultSizes(Async)");
        }
        

        okhttp3.Call localVarCall = getEstResultSizesCall(namespace, array, type, contentType, query, xPayer, openAt, _callback);
        return localVarCall;

    }

    /**
     * 
     * send a query to run against a specified array/URI registered to a group/project
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param type type of query (required)
     * @param contentType Content Type of input and return mime (required)
     * @param query query to run (required)
     * @param xPayer Name of organization or user who should be charged for this request (optional)
     * @param openAt open_at for array in unix epoch (optional)
     * @return Query
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> query est result size computed and results are returned in query object </td><td>  * X-TILEDB-CLOUD-TASK-ID - Task ID for just completed request <br>  </td></tr>
        <tr><td> 204 </td><td> query completed successfully with no return </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public Query getEstResultSizes(String namespace, String array, String type, String contentType, Query query, String xPayer, Integer openAt) throws ApiException {
        ApiResponse<Query> localVarResp = getEstResultSizesWithHttpInfo(namespace, array, type, contentType, query, xPayer, openAt);
        return localVarResp.getData();
    }

    /**
     * 
     * send a query to run against a specified array/URI registered to a group/project
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param type type of query (required)
     * @param contentType Content Type of input and return mime (required)
     * @param query query to run (required)
     * @param xPayer Name of organization or user who should be charged for this request (optional)
     * @param openAt open_at for array in unix epoch (optional)
     * @return ApiResponse&lt;Query&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> query est result size computed and results are returned in query object </td><td>  * X-TILEDB-CLOUD-TASK-ID - Task ID for just completed request <br>  </td></tr>
        <tr><td> 204 </td><td> query completed successfully with no return </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Query> getEstResultSizesWithHttpInfo(String namespace, String array, String type, String contentType, Query query, String xPayer, Integer openAt) throws ApiException {
        okhttp3.Call localVarCall = getEstResultSizesValidateBeforeCall(namespace, array, type, contentType, query, xPayer, openAt, null);
        Type localVarReturnType = new TypeToken<Query>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * send a query to run against a specified array/URI registered to a group/project
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param type type of query (required)
     * @param contentType Content Type of input and return mime (required)
     * @param query query to run (required)
     * @param xPayer Name of organization or user who should be charged for this request (optional)
     * @param openAt open_at for array in unix epoch (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> query est result size computed and results are returned in query object </td><td>  * X-TILEDB-CLOUD-TASK-ID - Task ID for just completed request <br>  </td></tr>
        <tr><td> 204 </td><td> query completed successfully with no return </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getEstResultSizesAsync(String namespace, String array, String type, String contentType, Query query, String xPayer, Integer openAt, final ApiCallback<Query> _callback) throws ApiException {

        okhttp3.Call localVarCall = getEstResultSizesValidateBeforeCall(namespace, array, type, contentType, query, xPayer, openAt, _callback);
        Type localVarReturnType = new TypeToken<Query>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getFile
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param contentType Content Type of input and return mime (required)
     * @param xPayer Name of organization or user who should be charged for this request (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> query completed and result bytes are returned </td><td>  * X-TILEDB-CLOUD-TASK-ID - Task ID for just completed request <br>  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getFileCall(String namespace, String array, String contentType, String xPayer, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/arrays/{namespace}/{array}/query/get_file"
            .replaceAll("\\{" + "namespace" + "\\}", localVarApiClient.escapeString(namespace.toString()))
            .replaceAll("\\{" + "array" + "\\}", localVarApiClient.escapeString(array.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (contentType != null) {
            localVarHeaderParams.put("Content-Type", localVarApiClient.parameterToString(contentType));
        }

        if (xPayer != null) {
            localVarHeaderParams.put("X-Payer", localVarApiClient.parameterToString(xPayer));
        }

        final String[] localVarAccepts = {
            "application/x-ipynb+json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getFileValidateBeforeCall(String namespace, String array, String contentType, String xPayer, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'namespace' is set
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling getFile(Async)");
        }
        
        // verify the required parameter 'array' is set
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling getFile(Async)");
        }
        
        // verify the required parameter 'contentType' is set
        if (contentType == null) {
            throw new ApiException("Missing the required parameter 'contentType' when calling getFile(Async)");
        }
        

        okhttp3.Call localVarCall = getFileCall(namespace, array, contentType, xPayer, _callback);
        return localVarCall;

    }

    /**
     * 
     * send a query to run against a specified array/URI registered to a group/project, returns file bytes
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param contentType Content Type of input and return mime (required)
     * @param xPayer Name of organization or user who should be charged for this request (optional)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> query completed and result bytes are returned </td><td>  * X-TILEDB-CLOUD-TASK-ID - Task ID for just completed request <br>  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public File getFile(String namespace, String array, String contentType, String xPayer) throws ApiException {
        ApiResponse<File> localVarResp = getFileWithHttpInfo(namespace, array, contentType, xPayer);
        return localVarResp.getData();
    }

    /**
     * 
     * send a query to run against a specified array/URI registered to a group/project, returns file bytes
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param contentType Content Type of input and return mime (required)
     * @param xPayer Name of organization or user who should be charged for this request (optional)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> query completed and result bytes are returned </td><td>  * X-TILEDB-CLOUD-TASK-ID - Task ID for just completed request <br>  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<File> getFileWithHttpInfo(String namespace, String array, String contentType, String xPayer) throws ApiException {
        okhttp3.Call localVarCall = getFileValidateBeforeCall(namespace, array, contentType, xPayer, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * send a query to run against a specified array/URI registered to a group/project, returns file bytes
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param contentType Content Type of input and return mime (required)
     * @param xPayer Name of organization or user who should be charged for this request (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> query completed and result bytes are returned </td><td>  * X-TILEDB-CLOUD-TASK-ID - Task ID for just completed request <br>  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getFileAsync(String namespace, String array, String contentType, String xPayer, final ApiCallback<File> _callback) throws ApiException {

        okhttp3.Call localVarCall = getFileValidateBeforeCall(namespace, array, contentType, xPayer, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for submitQuery
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param type type of query (required)
     * @param contentType Content Type of input and return mime (required)
     * @param query query to run (required)
     * @param xPayer Name of organization or user who should be charged for this request (optional)
     * @param openAt open_at for array in unix epoch (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> query completed and results are returned in query object </td><td>  * X-TILEDB-CLOUD-TASK-ID - Task ID for just completed request <br>  </td></tr>
        <tr><td> 204 </td><td> query completed successfully with no return </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call submitQueryCall(String namespace, String array, String type, String contentType, Query query, String xPayer, Integer openAt, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = query;

        // create path and map variables
        String localVarPath = "/arrays/{namespace}/{array}/query/submit"
            .replaceAll("\\{" + "namespace" + "\\}", localVarApiClient.escapeString(namespace.toString()))
            .replaceAll("\\{" + "array" + "\\}", localVarApiClient.escapeString(array.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (type != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("type", type));
        }

        if (openAt != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("open_at", openAt));
        }

        if (contentType != null) {
            localVarHeaderParams.put("Content-Type", localVarApiClient.parameterToString(contentType));
        }

        if (xPayer != null) {
            localVarHeaderParams.put("X-Payer", localVarApiClient.parameterToString(xPayer));
        }

        final String[] localVarAccepts = {
            "application/json", "application/capnp"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json", "application/capnp"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call submitQueryValidateBeforeCall(String namespace, String array, String type, String contentType, Query query, String xPayer, Integer openAt, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'namespace' is set
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling submitQuery(Async)");
        }
        
        // verify the required parameter 'array' is set
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling submitQuery(Async)");
        }
        
        // verify the required parameter 'type' is set
        if (type == null) {
            throw new ApiException("Missing the required parameter 'type' when calling submitQuery(Async)");
        }
        
        // verify the required parameter 'contentType' is set
        if (contentType == null) {
            throw new ApiException("Missing the required parameter 'contentType' when calling submitQuery(Async)");
        }
        
        // verify the required parameter 'query' is set
        if (query == null) {
            throw new ApiException("Missing the required parameter 'query' when calling submitQuery(Async)");
        }
        

        okhttp3.Call localVarCall = submitQueryCall(namespace, array, type, contentType, query, xPayer, openAt, _callback);
        return localVarCall;

    }

    /**
     * 
     * send a query to run against a specified array/URI registered to a group/project
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param type type of query (required)
     * @param contentType Content Type of input and return mime (required)
     * @param query query to run (required)
     * @param xPayer Name of organization or user who should be charged for this request (optional)
     * @param openAt open_at for array in unix epoch (optional)
     * @return Query
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> query completed and results are returned in query object </td><td>  * X-TILEDB-CLOUD-TASK-ID - Task ID for just completed request <br>  </td></tr>
        <tr><td> 204 </td><td> query completed successfully with no return </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public Query submitQuery(String namespace, String array, String type, String contentType, Query query, String xPayer, Integer openAt) throws ApiException {
        ApiResponse<Query> localVarResp = submitQueryWithHttpInfo(namespace, array, type, contentType, query, xPayer, openAt);
        return localVarResp.getData();
    }

    /**
     * 
     * send a query to run against a specified array/URI registered to a group/project
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param type type of query (required)
     * @param contentType Content Type of input and return mime (required)
     * @param query query to run (required)
     * @param xPayer Name of organization or user who should be charged for this request (optional)
     * @param openAt open_at for array in unix epoch (optional)
     * @return ApiResponse&lt;Query&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> query completed and results are returned in query object </td><td>  * X-TILEDB-CLOUD-TASK-ID - Task ID for just completed request <br>  </td></tr>
        <tr><td> 204 </td><td> query completed successfully with no return </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Query> submitQueryWithHttpInfo(String namespace, String array, String type, String contentType, Query query, String xPayer, Integer openAt) throws ApiException {
        okhttp3.Call localVarCall = submitQueryValidateBeforeCall(namespace, array, type, contentType, query, xPayer, openAt, null);
        Type localVarReturnType = new TypeToken<Query>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * send a query to run against a specified array/URI registered to a group/project
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param type type of query (required)
     * @param contentType Content Type of input and return mime (required)
     * @param query query to run (required)
     * @param xPayer Name of organization or user who should be charged for this request (optional)
     * @param openAt open_at for array in unix epoch (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> query completed and results are returned in query object </td><td>  * X-TILEDB-CLOUD-TASK-ID - Task ID for just completed request <br>  </td></tr>
        <tr><td> 204 </td><td> query completed successfully with no return </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call submitQueryAsync(String namespace, String array, String type, String contentType, Query query, String xPayer, Integer openAt, final ApiCallback<Query> _callback) throws ApiException {

        okhttp3.Call localVarCall = submitQueryValidateBeforeCall(namespace, array, type, contentType, query, xPayer, openAt, _callback);
        Type localVarReturnType = new TypeToken<Query>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for submitQueryJson
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param contentType Content Type of input and return mime (required)
     * @param queryJson query to run (required)
     * @param xPayer Name of organization or user who should be charged for this request (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> query completed and results are returned in JSON format </td><td>  * X-TILEDB-CLOUD-TASK-ID - Task ID for just completed request <br>  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call submitQueryJsonCall(String namespace, String array, String contentType, QueryJson queryJson, String xPayer, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = queryJson;

        // create path and map variables
        String localVarPath = "/arrays/{namespace}/{array}/query/submit_query_json"
            .replaceAll("\\{" + "namespace" + "\\}", localVarApiClient.escapeString(namespace.toString()))
            .replaceAll("\\{" + "array" + "\\}", localVarApiClient.escapeString(array.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (contentType != null) {
            localVarHeaderParams.put("Content-Type", localVarApiClient.parameterToString(contentType));
        }

        if (xPayer != null) {
            localVarHeaderParams.put("X-Payer", localVarApiClient.parameterToString(xPayer));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call submitQueryJsonValidateBeforeCall(String namespace, String array, String contentType, QueryJson queryJson, String xPayer, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'namespace' is set
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling submitQueryJson(Async)");
        }
        
        // verify the required parameter 'array' is set
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling submitQueryJson(Async)");
        }
        
        // verify the required parameter 'contentType' is set
        if (contentType == null) {
            throw new ApiException("Missing the required parameter 'contentType' when calling submitQueryJson(Async)");
        }
        
        // verify the required parameter 'queryJson' is set
        if (queryJson == null) {
            throw new ApiException("Missing the required parameter 'queryJson' when calling submitQueryJson(Async)");
        }
        

        okhttp3.Call localVarCall = submitQueryJsonCall(namespace, array, contentType, queryJson, xPayer, _callback);
        return localVarCall;

    }

    /**
     * 
     * send a query to run against a specified array/URI registered to a group/project, returns JSON results
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param contentType Content Type of input and return mime (required)
     * @param queryJson query to run (required)
     * @param xPayer Name of organization or user who should be charged for this request (optional)
     * @return Object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> query completed and results are returned in JSON format </td><td>  * X-TILEDB-CLOUD-TASK-ID - Task ID for just completed request <br>  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public Object submitQueryJson(String namespace, String array, String contentType, QueryJson queryJson, String xPayer) throws ApiException {
        ApiResponse<Object> localVarResp = submitQueryJsonWithHttpInfo(namespace, array, contentType, queryJson, xPayer);
        return localVarResp.getData();
    }

    /**
     * 
     * send a query to run against a specified array/URI registered to a group/project, returns JSON results
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param contentType Content Type of input and return mime (required)
     * @param queryJson query to run (required)
     * @param xPayer Name of organization or user who should be charged for this request (optional)
     * @return ApiResponse&lt;Object&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> query completed and results are returned in JSON format </td><td>  * X-TILEDB-CLOUD-TASK-ID - Task ID for just completed request <br>  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Object> submitQueryJsonWithHttpInfo(String namespace, String array, String contentType, QueryJson queryJson, String xPayer) throws ApiException {
        okhttp3.Call localVarCall = submitQueryJsonValidateBeforeCall(namespace, array, contentType, queryJson, xPayer, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * send a query to run against a specified array/URI registered to a group/project, returns JSON results
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param contentType Content Type of input and return mime (required)
     * @param queryJson query to run (required)
     * @param xPayer Name of organization or user who should be charged for this request (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> query completed and results are returned in JSON format </td><td>  * X-TILEDB-CLOUD-TASK-ID - Task ID for just completed request <br>  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call submitQueryJsonAsync(String namespace, String array, String contentType, QueryJson queryJson, String xPayer, final ApiCallback<Object> _callback) throws ApiException {

        okhttp3.Call localVarCall = submitQueryJsonValidateBeforeCall(namespace, array, contentType, queryJson, xPayer, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
