/*
 * TileDB Storage Platform API
 * TileDB Storage Platform REST API
 *
 * The version of the OpenAPI document: 2.2.19
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.tiledb.cloud.rest_api.api;

import io.tiledb.cloud.rest_api.ApiCallback;
import io.tiledb.cloud.rest_api.ApiClient;
import io.tiledb.cloud.rest_api.ApiException;
import io.tiledb.cloud.rest_api.ApiResponse;
import io.tiledb.cloud.rest_api.Configuration;
import io.tiledb.cloud.rest_api.Pair;

import com.google.gson.reflect.TypeToken;


import io.tiledb.cloud.rest_api.model.ArrayTask;
import io.tiledb.cloud.rest_api.model.ArrayTaskData;
import io.tiledb.cloud.rest_api.model.SQLParameters;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TasksApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public TasksApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TasksApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    /**
     * Build call for runSQL
     * @param namespace namespace to run task under is in (an organization name or user&#39;s username) (required)
     * @param sql sql being submitted (required)
     * @param acceptEncoding Encoding to use (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> JSON results in array of objects form, if the query returns results </td><td>  * X-TILEDB-CLOUD-TASK-ID - Task ID for just completed request <br>  </td></tr>
        <tr><td> 204 </td><td> SQL executed successfully </td><td>  * X-TILEDB-CLOUD-TASK-ID - Task ID for just completed request <br>  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call runSQLCall(String namespace, SQLParameters sql, String acceptEncoding, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = sql;

        // create path and map variables
        String localVarPath = "/sql/{namespace}"
            .replaceAll("\\{" + "namespace" + "\\}", localVarApiClient.escapeString(namespace.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", localVarApiClient.parameterToString(acceptEncoding));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call runSQLValidateBeforeCall(String namespace, SQLParameters sql, String acceptEncoding, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'namespace' is set
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling runSQL(Async)");
        }
        
        // verify the required parameter 'sql' is set
        if (sql == null) {
            throw new ApiException("Missing the required parameter 'sql' when calling runSQL(Async)");
        }
        

        okhttp3.Call localVarCall = runSQLCall(namespace, sql, acceptEncoding, _callback);
        return localVarCall;

    }

    /**
     * 
     * Run a sql query
     * @param namespace namespace to run task under is in (an organization name or user&#39;s username) (required)
     * @param sql sql being submitted (required)
     * @param acceptEncoding Encoding to use (optional)
     * @return List&lt;Object&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> JSON results in array of objects form, if the query returns results </td><td>  * X-TILEDB-CLOUD-TASK-ID - Task ID for just completed request <br>  </td></tr>
        <tr><td> 204 </td><td> SQL executed successfully </td><td>  * X-TILEDB-CLOUD-TASK-ID - Task ID for just completed request <br>  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public List<Object> runSQL(String namespace, SQLParameters sql, String acceptEncoding) throws ApiException {
        ApiResponse<List<Object>> localVarResp = runSQLWithHttpInfo(namespace, sql, acceptEncoding);
        return localVarResp.getData();
    }

    /**
     * 
     * Run a sql query
     * @param namespace namespace to run task under is in (an organization name or user&#39;s username) (required)
     * @param sql sql being submitted (required)
     * @param acceptEncoding Encoding to use (optional)
     * @return ApiResponse&lt;List&lt;Object&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> JSON results in array of objects form, if the query returns results </td><td>  * X-TILEDB-CLOUD-TASK-ID - Task ID for just completed request <br>  </td></tr>
        <tr><td> 204 </td><td> SQL executed successfully </td><td>  * X-TILEDB-CLOUD-TASK-ID - Task ID for just completed request <br>  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<Object>> runSQLWithHttpInfo(String namespace, SQLParameters sql, String acceptEncoding) throws ApiException {
        okhttp3.Call localVarCall = runSQLValidateBeforeCall(namespace, sql, acceptEncoding, null);
        Type localVarReturnType = new TypeToken<List<Object>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Run a sql query
     * @param namespace namespace to run task under is in (an organization name or user&#39;s username) (required)
     * @param sql sql being submitted (required)
     * @param acceptEncoding Encoding to use (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> JSON results in array of objects form, if the query returns results </td><td>  * X-TILEDB-CLOUD-TASK-ID - Task ID for just completed request <br>  </td></tr>
        <tr><td> 204 </td><td> SQL executed successfully </td><td>  * X-TILEDB-CLOUD-TASK-ID - Task ID for just completed request <br>  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call runSQLAsync(String namespace, SQLParameters sql, String acceptEncoding, final ApiCallback<List<Object>> _callback) throws ApiException {

        okhttp3.Call localVarCall = runSQLValidateBeforeCall(namespace, sql, acceptEncoding, _callback);
        Type localVarReturnType = new TypeToken<List<Object>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for taskIdGet
     * @param id task ID to fetch (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Array task </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call taskIdGetCall(String id, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/task/{id}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call taskIdGetValidateBeforeCall(String id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling taskIdGet(Async)");
        }
        

        okhttp3.Call localVarCall = taskIdGetCall(id, _callback);
        return localVarCall;

    }

    /**
     * 
     * Fetch an array task
     * @param id task ID to fetch (required)
     * @return ArrayTask
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Array task </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ArrayTask taskIdGet(String id) throws ApiException {
        ApiResponse<ArrayTask> localVarResp = taskIdGetWithHttpInfo(id);
        return localVarResp.getData();
    }

    /**
     * 
     * Fetch an array task
     * @param id task ID to fetch (required)
     * @return ApiResponse&lt;ArrayTask&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Array task </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ArrayTask> taskIdGetWithHttpInfo(String id) throws ApiException {
        okhttp3.Call localVarCall = taskIdGetValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<ArrayTask>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Fetch an array task
     * @param id task ID to fetch (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Array task </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call taskIdGetAsync(String id, final ApiCallback<ArrayTask> _callback) throws ApiException {

        okhttp3.Call localVarCall = taskIdGetValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<ArrayTask>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for taskIdResultGet
     * @param id task ID to retrieve stored results (required)
     * @param acceptEncoding Encoding to use (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> output and format of originating request </td><td>  * Content-Type - format results are delivered in <br>  </td></tr>
        <tr><td> 202 </td><td> task is still executing </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> results were not saved, or results have expored </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call taskIdResultGetCall(String id, String acceptEncoding, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/task/{id}/result"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", localVarApiClient.parameterToString(acceptEncoding));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call taskIdResultGetValidateBeforeCall(String id, String acceptEncoding, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling taskIdResultGet(Async)");
        }
        

        okhttp3.Call localVarCall = taskIdResultGetCall(id, acceptEncoding, _callback);
        return localVarCall;

    }

    /**
     * 
     * Retrieve results of an array task
     * @param id task ID to retrieve stored results (required)
     * @param acceptEncoding Encoding to use (optional)
     * @return String
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> output and format of originating request </td><td>  * Content-Type - format results are delivered in <br>  </td></tr>
        <tr><td> 202 </td><td> task is still executing </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> results were not saved, or results have expored </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public String taskIdResultGet(String id, String acceptEncoding) throws ApiException {
        ApiResponse<String> localVarResp = taskIdResultGetWithHttpInfo(id, acceptEncoding);
        return localVarResp.getData();
    }

    /**
     * 
     * Retrieve results of an array task
     * @param id task ID to retrieve stored results (required)
     * @param acceptEncoding Encoding to use (optional)
     * @return ApiResponse&lt;String&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> output and format of originating request </td><td>  * Content-Type - format results are delivered in <br>  </td></tr>
        <tr><td> 202 </td><td> task is still executing </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> results were not saved, or results have expored </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<String> taskIdResultGetWithHttpInfo(String id, String acceptEncoding) throws ApiException {
        okhttp3.Call localVarCall = taskIdResultGetValidateBeforeCall(id, acceptEncoding, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Retrieve results of an array task
     * @param id task ID to retrieve stored results (required)
     * @param acceptEncoding Encoding to use (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> output and format of originating request </td><td>  * Content-Type - format results are delivered in <br>  </td></tr>
        <tr><td> 202 </td><td> task is still executing </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> results were not saved, or results have expored </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call taskIdResultGetAsync(String id, String acceptEncoding, final ApiCallback<String> _callback) throws ApiException {

        okhttp3.Call localVarCall = taskIdResultGetValidateBeforeCall(id, acceptEncoding, _callback);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for tasksGet
     * @param namespace namespace to filter (optional)
     * @param createdBy username to filter (optional)
     * @param array name/uri of array that is url-encoded to filter (optional)
     * @param start start time for tasks to filter by (optional)
     * @param end end time for tasks to filter by (optional)
     * @param page pagination offset (optional)
     * @param perPage pagination limit (optional)
     * @param type task type, \&quot;QUERY\&quot;, \&quot;SQL\&quot;, \&quot;UDF\&quot;, \&quot;GENERIC_UDF\&quot; (optional)
     * @param excludeType task_type to exclude matching array in results, more than one can be included (optional)
     * @param fileType match file_type of task array, more than one can be included (optional)
     * @param excludeFileType exclude file_type of task arrays, more than one can be included (optional)
     * @param status Filter to only return these statuses (optional)
     * @param search search string that will look at name, namespace or description fields (optional)
     * @param orderby sort by which field valid values include start_time, name (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Array of all tasks user has access too </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call tasksGetCall(String namespace, String createdBy, String array, Integer start, Integer end, Integer page, Integer perPage, String type, List<String> excludeType, List<String> fileType, List<String> excludeFileType, String status, String search, String orderby, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/tasks";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (namespace != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("namespace", namespace));
        }

        if (createdBy != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("created_by", createdBy));
        }

        if (array != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("array", array));
        }

        if (start != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("start", start));
        }

        if (end != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("end", end));
        }

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (perPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("per_page", perPage));
        }

        if (type != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("type", type));
        }

        if (excludeType != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "exclude_type", excludeType));
        }

        if (fileType != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "file_type", fileType));
        }

        if (excludeFileType != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "exclude_file_type", excludeFileType));
        }

        if (status != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("status", status));
        }

        if (search != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("search", search));
        }

        if (orderby != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("orderby", orderby));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call tasksGetValidateBeforeCall(String namespace, String createdBy, String array, Integer start, Integer end, Integer page, Integer perPage, String type, List<String> excludeType, List<String> fileType, List<String> excludeFileType, String status, String search, String orderby, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = tasksGetCall(namespace, createdBy, array, start, end, page, perPage, type, excludeType, fileType, excludeFileType, status, search, orderby, _callback);
        return localVarCall;

    }

    /**
     * 
     * Fetch a list of all array tasks a user has access to
     * @param namespace namespace to filter (optional)
     * @param createdBy username to filter (optional)
     * @param array name/uri of array that is url-encoded to filter (optional)
     * @param start start time for tasks to filter by (optional)
     * @param end end time for tasks to filter by (optional)
     * @param page pagination offset (optional)
     * @param perPage pagination limit (optional)
     * @param type task type, \&quot;QUERY\&quot;, \&quot;SQL\&quot;, \&quot;UDF\&quot;, \&quot;GENERIC_UDF\&quot; (optional)
     * @param excludeType task_type to exclude matching array in results, more than one can be included (optional)
     * @param fileType match file_type of task array, more than one can be included (optional)
     * @param excludeFileType exclude file_type of task arrays, more than one can be included (optional)
     * @param status Filter to only return these statuses (optional)
     * @param search search string that will look at name, namespace or description fields (optional)
     * @param orderby sort by which field valid values include start_time, name (optional)
     * @return ArrayTaskData
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Array of all tasks user has access too </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ArrayTaskData tasksGet(String namespace, String createdBy, String array, Integer start, Integer end, Integer page, Integer perPage, String type, List<String> excludeType, List<String> fileType, List<String> excludeFileType, String status, String search, String orderby) throws ApiException {
        ApiResponse<ArrayTaskData> localVarResp = tasksGetWithHttpInfo(namespace, createdBy, array, start, end, page, perPage, type, excludeType, fileType, excludeFileType, status, search, orderby);
        return localVarResp.getData();
    }

    /**
     * 
     * Fetch a list of all array tasks a user has access to
     * @param namespace namespace to filter (optional)
     * @param createdBy username to filter (optional)
     * @param array name/uri of array that is url-encoded to filter (optional)
     * @param start start time for tasks to filter by (optional)
     * @param end end time for tasks to filter by (optional)
     * @param page pagination offset (optional)
     * @param perPage pagination limit (optional)
     * @param type task type, \&quot;QUERY\&quot;, \&quot;SQL\&quot;, \&quot;UDF\&quot;, \&quot;GENERIC_UDF\&quot; (optional)
     * @param excludeType task_type to exclude matching array in results, more than one can be included (optional)
     * @param fileType match file_type of task array, more than one can be included (optional)
     * @param excludeFileType exclude file_type of task arrays, more than one can be included (optional)
     * @param status Filter to only return these statuses (optional)
     * @param search search string that will look at name, namespace or description fields (optional)
     * @param orderby sort by which field valid values include start_time, name (optional)
     * @return ApiResponse&lt;ArrayTaskData&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Array of all tasks user has access too </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ArrayTaskData> tasksGetWithHttpInfo(String namespace, String createdBy, String array, Integer start, Integer end, Integer page, Integer perPage, String type, List<String> excludeType, List<String> fileType, List<String> excludeFileType, String status, String search, String orderby) throws ApiException {
        okhttp3.Call localVarCall = tasksGetValidateBeforeCall(namespace, createdBy, array, start, end, page, perPage, type, excludeType, fileType, excludeFileType, status, search, orderby, null);
        Type localVarReturnType = new TypeToken<ArrayTaskData>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Fetch a list of all array tasks a user has access to
     * @param namespace namespace to filter (optional)
     * @param createdBy username to filter (optional)
     * @param array name/uri of array that is url-encoded to filter (optional)
     * @param start start time for tasks to filter by (optional)
     * @param end end time for tasks to filter by (optional)
     * @param page pagination offset (optional)
     * @param perPage pagination limit (optional)
     * @param type task type, \&quot;QUERY\&quot;, \&quot;SQL\&quot;, \&quot;UDF\&quot;, \&quot;GENERIC_UDF\&quot; (optional)
     * @param excludeType task_type to exclude matching array in results, more than one can be included (optional)
     * @param fileType match file_type of task array, more than one can be included (optional)
     * @param excludeFileType exclude file_type of task arrays, more than one can be included (optional)
     * @param status Filter to only return these statuses (optional)
     * @param search search string that will look at name, namespace or description fields (optional)
     * @param orderby sort by which field valid values include start_time, name (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Array of all tasks user has access too </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call tasksGetAsync(String namespace, String createdBy, String array, Integer start, Integer end, Integer page, Integer perPage, String type, List<String> excludeType, List<String> fileType, List<String> excludeFileType, String status, String search, String orderby, final ApiCallback<ArrayTaskData> _callback) throws ApiException {

        okhttp3.Call localVarCall = tasksGetValidateBeforeCall(namespace, createdBy, array, start, end, page, perPage, type, excludeType, fileType, excludeFileType, status, search, orderby, _callback);
        Type localVarReturnType = new TypeToken<ArrayTaskData>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
