/*
 * TileDB Storage Platform API
 * TileDB Storage Platform REST API
 *
 * The version of the OpenAPI document: 2.2.19
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.tiledb.cloud.rest_api.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import io.tiledb.cloud.rest_api.JSON;
import org.openapitools.jackson.nullable.JsonNullable;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.util.HashSet;
import java.util.Map.Entry;
import java.util.Set;

/**
 * metadata of an array
 */
@ApiModel(description = "metadata of an array")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-09-14T18:46:41.869452+03:00[Europe/Athens]")
public class ArrayInfo {
  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private String id;

  public static final String SERIALIZED_NAME_FILE_TYPE = "file_type";
  @SerializedName(SERIALIZED_NAME_FILE_TYPE)
  private FileType fileType;

  public static final String SERIALIZED_NAME_FILE_PROPERTIES = "file_properties";
  @SerializedName(SERIALIZED_NAME_FILE_PROPERTIES)
  private Map<String, String> fileProperties = null;

  public static final String SERIALIZED_NAME_URI = "uri";
  @SerializedName(SERIALIZED_NAME_URI)
  private String uri;

  public static final String SERIALIZED_NAME_NAMESPACE = "namespace";
  @SerializedName(SERIALIZED_NAME_NAMESPACE)
  private String namespace;

  public static final String SERIALIZED_NAME_SIZE = "size";
  @SerializedName(SERIALIZED_NAME_SIZE)
  private BigDecimal size;

  public static final String SERIALIZED_NAME_LAST_ACCESSED = "last_accessed";
  @SerializedName(SERIALIZED_NAME_LAST_ACCESSED)
  private OffsetDateTime lastAccessed;

  public static final String SERIALIZED_NAME_DESCRIPTION = "description";
  @SerializedName(SERIALIZED_NAME_DESCRIPTION)
  private String description;

  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_ALLOWED_ACTIONS = "allowed_actions";
  @SerializedName(SERIALIZED_NAME_ALLOWED_ACTIONS)
  private List<ArrayActions> allowedActions = null;

  public static final String SERIALIZED_NAME_PRICING = "pricing";
  @SerializedName(SERIALIZED_NAME_PRICING)
  private List<Pricing> pricing = null;

  public static final String SERIALIZED_NAME_SUBSCRIPTIONS = "subscriptions";
  @SerializedName(SERIALIZED_NAME_SUBSCRIPTIONS)
  private List<Subscription> subscriptions = null;

  public static final String SERIALIZED_NAME_LOGO = "logo";
  @SerializedName(SERIALIZED_NAME_LOGO)
  private String logo;

  public static final String SERIALIZED_NAME_ACCESS_CREDENTIALS_NAME = "access_credentials_name";
  @SerializedName(SERIALIZED_NAME_ACCESS_CREDENTIALS_NAME)
  private String accessCredentialsName;

  public static final String SERIALIZED_NAME_TYPE = "type";
  @SerializedName(SERIALIZED_NAME_TYPE)
  private String type;

  public static final String SERIALIZED_NAME_SHARE_COUNT = "share_count";
  @SerializedName(SERIALIZED_NAME_SHARE_COUNT)
  private BigDecimal shareCount;

  public static final String SERIALIZED_NAME_PUBLIC_SHARE = "public_share";
  @SerializedName(SERIALIZED_NAME_PUBLIC_SHARE)
  private Boolean publicShare;

  public static final String SERIALIZED_NAME_NAMESPACE_SUBSCRIBED = "namespace_subscribed";
  @SerializedName(SERIALIZED_NAME_NAMESPACE_SUBSCRIBED)
  private Boolean namespaceSubscribed;

  public static final String SERIALIZED_NAME_TILEDB_URI = "tiledb_uri";
  @SerializedName(SERIALIZED_NAME_TILEDB_URI)
  private String tiledbUri;

  public static final String SERIALIZED_NAME_TAGS = "tags";
  @SerializedName(SERIALIZED_NAME_TAGS)
  private List<String> tags = null;

  public static final String SERIALIZED_NAME_LICENSE_ID = "license_id";
  @SerializedName(SERIALIZED_NAME_LICENSE_ID)
  private String licenseId;

  public static final String SERIALIZED_NAME_LICENSE_TEXT = "license_text";
  @SerializedName(SERIALIZED_NAME_LICENSE_TEXT)
  private String licenseText;

  public static final String SERIALIZED_NAME_READ_ONLY = "read_only";
  @SerializedName(SERIALIZED_NAME_READ_ONLY)
  private Boolean readOnly;

  public static final String SERIALIZED_NAME_IS_FAVORITE = "is_favorite";
  @SerializedName(SERIALIZED_NAME_IS_FAVORITE)
  private Boolean isFavorite;

  public ArrayInfo() { 
  }

  
  public ArrayInfo(
     Boolean namespaceSubscribed
  ) {
    this();
    this.namespaceSubscribed = namespaceSubscribed;
  }

  public ArrayInfo id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * unique ID of registered array
   * @return id
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "00000000-0000-0000-0000-000000000000", value = "unique ID of registered array")

  public String getId() {
    return id;
  }


  public void setId(String id) {
    this.id = id;
  }


  public ArrayInfo fileType(FileType fileType) {
    
    this.fileType = fileType;
    return this;
  }

   /**
   * Get fileType
   * @return fileType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public FileType getFileType() {
    return fileType;
  }


  public void setFileType(FileType fileType) {
    this.fileType = fileType;
  }


  public ArrayInfo fileProperties(Map<String, String> fileProperties) {
    
    this.fileProperties = fileProperties;
    return this;
  }

  public ArrayInfo putFilePropertiesItem(String key, String filePropertiesItem) {
    if (this.fileProperties == null) {
      this.fileProperties = new HashMap<>();
    }
    this.fileProperties.put(key, filePropertiesItem);
    return this;
  }

   /**
   * map of file properties created for this array
   * @return fileProperties
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "map of file properties created for this array")

  public Map<String, String> getFileProperties() {
    return fileProperties;
  }


  public void setFileProperties(Map<String, String> fileProperties) {
    this.fileProperties = fileProperties;
  }


  public ArrayInfo uri(String uri) {
    
    this.uri = uri;
    return this;
  }

   /**
   * uri of array
   * @return uri
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "s3://bucket/array", value = "uri of array")

  public String getUri() {
    return uri;
  }


  public void setUri(String uri) {
    this.uri = uri;
  }


  public ArrayInfo namespace(String namespace) {
    
    this.namespace = namespace;
    return this;
  }

   /**
   * namespace array is in
   * @return namespace
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "user1", value = "namespace array is in")

  public String getNamespace() {
    return namespace;
  }


  public void setNamespace(String namespace) {
    this.namespace = namespace;
  }


  public ArrayInfo size(BigDecimal size) {
    
    this.size = size;
    return this;
  }

   /**
   * size in bytes of array
   * @return size
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "1024.0", value = "size in bytes of array")

  public BigDecimal getSize() {
    return size;
  }


  public void setSize(BigDecimal size) {
    this.size = size;
  }


  public ArrayInfo lastAccessed(OffsetDateTime lastAccessed) {
    
    this.lastAccessed = lastAccessed;
    return this;
  }

   /**
   * Datetime array was last accessed in UTC
   * @return lastAccessed
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Datetime array was last accessed in UTC")

  public OffsetDateTime getLastAccessed() {
    return lastAccessed;
  }


  public void setLastAccessed(OffsetDateTime lastAccessed) {
    this.lastAccessed = lastAccessed;
  }


  public ArrayInfo description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * description of array
   * @return description
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "description of array")

  public String getDescription() {
    return description;
  }


  public void setDescription(String description) {
    this.description = description;
  }


  public ArrayInfo name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * name of array
   * @return name
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "myarray1", value = "name of array")

  public String getName() {
    return name;
  }


  public void setName(String name) {
    this.name = name;
  }


  public ArrayInfo allowedActions(List<ArrayActions> allowedActions) {
    
    this.allowedActions = allowedActions;
    return this;
  }

  public ArrayInfo addAllowedActionsItem(ArrayActions allowedActionsItem) {
    if (this.allowedActions == null) {
      this.allowedActions = new ArrayList<>();
    }
    this.allowedActions.add(allowedActionsItem);
    return this;
  }

   /**
   * list of actions user is allowed to do on this array
   * @return allowedActions
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "list of actions user is allowed to do on this array")

  public List<ArrayActions> getAllowedActions() {
    return allowedActions;
  }


  public void setAllowedActions(List<ArrayActions> allowedActions) {
    this.allowedActions = allowedActions;
  }


  public ArrayInfo pricing(List<Pricing> pricing) {
    
    this.pricing = pricing;
    return this;
  }

  public ArrayInfo addPricingItem(Pricing pricingItem) {
    if (this.pricing == null) {
      this.pricing = new ArrayList<>();
    }
    this.pricing.add(pricingItem);
    return this;
  }

   /**
   * list of pricing created for this array
   * @return pricing
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "list of pricing created for this array")

  public List<Pricing> getPricing() {
    return pricing;
  }


  public void setPricing(List<Pricing> pricing) {
    this.pricing = pricing;
  }


  public ArrayInfo subscriptions(List<Subscription> subscriptions) {
    
    this.subscriptions = subscriptions;
    return this;
  }

  public ArrayInfo addSubscriptionsItem(Subscription subscriptionsItem) {
    if (this.subscriptions == null) {
      this.subscriptions = new ArrayList<>();
    }
    this.subscriptions.add(subscriptionsItem);
    return this;
  }

   /**
   * list of subscriptions created for this array
   * @return subscriptions
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "list of subscriptions created for this array")

  public List<Subscription> getSubscriptions() {
    return subscriptions;
  }


  public void setSubscriptions(List<Subscription> subscriptions) {
    this.subscriptions = subscriptions;
  }


  public ArrayInfo logo(String logo) {
    
    this.logo = logo;
    return this;
  }

   /**
   * logo (base64 encoded) for the array. Optional
   * @return logo
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "logo (base64 encoded) for the array. Optional")

  public String getLogo() {
    return logo;
  }


  public void setLogo(String logo) {
    this.logo = logo;
  }


  public ArrayInfo accessCredentialsName(String accessCredentialsName) {
    
    this.accessCredentialsName = accessCredentialsName;
    return this;
  }

   /**
   * the name of the access credentials to use. if unset, the default credentials will be used
   * @return accessCredentialsName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "the name of the access credentials to use. if unset, the default credentials will be used")

  public String getAccessCredentialsName() {
    return accessCredentialsName;
  }


  public void setAccessCredentialsName(String accessCredentialsName) {
    this.accessCredentialsName = accessCredentialsName;
  }


  public ArrayInfo type(String type) {
    
    this.type = type;
    return this;
  }

   /**
   * Array type (dense, key-value, sparse)
   * @return type
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "sparse", value = "Array type (dense, key-value, sparse)")

  public String getType() {
    return type;
  }


  public void setType(String type) {
    this.type = type;
  }


  public ArrayInfo shareCount(BigDecimal shareCount) {
    
    this.shareCount = shareCount;
    return this;
  }

   /**
   * number of unique namespaces this array is shared with
   * @return shareCount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "number of unique namespaces this array is shared with")

  public BigDecimal getShareCount() {
    return shareCount;
  }


  public void setShareCount(BigDecimal shareCount) {
    this.shareCount = shareCount;
  }


  public ArrayInfo publicShare(Boolean publicShare) {
    
    this.publicShare = publicShare;
    return this;
  }

   /**
   * Suggests if the array was shared to public by owner
   * @return publicShare
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Suggests if the array was shared to public by owner")

  public Boolean getPublicShare() {
    return publicShare;
  }


  public void setPublicShare(Boolean publicShare) {
    this.publicShare = publicShare;
  }


   /**
   * Depends on the namespace asking, denotes the existence of subscription of namespace to this array
   * @return namespaceSubscribed
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Depends on the namespace asking, denotes the existence of subscription of namespace to this array")

  public Boolean getNamespaceSubscribed() {
    return namespaceSubscribed;
  }




  public ArrayInfo tiledbUri(String tiledbUri) {
    
    this.tiledbUri = tiledbUri;
    return this;
  }

   /**
   * uri for access through TileDB cloud
   * @return tiledbUri
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "uri for access through TileDB cloud")

  public String getTiledbUri() {
    return tiledbUri;
  }


  public void setTiledbUri(String tiledbUri) {
    this.tiledbUri = tiledbUri;
  }


  public ArrayInfo tags(List<String> tags) {
    
    this.tags = tags;
    return this;
  }

  public ArrayInfo addTagsItem(String tagsItem) {
    if (this.tags == null) {
      this.tags = new ArrayList<>();
    }
    this.tags.add(tagsItem);
    return this;
  }

   /**
   * optional tags for array
   * @return tags
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "optional tags for array")

  public List<String> getTags() {
    return tags;
  }


  public void setTags(List<String> tags) {
    this.tags = tags;
  }


  public ArrayInfo licenseId(String licenseId) {
    
    this.licenseId = licenseId;
    return this;
  }

   /**
   * License identifier from SPDX License List or Custom
   * @return licenseId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "License identifier from SPDX License List or Custom")

  public String getLicenseId() {
    return licenseId;
  }


  public void setLicenseId(String licenseId) {
    this.licenseId = licenseId;
  }


  public ArrayInfo licenseText(String licenseText) {
    
    this.licenseText = licenseText;
    return this;
  }

   /**
   * License text
   * @return licenseText
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "License text")

  public String getLicenseText() {
    return licenseText;
  }


  public void setLicenseText(String licenseText) {
    this.licenseText = licenseText;
  }


  public ArrayInfo readOnly(Boolean readOnly) {
    
    this.readOnly = readOnly;
    return this;
  }

   /**
   * Suggests if the array is in read_only mode
   * @return readOnly
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "Suggests if the array is in read_only mode")

  public Boolean getReadOnly() {
    return readOnly;
  }


  public void setReadOnly(Boolean readOnly) {
    this.readOnly = readOnly;
  }


  public ArrayInfo isFavorite(Boolean isFavorite) {
    
    this.isFavorite = isFavorite;
    return this;
  }

   /**
   * Indicates whether the array is in user favorites
   * @return isFavorite
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "Indicates whether the array is in user favorites")

  public Boolean getIsFavorite() {
    return isFavorite;
  }


  public void setIsFavorite(Boolean isFavorite) {
    this.isFavorite = isFavorite;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ArrayInfo arrayInfo = (ArrayInfo) o;
    return Objects.equals(this.id, arrayInfo.id) &&
        Objects.equals(this.fileType, arrayInfo.fileType) &&
        Objects.equals(this.fileProperties, arrayInfo.fileProperties) &&
        Objects.equals(this.uri, arrayInfo.uri) &&
        Objects.equals(this.namespace, arrayInfo.namespace) &&
        Objects.equals(this.size, arrayInfo.size) &&
        Objects.equals(this.lastAccessed, arrayInfo.lastAccessed) &&
        Objects.equals(this.description, arrayInfo.description) &&
        Objects.equals(this.name, arrayInfo.name) &&
        Objects.equals(this.allowedActions, arrayInfo.allowedActions) &&
        Objects.equals(this.pricing, arrayInfo.pricing) &&
        Objects.equals(this.subscriptions, arrayInfo.subscriptions) &&
        Objects.equals(this.logo, arrayInfo.logo) &&
        Objects.equals(this.accessCredentialsName, arrayInfo.accessCredentialsName) &&
        Objects.equals(this.type, arrayInfo.type) &&
        Objects.equals(this.shareCount, arrayInfo.shareCount) &&
        Objects.equals(this.publicShare, arrayInfo.publicShare) &&
        Objects.equals(this.namespaceSubscribed, arrayInfo.namespaceSubscribed) &&
        Objects.equals(this.tiledbUri, arrayInfo.tiledbUri) &&
        Objects.equals(this.tags, arrayInfo.tags) &&
        Objects.equals(this.licenseId, arrayInfo.licenseId) &&
        Objects.equals(this.licenseText, arrayInfo.licenseText) &&
        Objects.equals(this.readOnly, arrayInfo.readOnly) &&
        Objects.equals(this.isFavorite, arrayInfo.isFavorite);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, fileType, fileProperties, uri, namespace, size, lastAccessed, description, name, allowedActions, pricing, subscriptions, logo, accessCredentialsName, type, shareCount, publicShare, namespaceSubscribed, tiledbUri, tags, licenseId, licenseText, readOnly, isFavorite);
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ArrayInfo {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    fileType: ").append(toIndentedString(fileType)).append("\n");
    sb.append("    fileProperties: ").append(toIndentedString(fileProperties)).append("\n");
    sb.append("    uri: ").append(toIndentedString(uri)).append("\n");
    sb.append("    namespace: ").append(toIndentedString(namespace)).append("\n");
    sb.append("    size: ").append(toIndentedString(size)).append("\n");
    sb.append("    lastAccessed: ").append(toIndentedString(lastAccessed)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    allowedActions: ").append(toIndentedString(allowedActions)).append("\n");
    sb.append("    pricing: ").append(toIndentedString(pricing)).append("\n");
    sb.append("    subscriptions: ").append(toIndentedString(subscriptions)).append("\n");
    sb.append("    logo: ").append(toIndentedString(logo)).append("\n");
    sb.append("    accessCredentialsName: ").append(toIndentedString(accessCredentialsName)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    shareCount: ").append(toIndentedString(shareCount)).append("\n");
    sb.append("    publicShare: ").append(toIndentedString(publicShare)).append("\n");
    sb.append("    namespaceSubscribed: ").append(toIndentedString(namespaceSubscribed)).append("\n");
    sb.append("    tiledbUri: ").append(toIndentedString(tiledbUri)).append("\n");
    sb.append("    tags: ").append(toIndentedString(tags)).append("\n");
    sb.append("    licenseId: ").append(toIndentedString(licenseId)).append("\n");
    sb.append("    licenseText: ").append(toIndentedString(licenseText)).append("\n");
    sb.append("    readOnly: ").append(toIndentedString(readOnly)).append("\n");
    sb.append("    isFavorite: ").append(toIndentedString(isFavorite)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("id");
    openapiFields.add("file_type");
    openapiFields.add("file_properties");
    openapiFields.add("uri");
    openapiFields.add("namespace");
    openapiFields.add("size");
    openapiFields.add("last_accessed");
    openapiFields.add("description");
    openapiFields.add("name");
    openapiFields.add("allowed_actions");
    openapiFields.add("pricing");
    openapiFields.add("subscriptions");
    openapiFields.add("logo");
    openapiFields.add("access_credentials_name");
    openapiFields.add("type");
    openapiFields.add("share_count");
    openapiFields.add("public_share");
    openapiFields.add("namespace_subscribed");
    openapiFields.add("tiledb_uri");
    openapiFields.add("tags");
    openapiFields.add("license_id");
    openapiFields.add("license_text");
    openapiFields.add("read_only");
    openapiFields.add("is_favorite");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to ArrayInfo
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (ArrayInfo.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in ArrayInfo is not found in the empty JSON string", ArrayInfo.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!ArrayInfo.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `ArrayInfo` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
      }
      if (jsonObj.get("id") != null && !jsonObj.get("id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("id").toString()));
      }
      if (jsonObj.get("uri") != null && !jsonObj.get("uri").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `uri` to be a primitive type in the JSON string but got `%s`", jsonObj.get("uri").toString()));
      }
      if (jsonObj.get("namespace") != null && !jsonObj.get("namespace").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `namespace` to be a primitive type in the JSON string but got `%s`", jsonObj.get("namespace").toString()));
      }
      if (jsonObj.get("description") != null && !jsonObj.get("description").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get("description").toString()));
      }
      if (jsonObj.get("name") != null && !jsonObj.get("name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("name").toString()));
      }
      // ensure the json data is an array
      if (jsonObj.get("allowed_actions") != null && !jsonObj.get("allowed_actions").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `allowed_actions` to be an array in the JSON string but got `%s`", jsonObj.get("allowed_actions").toString()));
      }
      JsonArray jsonArraypricing = jsonObj.getAsJsonArray("pricing");
      if (jsonArraypricing != null) {
        // ensure the json data is an array
        if (!jsonObj.get("pricing").isJsonArray()) {
          throw new IllegalArgumentException(String.format("Expected the field `pricing` to be an array in the JSON string but got `%s`", jsonObj.get("pricing").toString()));
        }

        // validate the optional field `pricing` (array)
        for (int i = 0; i < jsonArraypricing.size(); i++) {
          Pricing.validateJsonObject(jsonArraypricing.get(i).getAsJsonObject());
        };
      }
      JsonArray jsonArraysubscriptions = jsonObj.getAsJsonArray("subscriptions");
      if (jsonArraysubscriptions != null) {
        // ensure the json data is an array
        if (!jsonObj.get("subscriptions").isJsonArray()) {
          throw new IllegalArgumentException(String.format("Expected the field `subscriptions` to be an array in the JSON string but got `%s`", jsonObj.get("subscriptions").toString()));
        }

        // validate the optional field `subscriptions` (array)
        for (int i = 0; i < jsonArraysubscriptions.size(); i++) {
          Subscription.validateJsonObject(jsonArraysubscriptions.get(i).getAsJsonObject());
        };
      }
      if (jsonObj.get("logo") != null && !jsonObj.get("logo").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `logo` to be a primitive type in the JSON string but got `%s`", jsonObj.get("logo").toString()));
      }
      if (jsonObj.get("access_credentials_name") != null && !jsonObj.get("access_credentials_name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `access_credentials_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("access_credentials_name").toString()));
      }
      if (jsonObj.get("type") != null && !jsonObj.get("type").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get("type").toString()));
      }
      if (jsonObj.get("tiledb_uri") != null && !jsonObj.get("tiledb_uri").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `tiledb_uri` to be a primitive type in the JSON string but got `%s`", jsonObj.get("tiledb_uri").toString()));
      }
      // ensure the json data is an array
      if (jsonObj.get("tags") != null && !jsonObj.get("tags").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `tags` to be an array in the JSON string but got `%s`", jsonObj.get("tags").toString()));
      }
      if (jsonObj.get("license_id") != null && !jsonObj.get("license_id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `license_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("license_id").toString()));
      }
      if (jsonObj.get("license_text") != null && !jsonObj.get("license_text").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `license_text` to be a primitive type in the JSON string but got `%s`", jsonObj.get("license_text").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!ArrayInfo.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'ArrayInfo' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<ArrayInfo> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(ArrayInfo.class));

       return (TypeAdapter<T>) new TypeAdapter<ArrayInfo>() {
           @Override
           public void write(JsonWriter out, ArrayInfo value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public ArrayInfo read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of ArrayInfo given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of ArrayInfo
  * @throws IOException if the JSON string is invalid with respect to ArrayInfo
  */
  public static ArrayInfo fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, ArrayInfo.class);
  }

 /**
  * Convert an instance of ArrayInfo to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

