/*
 * TileDB Storage Platform API
 * TileDB Storage Platform REST API
 *
 * The version of the OpenAPI document: 2.2.19
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.tiledb.cloud.rest_api.model;

import java.util.Objects;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.util.HashSet;
import java.util.Map.Entry;
import java.util.Set;

import io.tiledb.cloud.rest_api.JSON;

/**
 * object representing buffer size of an attribute
 */
@ApiModel(description = "object representing buffer size of an attribute")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-09-14T18:46:41.869452+03:00[Europe/Athens]")
public class AttributeBufferSize {
  public static final String SERIALIZED_NAME_ATTRIBUTE = "attribute";
  @SerializedName(SERIALIZED_NAME_ATTRIBUTE)
  private String attribute;

  public static final String SERIALIZED_NAME_OFFSET_BYTES = "offsetBytes";
  @SerializedName(SERIALIZED_NAME_OFFSET_BYTES)
  private Integer offsetBytes;

  public static final String SERIALIZED_NAME_DATA_BYTES = "dataBytes";
  @SerializedName(SERIALIZED_NAME_DATA_BYTES)
  private Integer dataBytes;

  public AttributeBufferSize() { 
  }

  public AttributeBufferSize attribute(String attribute) {
    
    this.attribute = attribute;
    return this;
  }

   /**
   * name of attribute
   * @return attribute
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "name of attribute")

  public String getAttribute() {
    return attribute;
  }


  public void setAttribute(String attribute) {
    this.attribute = attribute;
  }


  public AttributeBufferSize offsetBytes(Integer offsetBytes) {
    
    this.offsetBytes = offsetBytes;
    return this;
  }

   /**
   * buffer size (in bytes) of offset buffer
   * @return offsetBytes
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "buffer size (in bytes) of offset buffer")

  public Integer getOffsetBytes() {
    return offsetBytes;
  }


  public void setOffsetBytes(Integer offsetBytes) {
    this.offsetBytes = offsetBytes;
  }


  public AttributeBufferSize dataBytes(Integer dataBytes) {
    
    this.dataBytes = dataBytes;
    return this;
  }

   /**
   * buffer size (in bytes) of data buffer
   * @return dataBytes
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "buffer size (in bytes) of data buffer")

  public Integer getDataBytes() {
    return dataBytes;
  }


  public void setDataBytes(Integer dataBytes) {
    this.dataBytes = dataBytes;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AttributeBufferSize attributeBufferSize = (AttributeBufferSize) o;
    return Objects.equals(this.attribute, attributeBufferSize.attribute) &&
        Objects.equals(this.offsetBytes, attributeBufferSize.offsetBytes) &&
        Objects.equals(this.dataBytes, attributeBufferSize.dataBytes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(attribute, offsetBytes, dataBytes);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AttributeBufferSize {\n");
    sb.append("    attribute: ").append(toIndentedString(attribute)).append("\n");
    sb.append("    offsetBytes: ").append(toIndentedString(offsetBytes)).append("\n");
    sb.append("    dataBytes: ").append(toIndentedString(dataBytes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("attribute");
    openapiFields.add("offsetBytes");
    openapiFields.add("dataBytes");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("attribute");
    openapiRequiredFields.add("offsetBytes");
    openapiRequiredFields.add("dataBytes");
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to AttributeBufferSize
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (AttributeBufferSize.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in AttributeBufferSize is not found in the empty JSON string", AttributeBufferSize.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
//      for (Entry<String, JsonElement> entry : entries) {
//        if (!AttributeBufferSize.openapiFields.contains(entry.getKey())) {
//          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `AttributeBufferSize` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
//        }
//      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : AttributeBufferSize.openapiRequiredFields) {
        if (jsonObj.get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
      }
      if (jsonObj.get("attribute") != null && !jsonObj.get("attribute").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `attribute` to be a primitive type in the JSON string but got `%s`", jsonObj.get("attribute").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!AttributeBufferSize.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'AttributeBufferSize' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<AttributeBufferSize> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(AttributeBufferSize.class));

       return (TypeAdapter<T>) new TypeAdapter<AttributeBufferSize>() {
           @Override
           public void write(JsonWriter out, AttributeBufferSize value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public AttributeBufferSize read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of AttributeBufferSize given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of AttributeBufferSize
  * @throws IOException if the JSON string is invalid with respect to AttributeBufferSize
  */
  public static AttributeBufferSize fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, AttributeBufferSize.class);
  }

 /**
  * Convert an instance of AttributeBufferSize to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

