/*
 * TileDB Storage Platform API
 * TileDB Storage Platform REST API
 *
 * The version of the OpenAPI document: 2.2.19
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.tiledb.cloud.rest_api.model;

import java.util.Objects;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

import io.tiledb.cloud.rest_api.JSON;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.util.HashSet;
import java.util.Map.Entry;
import java.util.Set;

/**
 * Dimension of array
 */
@ApiModel(description = "Dimension of array")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-09-14T18:46:41.869452+03:00[Europe/Athens]")
public class Dimension {
  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_TYPE = "type";
  @SerializedName(SERIALIZED_NAME_TYPE)
  private Datatype type;

  public static final String SERIALIZED_NAME_DOMAIN = "domain";
  @SerializedName(SERIALIZED_NAME_DOMAIN)
  private DomainArray domain;

  public static final String SERIALIZED_NAME_NULL_TILE_EXTENT = "nullTileExtent";
  @SerializedName(SERIALIZED_NAME_NULL_TILE_EXTENT)
  private Boolean nullTileExtent;

  public static final String SERIALIZED_NAME_TILE_EXTENT = "tileExtent";
  @SerializedName(SERIALIZED_NAME_TILE_EXTENT)
  private DimensionTileExtent tileExtent;

  public static final String SERIALIZED_NAME_FILTER_PIPELINE = "filterPipeline";
  @SerializedName(SERIALIZED_NAME_FILTER_PIPELINE)
  private FilterPipeline filterPipeline;

  public Dimension() { 
  }

  public Dimension name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Dimension name
   * @return name
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "row", value = "Dimension name")

  public String getName() {
    return name;
  }


  public void setName(String name) {
    this.name = name;
  }


  public Dimension type(Datatype type) {
    
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")

  public Datatype getType() {
    return type;
  }


  public void setType(Datatype type) {
    this.type = type;
  }


  public Dimension domain(DomainArray domain) {
    
    this.domain = domain;
    return this;
  }

   /**
   * Get domain
   * @return domain
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")

  public DomainArray getDomain() {
    return domain;
  }


  public void setDomain(DomainArray domain) {
    this.domain = domain;
  }


  public Dimension nullTileExtent(Boolean nullTileExtent) {
    
    this.nullTileExtent = nullTileExtent;
    return this;
  }

   /**
   * Is tile extent null
   * @return nullTileExtent
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "true", required = true, value = "Is tile extent null")

  public Boolean getNullTileExtent() {
    return nullTileExtent;
  }


  public void setNullTileExtent(Boolean nullTileExtent) {
    this.nullTileExtent = nullTileExtent;
  }


  public Dimension tileExtent(DimensionTileExtent tileExtent) {
    
    this.tileExtent = tileExtent;
    return this;
  }

   /**
   * Get tileExtent
   * @return tileExtent
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public DimensionTileExtent getTileExtent() {
    return tileExtent;
  }


  public void setTileExtent(DimensionTileExtent tileExtent) {
    this.tileExtent = tileExtent;
  }


  public Dimension filterPipeline(FilterPipeline filterPipeline) {
    
    this.filterPipeline = filterPipeline;
    return this;
  }

   /**
   * Get filterPipeline
   * @return filterPipeline
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public FilterPipeline getFilterPipeline() {
    return filterPipeline;
  }


  public void setFilterPipeline(FilterPipeline filterPipeline) {
    this.filterPipeline = filterPipeline;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Dimension dimension = (Dimension) o;
    return Objects.equals(this.name, dimension.name) &&
        Objects.equals(this.type, dimension.type) &&
        Objects.equals(this.domain, dimension.domain) &&
        Objects.equals(this.nullTileExtent, dimension.nullTileExtent) &&
        Objects.equals(this.tileExtent, dimension.tileExtent) &&
        Objects.equals(this.filterPipeline, dimension.filterPipeline);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, type, domain, nullTileExtent, tileExtent, filterPipeline);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Dimension {\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    domain: ").append(toIndentedString(domain)).append("\n");
    sb.append("    nullTileExtent: ").append(toIndentedString(nullTileExtent)).append("\n");
    sb.append("    tileExtent: ").append(toIndentedString(tileExtent)).append("\n");
    sb.append("    filterPipeline: ").append(toIndentedString(filterPipeline)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("name");
    openapiFields.add("type");
    openapiFields.add("domain");
    openapiFields.add("nullTileExtent");
    openapiFields.add("tileExtent");
    openapiFields.add("filterPipeline");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("type");
    openapiRequiredFields.add("domain");
    openapiRequiredFields.add("nullTileExtent");
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to Dimension
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (Dimension.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in Dimension is not found in the empty JSON string", Dimension.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
//      for (Entry<String, JsonElement> entry : entries) {
//        if (!Dimension.openapiFields.contains(entry.getKey())) {
//          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Dimension` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
//        }
//      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : Dimension.openapiRequiredFields) {
        if (jsonObj.get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
      }
      if (jsonObj.get("name") != null && !jsonObj.get("name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("name").toString()));
      }
      // validate the optional field `domain`
      if (jsonObj.getAsJsonObject("domain") != null) {
        DomainArray.validateJsonObject(jsonObj.getAsJsonObject("domain"));
      }
      // validate the optional field `tileExtent`
      if (jsonObj.getAsJsonObject("tileExtent") != null) {
        DimensionTileExtent.validateJsonObject(jsonObj.getAsJsonObject("tileExtent"));
      }
      // validate the optional field `filterPipeline`
      if (jsonObj.getAsJsonObject("filterPipeline") != null) {
        FilterPipeline.validateJsonObject(jsonObj.getAsJsonObject("filterPipeline"));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!Dimension.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'Dimension' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<Dimension> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(Dimension.class));

       return (TypeAdapter<T>) new TypeAdapter<Dimension>() {
           @Override
           public void write(JsonWriter out, Dimension value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public Dimension read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of Dimension given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of Dimension
  * @throws IOException if the JSON string is invalid with respect to Dimension
  */
  public static Dimension fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, Dimension.class);
  }

 /**
  * Convert an instance of Dimension to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

