/*
 * TileDB Storage Platform API
 * TileDB Storage Platform REST API
 *
 * The version of the OpenAPI document: 2.2.19
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.tiledb.cloud.rest_api.model;

import java.util.Objects;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import io.tiledb.cloud.rest_api.JSON;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.util.HashSet;
import java.util.Map.Entry;
import java.util.Set;

/**
 * User-defined function
 */
@ApiModel(description = "User-defined function")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-09-14T18:46:41.869452+03:00[Europe/Athens]")
public class GenericUDF {
  public static final String SERIALIZED_NAME_UDF_INFO_NAME = "udf_info_name";
  @SerializedName(SERIALIZED_NAME_UDF_INFO_NAME)
  private String udfInfoName;

  public static final String SERIALIZED_NAME_LANGUAGE = "language";
  @SerializedName(SERIALIZED_NAME_LANGUAGE)
  private UDFLanguage language;

  public static final String SERIALIZED_NAME_VERSION = "version";
  @SerializedName(SERIALIZED_NAME_VERSION)
  private String version;

  public static final String SERIALIZED_NAME_IMAGE_NAME = "image_name";
  @SerializedName(SERIALIZED_NAME_IMAGE_NAME)
  private String imageName;

  public static final String SERIALIZED_NAME_RESOURCE_CLASS = "resource_class";
  @SerializedName(SERIALIZED_NAME_RESOURCE_CLASS)
  private String resourceClass;

  public static final String SERIALIZED_NAME_EXEC = "exec";
  @SerializedName(SERIALIZED_NAME_EXEC)
  private String exec;

  public static final String SERIALIZED_NAME_EXEC_RAW = "exec_raw";
  @SerializedName(SERIALIZED_NAME_EXEC_RAW)
  private String execRaw;

  public static final String SERIALIZED_NAME_ARGUMENT = "argument";
  @SerializedName(SERIALIZED_NAME_ARGUMENT)
  private String argument;

  public static final String SERIALIZED_NAME_STORED_PARAM_UUIDS = "stored_param_uuids";
  @SerializedName(SERIALIZED_NAME_STORED_PARAM_UUIDS)
  private List<String> storedParamUuids = null;

  public static final String SERIALIZED_NAME_RESULT_FORMAT = "result_format";
  @SerializedName(SERIALIZED_NAME_RESULT_FORMAT)
  private ResultFormat resultFormat;

  public static final String SERIALIZED_NAME_TASK_NAME = "task_name";
  @SerializedName(SERIALIZED_NAME_TASK_NAME)
  private String taskName;

  public static final String SERIALIZED_NAME_STORE_RESULTS = "store_results";
  @SerializedName(SERIALIZED_NAME_STORE_RESULTS)
  private Boolean storeResults;

  public static final String SERIALIZED_NAME_TIMEOUT = "timeout";
  @SerializedName(SERIALIZED_NAME_TIMEOUT)
  private Integer timeout;

  public static final String SERIALIZED_NAME_DONT_DOWNLOAD_RESULTS = "dont_download_results";
  @SerializedName(SERIALIZED_NAME_DONT_DOWNLOAD_RESULTS)
  private Boolean dontDownloadResults;

  public static final String SERIALIZED_NAME_TASK_GRAPH_UUID = "task_graph_uuid";
  @SerializedName(SERIALIZED_NAME_TASK_GRAPH_UUID)
  private String taskGraphUuid;

  public static final String SERIALIZED_NAME_CLIENT_NODE_UUID = "client_node_uuid";
  @SerializedName(SERIALIZED_NAME_CLIENT_NODE_UUID)
  private String clientNodeUuid;

  public GenericUDF() { 
  }

  public GenericUDF udfInfoName(String udfInfoName) {
    
    this.udfInfoName = udfInfoName;
    return this;
  }

   /**
   * name of UDFInfo to run, format is {namespace}/{udf_name}. Can not be used with exec
   * @return udfInfoName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "TileDB-Inc/csv_ingestor", value = "name of UDFInfo to run, format is {namespace}/{udf_name}. Can not be used with exec")

  public String getUdfInfoName() {
    return udfInfoName;
  }


  public void setUdfInfoName(String udfInfoName) {
    this.udfInfoName = udfInfoName;
  }


  public GenericUDF language(UDFLanguage language) {
    
    this.language = language;
    return this;
  }

   /**
   * Get language
   * @return language
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public UDFLanguage getLanguage() {
    return language;
  }


  public void setLanguage(UDFLanguage language) {
    this.language = language;
  }


  public GenericUDF version(String version) {
    
    this.version = version;
    return this;
  }

   /**
   * Type-specific version
   * @return version
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Type-specific version")

  public String getVersion() {
    return version;
  }


  public void setVersion(String version) {
    this.version = version;
  }


  public GenericUDF imageName(String imageName) {
    
    this.imageName = imageName;
    return this;
  }

   /**
   * Docker image name to use for UDF
   * @return imageName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Docker image name to use for UDF")

  public String getImageName() {
    return imageName;
  }


  public void setImageName(String imageName) {
    this.imageName = imageName;
  }


  public GenericUDF resourceClass(String resourceClass) {
    
    this.resourceClass = resourceClass;
    return this;
  }

   /**
   * The resource class to use for the UDF execution. Resource classes define resource limits for memory and CPUs. If this is empty, then the UDF will execute in the standard resource class of the TileDB Cloud provider. 
   * @return resourceClass
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "standard", value = "The resource class to use for the UDF execution. Resource classes define resource limits for memory and CPUs. If this is empty, then the UDF will execute in the standard resource class of the TileDB Cloud provider. ")

  public String getResourceClass() {
    return resourceClass;
  }


  public void setResourceClass(String resourceClass) {
    this.resourceClass = resourceClass;
  }


  public GenericUDF exec(String exec) {
    
    this.exec = exec;
    return this;
  }

   /**
   * Type-specific executable text
   * @return exec
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Type-specific executable text")

  public String getExec() {
    return exec;
  }


  public void setExec(String exec) {
    this.exec = exec;
  }


  public GenericUDF execRaw(String execRaw) {
    
    this.execRaw = execRaw;
    return this;
  }

   /**
   * optional raw text to store of serialized function, used for showing in UI
   * @return execRaw
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "optional raw text to store of serialized function, used for showing in UI")

  public String getExecRaw() {
    return execRaw;
  }


  public void setExecRaw(String execRaw) {
    this.execRaw = execRaw;
  }


  public GenericUDF argument(String argument) {
    
    this.argument = argument;
    return this;
  }

   /**
   * Argument(s) to pass to UDF function, tuple or list of args/kwargs which can be in native or JSON format
   * @return argument
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Argument(s) to pass to UDF function, tuple or list of args/kwargs which can be in native or JSON format")

  public String getArgument() {
    return argument;
  }


  public void setArgument(String argument) {
    this.argument = argument;
  }


  public GenericUDF storedParamUuids(List<String> storedParamUuids) {
    
    this.storedParamUuids = storedParamUuids;
    return this;
  }

  public GenericUDF addStoredParamUuidsItem(String storedParamUuidsItem) {
    if (this.storedParamUuids == null) {
      this.storedParamUuids = new ArrayList<>();
    }
    this.storedParamUuids.add(storedParamUuidsItem);
    return this;
  }

   /**
   * The UUIDs of stored input parameters (passed in a language-specific format within \&quot;argument\&quot;) to be retrieved from the server-side cache. Serialized in standard hex format with no {}.
   * @return storedParamUuids
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The UUIDs of stored input parameters (passed in a language-specific format within \"argument\") to be retrieved from the server-side cache. Serialized in standard hex format with no {}.")

  public List<String> getStoredParamUuids() {
    return storedParamUuids;
  }


  public void setStoredParamUuids(List<String> storedParamUuids) {
    this.storedParamUuids = storedParamUuids;
  }


  public GenericUDF resultFormat(ResultFormat resultFormat) {
    
    this.resultFormat = resultFormat;
    return this;
  }

   /**
   * Get resultFormat
   * @return resultFormat
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public ResultFormat getResultFormat() {
    return resultFormat;
  }


  public void setResultFormat(ResultFormat resultFormat) {
    this.resultFormat = resultFormat;
  }


  public GenericUDF taskName(String taskName) {
    
    this.taskName = taskName;
    return this;
  }

   /**
   * name of task, optional
   * @return taskName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "name of task, optional")

  public String getTaskName() {
    return taskName;
  }


  public void setTaskName(String taskName) {
    this.taskName = taskName;
  }


  public GenericUDF storeResults(Boolean storeResults) {
    
    this.storeResults = storeResults;
    return this;
  }

   /**
   * store results for later retrieval
   * @return storeResults
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "store results for later retrieval")

  public Boolean getStoreResults() {
    return storeResults;
  }


  public void setStoreResults(Boolean storeResults) {
    this.storeResults = storeResults;
  }


  public GenericUDF timeout(Integer timeout) {
    
    this.timeout = timeout;
    return this;
  }

   /**
   * UDF-type timeout in seconds (default: 900)
   * @return timeout
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "UDF-type timeout in seconds (default: 900)")

  public Integer getTimeout() {
    return timeout;
  }


  public void setTimeout(Integer timeout) {
    this.timeout = timeout;
  }


  public GenericUDF dontDownloadResults(Boolean dontDownloadResults) {
    
    this.dontDownloadResults = dontDownloadResults;
    return this;
  }

   /**
   * Set to true to avoid downloading the results of this UDF. Useful for intermediate nodes in a task graph where you will not be using the results of your function. Defaults to false (\&quot;yes download results\&quot;).
   * @return dontDownloadResults
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Set to true to avoid downloading the results of this UDF. Useful for intermediate nodes in a task graph where you will not be using the results of your function. Defaults to false (\"yes download results\").")

  public Boolean getDontDownloadResults() {
    return dontDownloadResults;
  }


  public void setDontDownloadResults(Boolean dontDownloadResults) {
    this.dontDownloadResults = dontDownloadResults;
  }


  public GenericUDF taskGraphUuid(String taskGraphUuid) {
    
    this.taskGraphUuid = taskGraphUuid;
    return this;
  }

   /**
   * If set, the ID of the log for the task graph that this was part of. 
   * @return taskGraphUuid
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "If set, the ID of the log for the task graph that this was part of. ")

  public String getTaskGraphUuid() {
    return taskGraphUuid;
  }


  public void setTaskGraphUuid(String taskGraphUuid) {
    this.taskGraphUuid = taskGraphUuid;
  }


  public GenericUDF clientNodeUuid(String clientNodeUuid) {
    
    this.clientNodeUuid = clientNodeUuid;
    return this;
  }

   /**
   * If set, the client-defined ID of the node within this task&#39;s graph. 
   * @return clientNodeUuid
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "If set, the client-defined ID of the node within this task's graph. ")

  public String getClientNodeUuid() {
    return clientNodeUuid;
  }


  public void setClientNodeUuid(String clientNodeUuid) {
    this.clientNodeUuid = clientNodeUuid;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GenericUDF genericUDF = (GenericUDF) o;
    return Objects.equals(this.udfInfoName, genericUDF.udfInfoName) &&
        Objects.equals(this.language, genericUDF.language) &&
        Objects.equals(this.version, genericUDF.version) &&
        Objects.equals(this.imageName, genericUDF.imageName) &&
        Objects.equals(this.resourceClass, genericUDF.resourceClass) &&
        Objects.equals(this.exec, genericUDF.exec) &&
        Objects.equals(this.execRaw, genericUDF.execRaw) &&
        Objects.equals(this.argument, genericUDF.argument) &&
        Objects.equals(this.storedParamUuids, genericUDF.storedParamUuids) &&
        Objects.equals(this.resultFormat, genericUDF.resultFormat) &&
        Objects.equals(this.taskName, genericUDF.taskName) &&
        Objects.equals(this.storeResults, genericUDF.storeResults) &&
        Objects.equals(this.timeout, genericUDF.timeout) &&
        Objects.equals(this.dontDownloadResults, genericUDF.dontDownloadResults) &&
        Objects.equals(this.taskGraphUuid, genericUDF.taskGraphUuid) &&
        Objects.equals(this.clientNodeUuid, genericUDF.clientNodeUuid);
  }

  @Override
  public int hashCode() {
    return Objects.hash(udfInfoName, language, version, imageName, resourceClass, exec, execRaw, argument, storedParamUuids, resultFormat, taskName, storeResults, timeout, dontDownloadResults, taskGraphUuid, clientNodeUuid);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GenericUDF {\n");
    sb.append("    udfInfoName: ").append(toIndentedString(udfInfoName)).append("\n");
    sb.append("    language: ").append(toIndentedString(language)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    imageName: ").append(toIndentedString(imageName)).append("\n");
    sb.append("    resourceClass: ").append(toIndentedString(resourceClass)).append("\n");
    sb.append("    exec: ").append(toIndentedString(exec)).append("\n");
    sb.append("    execRaw: ").append(toIndentedString(execRaw)).append("\n");
    sb.append("    argument: ").append(toIndentedString(argument)).append("\n");
    sb.append("    storedParamUuids: ").append(toIndentedString(storedParamUuids)).append("\n");
    sb.append("    resultFormat: ").append(toIndentedString(resultFormat)).append("\n");
    sb.append("    taskName: ").append(toIndentedString(taskName)).append("\n");
    sb.append("    storeResults: ").append(toIndentedString(storeResults)).append("\n");
    sb.append("    timeout: ").append(toIndentedString(timeout)).append("\n");
    sb.append("    dontDownloadResults: ").append(toIndentedString(dontDownloadResults)).append("\n");
    sb.append("    taskGraphUuid: ").append(toIndentedString(taskGraphUuid)).append("\n");
    sb.append("    clientNodeUuid: ").append(toIndentedString(clientNodeUuid)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("udf_info_name");
    openapiFields.add("language");
    openapiFields.add("version");
    openapiFields.add("image_name");
    openapiFields.add("resource_class");
    openapiFields.add("exec");
    openapiFields.add("exec_raw");
    openapiFields.add("argument");
    openapiFields.add("stored_param_uuids");
    openapiFields.add("result_format");
    openapiFields.add("task_name");
    openapiFields.add("store_results");
    openapiFields.add("timeout");
    openapiFields.add("dont_download_results");
    openapiFields.add("task_graph_uuid");
    openapiFields.add("client_node_uuid");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to GenericUDF
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (GenericUDF.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in GenericUDF is not found in the empty JSON string", GenericUDF.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!GenericUDF.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `GenericUDF` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
      }
      if (jsonObj.get("udf_info_name") != null && !jsonObj.get("udf_info_name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `udf_info_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("udf_info_name").toString()));
      }
      if (jsonObj.get("version") != null && !jsonObj.get("version").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `version` to be a primitive type in the JSON string but got `%s`", jsonObj.get("version").toString()));
      }
      if (jsonObj.get("image_name") != null && !jsonObj.get("image_name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `image_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("image_name").toString()));
      }
      if (jsonObj.get("resource_class") != null && !jsonObj.get("resource_class").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `resource_class` to be a primitive type in the JSON string but got `%s`", jsonObj.get("resource_class").toString()));
      }
      if (jsonObj.get("exec") != null && !jsonObj.get("exec").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `exec` to be a primitive type in the JSON string but got `%s`", jsonObj.get("exec").toString()));
      }
      if (jsonObj.get("exec_raw") != null && !jsonObj.get("exec_raw").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `exec_raw` to be a primitive type in the JSON string but got `%s`", jsonObj.get("exec_raw").toString()));
      }
      if (jsonObj.get("argument") != null && !jsonObj.get("argument").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `argument` to be a primitive type in the JSON string but got `%s`", jsonObj.get("argument").toString()));
      }
      // ensure the json data is an array
      if (jsonObj.get("stored_param_uuids") != null && !jsonObj.get("stored_param_uuids").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `stored_param_uuids` to be an array in the JSON string but got `%s`", jsonObj.get("stored_param_uuids").toString()));
      }
      if (jsonObj.get("task_name") != null && !jsonObj.get("task_name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `task_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("task_name").toString()));
      }
      if (jsonObj.get("task_graph_uuid") != null && !jsonObj.get("task_graph_uuid").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `task_graph_uuid` to be a primitive type in the JSON string but got `%s`", jsonObj.get("task_graph_uuid").toString()));
      }
      if (jsonObj.get("client_node_uuid") != null && !jsonObj.get("client_node_uuid").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `client_node_uuid` to be a primitive type in the JSON string but got `%s`", jsonObj.get("client_node_uuid").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!GenericUDF.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'GenericUDF' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<GenericUDF> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(GenericUDF.class));

       return (TypeAdapter<T>) new TypeAdapter<GenericUDF>() {
           @Override
           public void write(JsonWriter out, GenericUDF value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public GenericUDF read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of GenericUDF given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of GenericUDF
  * @throws IOException if the JSON string is invalid with respect to GenericUDF
  */
  public static GenericUDF fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, GenericUDF.class);
  }

 /**
  * Convert an instance of GenericUDF to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

