/*
 * TileDB Storage Platform API
 * TileDB Storage Platform REST API
 *
 * The version of the OpenAPI document: 2.2.19
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.tiledb.cloud.rest_api.model;

import java.util.Objects;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.OffsetDateTime;

import io.tiledb.cloud.rest_api.JSON;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.util.HashSet;
import java.util.Map.Entry;
import java.util.Set;

/**
 * Invitations to share or collaborate
 */
@ApiModel(description = "Invitations to share or collaborate")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-09-14T18:46:41.869452+03:00[Europe/Athens]")
public class Invitation {
  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private String id;

  public static final String SERIALIZED_NAME_INVITATION_TYPE = "invitation_type";
  @SerializedName(SERIALIZED_NAME_INVITATION_TYPE)
  private InvitationType invitationType;

  public static final String SERIALIZED_NAME_OWNER_NAMESPACE_UUID = "owner_namespace_uuid";
  @SerializedName(SERIALIZED_NAME_OWNER_NAMESPACE_UUID)
  private String ownerNamespaceUuid;

  public static final String SERIALIZED_NAME_USER_NAMESPACE_UUID = "user_namespace_uuid";
  @SerializedName(SERIALIZED_NAME_USER_NAMESPACE_UUID)
  private String userNamespaceUuid;

  public static final String SERIALIZED_NAME_ORGANIZATION_USER_UUID = "organization_user_uuid";
  @SerializedName(SERIALIZED_NAME_ORGANIZATION_USER_UUID)
  private String organizationUserUuid;

  public static final String SERIALIZED_NAME_ORGANIZATION_NAME = "organization_name";
  @SerializedName(SERIALIZED_NAME_ORGANIZATION_NAME)
  private String organizationName;

  public static final String SERIALIZED_NAME_ORGANIZATION_ROLE = "organization_role";
  @SerializedName(SERIALIZED_NAME_ORGANIZATION_ROLE)
  private OrganizationRoles organizationRole;

  public static final String SERIALIZED_NAME_ARRAY_UUID = "array_uuid";
  @SerializedName(SERIALIZED_NAME_ARRAY_UUID)
  private String arrayUuid;

  public static final String SERIALIZED_NAME_ARRAY_NAME = "array_name";
  @SerializedName(SERIALIZED_NAME_ARRAY_NAME)
  private String arrayName;

  public static final String SERIALIZED_NAME_EMAIL = "email";
  @SerializedName(SERIALIZED_NAME_EMAIL)
  private String email;

  public static final String SERIALIZED_NAME_ACTIONS = "actions";
  @SerializedName(SERIALIZED_NAME_ACTIONS)
  private String actions;

  public static final String SERIALIZED_NAME_STATUS = "status";
  @SerializedName(SERIALIZED_NAME_STATUS)
  private InvitationStatus status;

  public static final String SERIALIZED_NAME_CREATED_AT = "created_at";
  @SerializedName(SERIALIZED_NAME_CREATED_AT)
  private OffsetDateTime createdAt;

  public static final String SERIALIZED_NAME_EXPIRES_AT = "expires_at";
  @SerializedName(SERIALIZED_NAME_EXPIRES_AT)
  private OffsetDateTime expiresAt;

  public static final String SERIALIZED_NAME_ACCEPTED_AT = "accepted_at";
  @SerializedName(SERIALIZED_NAME_ACCEPTED_AT)
  private OffsetDateTime acceptedAt;

  public Invitation() { 
  }

  public Invitation id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Unique ID of invitation added to magic link
   * @return id
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "00000000-0000-0000-0000-000000000000", value = "Unique ID of invitation added to magic link")

  public String getId() {
    return id;
  }


  public void setId(String id) {
    this.id = id;
  }


  public Invitation invitationType(InvitationType invitationType) {
    
    this.invitationType = invitationType;
    return this;
  }

   /**
   * Get invitationType
   * @return invitationType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public InvitationType getInvitationType() {
    return invitationType;
  }


  public void setInvitationType(InvitationType invitationType) {
    this.invitationType = invitationType;
  }


  public Invitation ownerNamespaceUuid(String ownerNamespaceUuid) {
    
    this.ownerNamespaceUuid = ownerNamespaceUuid;
    return this;
  }

   /**
   * Namespace of the owner of the invitation (user or organization)
   * @return ownerNamespaceUuid
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "00000000-0000-0000-0000-000000000000", value = "Namespace of the owner of the invitation (user or organization)")

  public String getOwnerNamespaceUuid() {
    return ownerNamespaceUuid;
  }


  public void setOwnerNamespaceUuid(String ownerNamespaceUuid) {
    this.ownerNamespaceUuid = ownerNamespaceUuid;
  }


  public Invitation userNamespaceUuid(String userNamespaceUuid) {
    
    this.userNamespaceUuid = userNamespaceUuid;
    return this;
  }

   /**
   * Unique ID of the user accepted the invitation
   * @return userNamespaceUuid
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "00000000-0000-0000-0000-000000000000", value = "Unique ID of the user accepted the invitation")

  public String getUserNamespaceUuid() {
    return userNamespaceUuid;
  }


  public void setUserNamespaceUuid(String userNamespaceUuid) {
    this.userNamespaceUuid = userNamespaceUuid;
  }


  public Invitation organizationUserUuid(String organizationUserUuid) {
    
    this.organizationUserUuid = organizationUserUuid;
    return this;
  }

   /**
   * Unique ID of the organization user accepted the invitation
   * @return organizationUserUuid
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "00000000-0000-0000-0000-000000000000", value = "Unique ID of the organization user accepted the invitation")

  public String getOrganizationUserUuid() {
    return organizationUserUuid;
  }


  public void setOrganizationUserUuid(String organizationUserUuid) {
    this.organizationUserUuid = organizationUserUuid;
  }


  public Invitation organizationName(String organizationName) {
    
    this.organizationName = organizationName;
    return this;
  }

   /**
   * Name of the organization, does not persist in database
   * @return organizationName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "organization_name", value = "Name of the organization, does not persist in database")

  public String getOrganizationName() {
    return organizationName;
  }


  public void setOrganizationName(String organizationName) {
    this.organizationName = organizationName;
  }


  public Invitation organizationRole(OrganizationRoles organizationRole) {
    
    this.organizationRole = organizationRole;
    return this;
  }

   /**
   * Get organizationRole
   * @return organizationRole
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public OrganizationRoles getOrganizationRole() {
    return organizationRole;
  }


  public void setOrganizationRole(OrganizationRoles organizationRole) {
    this.organizationRole = organizationRole;
  }


  public Invitation arrayUuid(String arrayUuid) {
    
    this.arrayUuid = arrayUuid;
    return this;
  }

   /**
   * Unique ID of the array
   * @return arrayUuid
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "00000000-0000-0000-0000-000000000000", value = "Unique ID of the array")

  public String getArrayUuid() {
    return arrayUuid;
  }


  public void setArrayUuid(String arrayUuid) {
    this.arrayUuid = arrayUuid;
  }


  public Invitation arrayName(String arrayName) {
    
    this.arrayName = arrayName;
    return this;
  }

   /**
   * Name of the array, does not persist in database
   * @return arrayName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "array_name", value = "Name of the array, does not persist in database")

  public String getArrayName() {
    return arrayName;
  }


  public void setArrayName(String arrayName) {
    this.arrayName = arrayName;
  }


  public Invitation email(String email) {
    
    this.email = email;
    return this;
  }

   /**
   * Email of the individual we send the invitation to
   * @return email
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "jane@doe.com", value = "Email of the individual we send the invitation to")

  public String getEmail() {
    return email;
  }


  public void setEmail(String email) {
    this.email = email;
  }


  public Invitation actions(String actions) {
    
    this.actions = actions;
    return this;
  }

   /**
   * A comma separated list of ArrayActions or NamespaceActions
   * @return actions
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "read,write", value = "A comma separated list of ArrayActions or NamespaceActions")

  public String getActions() {
    return actions;
  }


  public void setActions(String actions) {
    this.actions = actions;
  }


  public Invitation status(InvitationStatus status) {
    
    this.status = status;
    return this;
  }

   /**
   * Get status
   * @return status
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public InvitationStatus getStatus() {
    return status;
  }


  public void setStatus(InvitationStatus status) {
    this.status = status;
  }


  public Invitation createdAt(OffsetDateTime createdAt) {
    
    this.createdAt = createdAt;
    return this;
  }

   /**
   * Datetime the invitation was created in UTC
   * @return createdAt
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Datetime the invitation was created in UTC")

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }


  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }


  public Invitation expiresAt(OffsetDateTime expiresAt) {
    
    this.expiresAt = expiresAt;
    return this;
  }

   /**
   * Datetime the invitation is expected to expire in UTC
   * @return expiresAt
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Datetime the invitation is expected to expire in UTC")

  public OffsetDateTime getExpiresAt() {
    return expiresAt;
  }


  public void setExpiresAt(OffsetDateTime expiresAt) {
    this.expiresAt = expiresAt;
  }


  public Invitation acceptedAt(OffsetDateTime acceptedAt) {
    
    this.acceptedAt = acceptedAt;
    return this;
  }

   /**
   * Datetime the invitation was accepted in UTC
   * @return acceptedAt
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Datetime the invitation was accepted in UTC")

  public OffsetDateTime getAcceptedAt() {
    return acceptedAt;
  }


  public void setAcceptedAt(OffsetDateTime acceptedAt) {
    this.acceptedAt = acceptedAt;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Invitation invitation = (Invitation) o;
    return Objects.equals(this.id, invitation.id) &&
        Objects.equals(this.invitationType, invitation.invitationType) &&
        Objects.equals(this.ownerNamespaceUuid, invitation.ownerNamespaceUuid) &&
        Objects.equals(this.userNamespaceUuid, invitation.userNamespaceUuid) &&
        Objects.equals(this.organizationUserUuid, invitation.organizationUserUuid) &&
        Objects.equals(this.organizationName, invitation.organizationName) &&
        Objects.equals(this.organizationRole, invitation.organizationRole) &&
        Objects.equals(this.arrayUuid, invitation.arrayUuid) &&
        Objects.equals(this.arrayName, invitation.arrayName) &&
        Objects.equals(this.email, invitation.email) &&
        Objects.equals(this.actions, invitation.actions) &&
        Objects.equals(this.status, invitation.status) &&
        Objects.equals(this.createdAt, invitation.createdAt) &&
        Objects.equals(this.expiresAt, invitation.expiresAt) &&
        Objects.equals(this.acceptedAt, invitation.acceptedAt);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, invitationType, ownerNamespaceUuid, userNamespaceUuid, organizationUserUuid, organizationName, organizationRole, arrayUuid, arrayName, email, actions, status, createdAt, expiresAt, acceptedAt);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Invitation {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    invitationType: ").append(toIndentedString(invitationType)).append("\n");
    sb.append("    ownerNamespaceUuid: ").append(toIndentedString(ownerNamespaceUuid)).append("\n");
    sb.append("    userNamespaceUuid: ").append(toIndentedString(userNamespaceUuid)).append("\n");
    sb.append("    organizationUserUuid: ").append(toIndentedString(organizationUserUuid)).append("\n");
    sb.append("    organizationName: ").append(toIndentedString(organizationName)).append("\n");
    sb.append("    organizationRole: ").append(toIndentedString(organizationRole)).append("\n");
    sb.append("    arrayUuid: ").append(toIndentedString(arrayUuid)).append("\n");
    sb.append("    arrayName: ").append(toIndentedString(arrayName)).append("\n");
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    actions: ").append(toIndentedString(actions)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    expiresAt: ").append(toIndentedString(expiresAt)).append("\n");
    sb.append("    acceptedAt: ").append(toIndentedString(acceptedAt)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("id");
    openapiFields.add("invitation_type");
    openapiFields.add("owner_namespace_uuid");
    openapiFields.add("user_namespace_uuid");
    openapiFields.add("organization_user_uuid");
    openapiFields.add("organization_name");
    openapiFields.add("organization_role");
    openapiFields.add("array_uuid");
    openapiFields.add("array_name");
    openapiFields.add("email");
    openapiFields.add("actions");
    openapiFields.add("status");
    openapiFields.add("created_at");
    openapiFields.add("expires_at");
    openapiFields.add("accepted_at");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to Invitation
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (Invitation.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in Invitation is not found in the empty JSON string", Invitation.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!Invitation.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Invitation` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
      }
      if (jsonObj.get("id") != null && !jsonObj.get("id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("id").toString()));
      }
      if (jsonObj.get("owner_namespace_uuid") != null && !jsonObj.get("owner_namespace_uuid").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `owner_namespace_uuid` to be a primitive type in the JSON string but got `%s`", jsonObj.get("owner_namespace_uuid").toString()));
      }
      if (jsonObj.get("user_namespace_uuid") != null && !jsonObj.get("user_namespace_uuid").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `user_namespace_uuid` to be a primitive type in the JSON string but got `%s`", jsonObj.get("user_namespace_uuid").toString()));
      }
      if (jsonObj.get("organization_user_uuid") != null && !jsonObj.get("organization_user_uuid").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `organization_user_uuid` to be a primitive type in the JSON string but got `%s`", jsonObj.get("organization_user_uuid").toString()));
      }
      if (jsonObj.get("organization_name") != null && !jsonObj.get("organization_name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `organization_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("organization_name").toString()));
      }
      if (jsonObj.get("array_uuid") != null && !jsonObj.get("array_uuid").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `array_uuid` to be a primitive type in the JSON string but got `%s`", jsonObj.get("array_uuid").toString()));
      }
      if (jsonObj.get("array_name") != null && !jsonObj.get("array_name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `array_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("array_name").toString()));
      }
      if (jsonObj.get("email") != null && !jsonObj.get("email").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `email` to be a primitive type in the JSON string but got `%s`", jsonObj.get("email").toString()));
      }
      if (jsonObj.get("actions") != null && !jsonObj.get("actions").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `actions` to be a primitive type in the JSON string but got `%s`", jsonObj.get("actions").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!Invitation.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'Invitation' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<Invitation> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(Invitation.class));

       return (TypeAdapter<T>) new TypeAdapter<Invitation>() {
           @Override
           public void write(JsonWriter out, Invitation value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public Invitation read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of Invitation given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of Invitation
  * @throws IOException if the JSON string is invalid with respect to Invitation
  */
  public static Invitation fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, Invitation.class);
  }

 /**
  * Convert an instance of Invitation to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

