/*
 * TileDB Storage Platform API
 * TileDB Storage Platform REST API
 *
 * The version of the OpenAPI document: 2.2.19
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.tiledb.cloud.rest_api.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import io.tiledb.cloud.rest_api.JSON;
import org.openapitools.jackson.nullable.JsonNullable;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.util.HashSet;
import java.util.Map.Entry;
import java.util.Set;

/**
 * The structure and metadata of a task graph that can be stored on TileDB Cloud and executed by users who have access to it. 
 */
@ApiModel(description = "The structure and metadata of a task graph that can be stored on TileDB Cloud and executed by users who have access to it. ")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-09-14T18:46:41.869452+03:00[Europe/Athens]")
public class RegisteredTaskGraph {
  public static final String SERIALIZED_NAME_UUID = "uuid";
  @SerializedName(SERIALIZED_NAME_UUID)
  private String uuid;

  public static final String SERIALIZED_NAME_NAMESPACE = "namespace";
  @SerializedName(SERIALIZED_NAME_NAMESPACE)
  private String namespace;

  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_README = "readme";
  @SerializedName(SERIALIZED_NAME_README)
  private String readme;

  public static final String SERIALIZED_NAME_LICENSE_ID = "license_id";
  @SerializedName(SERIALIZED_NAME_LICENSE_ID)
  private String licenseId;

  public static final String SERIALIZED_NAME_LICENSE_TEXT = "license_text";
  @SerializedName(SERIALIZED_NAME_LICENSE_TEXT)
  private String licenseText;

  public static final String SERIALIZED_NAME_TAGS = "tags";
  @SerializedName(SERIALIZED_NAME_TAGS)
  private List<String> tags = null;

  public static final String SERIALIZED_NAME_NODES = "nodes";
  @SerializedName(SERIALIZED_NAME_NODES)
  private List<RegisteredTaskGraphNode> nodes = null;

  public RegisteredTaskGraph() { 
  }

  public RegisteredTaskGraph uuid(String uuid) {
    
    this.uuid = uuid;
    return this;
  }

   /**
   * A server-assigned unique ID for the UDF, in UUID format.
   * @return uuid
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "A server-assigned unique ID for the UDF, in UUID format.")

  public String getUuid() {
    return uuid;
  }


  public void setUuid(String uuid) {
    this.uuid = uuid;
  }


  public RegisteredTaskGraph namespace(String namespace) {
    
    this.namespace = namespace;
    return this;
  }

   /**
   * The namespace that owns this task graph log.
   * @return namespace
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The namespace that owns this task graph log.")

  public String getNamespace() {
    return namespace;
  }


  public void setNamespace(String namespace) {
    this.namespace = namespace;
  }


  public RegisteredTaskGraph name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * The name of this graph, to appear in URLs. Must be unique per-namespace. 
   * @return name
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The name of this graph, to appear in URLs. Must be unique per-namespace. ")

  public String getName() {
    return name;
  }


  public void setName(String name) {
    this.name = name;
  }


  public RegisteredTaskGraph readme(String readme) {
    
    this.readme = readme;
    return this;
  }

   /**
   * Documentation for the task graph, in Markdown format.
   * @return readme
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Documentation for the task graph, in Markdown format.")

  public String getReadme() {
    return readme;
  }


  public void setReadme(String readme) {
    this.readme = readme;
  }


  public RegisteredTaskGraph licenseId(String licenseId) {
    
    this.licenseId = licenseId;
    return this;
  }

   /**
   * SPDX license identifier.
   * @return licenseId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "SPDX license identifier.")

  public String getLicenseId() {
    return licenseId;
  }


  public void setLicenseId(String licenseId) {
    this.licenseId = licenseId;
  }


  public RegisteredTaskGraph licenseText(String licenseText) {
    
    this.licenseText = licenseText;
    return this;
  }

   /**
   * Full text of the license.
   * @return licenseText
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Full text of the license.")

  public String getLicenseText() {
    return licenseText;
  }


  public void setLicenseText(String licenseText) {
    this.licenseText = licenseText;
  }


  public RegisteredTaskGraph tags(List<String> tags) {
    
    this.tags = tags;
    return this;
  }

  public RegisteredTaskGraph addTagsItem(String tagsItem) {
    if (this.tags == null) {
      this.tags = new ArrayList<>();
    }
    this.tags.add(tagsItem);
    return this;
  }

   /**
   * Optional tags to classify the graph.
   * @return tags
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Optional tags to classify the graph.")

  public List<String> getTags() {
    return tags;
  }


  public void setTags(List<String> tags) {
    this.tags = tags;
  }


  public RegisteredTaskGraph nodes(List<RegisteredTaskGraphNode> nodes) {
    
    this.nodes = nodes;
    return this;
  }

  public RegisteredTaskGraph addNodesItem(RegisteredTaskGraphNode nodesItem) {
    if (this.nodes == null) {
      this.nodes = new ArrayList<>();
    }
    this.nodes.add(nodesItem);
    return this;
  }

   /**
   * The structure of the graph, in the form of the nodes that make it up. As with &#x60;TaskGraphLog&#x60;, nodes must topologically sorted, so that any node appears after all the nodes it depends on. 
   * @return nodes
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The structure of the graph, in the form of the nodes that make it up. As with `TaskGraphLog`, nodes must topologically sorted, so that any node appears after all the nodes it depends on. ")

  public List<RegisteredTaskGraphNode> getNodes() {
    return nodes;
  }


  public void setNodes(List<RegisteredTaskGraphNode> nodes) {
    this.nodes = nodes;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RegisteredTaskGraph registeredTaskGraph = (RegisteredTaskGraph) o;
    return Objects.equals(this.uuid, registeredTaskGraph.uuid) &&
        Objects.equals(this.namespace, registeredTaskGraph.namespace) &&
        Objects.equals(this.name, registeredTaskGraph.name) &&
        Objects.equals(this.readme, registeredTaskGraph.readme) &&
        Objects.equals(this.licenseId, registeredTaskGraph.licenseId) &&
        Objects.equals(this.licenseText, registeredTaskGraph.licenseText) &&
        Objects.equals(this.tags, registeredTaskGraph.tags) &&
        Objects.equals(this.nodes, registeredTaskGraph.nodes);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(uuid, namespace, name, readme, licenseId, licenseText, tags, nodes);
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RegisteredTaskGraph {\n");
    sb.append("    uuid: ").append(toIndentedString(uuid)).append("\n");
    sb.append("    namespace: ").append(toIndentedString(namespace)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    readme: ").append(toIndentedString(readme)).append("\n");
    sb.append("    licenseId: ").append(toIndentedString(licenseId)).append("\n");
    sb.append("    licenseText: ").append(toIndentedString(licenseText)).append("\n");
    sb.append("    tags: ").append(toIndentedString(tags)).append("\n");
    sb.append("    nodes: ").append(toIndentedString(nodes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("uuid");
    openapiFields.add("namespace");
    openapiFields.add("name");
    openapiFields.add("readme");
    openapiFields.add("license_id");
    openapiFields.add("license_text");
    openapiFields.add("tags");
    openapiFields.add("nodes");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to RegisteredTaskGraph
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (RegisteredTaskGraph.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in RegisteredTaskGraph is not found in the empty JSON string", RegisteredTaskGraph.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
//      for (Entry<String, JsonElement> entry : entries) {
//        if (!RegisteredTaskGraph.openapiFields.contains(entry.getKey())) {
//          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `RegisteredTaskGraph` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
//        }
//      }
      if (jsonObj.get("uuid") != null && !jsonObj.get("uuid").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `uuid` to be a primitive type in the JSON string but got `%s`", jsonObj.get("uuid").toString()));
      }
      if (jsonObj.get("namespace") != null && !jsonObj.get("namespace").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `namespace` to be a primitive type in the JSON string but got `%s`", jsonObj.get("namespace").toString()));
      }
      if (jsonObj.get("name") != null && !jsonObj.get("name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("name").toString()));
      }
      if (jsonObj.get("readme") != null && !jsonObj.get("readme").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `readme` to be a primitive type in the JSON string but got `%s`", jsonObj.get("readme").toString()));
      }
      if (jsonObj.get("license_id") != null && !jsonObj.get("license_id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `license_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("license_id").toString()));
      }
      if (jsonObj.get("license_text") != null && !jsonObj.get("license_text").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `license_text` to be a primitive type in the JSON string but got `%s`", jsonObj.get("license_text").toString()));
      }
      // ensure the json data is an array
      if (jsonObj.get("tags") != null && !jsonObj.get("tags").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `tags` to be an array in the JSON string but got `%s`", jsonObj.get("tags").toString()));
      }
      JsonArray jsonArraynodes = jsonObj.getAsJsonArray("nodes");
      if (jsonArraynodes != null) {
        // ensure the json data is an array
        if (!jsonObj.get("nodes").isJsonArray()) {
          throw new IllegalArgumentException(String.format("Expected the field `nodes` to be an array in the JSON string but got `%s`", jsonObj.get("nodes").toString()));
        }

        // validate the optional field `nodes` (array)
        for (int i = 0; i < jsonArraynodes.size(); i++) {
          RegisteredTaskGraphNode.validateJsonObject(jsonArraynodes.get(i).getAsJsonObject());
        };
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!RegisteredTaskGraph.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'RegisteredTaskGraph' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<RegisteredTaskGraph> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(RegisteredTaskGraph.class));

       return (TypeAdapter<T>) new TypeAdapter<RegisteredTaskGraph>() {
           @Override
           public void write(JsonWriter out, RegisteredTaskGraph value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public RegisteredTaskGraph read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of RegisteredTaskGraph given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of RegisteredTaskGraph
  * @throws IOException if the JSON string is invalid with respect to RegisteredTaskGraph
  */
  public static RegisteredTaskGraph fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, RegisteredTaskGraph.class);
  }

 /**
  * Convert an instance of RegisteredTaskGraph to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

