/*
 * TileDB Storage Platform API
 * TileDB Storage Platform REST API
 *
 * The version of the OpenAPI document: 2.2.19
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.tiledb.cloud.rest_api.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import io.tiledb.cloud.rest_api.JSON;
import org.openapitools.jackson.nullable.JsonNullable;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.util.HashSet;
import java.util.Map.Entry;
import java.util.Set;

/**
 * Information about a single node within a registered task graph. A single node represents one piece of data or a computational step; either as an input value, a data source, or a computation that acts upon earlier nodes. The structure parallels the existing &#x60;TaskGraphNodeMetadata&#x60;. 
 */
@ApiModel(description = "Information about a single node within a registered task graph. A single node represents one piece of data or a computational step; either as an input value, a data source, or a computation that acts upon earlier nodes. The structure parallels the existing `TaskGraphNodeMetadata`. ")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-09-14T18:46:41.869452+03:00[Europe/Athens]")
public class RegisteredTaskGraphNode {
  public static final String SERIALIZED_NAME_CLIENT_NODE_ID = "client_node_id";
  @SerializedName(SERIALIZED_NAME_CLIENT_NODE_ID)
  private String clientNodeId;

  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_DEPENDS_ON = "depends_on";
  @SerializedName(SERIALIZED_NAME_DEPENDS_ON)
  private List<String> dependsOn = null;

  public static final String SERIALIZED_NAME_ARRAY_NODE = "array_node";
  @SerializedName(SERIALIZED_NAME_ARRAY_NODE)
  private UDFArrayDetails arrayNode;

  public static final String SERIALIZED_NAME_INPUT_NODE = "input_node";
  @SerializedName(SERIALIZED_NAME_INPUT_NODE)
  private TGInputNodeData inputNode;

  public static final String SERIALIZED_NAME_SQL_NODE = "sql_node";
  @SerializedName(SERIALIZED_NAME_SQL_NODE)
  private TGSQLNodeData sqlNode;

  public static final String SERIALIZED_NAME_UDF_NODE = "udf_node";
  @SerializedName(SERIALIZED_NAME_UDF_NODE)
  private TGUDFNodeData udfNode;

  public RegisteredTaskGraphNode() { 
  }

  public RegisteredTaskGraphNode clientNodeId(String clientNodeId) {
    
    this.clientNodeId = clientNodeId;
    return this;
  }

   /**
   * The client-generated UUID of the given graph node.
   * @return clientNodeId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The client-generated UUID of the given graph node.")

  public String getClientNodeId() {
    return clientNodeId;
  }


  public void setClientNodeId(String clientNodeId) {
    this.clientNodeId = clientNodeId;
  }


  public RegisteredTaskGraphNode name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * A client-specified name for the node. If provided, this must be unique. 
   * @return name
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "A client-specified name for the node. If provided, this must be unique. ")

  public String getName() {
    return name;
  }


  public void setName(String name) {
    this.name = name;
  }


  public RegisteredTaskGraphNode dependsOn(List<String> dependsOn) {
    
    this.dependsOn = dependsOn;
    return this;
  }

  public RegisteredTaskGraphNode addDependsOnItem(String dependsOnItem) {
    if (this.dependsOn == null) {
      this.dependsOn = new ArrayList<>();
    }
    this.dependsOn.add(dependsOnItem);
    return this;
  }

   /**
   * The client_node_uuid of each node that this node depends upon. Used to define the structure of the graph. 
   * @return dependsOn
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The client_node_uuid of each node that this node depends upon. Used to define the structure of the graph. ")

  public List<String> getDependsOn() {
    return dependsOn;
  }


  public void setDependsOn(List<String> dependsOn) {
    this.dependsOn = dependsOn;
  }


  public RegisteredTaskGraphNode arrayNode(UDFArrayDetails arrayNode) {
    
    this.arrayNode = arrayNode;
    return this;
  }

   /**
   * Get arrayNode
   * @return arrayNode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public UDFArrayDetails getArrayNode() {
    return arrayNode;
  }


  public void setArrayNode(UDFArrayDetails arrayNode) {
    this.arrayNode = arrayNode;
  }


  public RegisteredTaskGraphNode inputNode(TGInputNodeData inputNode) {
    
    this.inputNode = inputNode;
    return this;
  }

   /**
   * Get inputNode
   * @return inputNode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public TGInputNodeData getInputNode() {
    return inputNode;
  }


  public void setInputNode(TGInputNodeData inputNode) {
    this.inputNode = inputNode;
  }


  public RegisteredTaskGraphNode sqlNode(TGSQLNodeData sqlNode) {
    
    this.sqlNode = sqlNode;
    return this;
  }

   /**
   * Get sqlNode
   * @return sqlNode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public TGSQLNodeData getSqlNode() {
    return sqlNode;
  }


  public void setSqlNode(TGSQLNodeData sqlNode) {
    this.sqlNode = sqlNode;
  }


  public RegisteredTaskGraphNode udfNode(TGUDFNodeData udfNode) {
    
    this.udfNode = udfNode;
    return this;
  }

   /**
   * Get udfNode
   * @return udfNode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public TGUDFNodeData getUdfNode() {
    return udfNode;
  }


  public void setUdfNode(TGUDFNodeData udfNode) {
    this.udfNode = udfNode;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RegisteredTaskGraphNode registeredTaskGraphNode = (RegisteredTaskGraphNode) o;
    return Objects.equals(this.clientNodeId, registeredTaskGraphNode.clientNodeId) &&
        Objects.equals(this.name, registeredTaskGraphNode.name) &&
        Objects.equals(this.dependsOn, registeredTaskGraphNode.dependsOn) &&
        Objects.equals(this.arrayNode, registeredTaskGraphNode.arrayNode) &&
        Objects.equals(this.inputNode, registeredTaskGraphNode.inputNode) &&
        Objects.equals(this.sqlNode, registeredTaskGraphNode.sqlNode) &&
        Objects.equals(this.udfNode, registeredTaskGraphNode.udfNode);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(clientNodeId, name, dependsOn, arrayNode, inputNode, sqlNode, udfNode);
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RegisteredTaskGraphNode {\n");
    sb.append("    clientNodeId: ").append(toIndentedString(clientNodeId)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    dependsOn: ").append(toIndentedString(dependsOn)).append("\n");
    sb.append("    arrayNode: ").append(toIndentedString(arrayNode)).append("\n");
    sb.append("    inputNode: ").append(toIndentedString(inputNode)).append("\n");
    sb.append("    sqlNode: ").append(toIndentedString(sqlNode)).append("\n");
    sb.append("    udfNode: ").append(toIndentedString(udfNode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("client_node_id");
    openapiFields.add("name");
    openapiFields.add("depends_on");
    openapiFields.add("array_node");
    openapiFields.add("input_node");
    openapiFields.add("sql_node");
    openapiFields.add("udf_node");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to RegisteredTaskGraphNode
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (RegisteredTaskGraphNode.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in RegisteredTaskGraphNode is not found in the empty JSON string", RegisteredTaskGraphNode.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
//      for (Entry<String, JsonElement> entry : entries) {
//        if (!RegisteredTaskGraphNode.openapiFields.contains(entry.getKey())) {
//          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `RegisteredTaskGraphNode` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
//        }
//      }
      if (jsonObj.get("client_node_id") != null && !jsonObj.get("client_node_id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `client_node_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("client_node_id").toString()));
      }
      if (jsonObj.get("name") != null && !jsonObj.get("name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("name").toString()));
      }
      // ensure the json data is an array
      if (jsonObj.get("depends_on") != null && !jsonObj.get("depends_on").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `depends_on` to be an array in the JSON string but got `%s`", jsonObj.get("depends_on").toString()));
      }
      // validate the optional field `array_node`
      if (jsonObj.getAsJsonObject("array_node") != null) {
        UDFArrayDetails.validateJsonObject(jsonObj.getAsJsonObject("array_node"));
      }
      // validate the optional field `input_node`
      if (jsonObj.getAsJsonObject("input_node") != null) {
        TGInputNodeData.validateJsonObject(jsonObj.getAsJsonObject("input_node"));
      }
      // validate the optional field `sql_node`
      if (jsonObj.getAsJsonObject("sql_node") != null) {
        TGSQLNodeData.validateJsonObject(jsonObj.getAsJsonObject("sql_node"));
      }
      // validate the optional field `udf_node`
      if (jsonObj.getAsJsonObject("udf_node") != null) {
        TGUDFNodeData.validateJsonObject(jsonObj.getAsJsonObject("udf_node"));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!RegisteredTaskGraphNode.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'RegisteredTaskGraphNode' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<RegisteredTaskGraphNode> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(RegisteredTaskGraphNode.class));

       return (TypeAdapter<T>) new TypeAdapter<RegisteredTaskGraphNode>() {
           @Override
           public void write(JsonWriter out, RegisteredTaskGraphNode value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public RegisteredTaskGraphNode read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of RegisteredTaskGraphNode given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of RegisteredTaskGraphNode
  * @throws IOException if the JSON string is invalid with respect to RegisteredTaskGraphNode
  */
  public static RegisteredTaskGraphNode fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, RegisteredTaskGraphNode.class);
  }

 /**
  * Convert an instance of RegisteredTaskGraphNode to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

