/*
 * TileDB Storage Platform API
 * TileDB Storage Platform REST API
 *
 * The version of the OpenAPI document: 2.2.19
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.tiledb.cloud.rest_api.model;

import java.util.Objects;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import io.tiledb.cloud.rest_api.JSON;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.util.HashSet;
import java.util.Map.Entry;
import java.util.Set;

/**
 * Parameters for running sql query
 */
@ApiModel(description = "Parameters for running sql query")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-09-14T18:46:41.869452+03:00[Europe/Athens]")
public class SQLParameters {
  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_QUERY = "query";
  @SerializedName(SERIALIZED_NAME_QUERY)
  private String query;

  public static final String SERIALIZED_NAME_OUTPUT_URI = "output_uri";
  @SerializedName(SERIALIZED_NAME_OUTPUT_URI)
  private String outputUri;

  public static final String SERIALIZED_NAME_STORE_RESULTS = "store_results";
  @SerializedName(SERIALIZED_NAME_STORE_RESULTS)
  private Boolean storeResults;

  public static final String SERIALIZED_NAME_DONT_DOWNLOAD_RESULTS = "dont_download_results";
  @SerializedName(SERIALIZED_NAME_DONT_DOWNLOAD_RESULTS)
  private Boolean dontDownloadResults;

  public static final String SERIALIZED_NAME_RESOURCE_CLASS = "resource_class";
  @SerializedName(SERIALIZED_NAME_RESOURCE_CLASS)
  private String resourceClass;

  public static final String SERIALIZED_NAME_RESULT_FORMAT = "result_format";
  @SerializedName(SERIALIZED_NAME_RESULT_FORMAT)
  private ResultFormat resultFormat;

  public static final String SERIALIZED_NAME_INIT_COMMANDS = "init_commands";
  @SerializedName(SERIALIZED_NAME_INIT_COMMANDS)
  private List<String> initCommands = null;

  public static final String SERIALIZED_NAME_PARAMETERS = "parameters";
  @SerializedName(SERIALIZED_NAME_PARAMETERS)
  private List<Object> parameters = null;

  public static final String SERIALIZED_NAME_TASK_GRAPH_UUID = "task_graph_uuid";
  @SerializedName(SERIALIZED_NAME_TASK_GRAPH_UUID)
  private String taskGraphUuid;

  public static final String SERIALIZED_NAME_CLIENT_NODE_UUID = "client_node_uuid";
  @SerializedName(SERIALIZED_NAME_CLIENT_NODE_UUID)
  private String clientNodeUuid;

  public SQLParameters() { 
  }

  public SQLParameters name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * name of task, optional
   * @return name
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "name of task, optional")

  public String getName() {
    return name;
  }


  public void setName(String name) {
    this.name = name;
  }


  public SQLParameters query(String query) {
    
    this.query = query;
    return this;
  }

   /**
   * query to run
   * @return query
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "query to run")

  public String getQuery() {
    return query;
  }


  public void setQuery(String query) {
    this.query = query;
  }


  public SQLParameters outputUri(String outputUri) {
    
    this.outputUri = outputUri;
    return this;
  }

   /**
   * Output array uri
   * @return outputUri
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "s3://my_bucket/my_output_array", value = "Output array uri")

  public String getOutputUri() {
    return outputUri;
  }


  public void setOutputUri(String outputUri) {
    this.outputUri = outputUri;
  }


  public SQLParameters storeResults(Boolean storeResults) {
    
    this.storeResults = storeResults;
    return this;
  }

   /**
   * store results for later retrieval
   * @return storeResults
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "store results for later retrieval")

  public Boolean getStoreResults() {
    return storeResults;
  }


  public void setStoreResults(Boolean storeResults) {
    this.storeResults = storeResults;
  }


  public SQLParameters dontDownloadResults(Boolean dontDownloadResults) {
    
    this.dontDownloadResults = dontDownloadResults;
    return this;
  }

   /**
   * Set to true to avoid downloading the results of this UDF. Useful for intermediate nodes in a task graph where you will not be using the results of your function. Defaults to false (\&quot;yes download results\&quot;).
   * @return dontDownloadResults
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Set to true to avoid downloading the results of this UDF. Useful for intermediate nodes in a task graph where you will not be using the results of your function. Defaults to false (\"yes download results\").")

  public Boolean getDontDownloadResults() {
    return dontDownloadResults;
  }


  public void setDontDownloadResults(Boolean dontDownloadResults) {
    this.dontDownloadResults = dontDownloadResults;
  }


  public SQLParameters resourceClass(String resourceClass) {
    
    this.resourceClass = resourceClass;
    return this;
  }

   /**
   * The resource class to use for the SQL execution. Resource classes define resource limits for memory and CPUs. If this is empty, then the SQL will execute in the standard resource class of the TileDB Cloud provider. 
   * @return resourceClass
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "standard", value = "The resource class to use for the SQL execution. Resource classes define resource limits for memory and CPUs. If this is empty, then the SQL will execute in the standard resource class of the TileDB Cloud provider. ")

  public String getResourceClass() {
    return resourceClass;
  }


  public void setResourceClass(String resourceClass) {
    this.resourceClass = resourceClass;
  }


  public SQLParameters resultFormat(ResultFormat resultFormat) {
    
    this.resultFormat = resultFormat;
    return this;
  }

   /**
   * Get resultFormat
   * @return resultFormat
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public ResultFormat getResultFormat() {
    return resultFormat;
  }


  public void setResultFormat(ResultFormat resultFormat) {
    this.resultFormat = resultFormat;
  }


  public SQLParameters initCommands(List<String> initCommands) {
    
    this.initCommands = initCommands;
    return this;
  }

  public SQLParameters addInitCommandsItem(String initCommandsItem) {
    if (this.initCommands == null) {
      this.initCommands = new ArrayList<>();
    }
    this.initCommands.add(initCommandsItem);
    return this;
  }

   /**
   * Queries or commands to run before main query
   * @return initCommands
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Queries or commands to run before main query")

  public List<String> getInitCommands() {
    return initCommands;
  }


  public void setInitCommands(List<String> initCommands) {
    this.initCommands = initCommands;
  }


  public SQLParameters parameters(List<Object> parameters) {
    
    this.parameters = parameters;
    return this;
  }

  public SQLParameters addParametersItem(Object parametersItem) {
    if (this.parameters == null) {
      this.parameters = new ArrayList<>();
    }
    this.parameters.add(parametersItem);
    return this;
  }

   /**
   * SQL query parameters
   * @return parameters
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "SQL query parameters")

  public List<Object> getParameters() {
    return parameters;
  }


  public void setParameters(List<Object> parameters) {
    this.parameters = parameters;
  }


  public SQLParameters taskGraphUuid(String taskGraphUuid) {
    
    this.taskGraphUuid = taskGraphUuid;
    return this;
  }

   /**
   * If set, the ID of the log for the task graph that this was part of. 
   * @return taskGraphUuid
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "If set, the ID of the log for the task graph that this was part of. ")

  public String getTaskGraphUuid() {
    return taskGraphUuid;
  }


  public void setTaskGraphUuid(String taskGraphUuid) {
    this.taskGraphUuid = taskGraphUuid;
  }


  public SQLParameters clientNodeUuid(String clientNodeUuid) {
    
    this.clientNodeUuid = clientNodeUuid;
    return this;
  }

   /**
   * If set, the client-defined ID of the node within this task&#39;s graph. 
   * @return clientNodeUuid
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "If set, the client-defined ID of the node within this task's graph. ")

  public String getClientNodeUuid() {
    return clientNodeUuid;
  }


  public void setClientNodeUuid(String clientNodeUuid) {
    this.clientNodeUuid = clientNodeUuid;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SQLParameters sqLParameters = (SQLParameters) o;
    return Objects.equals(this.name, sqLParameters.name) &&
        Objects.equals(this.query, sqLParameters.query) &&
        Objects.equals(this.outputUri, sqLParameters.outputUri) &&
        Objects.equals(this.storeResults, sqLParameters.storeResults) &&
        Objects.equals(this.dontDownloadResults, sqLParameters.dontDownloadResults) &&
        Objects.equals(this.resourceClass, sqLParameters.resourceClass) &&
        Objects.equals(this.resultFormat, sqLParameters.resultFormat) &&
        Objects.equals(this.initCommands, sqLParameters.initCommands) &&
        Objects.equals(this.parameters, sqLParameters.parameters) &&
        Objects.equals(this.taskGraphUuid, sqLParameters.taskGraphUuid) &&
        Objects.equals(this.clientNodeUuid, sqLParameters.clientNodeUuid);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, query, outputUri, storeResults, dontDownloadResults, resourceClass, resultFormat, initCommands, parameters, taskGraphUuid, clientNodeUuid);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SQLParameters {\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    query: ").append(toIndentedString(query)).append("\n");
    sb.append("    outputUri: ").append(toIndentedString(outputUri)).append("\n");
    sb.append("    storeResults: ").append(toIndentedString(storeResults)).append("\n");
    sb.append("    dontDownloadResults: ").append(toIndentedString(dontDownloadResults)).append("\n");
    sb.append("    resourceClass: ").append(toIndentedString(resourceClass)).append("\n");
    sb.append("    resultFormat: ").append(toIndentedString(resultFormat)).append("\n");
    sb.append("    initCommands: ").append(toIndentedString(initCommands)).append("\n");
    sb.append("    parameters: ").append(toIndentedString(parameters)).append("\n");
    sb.append("    taskGraphUuid: ").append(toIndentedString(taskGraphUuid)).append("\n");
    sb.append("    clientNodeUuid: ").append(toIndentedString(clientNodeUuid)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("name");
    openapiFields.add("query");
    openapiFields.add("output_uri");
    openapiFields.add("store_results");
    openapiFields.add("dont_download_results");
    openapiFields.add("resource_class");
    openapiFields.add("result_format");
    openapiFields.add("init_commands");
    openapiFields.add("parameters");
    openapiFields.add("task_graph_uuid");
    openapiFields.add("client_node_uuid");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to SQLParameters
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (SQLParameters.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in SQLParameters is not found in the empty JSON string", SQLParameters.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
//      for (Entry<String, JsonElement> entry : entries) {
//        if (!SQLParameters.openapiFields.contains(entry.getKey())) {
//          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `SQLParameters` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
//        }
//      }
      if (jsonObj.get("name") != null && !jsonObj.get("name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("name").toString()));
      }
      if (jsonObj.get("query") != null && !jsonObj.get("query").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `query` to be a primitive type in the JSON string but got `%s`", jsonObj.get("query").toString()));
      }
      if (jsonObj.get("output_uri") != null && !jsonObj.get("output_uri").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `output_uri` to be a primitive type in the JSON string but got `%s`", jsonObj.get("output_uri").toString()));
      }
      if (jsonObj.get("resource_class") != null && !jsonObj.get("resource_class").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `resource_class` to be a primitive type in the JSON string but got `%s`", jsonObj.get("resource_class").toString()));
      }
      // ensure the json data is an array
      if (jsonObj.get("init_commands") != null && !jsonObj.get("init_commands").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `init_commands` to be an array in the JSON string but got `%s`", jsonObj.get("init_commands").toString()));
      }
      // ensure the json data is an array
      if (jsonObj.get("parameters") != null && !jsonObj.get("parameters").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `parameters` to be an array in the JSON string but got `%s`", jsonObj.get("parameters").toString()));
      }
      if (jsonObj.get("task_graph_uuid") != null && !jsonObj.get("task_graph_uuid").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `task_graph_uuid` to be a primitive type in the JSON string but got `%s`", jsonObj.get("task_graph_uuid").toString()));
      }
      if (jsonObj.get("client_node_uuid") != null && !jsonObj.get("client_node_uuid").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `client_node_uuid` to be a primitive type in the JSON string but got `%s`", jsonObj.get("client_node_uuid").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!SQLParameters.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'SQLParameters' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<SQLParameters> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(SQLParameters.class));

       return (TypeAdapter<T>) new TypeAdapter<SQLParameters>() {
           @Override
           public void write(JsonWriter out, SQLParameters value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public SQLParameters read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of SQLParameters given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of SQLParameters
  * @throws IOException if the JSON string is invalid with respect to SQLParameters
  */
  public static SQLParameters fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, SQLParameters.class);
  }

 /**
  * Convert an instance of SQLParameters to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

