/*
 * TileDB Storage Platform API
 * TileDB Storage Platform REST API
 *
 * The version of the OpenAPI document: 2.2.19
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.tiledb.cloud.rest_api.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import org.openapitools.jackson.nullable.JsonNullable;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.util.HashSet;
import java.util.Map.Entry;
import java.util.Set;

import io.tiledb.cloud.rest_api.JSON;

/**
 * A node specifying the execution of a user-defined function.
 */
@ApiModel(description = "A node specifying the execution of a user-defined function.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-09-14T18:46:41.869452+03:00[Europe/Athens]")
public class TGUDFNodeData {
  public static final String SERIALIZED_NAME_REGISTERED_UDF_NAME = "registered_udf_name";
  @SerializedName(SERIALIZED_NAME_REGISTERED_UDF_NAME)
  private String registeredUdfName;

  public static final String SERIALIZED_NAME_EXECUTABLE_CODE = "executable_code";
  @SerializedName(SERIALIZED_NAME_EXECUTABLE_CODE)
  private String executableCode;

  public static final String SERIALIZED_NAME_SOURCE_TEXT = "source_text";
  @SerializedName(SERIALIZED_NAME_SOURCE_TEXT)
  private String sourceText;

  public static final String SERIALIZED_NAME_ENVIRONMENT = "environment";
  @SerializedName(SERIALIZED_NAME_ENVIRONMENT)
  private TGUDFEnvironment environment;

  public static final String SERIALIZED_NAME_ARGUMENTS = "arguments";
  @SerializedName(SERIALIZED_NAME_ARGUMENTS)
  private List<TGUDFArgument> arguments = null;

  public static final String SERIALIZED_NAME_RESULT_FORMAT = "result_format";
  @SerializedName(SERIALIZED_NAME_RESULT_FORMAT)
  private ResultFormat resultFormat;

  public TGUDFNodeData() { 
  }

  public TGUDFNodeData registeredUdfName(String registeredUdfName) {
    
    this.registeredUdfName = registeredUdfName;
    return this;
  }

   /**
   * If set, the name of the registered UDF to execute, in the format &#x60;namespace/name&#x60;. Either this or &#x60;executable_code&#x60; should be set, but not both. 
   * @return registeredUdfName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "If set, the name of the registered UDF to execute, in the format `namespace/name`. Either this or `executable_code` should be set, but not both. ")

  public String getRegisteredUdfName() {
    return registeredUdfName;
  }


  public void setRegisteredUdfName(String registeredUdfName) {
    this.registeredUdfName = registeredUdfName;
  }


  public TGUDFNodeData executableCode(String executableCode) {
    
    this.executableCode = executableCode;
    return this;
  }

   /**
   * If set, the base64 serialization of the code for this step, encoded in a language-specific format (e.g. Pickle for Python, serialization for R). 
   * @return executableCode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "If set, the base64 serialization of the code for this step, encoded in a language-specific format (e.g. Pickle for Python, serialization for R). ")

  public String getExecutableCode() {
    return executableCode;
  }


  public void setExecutableCode(String executableCode) {
    this.executableCode = executableCode;
  }


  public TGUDFNodeData sourceText(String sourceText) {
    
    this.sourceText = sourceText;
    return this;
  }

   /**
   * Optionally, the source text for the code passed in &#x60;executable_code&#x60;. *For reference only; only the code in &#x60;executable_code&#x60; is actually executed.* This will be included in activity logs and may be useful for debugging. 
   * @return sourceText
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Optionally, the source text for the code passed in `executable_code`. *For reference only; only the code in `executable_code` is actually executed.* This will be included in activity logs and may be useful for debugging. ")

  public String getSourceText() {
    return sourceText;
  }


  public void setSourceText(String sourceText) {
    this.sourceText = sourceText;
  }


  public TGUDFNodeData environment(TGUDFEnvironment environment) {
    
    this.environment = environment;
    return this;
  }

   /**
   * Get environment
   * @return environment
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public TGUDFEnvironment getEnvironment() {
    return environment;
  }


  public void setEnvironment(TGUDFEnvironment environment) {
    this.environment = environment;
  }


  public TGUDFNodeData arguments(List<TGUDFArgument> arguments) {
    
    this.arguments = arguments;
    return this;
  }

  public TGUDFNodeData addArgumentsItem(TGUDFArgument argumentsItem) {
    if (this.arguments == null) {
      this.arguments = new ArrayList<>();
    }
    this.arguments.add(argumentsItem);
    return this;
  }

   /**
   * The arguments to a UDF function. This encompasses both named and positional arguments. The format is designed to provide compatibility across languages like Python which have a fairly traditional split between positional arguments and named arguments, and languages like R which has a rather unique way of specifying arguments. For Python (and most other languages), all positional arguments will come before all named arguments (if any are present):      // fn(arg1, arg2, arg3)     [       {value: arg1},       {value: arg2},       {value: arg3},     ]     // fn(arg1, arg2, n&#x3D;kw1, a&#x3D;kw2)     [       {value: arg1},       {value: arg2},       {name: \&quot;n\&quot;, value: kw1},       {name: \&quot;a\&quot;, value: kw2},     ]     // fn(kw&#x3D;k1, only&#x3D;k2)     [       {name: \&quot;kw\&quot;, value: k1},       {name: \&quot;only\&quot;, value: k2},     ]  However, in R, named and positional arguments may be intermixed freely:      // fn(arg, n&#x3D;kw1, arg2)     [       {value: arg},       {name: \&quot;n\&quot;, value: kw1},       {value: arg2},     ] 
   * @return arguments
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The arguments to a UDF function. This encompasses both named and positional arguments. The format is designed to provide compatibility across languages like Python which have a fairly traditional split between positional arguments and named arguments, and languages like R which has a rather unique way of specifying arguments. For Python (and most other languages), all positional arguments will come before all named arguments (if any are present):      // fn(arg1, arg2, arg3)     [       {value: arg1},       {value: arg2},       {value: arg3},     ]     // fn(arg1, arg2, n=kw1, a=kw2)     [       {value: arg1},       {value: arg2},       {name: \"n\", value: kw1},       {name: \"a\", value: kw2},     ]     // fn(kw=k1, only=k2)     [       {name: \"kw\", value: k1},       {name: \"only\", value: k2},     ]  However, in R, named and positional arguments may be intermixed freely:      // fn(arg, n=kw1, arg2)     [       {value: arg},       {name: \"n\", value: kw1},       {value: arg2},     ] ")

  public List<TGUDFArgument> getArguments() {
    return arguments;
  }


  public void setArguments(List<TGUDFArgument> arguments) {
    this.arguments = arguments;
  }


  public TGUDFNodeData resultFormat(ResultFormat resultFormat) {
    
    this.resultFormat = resultFormat;
    return this;
  }

   /**
   * Get resultFormat
   * @return resultFormat
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public ResultFormat getResultFormat() {
    return resultFormat;
  }


  public void setResultFormat(ResultFormat resultFormat) {
    this.resultFormat = resultFormat;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TGUDFNodeData tgUDFNodeData = (TGUDFNodeData) o;
    return Objects.equals(this.registeredUdfName, tgUDFNodeData.registeredUdfName) &&
        Objects.equals(this.executableCode, tgUDFNodeData.executableCode) &&
        Objects.equals(this.sourceText, tgUDFNodeData.sourceText) &&
        Objects.equals(this.environment, tgUDFNodeData.environment) &&
        Objects.equals(this.arguments, tgUDFNodeData.arguments) &&
        Objects.equals(this.resultFormat, tgUDFNodeData.resultFormat);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(registeredUdfName, executableCode, sourceText, environment, arguments, resultFormat);
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TGUDFNodeData {\n");
    sb.append("    registeredUdfName: ").append(toIndentedString(registeredUdfName)).append("\n");
    sb.append("    executableCode: ").append(toIndentedString(executableCode)).append("\n");
    sb.append("    sourceText: ").append(toIndentedString(sourceText)).append("\n");
    sb.append("    environment: ").append(toIndentedString(environment)).append("\n");
    sb.append("    arguments: ").append(toIndentedString(arguments)).append("\n");
    sb.append("    resultFormat: ").append(toIndentedString(resultFormat)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("registered_udf_name");
    openapiFields.add("executable_code");
    openapiFields.add("source_text");
    openapiFields.add("environment");
    openapiFields.add("arguments");
    openapiFields.add("result_format");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to TGUDFNodeData
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (TGUDFNodeData.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in TGUDFNodeData is not found in the empty JSON string", TGUDFNodeData.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
//      for (Entry<String, JsonElement> entry : entries) {
//        if (!TGUDFNodeData.openapiFields.contains(entry.getKey())) {
//          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `TGUDFNodeData` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
//        }
//      }
      if (jsonObj.get("registered_udf_name") != null && !jsonObj.get("registered_udf_name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `registered_udf_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("registered_udf_name").toString()));
      }
      if (jsonObj.get("executable_code") != null && !jsonObj.get("executable_code").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `executable_code` to be a primitive type in the JSON string but got `%s`", jsonObj.get("executable_code").toString()));
      }
      if (jsonObj.get("source_text") != null && !jsonObj.get("source_text").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `source_text` to be a primitive type in the JSON string but got `%s`", jsonObj.get("source_text").toString()));
      }
      // validate the optional field `environment`
      if (jsonObj.getAsJsonObject("environment") != null) {
        TGUDFEnvironment.validateJsonObject(jsonObj.getAsJsonObject("environment"));
      }
      JsonArray jsonArrayarguments = jsonObj.getAsJsonArray("arguments");
      if (jsonArrayarguments != null) {
        // ensure the json data is an array
        if (!jsonObj.get("arguments").isJsonArray()) {
          throw new IllegalArgumentException(String.format("Expected the field `arguments` to be an array in the JSON string but got `%s`", jsonObj.get("arguments").toString()));
        }

        // validate the optional field `arguments` (array)
        for (int i = 0; i < jsonArrayarguments.size(); i++) {
          TGUDFArgument.validateJsonObject(jsonArrayarguments.get(i).getAsJsonObject());
        };
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!TGUDFNodeData.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'TGUDFNodeData' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<TGUDFNodeData> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(TGUDFNodeData.class));

       return (TypeAdapter<T>) new TypeAdapter<TGUDFNodeData>() {
           @Override
           public void write(JsonWriter out, TGUDFNodeData value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public TGUDFNodeData read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of TGUDFNodeData given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of TGUDFNodeData
  * @throws IOException if the JSON string is invalid with respect to TGUDFNodeData
  */
  public static TGUDFNodeData fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, TGUDFNodeData.class);
  }

 /**
  * Convert an instance of TGUDFNodeData to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

