/*
 * TileDB Storage Platform API
 * TileDB Storage Platform REST API
 *
 * The version of the OpenAPI document: 2.2.19
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.tiledb.cloud.rest_api.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import io.tiledb.cloud.rest_api.JSON;
import org.openapitools.jackson.nullable.JsonNullable;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.util.HashSet;
import java.util.Map.Entry;
import java.util.Set;

/**
 * Logging information about the execution of a task graph.
 */
@ApiModel(description = "Logging information about the execution of a task graph.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-09-14T18:46:41.869452+03:00[Europe/Athens]")
public class TaskGraphLog {
  public static final String SERIALIZED_NAME_UUID = "uuid";
  @SerializedName(SERIALIZED_NAME_UUID)
  private String uuid;

  public static final String SERIALIZED_NAME_NAMESPACE = "namespace";
  @SerializedName(SERIALIZED_NAME_NAMESPACE)
  private String namespace;

  public static final String SERIALIZED_NAME_CREATED_BY = "created_by";
  @SerializedName(SERIALIZED_NAME_CREATED_BY)
  private String createdBy;

  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_CREATED_AT = "created_at";
  @SerializedName(SERIALIZED_NAME_CREATED_AT)
  private OffsetDateTime createdAt;

  public static final String SERIALIZED_NAME_START_TIME = "start_time";
  @SerializedName(SERIALIZED_NAME_START_TIME)
  private OffsetDateTime startTime;

  public static final String SERIALIZED_NAME_END_TIME = "end_time";
  @SerializedName(SERIALIZED_NAME_END_TIME)
  private OffsetDateTime endTime;

  public static final String SERIALIZED_NAME_STATUS = "status";
  @SerializedName(SERIALIZED_NAME_STATUS)
  private TaskGraphLogStatus status;

  public static final String SERIALIZED_NAME_TOTAL_COST = "total_cost";
  @SerializedName(SERIALIZED_NAME_TOTAL_COST)
  private BigDecimal totalCost;

  public static final String SERIALIZED_NAME_ACCESS_COST = "access_cost";
  @SerializedName(SERIALIZED_NAME_ACCESS_COST)
  private BigDecimal accessCost;

  public static final String SERIALIZED_NAME_EGRESS_COST = "egress_cost";
  @SerializedName(SERIALIZED_NAME_EGRESS_COST)
  private BigDecimal egressCost;

  public static final String SERIALIZED_NAME_EXECUTION_TIME = "execution_time";
  @SerializedName(SERIALIZED_NAME_EXECUTION_TIME)
  private String executionTime;

  public static final String SERIALIZED_NAME_STATUS_COUNT = "status_count";
  @SerializedName(SERIALIZED_NAME_STATUS_COUNT)
  private Map<String, BigDecimal> statusCount = null;

  public static final String SERIALIZED_NAME_NODES = "nodes";
  @SerializedName(SERIALIZED_NAME_NODES)
  private List<TaskGraphNodeMetadata> nodes = null;

  public TaskGraphLog() { 
  }

  
  public TaskGraphLog(
     String uuid, 
     String createdBy, 
     OffsetDateTime createdAt, 
     OffsetDateTime startTime, 
     OffsetDateTime endTime
  ) {
    this();
    this.uuid = uuid;
    this.createdBy = createdBy;
    this.createdAt = createdAt;
    this.startTime = startTime;
    this.endTime = endTime;
  }

   /**
   * The server-generated UUID of the task graph.
   * @return uuid
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The server-generated UUID of the task graph.")

  public String getUuid() {
    return uuid;
  }




  public TaskGraphLog namespace(String namespace) {
    
    this.namespace = namespace;
    return this;
  }

   /**
   * The namespace that owns this task graph log. When creating a task graph log, this is used as the namespace to create the log in; thereafter it is read-only. 
   * @return namespace
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The namespace that owns this task graph log. When creating a task graph log, this is used as the namespace to create the log in; thereafter it is read-only. ")

  public String getNamespace() {
    return namespace;
  }


  public void setNamespace(String namespace) {
    this.namespace = namespace;
  }


   /**
   * The name of the user who created this task graph log.
   * @return createdBy
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The name of the user who created this task graph log.")

  public String getCreatedBy() {
    return createdBy;
  }




  public TaskGraphLog name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * A name for this task graph log, displayed in the UI. Does not need to be unique. 
   * @return name
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "A name for this task graph log, displayed in the UI. Does not need to be unique. ")

  public String getName() {
    return name;
  }


  public void setName(String name) {
    this.name = name;
  }


   /**
   * The date/time when this task graph log was originally created. This is distinct from the execution start_time. 
   * @return createdAt
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The date/time when this task graph log was originally created. This is distinct from the execution start_time. ")

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }




   /**
   * The start time of the task graph, recorded when the server starts executing the first node. 
   * @return startTime
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The start time of the task graph, recorded when the server starts executing the first node. ")

  public OffsetDateTime getStartTime() {
    return startTime;
  }




   /**
   * The end time of the task graph, recorded when the client reports completion. 
   * @return endTime
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The end time of the task graph, recorded when the client reports completion. ")

  public OffsetDateTime getEndTime() {
    return endTime;
  }




  public TaskGraphLog status(TaskGraphLogStatus status) {
    
    this.status = status;
    return this;
  }

   /**
   * Get status
   * @return status
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public TaskGraphLogStatus getStatus() {
    return status;
  }


  public void setStatus(TaskGraphLogStatus status) {
    this.status = status;
  }


  public TaskGraphLog totalCost(BigDecimal totalCost) {
    
    this.totalCost = totalCost;
    return this;
  }

   /**
   * If present, the total cost of executing all nodes in this task graph. 
   * @return totalCost
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "If present, the total cost of executing all nodes in this task graph. ")

  public BigDecimal getTotalCost() {
    return totalCost;
  }


  public void setTotalCost(BigDecimal totalCost) {
    this.totalCost = totalCost;
  }


  public TaskGraphLog accessCost(BigDecimal accessCost) {
    
    this.accessCost = accessCost;
    return this;
  }

   /**
   * If present, the total cost of access from execution of the nodes in this task graph. 
   * @return accessCost
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "If present, the total cost of access from execution of the nodes in this task graph. ")

  public BigDecimal getAccessCost() {
    return accessCost;
  }


  public void setAccessCost(BigDecimal accessCost) {
    this.accessCost = accessCost;
  }


  public TaskGraphLog egressCost(BigDecimal egressCost) {
    
    this.egressCost = egressCost;
    return this;
  }

   /**
   * If present, the total cost of access from execution of the nodes in this task graph. 
   * @return egressCost
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "If present, the total cost of access from execution of the nodes in this task graph. ")

  public BigDecimal getEgressCost() {
    return egressCost;
  }


  public void setEgressCost(BigDecimal egressCost) {
    this.egressCost = egressCost;
  }


  public TaskGraphLog executionTime(String executionTime) {
    
    this.executionTime = executionTime;
    return this;
  }

   /**
   * The total execution time of all the nodes in this graph, in ISO 8601 format with hours, minutes, and seconds. 
   * @return executionTime
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "P15H22M0.45S", value = "The total execution time of all the nodes in this graph, in ISO 8601 format with hours, minutes, and seconds. ")

  public String getExecutionTime() {
    return executionTime;
  }


  public void setExecutionTime(String executionTime) {
    this.executionTime = executionTime;
  }


  public TaskGraphLog statusCount(Map<String, BigDecimal> statusCount) {
    
    this.statusCount = statusCount;
    return this;
  }

  public TaskGraphLog putStatusCountItem(String key, BigDecimal statusCountItem) {
    if (this.statusCount == null) {
      this.statusCount = new HashMap<>();
    }
    this.statusCount.put(key, statusCountItem);
    return this;
  }

   /**
   * A mapping from &#x60;ArrayTaskStatus&#x60; string value to the number of nodes in this graph that are in that status. 
   * @return statusCount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "A mapping from `ArrayTaskStatus` string value to the number of nodes in this graph that are in that status. ")

  public Map<String, BigDecimal> getStatusCount() {
    return statusCount;
  }


  public void setStatusCount(Map<String, BigDecimal> statusCount) {
    this.statusCount = statusCount;
  }


  public TaskGraphLog nodes(List<TaskGraphNodeMetadata> nodes) {
    
    this.nodes = nodes;
    return this;
  }

  public TaskGraphLog addNodesItem(TaskGraphNodeMetadata nodesItem) {
    if (this.nodes == null) {
      this.nodes = new ArrayList<>();
    }
    this.nodes.add(nodesItem);
    return this;
  }

   /**
   * The structure of the graph. This is provided by the client when first setting up the task graph. Thereafter, it is read-only. This must be topographically sorted; that is, each node must appear after all nodes that it depends upon. 
   * @return nodes
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The structure of the graph. This is provided by the client when first setting up the task graph. Thereafter, it is read-only. This must be topographically sorted; that is, each node must appear after all nodes that it depends upon. ")

  public List<TaskGraphNodeMetadata> getNodes() {
    return nodes;
  }


  public void setNodes(List<TaskGraphNodeMetadata> nodes) {
    this.nodes = nodes;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TaskGraphLog taskGraphLog = (TaskGraphLog) o;
    return Objects.equals(this.uuid, taskGraphLog.uuid) &&
        Objects.equals(this.namespace, taskGraphLog.namespace) &&
        Objects.equals(this.createdBy, taskGraphLog.createdBy) &&
        Objects.equals(this.name, taskGraphLog.name) &&
        Objects.equals(this.createdAt, taskGraphLog.createdAt) &&
        Objects.equals(this.startTime, taskGraphLog.startTime) &&
        Objects.equals(this.endTime, taskGraphLog.endTime) &&
        Objects.equals(this.status, taskGraphLog.status) &&
        Objects.equals(this.totalCost, taskGraphLog.totalCost) &&
        Objects.equals(this.accessCost, taskGraphLog.accessCost) &&
        Objects.equals(this.egressCost, taskGraphLog.egressCost) &&
        Objects.equals(this.executionTime, taskGraphLog.executionTime) &&
        Objects.equals(this.statusCount, taskGraphLog.statusCount) &&
        Objects.equals(this.nodes, taskGraphLog.nodes);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(uuid, namespace, createdBy, name, createdAt, startTime, endTime, status, totalCost, accessCost, egressCost, executionTime, statusCount, nodes);
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TaskGraphLog {\n");
    sb.append("    uuid: ").append(toIndentedString(uuid)).append("\n");
    sb.append("    namespace: ").append(toIndentedString(namespace)).append("\n");
    sb.append("    createdBy: ").append(toIndentedString(createdBy)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    startTime: ").append(toIndentedString(startTime)).append("\n");
    sb.append("    endTime: ").append(toIndentedString(endTime)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    totalCost: ").append(toIndentedString(totalCost)).append("\n");
    sb.append("    accessCost: ").append(toIndentedString(accessCost)).append("\n");
    sb.append("    egressCost: ").append(toIndentedString(egressCost)).append("\n");
    sb.append("    executionTime: ").append(toIndentedString(executionTime)).append("\n");
    sb.append("    statusCount: ").append(toIndentedString(statusCount)).append("\n");
    sb.append("    nodes: ").append(toIndentedString(nodes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("uuid");
    openapiFields.add("namespace");
    openapiFields.add("created_by");
    openapiFields.add("name");
    openapiFields.add("created_at");
    openapiFields.add("start_time");
    openapiFields.add("end_time");
    openapiFields.add("status");
    openapiFields.add("total_cost");
    openapiFields.add("access_cost");
    openapiFields.add("egress_cost");
    openapiFields.add("execution_time");
    openapiFields.add("status_count");
    openapiFields.add("nodes");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to TaskGraphLog
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (TaskGraphLog.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in TaskGraphLog is not found in the empty JSON string", TaskGraphLog.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!TaskGraphLog.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `TaskGraphLog` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
      }
      if (jsonObj.get("uuid") != null && !jsonObj.get("uuid").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `uuid` to be a primitive type in the JSON string but got `%s`", jsonObj.get("uuid").toString()));
      }
      if (jsonObj.get("namespace") != null && !jsonObj.get("namespace").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `namespace` to be a primitive type in the JSON string but got `%s`", jsonObj.get("namespace").toString()));
      }
      if (jsonObj.get("created_by") != null && !jsonObj.get("created_by").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `created_by` to be a primitive type in the JSON string but got `%s`", jsonObj.get("created_by").toString()));
      }
      if (jsonObj.get("name") != null && !jsonObj.get("name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("name").toString()));
      }
      if (jsonObj.get("execution_time") != null && !jsonObj.get("execution_time").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `execution_time` to be a primitive type in the JSON string but got `%s`", jsonObj.get("execution_time").toString()));
      }
      JsonArray jsonArraynodes = jsonObj.getAsJsonArray("nodes");
      if (jsonArraynodes != null) {
        // ensure the json data is an array
        if (!jsonObj.get("nodes").isJsonArray()) {
          throw new IllegalArgumentException(String.format("Expected the field `nodes` to be an array in the JSON string but got `%s`", jsonObj.get("nodes").toString()));
        }

        // validate the optional field `nodes` (array)
        for (int i = 0; i < jsonArraynodes.size(); i++) {
          TaskGraphNodeMetadata.validateJsonObject(jsonArraynodes.get(i).getAsJsonObject());
        };
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!TaskGraphLog.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'TaskGraphLog' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<TaskGraphLog> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(TaskGraphLog.class));

       return (TypeAdapter<T>) new TypeAdapter<TaskGraphLog>() {
           @Override
           public void write(JsonWriter out, TaskGraphLog value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public TaskGraphLog read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of TaskGraphLog given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of TaskGraphLog
  * @throws IOException if the JSON string is invalid with respect to TaskGraphLog
  */
  public static TaskGraphLog fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, TaskGraphLog.class);
  }

 /**
  * Convert an instance of TaskGraphLog to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

