/*
 * TileDB Storage Platform API
 * TileDB Storage Platform REST API
 *
 * The version of the OpenAPI document: 2.2.19
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.tiledb.cloud.rest_api.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import io.tiledb.cloud.rest_api.JSON;
import org.openapitools.jackson.nullable.JsonNullable;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.util.HashSet;
import java.util.Map.Entry;
import java.util.Set;

/**
 * Contains array details for multi-array query including uri, ranges buffers
 */
@ApiModel(description = "Contains array details for multi-array query including uri, ranges buffers")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-09-14T18:46:41.869452+03:00[Europe/Athens]")
public class UDFArrayDetails {
  public static final String SERIALIZED_NAME_PARAMETER_ID = "parameter_id";
  @SerializedName(SERIALIZED_NAME_PARAMETER_ID)
  private String parameterId;

  public static final String SERIALIZED_NAME_URI = "uri";
  @SerializedName(SERIALIZED_NAME_URI)
  private String uri;

  public static final String SERIALIZED_NAME_RANGES = "ranges";
  @SerializedName(SERIALIZED_NAME_RANGES)
  private QueryRanges ranges;

  public static final String SERIALIZED_NAME_BUFFERS = "buffers";
  @SerializedName(SERIALIZED_NAME_BUFFERS)
  private List<String> buffers = null;

  public UDFArrayDetails() { 
  }

  public UDFArrayDetails parameterId(String parameterId) {
    
    this.parameterId = parameterId;
    return this;
  }

   /**
   * An optional client-generated identifier to distinguish between multiple range/buffer requests from the same array in the same call. This may be set for MultiArrayUDFs that use the &#x60;argument_json&#x60; style of passing arrays. 
   * @return parameterId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "An optional client-generated identifier to distinguish between multiple range/buffer requests from the same array in the same call. This may be set for MultiArrayUDFs that use the `argument_json` style of passing arrays. ")

  public String getParameterId() {
    return parameterId;
  }


  public void setParameterId(String parameterId) {
    this.parameterId = parameterId;
  }


  public UDFArrayDetails uri(String uri) {
    
    this.uri = uri;
    return this;
  }

   /**
   * array to set ranges and buffers on, must be in tiledb:// format
   * @return uri
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "array to set ranges and buffers on, must be in tiledb:// format")

  public String getUri() {
    return uri;
  }


  public void setUri(String uri) {
    this.uri = uri;
  }


  public UDFArrayDetails ranges(QueryRanges ranges) {
    
    this.ranges = ranges;
    return this;
  }

   /**
   * Get ranges
   * @return ranges
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public QueryRanges getRanges() {
    return ranges;
  }


  public void setRanges(QueryRanges ranges) {
    this.ranges = ranges;
  }


  public UDFArrayDetails buffers(List<String> buffers) {
    
    this.buffers = buffers;
    return this;
  }

  public UDFArrayDetails addBuffersItem(String buffersItem) {
    if (this.buffers == null) {
      this.buffers = new ArrayList<>();
    }
    this.buffers.add(buffersItem);
    return this;
  }

   /**
   * List of buffers to fetch (attributes + dimensions)
   * @return buffers
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "List of buffers to fetch (attributes + dimensions)")

  public List<String> getBuffers() {
    return buffers;
  }


  public void setBuffers(List<String> buffers) {
    this.buffers = buffers;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UDFArrayDetails udFArrayDetails = (UDFArrayDetails) o;
    return Objects.equals(this.parameterId, udFArrayDetails.parameterId) &&
        Objects.equals(this.uri, udFArrayDetails.uri) &&
        Objects.equals(this.ranges, udFArrayDetails.ranges) &&
        Objects.equals(this.buffers, udFArrayDetails.buffers);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(parameterId, uri, ranges, buffers);
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UDFArrayDetails {\n");
    sb.append("    parameterId: ").append(toIndentedString(parameterId)).append("\n");
    sb.append("    uri: ").append(toIndentedString(uri)).append("\n");
    sb.append("    ranges: ").append(toIndentedString(ranges)).append("\n");
    sb.append("    buffers: ").append(toIndentedString(buffers)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("parameter_id");
    openapiFields.add("uri");
    openapiFields.add("ranges");
    openapiFields.add("buffers");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to UDFArrayDetails
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (UDFArrayDetails.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in UDFArrayDetails is not found in the empty JSON string", UDFArrayDetails.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
//      for (Entry<String, JsonElement> entry : entries) {
//        if (!UDFArrayDetails.openapiFields.contains(entry.getKey())) {
//          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `UDFArrayDetails` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
//        }
//      }
      if (jsonObj.get("parameter_id") != null && !jsonObj.get("parameter_id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `parameter_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("parameter_id").toString()));
      }
      if (jsonObj.get("uri") != null && !jsonObj.get("uri").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `uri` to be a primitive type in the JSON string but got `%s`", jsonObj.get("uri").toString()));
      }
      // validate the optional field `ranges`
      if (jsonObj.getAsJsonObject("ranges") != null) {
        QueryRanges.validateJsonObject(jsonObj.getAsJsonObject("ranges"));
      }
      // ensure the json data is an array
      if (jsonObj.get("buffers") != null && !jsonObj.get("buffers").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `buffers` to be an array in the JSON string but got `%s`", jsonObj.get("buffers").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!UDFArrayDetails.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'UDFArrayDetails' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<UDFArrayDetails> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(UDFArrayDetails.class));

       return (TypeAdapter<T>) new TypeAdapter<UDFArrayDetails>() {
           @Override
           public void write(JsonWriter out, UDFArrayDetails value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public UDFArrayDetails read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of UDFArrayDetails given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of UDFArrayDetails
  * @throws IOException if the JSON string is invalid with respect to UDFArrayDetails
  */
  public static UDFArrayDetails fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, UDFArrayDetails.class);
  }

 /**
  * Convert an instance of UDFArrayDetails to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

