/*
 * TileDB Storage Platform API
 * TileDB Storage Platform REST API
 *
 * The version of the OpenAPI document: 2.2.19
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.tiledb.cloud.rest_api.model;

import java.util.Objects;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import io.tiledb.cloud.rest_api.JSON;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.util.HashSet;
import java.util.Map.Entry;
import java.util.Set;

/**
 * User-defined function that can persist in db, used and shared multiple times
 */
@ApiModel(description = "User-defined function that can persist in db, used and shared multiple times")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-09-14T18:46:41.869452+03:00[Europe/Athens]")
public class UDFInfoUpdate {
  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_LANGUAGE = "language";
  @SerializedName(SERIALIZED_NAME_LANGUAGE)
  private UDFLanguage language;

  public static final String SERIALIZED_NAME_VERSION = "version";
  @SerializedName(SERIALIZED_NAME_VERSION)
  private String version;

  public static final String SERIALIZED_NAME_IMAGE_NAME = "image_name";
  @SerializedName(SERIALIZED_NAME_IMAGE_NAME)
  private String imageName;

  public static final String SERIALIZED_NAME_TYPE = "type";
  @SerializedName(SERIALIZED_NAME_TYPE)
  private UDFType type;

  public static final String SERIALIZED_NAME_EXEC = "exec";
  @SerializedName(SERIALIZED_NAME_EXEC)
  private String exec;

  public static final String SERIALIZED_NAME_EXEC_RAW = "exec_raw";
  @SerializedName(SERIALIZED_NAME_EXEC_RAW)
  private String execRaw;

  public static final String SERIALIZED_NAME_README = "readme";
  @SerializedName(SERIALIZED_NAME_README)
  private String readme;

  public static final String SERIALIZED_NAME_LICENSE_ID = "license_id";
  @SerializedName(SERIALIZED_NAME_LICENSE_ID)
  private String licenseId;

  public static final String SERIALIZED_NAME_LICENSE_TEXT = "license_text";
  @SerializedName(SERIALIZED_NAME_LICENSE_TEXT)
  private String licenseText;

  public static final String SERIALIZED_NAME_TAGS = "tags";
  @SerializedName(SERIALIZED_NAME_TAGS)
  private List<String> tags = null;

  public UDFInfoUpdate() { 
  }

  public UDFInfoUpdate name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * name of UDF
   * @return name
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "name of UDF")

  public String getName() {
    return name;
  }


  public void setName(String name) {
    this.name = name;
  }


  public UDFInfoUpdate language(UDFLanguage language) {
    
    this.language = language;
    return this;
  }

   /**
   * Get language
   * @return language
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public UDFLanguage getLanguage() {
    return language;
  }


  public void setLanguage(UDFLanguage language) {
    this.language = language;
  }


  public UDFInfoUpdate version(String version) {
    
    this.version = version;
    return this;
  }

   /**
   * Type-specific version
   * @return version
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Type-specific version")

  public String getVersion() {
    return version;
  }


  public void setVersion(String version) {
    this.version = version;
  }


  public UDFInfoUpdate imageName(String imageName) {
    
    this.imageName = imageName;
    return this;
  }

   /**
   * Docker image name to use for UDF
   * @return imageName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Docker image name to use for UDF")

  public String getImageName() {
    return imageName;
  }


  public void setImageName(String imageName) {
    this.imageName = imageName;
  }


  public UDFInfoUpdate type(UDFType type) {
    
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public UDFType getType() {
    return type;
  }


  public void setType(UDFType type) {
    this.type = type;
  }


  public UDFInfoUpdate exec(String exec) {
    
    this.exec = exec;
    return this;
  }

   /**
   * Type-specific executable text
   * @return exec
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Type-specific executable text")

  public String getExec() {
    return exec;
  }


  public void setExec(String exec) {
    this.exec = exec;
  }


  public UDFInfoUpdate execRaw(String execRaw) {
    
    this.execRaw = execRaw;
    return this;
  }

   /**
   * optional raw text to store of serialized function, used for showing in UI
   * @return execRaw
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "optional raw text to store of serialized function, used for showing in UI")

  public String getExecRaw() {
    return execRaw;
  }


  public void setExecRaw(String execRaw) {
    this.execRaw = execRaw;
  }


  public UDFInfoUpdate readme(String readme) {
    
    this.readme = readme;
    return this;
  }

   /**
   * Markdown readme of UDFs
   * @return readme
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Markdown readme of UDFs")

  public String getReadme() {
    return readme;
  }


  public void setReadme(String readme) {
    this.readme = readme;
  }


  public UDFInfoUpdate licenseId(String licenseId) {
    
    this.licenseId = licenseId;
    return this;
  }

   /**
   * License identifier from SPDX License List or Custom
   * @return licenseId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "License identifier from SPDX License List or Custom")

  public String getLicenseId() {
    return licenseId;
  }


  public void setLicenseId(String licenseId) {
    this.licenseId = licenseId;
  }


  public UDFInfoUpdate licenseText(String licenseText) {
    
    this.licenseText = licenseText;
    return this;
  }

   /**
   * License text
   * @return licenseText
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "License text")

  public String getLicenseText() {
    return licenseText;
  }


  public void setLicenseText(String licenseText) {
    this.licenseText = licenseText;
  }


  public UDFInfoUpdate tags(List<String> tags) {
    
    this.tags = tags;
    return this;
  }

  public UDFInfoUpdate addTagsItem(String tagsItem) {
    if (this.tags == null) {
      this.tags = new ArrayList<>();
    }
    this.tags.add(tagsItem);
    return this;
  }

   /**
   * optional tags for UDF
   * @return tags
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "optional tags for UDF")

  public List<String> getTags() {
    return tags;
  }


  public void setTags(List<String> tags) {
    this.tags = tags;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UDFInfoUpdate udFInfoUpdate = (UDFInfoUpdate) o;
    return Objects.equals(this.name, udFInfoUpdate.name) &&
        Objects.equals(this.language, udFInfoUpdate.language) &&
        Objects.equals(this.version, udFInfoUpdate.version) &&
        Objects.equals(this.imageName, udFInfoUpdate.imageName) &&
        Objects.equals(this.type, udFInfoUpdate.type) &&
        Objects.equals(this.exec, udFInfoUpdate.exec) &&
        Objects.equals(this.execRaw, udFInfoUpdate.execRaw) &&
        Objects.equals(this.readme, udFInfoUpdate.readme) &&
        Objects.equals(this.licenseId, udFInfoUpdate.licenseId) &&
        Objects.equals(this.licenseText, udFInfoUpdate.licenseText) &&
        Objects.equals(this.tags, udFInfoUpdate.tags);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, language, version, imageName, type, exec, execRaw, readme, licenseId, licenseText, tags);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UDFInfoUpdate {\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    language: ").append(toIndentedString(language)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    imageName: ").append(toIndentedString(imageName)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    exec: ").append(toIndentedString(exec)).append("\n");
    sb.append("    execRaw: ").append(toIndentedString(execRaw)).append("\n");
    sb.append("    readme: ").append(toIndentedString(readme)).append("\n");
    sb.append("    licenseId: ").append(toIndentedString(licenseId)).append("\n");
    sb.append("    licenseText: ").append(toIndentedString(licenseText)).append("\n");
    sb.append("    tags: ").append(toIndentedString(tags)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("name");
    openapiFields.add("language");
    openapiFields.add("version");
    openapiFields.add("image_name");
    openapiFields.add("type");
    openapiFields.add("exec");
    openapiFields.add("exec_raw");
    openapiFields.add("readme");
    openapiFields.add("license_id");
    openapiFields.add("license_text");
    openapiFields.add("tags");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to UDFInfoUpdate
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (UDFInfoUpdate.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in UDFInfoUpdate is not found in the empty JSON string", UDFInfoUpdate.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
//      for (Entry<String, JsonElement> entry : entries) {
//        if (!UDFInfoUpdate.openapiFields.contains(entry.getKey())) {
//          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `UDFInfoUpdate` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
//        }
//      }
      if (jsonObj.get("name") != null && !jsonObj.get("name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("name").toString()));
      }
      if (jsonObj.get("version") != null && !jsonObj.get("version").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `version` to be a primitive type in the JSON string but got `%s`", jsonObj.get("version").toString()));
      }
      if (jsonObj.get("image_name") != null && !jsonObj.get("image_name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `image_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("image_name").toString()));
      }
      if (jsonObj.get("exec") != null && !jsonObj.get("exec").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `exec` to be a primitive type in the JSON string but got `%s`", jsonObj.get("exec").toString()));
      }
      if (jsonObj.get("exec_raw") != null && !jsonObj.get("exec_raw").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `exec_raw` to be a primitive type in the JSON string but got `%s`", jsonObj.get("exec_raw").toString()));
      }
      if (jsonObj.get("readme") != null && !jsonObj.get("readme").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `readme` to be a primitive type in the JSON string but got `%s`", jsonObj.get("readme").toString()));
      }
      if (jsonObj.get("license_id") != null && !jsonObj.get("license_id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `license_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("license_id").toString()));
      }
      if (jsonObj.get("license_text") != null && !jsonObj.get("license_text").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `license_text` to be a primitive type in the JSON string but got `%s`", jsonObj.get("license_text").toString()));
      }
      // ensure the json data is an array
      if (jsonObj.get("tags") != null && !jsonObj.get("tags").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `tags` to be an array in the JSON string but got `%s`", jsonObj.get("tags").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!UDFInfoUpdate.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'UDFInfoUpdate' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<UDFInfoUpdate> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(UDFInfoUpdate.class));

       return (TypeAdapter<T>) new TypeAdapter<UDFInfoUpdate>() {
           @Override
           public void write(JsonWriter out, UDFInfoUpdate value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public UDFInfoUpdate read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of UDFInfoUpdate given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of UDFInfoUpdate
  * @throws IOException if the JSON string is invalid with respect to UDFInfoUpdate
  */
  public static UDFInfoUpdate fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, UDFInfoUpdate.class);
  }

 /**
  * Convert an instance of UDFInfoUpdate to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

