/*
 * TileDB Storage Platform API
 * TileDB Storage Platform REST API
 *
 * The version of the OpenAPI document: 2.2.19
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.tiledb.cloud.rest_api.api;

import io.tiledb.cloud.rest_api.ApiClient;
import io.tiledb.cloud.rest_api.ApiException;
import io.tiledb.cloud.rest_api.ApiResponse;
import io.tiledb.cloud.rest_api.Pair;
import io.tiledb.cloud.rest_api.ApiCallback;
import io.tiledb.cloud.rest_api.Configuration;

import com.google.gson.reflect.TypeToken;


import io.tiledb.cloud.rest_api.model.ArrayActivityLog;
import io.tiledb.cloud.rest_api.model.ArrayBrowserData;
import io.tiledb.cloud.rest_api.model.ArrayBrowserSidebar;
import io.tiledb.cloud.rest_api.model.ArrayEndTimestampData;
import io.tiledb.cloud.rest_api.model.ArrayInfo;
import io.tiledb.cloud.rest_api.model.ArrayInfoUpdate;
import io.tiledb.cloud.rest_api.model.ArrayMetadata;
import io.tiledb.cloud.rest_api.model.ArraySample;
import io.tiledb.cloud.rest_api.model.ArraySchema;
import io.tiledb.cloud.rest_api.model.ArraySharing;
import java.math.BigDecimal;

import io.tiledb.cloud.rest_api.model.LastAccessedArray;
import io.tiledb.cloud.rest_api.model.MaxBufferSizes;
import io.tiledb.cloud.rest_api.model.NonEmptyDomain;
import io.tiledb.cloud.rest_api.model.TileDBConfig;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ArrayApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ArrayApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ArrayApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    /**
     * Build call for arrayActivityLog
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param start Start time of window of fetch logs, unix epoch in seconds (default: seven days ago) (optional)
     * @param end End time of window of fetch logs, unix epoch in seconds (default: current utc timestamp) (optional)
     * @param eventTypes Event values can be one or more of the following read, write, create, delete, register, deregister, comma separated (optional)
     * @param taskId Array task ID To filter activity to (optional)
     * @param hasTaskId Excludes activity log results that do not contain an array task UUID (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> log of array activity </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call arrayActivityLogCall(String namespace, String array, Integer start, Integer end, String eventTypes, String taskId, Boolean hasTaskId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/arrays/{namespace}/{array}/activity"
            .replaceAll("\\{" + "namespace" + "\\}", localVarApiClient.escapeString(namespace.toString()))
            .replaceAll("\\{" + "array" + "\\}", localVarApiClient.escapeString(array.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (start != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("start", start));
        }

        if (end != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("end", end));
        }

        if (eventTypes != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("event_types", eventTypes));
        }

        if (taskId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("task_id", taskId));
        }

        if (hasTaskId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("has_task_id", hasTaskId));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call arrayActivityLogValidateBeforeCall(String namespace, String array, Integer start, Integer end, String eventTypes, String taskId, Boolean hasTaskId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'namespace' is set
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling arrayActivityLog(Async)");
        }
        
        // verify the required parameter 'array' is set
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling arrayActivityLog(Async)");
        }
        

        okhttp3.Call localVarCall = arrayActivityLogCall(namespace, array, start, end, eventTypes, taskId, hasTaskId, _callback);
        return localVarCall;

    }

    /**
     * 
     * get array activity logs
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param start Start time of window of fetch logs, unix epoch in seconds (default: seven days ago) (optional)
     * @param end End time of window of fetch logs, unix epoch in seconds (default: current utc timestamp) (optional)
     * @param eventTypes Event values can be one or more of the following read, write, create, delete, register, deregister, comma separated (optional)
     * @param taskId Array task ID To filter activity to (optional)
     * @param hasTaskId Excludes activity log results that do not contain an array task UUID (optional)
     * @return List&lt;ArrayActivityLog&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> log of array activity </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public List<ArrayActivityLog> arrayActivityLog(String namespace, String array, Integer start, Integer end, String eventTypes, String taskId, Boolean hasTaskId) throws ApiException {
        ApiResponse<List<ArrayActivityLog>> localVarResp = arrayActivityLogWithHttpInfo(namespace, array, start, end, eventTypes, taskId, hasTaskId);
        return localVarResp.getData();
    }

    /**
     * 
     * get array activity logs
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param start Start time of window of fetch logs, unix epoch in seconds (default: seven days ago) (optional)
     * @param end End time of window of fetch logs, unix epoch in seconds (default: current utc timestamp) (optional)
     * @param eventTypes Event values can be one or more of the following read, write, create, delete, register, deregister, comma separated (optional)
     * @param taskId Array task ID To filter activity to (optional)
     * @param hasTaskId Excludes activity log results that do not contain an array task UUID (optional)
     * @return ApiResponse&lt;List&lt;ArrayActivityLog&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> log of array activity </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<ArrayActivityLog>> arrayActivityLogWithHttpInfo(String namespace, String array, Integer start, Integer end, String eventTypes, String taskId, Boolean hasTaskId) throws ApiException {
        okhttp3.Call localVarCall = arrayActivityLogValidateBeforeCall(namespace, array, start, end, eventTypes, taskId, hasTaskId, null);
        Type localVarReturnType = new TypeToken<List<ArrayActivityLog>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * get array activity logs
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param start Start time of window of fetch logs, unix epoch in seconds (default: seven days ago) (optional)
     * @param end End time of window of fetch logs, unix epoch in seconds (default: current utc timestamp) (optional)
     * @param eventTypes Event values can be one or more of the following read, write, create, delete, register, deregister, comma separated (optional)
     * @param taskId Array task ID To filter activity to (optional)
     * @param hasTaskId Excludes activity log results that do not contain an array task UUID (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> log of array activity </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call arrayActivityLogAsync(String namespace, String array, Integer start, Integer end, String eventTypes, String taskId, Boolean hasTaskId, final ApiCallback<List<ArrayActivityLog>> _callback) throws ApiException {

        okhttp3.Call localVarCall = arrayActivityLogValidateBeforeCall(namespace, array, start, end, eventTypes, taskId, hasTaskId, _callback);
        Type localVarReturnType = new TypeToken<List<ArrayActivityLog>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for arraysBrowserOwnedGet
     * @param page pagination offset (optional)
     * @param perPage pagination limit (optional)
     * @param search search string that will look at name, namespace or description fields (optional)
     * @param namespace namespace (optional)
     * @param orderby sort by which field valid values include last_accessed, size, name (optional)
     * @param permissions permissions valid values include read, read_write, write, admin (optional)
     * @param tag tag to search for, more than one can be included (optional)
     * @param excludeTag tags to exclude matching array in results, more than one can be included (optional)
     * @param fileType file_type to search for, more than one can be included (optional)
     * @param excludeFileType file_type to exclude matching array in results, more than one can be included (optional)
     * @param fileProperty file_property key-value pair (comma separated, i.e. key,value) to search for, more than one can be included (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Array of array info that are owned directly by user or user&#39;s organizations </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call arraysBrowserOwnedGetCall(Integer page, Integer perPage, String search, String namespace, String orderby, String permissions, List<String> tag, List<String> excludeTag, List<String> fileType, List<String> excludeFileType, List<String> fileProperty, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/arrays/browser/owned";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (perPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("per_page", perPage));
        }

        if (search != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("search", search));
        }

        if (namespace != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("namespace", namespace));
        }

        if (orderby != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("orderby", orderby));
        }

        if (permissions != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("permissions", permissions));
        }

        if (tag != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "tag", tag));
        }

        if (excludeTag != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "exclude_tag", excludeTag));
        }

        if (fileType != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "file_type", fileType));
        }

        if (excludeFileType != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "exclude_file_type", excludeFileType));
        }

        if (fileProperty != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "file_property", fileProperty));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call arraysBrowserOwnedGetValidateBeforeCall(Integer page, Integer perPage, String search, String namespace, String orderby, String permissions, List<String> tag, List<String> excludeTag, List<String> fileType, List<String> excludeFileType, List<String> fileProperty, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = arraysBrowserOwnedGetCall(page, perPage, search, namespace, orderby, permissions, tag, excludeTag, fileType, excludeFileType, fileProperty, _callback);
        return localVarCall;

    }

    /**
     * 
     * Fetch a list of all arrays that are owned directly by user or user&#39;s organizations
     * @param page pagination offset (optional)
     * @param perPage pagination limit (optional)
     * @param search search string that will look at name, namespace or description fields (optional)
     * @param namespace namespace (optional)
     * @param orderby sort by which field valid values include last_accessed, size, name (optional)
     * @param permissions permissions valid values include read, read_write, write, admin (optional)
     * @param tag tag to search for, more than one can be included (optional)
     * @param excludeTag tags to exclude matching array in results, more than one can be included (optional)
     * @param fileType file_type to search for, more than one can be included (optional)
     * @param excludeFileType file_type to exclude matching array in results, more than one can be included (optional)
     * @param fileProperty file_property key-value pair (comma separated, i.e. key,value) to search for, more than one can be included (optional)
     * @return ArrayBrowserData
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Array of array info that are owned directly by user or user&#39;s organizations </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ArrayBrowserData arraysBrowserOwnedGet(Integer page, Integer perPage, String search, String namespace, String orderby, String permissions, List<String> tag, List<String> excludeTag, List<String> fileType, List<String> excludeFileType, List<String> fileProperty) throws ApiException {
        ApiResponse<ArrayBrowserData> localVarResp = arraysBrowserOwnedGetWithHttpInfo(page, perPage, search, namespace, orderby, permissions, tag, excludeTag, fileType, excludeFileType, fileProperty);
        return localVarResp.getData();
    }

    /**
     * 
     * Fetch a list of all arrays that are owned directly by user or user&#39;s organizations
     * @param page pagination offset (optional)
     * @param perPage pagination limit (optional)
     * @param search search string that will look at name, namespace or description fields (optional)
     * @param namespace namespace (optional)
     * @param orderby sort by which field valid values include last_accessed, size, name (optional)
     * @param permissions permissions valid values include read, read_write, write, admin (optional)
     * @param tag tag to search for, more than one can be included (optional)
     * @param excludeTag tags to exclude matching array in results, more than one can be included (optional)
     * @param fileType file_type to search for, more than one can be included (optional)
     * @param excludeFileType file_type to exclude matching array in results, more than one can be included (optional)
     * @param fileProperty file_property key-value pair (comma separated, i.e. key,value) to search for, more than one can be included (optional)
     * @return ApiResponse&lt;ArrayBrowserData&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Array of array info that are owned directly by user or user&#39;s organizations </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ArrayBrowserData> arraysBrowserOwnedGetWithHttpInfo(Integer page, Integer perPage, String search, String namespace, String orderby, String permissions, List<String> tag, List<String> excludeTag, List<String> fileType, List<String> excludeFileType, List<String> fileProperty) throws ApiException {
        okhttp3.Call localVarCall = arraysBrowserOwnedGetValidateBeforeCall(page, perPage, search, namespace, orderby, permissions, tag, excludeTag, fileType, excludeFileType, fileProperty, null);
        Type localVarReturnType = new TypeToken<ArrayBrowserData>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Fetch a list of all arrays that are owned directly by user or user&#39;s organizations
     * @param page pagination offset (optional)
     * @param perPage pagination limit (optional)
     * @param search search string that will look at name, namespace or description fields (optional)
     * @param namespace namespace (optional)
     * @param orderby sort by which field valid values include last_accessed, size, name (optional)
     * @param permissions permissions valid values include read, read_write, write, admin (optional)
     * @param tag tag to search for, more than one can be included (optional)
     * @param excludeTag tags to exclude matching array in results, more than one can be included (optional)
     * @param fileType file_type to search for, more than one can be included (optional)
     * @param excludeFileType file_type to exclude matching array in results, more than one can be included (optional)
     * @param fileProperty file_property key-value pair (comma separated, i.e. key,value) to search for, more than one can be included (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Array of array info that are owned directly by user or user&#39;s organizations </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call arraysBrowserOwnedGetAsync(Integer page, Integer perPage, String search, String namespace, String orderby, String permissions, List<String> tag, List<String> excludeTag, List<String> fileType, List<String> excludeFileType, List<String> fileProperty, final ApiCallback<ArrayBrowserData> _callback) throws ApiException {

        okhttp3.Call localVarCall = arraysBrowserOwnedGetValidateBeforeCall(page, perPage, search, namespace, orderby, permissions, tag, excludeTag, fileType, excludeFileType, fileProperty, _callback);
        Type localVarReturnType = new TypeToken<ArrayBrowserData>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for arraysBrowserOwnedSidebarGet
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Array of array info that are owned directly by user or user&#39;s organizations </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call arraysBrowserOwnedSidebarGetCall(final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/arrays/browser/owned/sidebar";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call arraysBrowserOwnedSidebarGetValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = arraysBrowserOwnedSidebarGetCall(_callback);
        return localVarCall;

    }

    /**
     * 
     * Fetch a sidebar for arrays that are owned directly by user or user&#39;s organizations
     * @return ArrayBrowserSidebar
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Array of array info that are owned directly by user or user&#39;s organizations </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ArrayBrowserSidebar arraysBrowserOwnedSidebarGet() throws ApiException {
        ApiResponse<ArrayBrowserSidebar> localVarResp = arraysBrowserOwnedSidebarGetWithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * 
     * Fetch a sidebar for arrays that are owned directly by user or user&#39;s organizations
     * @return ApiResponse&lt;ArrayBrowserSidebar&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Array of array info that are owned directly by user or user&#39;s organizations </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ArrayBrowserSidebar> arraysBrowserOwnedSidebarGetWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = arraysBrowserOwnedSidebarGetValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<ArrayBrowserSidebar>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Fetch a sidebar for arrays that are owned directly by user or user&#39;s organizations
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Array of array info that are owned directly by user or user&#39;s organizations </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call arraysBrowserOwnedSidebarGetAsync(final ApiCallback<ArrayBrowserSidebar> _callback) throws ApiException {

        okhttp3.Call localVarCall = arraysBrowserOwnedSidebarGetValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<ArrayBrowserSidebar>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for arraysBrowserPublicGet
     * @param page pagination offset (optional)
     * @param perPage pagination limit (optional)
     * @param search search string that will look at name, namespace or description fields (optional)
     * @param namespace namespace (optional)
     * @param orderby sort by which field valid values include last_accessed, size, name (optional)
     * @param permissions permissions valid values include read, read_write, write, admin (optional)
     * @param tag tag to search for, more than one can be included (optional)
     * @param excludeTag tags to exclude matching array in results, more than one can be included (optional)
     * @param fileType file_type to search for, more than one can be included (optional)
     * @param excludeFileType file_type to exclude matching array in results, more than one can be included (optional)
     * @param fileProperty file_property key-value pair (comma separated, i.e. key,value) to search for, more than one can be included (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Array of array info that has been shared publically </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call arraysBrowserPublicGetCall(Integer page, Integer perPage, String search, String namespace, String orderby, String permissions, List<String> tag, List<String> excludeTag, List<String> fileType, List<String> excludeFileType, List<String> fileProperty, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/arrays/browser/public";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (perPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("per_page", perPage));
        }

        if (search != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("search", search));
        }

        if (namespace != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("namespace", namespace));
        }

        if (orderby != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("orderby", orderby));
        }

        if (permissions != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("permissions", permissions));
        }

        if (tag != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "tag", tag));
        }

        if (excludeTag != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "exclude_tag", excludeTag));
        }

        if (fileType != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "file_type", fileType));
        }

        if (excludeFileType != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "exclude_file_type", excludeFileType));
        }

        if (fileProperty != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "file_property", fileProperty));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call arraysBrowserPublicGetValidateBeforeCall(Integer page, Integer perPage, String search, String namespace, String orderby, String permissions, List<String> tag, List<String> excludeTag, List<String> fileType, List<String> excludeFileType, List<String> fileProperty, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = arraysBrowserPublicGetCall(page, perPage, search, namespace, orderby, permissions, tag, excludeTag, fileType, excludeFileType, fileProperty, _callback);
        return localVarCall;

    }

    /**
     * 
     * Fetch a list of all arrays that have been shared publically
     * @param page pagination offset (optional)
     * @param perPage pagination limit (optional)
     * @param search search string that will look at name, namespace or description fields (optional)
     * @param namespace namespace (optional)
     * @param orderby sort by which field valid values include last_accessed, size, name (optional)
     * @param permissions permissions valid values include read, read_write, write, admin (optional)
     * @param tag tag to search for, more than one can be included (optional)
     * @param excludeTag tags to exclude matching array in results, more than one can be included (optional)
     * @param fileType file_type to search for, more than one can be included (optional)
     * @param excludeFileType file_type to exclude matching array in results, more than one can be included (optional)
     * @param fileProperty file_property key-value pair (comma separated, i.e. key,value) to search for, more than one can be included (optional)
     * @return ArrayBrowserData
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Array of array info that has been shared publically </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ArrayBrowserData arraysBrowserPublicGet(Integer page, Integer perPage, String search, String namespace, String orderby, String permissions, List<String> tag, List<String> excludeTag, List<String> fileType, List<String> excludeFileType, List<String> fileProperty) throws ApiException {
        ApiResponse<ArrayBrowserData> localVarResp = arraysBrowserPublicGetWithHttpInfo(page, perPage, search, namespace, orderby, permissions, tag, excludeTag, fileType, excludeFileType, fileProperty);
        return localVarResp.getData();
    }

    /**
     * 
     * Fetch a list of all arrays that have been shared publically
     * @param page pagination offset (optional)
     * @param perPage pagination limit (optional)
     * @param search search string that will look at name, namespace or description fields (optional)
     * @param namespace namespace (optional)
     * @param orderby sort by which field valid values include last_accessed, size, name (optional)
     * @param permissions permissions valid values include read, read_write, write, admin (optional)
     * @param tag tag to search for, more than one can be included (optional)
     * @param excludeTag tags to exclude matching array in results, more than one can be included (optional)
     * @param fileType file_type to search for, more than one can be included (optional)
     * @param excludeFileType file_type to exclude matching array in results, more than one can be included (optional)
     * @param fileProperty file_property key-value pair (comma separated, i.e. key,value) to search for, more than one can be included (optional)
     * @return ApiResponse&lt;ArrayBrowserData&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Array of array info that has been shared publically </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ArrayBrowserData> arraysBrowserPublicGetWithHttpInfo(Integer page, Integer perPage, String search, String namespace, String orderby, String permissions, List<String> tag, List<String> excludeTag, List<String> fileType, List<String> excludeFileType, List<String> fileProperty) throws ApiException {
        okhttp3.Call localVarCall = arraysBrowserPublicGetValidateBeforeCall(page, perPage, search, namespace, orderby, permissions, tag, excludeTag, fileType, excludeFileType, fileProperty, null);
        Type localVarReturnType = new TypeToken<ArrayBrowserData>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Fetch a list of all arrays that have been shared publically
     * @param page pagination offset (optional)
     * @param perPage pagination limit (optional)
     * @param search search string that will look at name, namespace or description fields (optional)
     * @param namespace namespace (optional)
     * @param orderby sort by which field valid values include last_accessed, size, name (optional)
     * @param permissions permissions valid values include read, read_write, write, admin (optional)
     * @param tag tag to search for, more than one can be included (optional)
     * @param excludeTag tags to exclude matching array in results, more than one can be included (optional)
     * @param fileType file_type to search for, more than one can be included (optional)
     * @param excludeFileType file_type to exclude matching array in results, more than one can be included (optional)
     * @param fileProperty file_property key-value pair (comma separated, i.e. key,value) to search for, more than one can be included (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Array of array info that has been shared publically </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call arraysBrowserPublicGetAsync(Integer page, Integer perPage, String search, String namespace, String orderby, String permissions, List<String> tag, List<String> excludeTag, List<String> fileType, List<String> excludeFileType, List<String> fileProperty, final ApiCallback<ArrayBrowserData> _callback) throws ApiException {

        okhttp3.Call localVarCall = arraysBrowserPublicGetValidateBeforeCall(page, perPage, search, namespace, orderby, permissions, tag, excludeTag, fileType, excludeFileType, fileProperty, _callback);
        Type localVarReturnType = new TypeToken<ArrayBrowserData>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for arraysBrowserPublicSidebarGet
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Array of array info that has been shared publically </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call arraysBrowserPublicSidebarGetCall(final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/arrays/browser/public/sidebar";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call arraysBrowserPublicSidebarGetValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = arraysBrowserPublicSidebarGetCall(_callback);
        return localVarCall;

    }

    /**
     * 
     * Fetch a sidebar of all arrays that have been shared publically
     * @return ArrayBrowserSidebar
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Array of array info that has been shared publically </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ArrayBrowserSidebar arraysBrowserPublicSidebarGet() throws ApiException {
        ApiResponse<ArrayBrowserSidebar> localVarResp = arraysBrowserPublicSidebarGetWithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * 
     * Fetch a sidebar of all arrays that have been shared publically
     * @return ApiResponse&lt;ArrayBrowserSidebar&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Array of array info that has been shared publically </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ArrayBrowserSidebar> arraysBrowserPublicSidebarGetWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = arraysBrowserPublicSidebarGetValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<ArrayBrowserSidebar>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Fetch a sidebar of all arrays that have been shared publically
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Array of array info that has been shared publically </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call arraysBrowserPublicSidebarGetAsync(final ApiCallback<ArrayBrowserSidebar> _callback) throws ApiException {

        okhttp3.Call localVarCall = arraysBrowserPublicSidebarGetValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<ArrayBrowserSidebar>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for arraysBrowserSharedGet
     * @param page pagination offset (optional)
     * @param perPage pagination limit (optional)
     * @param search search string that will look at name, namespace or description fields (optional)
     * @param namespace namespace (optional)
     * @param orderby sort by which field valid values include last_accessed, size, name (optional)
     * @param permissions permissions valid values include read, read_write, write, admin (optional)
     * @param tag tag to search for, more than one can be included (optional)
     * @param excludeTag tags to exclude matching array in results, more than one can be included (optional)
     * @param fileType file_type to search for, more than one can be included (optional)
     * @param excludeFileType file_type to exclude matching array in results, more than one can be included (optional)
     * @param fileProperty file_property key-value pair (comma separated, i.e. key,value) to search for, more than one can be included (optional)
     * @param sharedTo namespaces to filter results of where there arrays were shared to (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Array of array info that has been shared with the user </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call arraysBrowserSharedGetCall(Integer page, Integer perPage, String search, String namespace, String orderby, String permissions, List<String> tag, List<String> excludeTag, List<String> fileType, List<String> excludeFileType, List<String> fileProperty, List<String> sharedTo, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/arrays/browser/shared";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (perPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("per_page", perPage));
        }

        if (search != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("search", search));
        }

        if (namespace != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("namespace", namespace));
        }

        if (orderby != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("orderby", orderby));
        }

        if (permissions != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("permissions", permissions));
        }

        if (tag != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "tag", tag));
        }

        if (excludeTag != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "exclude_tag", excludeTag));
        }

        if (fileType != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "file_type", fileType));
        }

        if (excludeFileType != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "exclude_file_type", excludeFileType));
        }

        if (fileProperty != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "file_property", fileProperty));
        }

        if (sharedTo != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "shared_to", sharedTo));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call arraysBrowserSharedGetValidateBeforeCall(Integer page, Integer perPage, String search, String namespace, String orderby, String permissions, List<String> tag, List<String> excludeTag, List<String> fileType, List<String> excludeFileType, List<String> fileProperty, List<String> sharedTo, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = arraysBrowserSharedGetCall(page, perPage, search, namespace, orderby, permissions, tag, excludeTag, fileType, excludeFileType, fileProperty, sharedTo, _callback);
        return localVarCall;

    }

    /**
     * 
     * Fetch a list of all arrays that have been shared with the user
     * @param page pagination offset (optional)
     * @param perPage pagination limit (optional)
     * @param search search string that will look at name, namespace or description fields (optional)
     * @param namespace namespace (optional)
     * @param orderby sort by which field valid values include last_accessed, size, name (optional)
     * @param permissions permissions valid values include read, read_write, write, admin (optional)
     * @param tag tag to search for, more than one can be included (optional)
     * @param excludeTag tags to exclude matching array in results, more than one can be included (optional)
     * @param fileType file_type to search for, more than one can be included (optional)
     * @param excludeFileType file_type to exclude matching array in results, more than one can be included (optional)
     * @param fileProperty file_property key-value pair (comma separated, i.e. key,value) to search for, more than one can be included (optional)
     * @param sharedTo namespaces to filter results of where there arrays were shared to (optional)
     * @return ArrayBrowserData
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Array of array info that has been shared with the user </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ArrayBrowserData arraysBrowserSharedGet(Integer page, Integer perPage, String search, String namespace, String orderby, String permissions, List<String> tag, List<String> excludeTag, List<String> fileType, List<String> excludeFileType, List<String> fileProperty, List<String> sharedTo) throws ApiException {
        ApiResponse<ArrayBrowserData> localVarResp = arraysBrowserSharedGetWithHttpInfo(page, perPage, search, namespace, orderby, permissions, tag, excludeTag, fileType, excludeFileType, fileProperty, sharedTo);
        return localVarResp.getData();
    }

    /**
     * 
     * Fetch a list of all arrays that have been shared with the user
     * @param page pagination offset (optional)
     * @param perPage pagination limit (optional)
     * @param search search string that will look at name, namespace or description fields (optional)
     * @param namespace namespace (optional)
     * @param orderby sort by which field valid values include last_accessed, size, name (optional)
     * @param permissions permissions valid values include read, read_write, write, admin (optional)
     * @param tag tag to search for, more than one can be included (optional)
     * @param excludeTag tags to exclude matching array in results, more than one can be included (optional)
     * @param fileType file_type to search for, more than one can be included (optional)
     * @param excludeFileType file_type to exclude matching array in results, more than one can be included (optional)
     * @param fileProperty file_property key-value pair (comma separated, i.e. key,value) to search for, more than one can be included (optional)
     * @param sharedTo namespaces to filter results of where there arrays were shared to (optional)
     * @return ApiResponse&lt;ArrayBrowserData&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Array of array info that has been shared with the user </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ArrayBrowserData> arraysBrowserSharedGetWithHttpInfo(Integer page, Integer perPage, String search, String namespace, String orderby, String permissions, List<String> tag, List<String> excludeTag, List<String> fileType, List<String> excludeFileType, List<String> fileProperty, List<String> sharedTo) throws ApiException {
        okhttp3.Call localVarCall = arraysBrowserSharedGetValidateBeforeCall(page, perPage, search, namespace, orderby, permissions, tag, excludeTag, fileType, excludeFileType, fileProperty, sharedTo, null);
        Type localVarReturnType = new TypeToken<ArrayBrowserData>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Fetch a list of all arrays that have been shared with the user
     * @param page pagination offset (optional)
     * @param perPage pagination limit (optional)
     * @param search search string that will look at name, namespace or description fields (optional)
     * @param namespace namespace (optional)
     * @param orderby sort by which field valid values include last_accessed, size, name (optional)
     * @param permissions permissions valid values include read, read_write, write, admin (optional)
     * @param tag tag to search for, more than one can be included (optional)
     * @param excludeTag tags to exclude matching array in results, more than one can be included (optional)
     * @param fileType file_type to search for, more than one can be included (optional)
     * @param excludeFileType file_type to exclude matching array in results, more than one can be included (optional)
     * @param fileProperty file_property key-value pair (comma separated, i.e. key,value) to search for, more than one can be included (optional)
     * @param sharedTo namespaces to filter results of where there arrays were shared to (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Array of array info that has been shared with the user </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call arraysBrowserSharedGetAsync(Integer page, Integer perPage, String search, String namespace, String orderby, String permissions, List<String> tag, List<String> excludeTag, List<String> fileType, List<String> excludeFileType, List<String> fileProperty, List<String> sharedTo, final ApiCallback<ArrayBrowserData> _callback) throws ApiException {

        okhttp3.Call localVarCall = arraysBrowserSharedGetValidateBeforeCall(page, perPage, search, namespace, orderby, permissions, tag, excludeTag, fileType, excludeFileType, fileProperty, sharedTo, _callback);
        Type localVarReturnType = new TypeToken<ArrayBrowserData>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for arraysBrowserSharedSidebarGet
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Array of array info that has been shared with the user </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call arraysBrowserSharedSidebarGetCall(final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/arrays/browser/shared/sidebar";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call arraysBrowserSharedSidebarGetValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = arraysBrowserSharedSidebarGetCall(_callback);
        return localVarCall;

    }

    /**
     * 
     * Fetch a list of all arrays that have been shared with the user
     * @return ArrayBrowserSidebar
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Array of array info that has been shared with the user </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ArrayBrowserSidebar arraysBrowserSharedSidebarGet() throws ApiException {
        ApiResponse<ArrayBrowserSidebar> localVarResp = arraysBrowserSharedSidebarGetWithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * 
     * Fetch a list of all arrays that have been shared with the user
     * @return ApiResponse&lt;ArrayBrowserSidebar&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Array of array info that has been shared with the user </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ArrayBrowserSidebar> arraysBrowserSharedSidebarGetWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = arraysBrowserSharedSidebarGetValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<ArrayBrowserSidebar>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Fetch a list of all arrays that have been shared with the user
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Array of array info that has been shared with the user </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call arraysBrowserSharedSidebarGetAsync(final ApiCallback<ArrayBrowserSidebar> _callback) throws ApiException {

        okhttp3.Call localVarCall = arraysBrowserSharedSidebarGetValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<ArrayBrowserSidebar>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for arraysNamespaceArrayEndTimestampsGet
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param page pagination offset (optional)
     * @param perPage pagination limit (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> list of timestamps in milliseconds, paginated </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call arraysNamespaceArrayEndTimestampsGetCall(String namespace, String array, Integer page, Integer perPage, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/arrays/{namespace}/{array}/end_timestamps"
            .replaceAll("\\{" + "namespace" + "\\}", localVarApiClient.escapeString(namespace.toString()))
            .replaceAll("\\{" + "array" + "\\}", localVarApiClient.escapeString(array.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (perPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("per_page", perPage));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call arraysNamespaceArrayEndTimestampsGetValidateBeforeCall(String namespace, String array, Integer page, Integer perPage, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'namespace' is set
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling arraysNamespaceArrayEndTimestampsGet(Async)");
        }
        
        // verify the required parameter 'array' is set
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling arraysNamespaceArrayEndTimestampsGet(Async)");
        }
        

        okhttp3.Call localVarCall = arraysNamespaceArrayEndTimestampsGetCall(namespace, array, page, perPage, _callback);
        return localVarCall;

    }

    /**
     * 
     * retrieve a list of timestamps from the array fragment info listing in milliseconds, paginated
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param page pagination offset (optional)
     * @param perPage pagination limit (optional)
     * @return ArrayEndTimestampData
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> list of timestamps in milliseconds, paginated </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ArrayEndTimestampData arraysNamespaceArrayEndTimestampsGet(String namespace, String array, Integer page, Integer perPage) throws ApiException {
        ApiResponse<ArrayEndTimestampData> localVarResp = arraysNamespaceArrayEndTimestampsGetWithHttpInfo(namespace, array, page, perPage);
        return localVarResp.getData();
    }

    /**
     * 
     * retrieve a list of timestamps from the array fragment info listing in milliseconds, paginated
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param page pagination offset (optional)
     * @param perPage pagination limit (optional)
     * @return ApiResponse&lt;ArrayEndTimestampData&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> list of timestamps in milliseconds, paginated </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ArrayEndTimestampData> arraysNamespaceArrayEndTimestampsGetWithHttpInfo(String namespace, String array, Integer page, Integer perPage) throws ApiException {
        okhttp3.Call localVarCall = arraysNamespaceArrayEndTimestampsGetValidateBeforeCall(namespace, array, page, perPage, null);
        Type localVarReturnType = new TypeToken<ArrayEndTimestampData>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * retrieve a list of timestamps from the array fragment info listing in milliseconds, paginated
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param page pagination offset (optional)
     * @param perPage pagination limit (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> list of timestamps in milliseconds, paginated </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call arraysNamespaceArrayEndTimestampsGetAsync(String namespace, String array, Integer page, Integer perPage, final ApiCallback<ArrayEndTimestampData> _callback) throws ApiException {

        okhttp3.Call localVarCall = arraysNamespaceArrayEndTimestampsGetValidateBeforeCall(namespace, array, page, perPage, _callback);
        Type localVarReturnType = new TypeToken<ArrayEndTimestampData>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for consolidateArray
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param tiledbConfig tiledb configuration (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> array consolidated successfully </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call consolidateArrayCall(String namespace, String array, TileDBConfig tiledbConfig, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = tiledbConfig;

        // create path and map variables
        String localVarPath = "/arrays/{namespace}/{array}/consolidate"
            .replaceAll("\\{" + "namespace" + "\\}", localVarApiClient.escapeString(namespace.toString()))
            .replaceAll("\\{" + "array" + "\\}", localVarApiClient.escapeString(array.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call consolidateArrayValidateBeforeCall(String namespace, String array, TileDBConfig tiledbConfig, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'namespace' is set
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling consolidateArray(Async)");
        }
        
        // verify the required parameter 'array' is set
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling consolidateArray(Async)");
        }
        
        // verify the required parameter 'tiledbConfig' is set
        if (tiledbConfig == null) {
            throw new ApiException("Missing the required parameter 'tiledbConfig' when calling consolidateArray(Async)");
        }
        

        okhttp3.Call localVarCall = consolidateArrayCall(namespace, array, tiledbConfig, _callback);
        return localVarCall;

    }

    /**
     * 
     * consolidate an array at a specified URI
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param tiledbConfig tiledb configuration (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> array consolidated successfully </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public void consolidateArray(String namespace, String array, TileDBConfig tiledbConfig) throws ApiException {
        consolidateArrayWithHttpInfo(namespace, array, tiledbConfig);
    }

    /**
     * 
     * consolidate an array at a specified URI
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param tiledbConfig tiledb configuration (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> array consolidated successfully </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> consolidateArrayWithHttpInfo(String namespace, String array, TileDBConfig tiledbConfig) throws ApiException {
        okhttp3.Call localVarCall = consolidateArrayValidateBeforeCall(namespace, array, tiledbConfig, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     *  (asynchronously)
     * consolidate an array at a specified URI
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param tiledbConfig tiledb configuration (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> array consolidated successfully </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call consolidateArrayAsync(String namespace, String array, TileDBConfig tiledbConfig, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = consolidateArrayValidateBeforeCall(namespace, array, tiledbConfig, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for createArray
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param contentType Content Type of input and return mime (required)
     * @param arraySchema ArraySchema being created (required)
     * @param X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME Optional registered access credentials to use for creation (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> schema created successfully </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createArrayCall(String namespace, String array, String contentType, ArraySchema arraySchema, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = arraySchema;

        // create path and map variables
        String localVarPath = "/arrays/{namespace}/{array}"
            .replaceAll("\\{" + "namespace" + "\\}", localVarApiClient.escapeString(namespace.toString()))
            .replaceAll("\\{" + "array" + "\\}", localVarApiClient.escapeString(array.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (contentType != null) {
            localVarHeaderParams.put("Content-Type", localVarApiClient.parameterToString(contentType));
        }

        if (X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME != null) {
            localVarHeaderParams.put("X-TILEDB-CLOUD-ACCESS-CREDENTIALS-NAME", localVarApiClient.parameterToString(X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createArrayValidateBeforeCall(String namespace, String array, String contentType, ArraySchema arraySchema, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'namespace' is set
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling createArray(Async)");
        }
        
        // verify the required parameter 'array' is set
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling createArray(Async)");
        }
        
        // verify the required parameter 'contentType' is set
        if (contentType == null) {
            throw new ApiException("Missing the required parameter 'contentType' when calling createArray(Async)");
        }
        
        // verify the required parameter 'arraySchema' is set
        if (arraySchema == null) {
            throw new ApiException("Missing the required parameter 'arraySchema' when calling createArray(Async)");
        }
        

        okhttp3.Call localVarCall = createArrayCall(namespace, array, contentType, arraySchema, X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, _callback);
        return localVarCall;

    }

    /**
     * 
     * create a array schema at a specified URI registered to a group/project
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param contentType Content Type of input and return mime (required)
     * @param arraySchema ArraySchema being created (required)
     * @param X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME Optional registered access credentials to use for creation (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> schema created successfully </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public void createArray(String namespace, String array, String contentType, ArraySchema arraySchema, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME) throws ApiException {
        createArrayWithHttpInfo(namespace, array, contentType, arraySchema, X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME);
    }

    /**
     * 
     * create a array schema at a specified URI registered to a group/project
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param contentType Content Type of input and return mime (required)
     * @param arraySchema ArraySchema being created (required)
     * @param X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME Optional registered access credentials to use for creation (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> schema created successfully </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> createArrayWithHttpInfo(String namespace, String array, String contentType, ArraySchema arraySchema, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME) throws ApiException {
        okhttp3.Call localVarCall = createArrayValidateBeforeCall(namespace, array, contentType, arraySchema, X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     *  (asynchronously)
     * create a array schema at a specified URI registered to a group/project
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param contentType Content Type of input and return mime (required)
     * @param arraySchema ArraySchema being created (required)
     * @param X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME Optional registered access credentials to use for creation (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> schema created successfully </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createArrayAsync(String namespace, String array, String contentType, ArraySchema arraySchema, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = createArrayValidateBeforeCall(namespace, array, contentType, arraySchema, X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteArray
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param contentType Content Type of input and return mime (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> delete array successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteArrayCall(String namespace, String array, String contentType, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/arrays/{namespace}/{array}"
            .replaceAll("\\{" + "namespace" + "\\}", localVarApiClient.escapeString(namespace.toString()))
            .replaceAll("\\{" + "array" + "\\}", localVarApiClient.escapeString(array.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (contentType != null) {
            localVarHeaderParams.put("Content-Type", localVarApiClient.parameterToString(contentType));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteArrayValidateBeforeCall(String namespace, String array, String contentType, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'namespace' is set
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling deleteArray(Async)");
        }
        
        // verify the required parameter 'array' is set
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling deleteArray(Async)");
        }
        
        // verify the required parameter 'contentType' is set
        if (contentType == null) {
            throw new ApiException("Missing the required parameter 'contentType' when calling deleteArray(Async)");
        }
        

        okhttp3.Call localVarCall = deleteArrayCall(namespace, array, contentType, _callback);
        return localVarCall;

    }

    /**
     * 
     * delete a array
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param contentType Content Type of input and return mime (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> delete array successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public void deleteArray(String namespace, String array, String contentType) throws ApiException {
        deleteArrayWithHttpInfo(namespace, array, contentType);
    }

    /**
     * 
     * delete a array
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param contentType Content Type of input and return mime (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> delete array successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deleteArrayWithHttpInfo(String namespace, String array, String contentType) throws ApiException {
        okhttp3.Call localVarCall = deleteArrayValidateBeforeCall(namespace, array, contentType, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     *  (asynchronously)
     * delete a array
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param contentType Content Type of input and return mime (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> delete array successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteArrayAsync(String namespace, String array, String contentType, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteArrayValidateBeforeCall(namespace, array, contentType, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for deregisterArray
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> deregistered array successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deregisterArrayCall(String namespace, String array, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/arrays/{namespace}/{array}/deregister"
            .replaceAll("\\{" + "namespace" + "\\}", localVarApiClient.escapeString(namespace.toString()))
            .replaceAll("\\{" + "array" + "\\}", localVarApiClient.escapeString(array.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deregisterArrayValidateBeforeCall(String namespace, String array, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'namespace' is set
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling deregisterArray(Async)");
        }
        
        // verify the required parameter 'array' is set
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling deregisterArray(Async)");
        }
        

        okhttp3.Call localVarCall = deregisterArrayCall(namespace, array, _callback);
        return localVarCall;

    }

    /**
     * 
     * deregister a array
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> deregistered array successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public void deregisterArray(String namespace, String array) throws ApiException {
        deregisterArrayWithHttpInfo(namespace, array);
    }

    /**
     * 
     * deregister a array
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> deregistered array successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deregisterArrayWithHttpInfo(String namespace, String array) throws ApiException {
        okhttp3.Call localVarCall = deregisterArrayValidateBeforeCall(namespace, array, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     *  (asynchronously)
     * deregister a array
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> deregistered array successful </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deregisterArrayAsync(String namespace, String array, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deregisterArrayValidateBeforeCall(namespace, array, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for getActivityLogById
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param id ID of the activity (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> array activity </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getActivityLogByIdCall(String namespace, String array, String id, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/arrays/{namespace}/{array}/activity/{id}"
            .replaceAll("\\{" + "namespace" + "\\}", localVarApiClient.escapeString(namespace.toString()))
            .replaceAll("\\{" + "array" + "\\}", localVarApiClient.escapeString(array.toString()))
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getActivityLogByIdValidateBeforeCall(String namespace, String array, String id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'namespace' is set
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling getActivityLogById(Async)");
        }
        
        // verify the required parameter 'array' is set
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling getActivityLogById(Async)");
        }
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getActivityLogById(Async)");
        }
        

        okhttp3.Call localVarCall = getActivityLogByIdCall(namespace, array, id, _callback);
        return localVarCall;

    }

    /**
     * 
     * get activity log by ID
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param id ID of the activity (required)
     * @return ArrayActivityLog
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> array activity </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ArrayActivityLog getActivityLogById(String namespace, String array, String id) throws ApiException {
        ApiResponse<ArrayActivityLog> localVarResp = getActivityLogByIdWithHttpInfo(namespace, array, id);
        return localVarResp.getData();
    }

    /**
     * 
     * get activity log by ID
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param id ID of the activity (required)
     * @return ApiResponse&lt;ArrayActivityLog&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> array activity </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ArrayActivityLog> getActivityLogByIdWithHttpInfo(String namespace, String array, String id) throws ApiException {
        okhttp3.Call localVarCall = getActivityLogByIdValidateBeforeCall(namespace, array, id, null);
        Type localVarReturnType = new TypeToken<ArrayActivityLog>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * get activity log by ID
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param id ID of the activity (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> array activity </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getActivityLogByIdAsync(String namespace, String array, String id, final ApiCallback<ArrayActivityLog> _callback) throws ApiException {

        okhttp3.Call localVarCall = getActivityLogByIdValidateBeforeCall(namespace, array, id, _callback);
        Type localVarReturnType = new TypeToken<ArrayActivityLog>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getAllArrayMetadata
     * @param publicShare Public share values can be one of exclude, only (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> array metadata for all arrays user has access to </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAllArrayMetadataCall(String publicShare, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/arrays";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (publicShare != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("public_share", publicShare));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getAllArrayMetadataValidateBeforeCall(String publicShare, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getAllArrayMetadataCall(publicShare, _callback);
        return localVarCall;

    }

    /**
     * 
     * get all array metadata user has access to
     * @param publicShare Public share values can be one of exclude, only (optional)
     * @return List&lt;ArrayInfo&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> array metadata for all arrays user has access to </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public List<ArrayInfo> getAllArrayMetadata(String publicShare) throws ApiException {
        ApiResponse<List<ArrayInfo>> localVarResp = getAllArrayMetadataWithHttpInfo(publicShare);
        return localVarResp.getData();
    }

    /**
     * 
     * get all array metadata user has access to
     * @param publicShare Public share values can be one of exclude, only (optional)
     * @return ApiResponse&lt;List&lt;ArrayInfo&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> array metadata for all arrays user has access to </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<ArrayInfo>> getAllArrayMetadataWithHttpInfo(String publicShare) throws ApiException {
        okhttp3.Call localVarCall = getAllArrayMetadataValidateBeforeCall(publicShare, null);
        Type localVarReturnType = new TypeToken<List<ArrayInfo>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * get all array metadata user has access to
     * @param publicShare Public share values can be one of exclude, only (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> array metadata for all arrays user has access to </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAllArrayMetadataAsync(String publicShare, final ApiCallback<List<ArrayInfo>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getAllArrayMetadataValidateBeforeCall(publicShare, _callback);
        Type localVarReturnType = new TypeToken<List<ArrayInfo>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getArray
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param contentType Content Type of input and return mime (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> get ArraySchema </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getArrayCall(String namespace, String array, String contentType, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/arrays/{namespace}/{array}"
            .replaceAll("\\{" + "namespace" + "\\}", localVarApiClient.escapeString(namespace.toString()))
            .replaceAll("\\{" + "array" + "\\}", localVarApiClient.escapeString(array.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (contentType != null) {
            localVarHeaderParams.put("Content-Type", localVarApiClient.parameterToString(contentType));
        }

        final String[] localVarAccepts = {
            "application/json", "application/capnp"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getArrayValidateBeforeCall(String namespace, String array, String contentType, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'namespace' is set
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling getArray(Async)");
        }
        
        // verify the required parameter 'array' is set
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling getArray(Async)");
        }
        
        // verify the required parameter 'contentType' is set
        if (contentType == null) {
            throw new ApiException("Missing the required parameter 'contentType' when calling getArray(Async)");
        }
        

        okhttp3.Call localVarCall = getArrayCall(namespace, array, contentType, _callback);
        return localVarCall;

    }

    /**
     * 
     * get an ArraySchema using a url encoded uri
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param contentType Content Type of input and return mime (required)
     * @return ArraySchema
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> get ArraySchema </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ArraySchema getArray(String namespace, String array, String contentType) throws ApiException {
        ApiResponse<ArraySchema> localVarResp = getArrayWithHttpInfo(namespace, array, contentType);
        return localVarResp.getData();
    }

    /**
     * 
     * get an ArraySchema using a url encoded uri
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param contentType Content Type of input and return mime (required)
     * @return ApiResponse&lt;ArraySchema&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> get ArraySchema </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ArraySchema> getArrayWithHttpInfo(String namespace, String array, String contentType) throws ApiException {
        okhttp3.Call localVarCall = getArrayValidateBeforeCall(namespace, array, contentType, null);
        Type localVarReturnType = new TypeToken<ArraySchema>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * get an ArraySchema using a url encoded uri
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param contentType Content Type of input and return mime (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> get ArraySchema </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getArrayAsync(String namespace, String array, String contentType, final ApiCallback<ArraySchema> _callback) throws ApiException {

        okhttp3.Call localVarCall = getArrayValidateBeforeCall(namespace, array, contentType, _callback);
        Type localVarReturnType = new TypeToken<ArraySchema>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getArrayMaxBufferSizes
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param subarray CSV string of subarray to get max buffer sizes for (required)
     * @param contentType Content Type of input and return mime (required)
     * @param xPayer Name of organization or user who should be charged for this request (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> get the max buffer sizes of an array for a subarray </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getArrayMaxBufferSizesCall(String namespace, String array, String subarray, String contentType, String xPayer, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/arrays/{namespace}/{array}/max_buffer_sizes"
            .replaceAll("\\{" + "namespace" + "\\}", localVarApiClient.escapeString(namespace.toString()))
            .replaceAll("\\{" + "array" + "\\}", localVarApiClient.escapeString(array.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (subarray != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("subarray", subarray));
        }

        if (contentType != null) {
            localVarHeaderParams.put("Content-Type", localVarApiClient.parameterToString(contentType));
        }

        if (xPayer != null) {
            localVarHeaderParams.put("X-Payer", localVarApiClient.parameterToString(xPayer));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getArrayMaxBufferSizesValidateBeforeCall(String namespace, String array, String subarray, String contentType, String xPayer, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'namespace' is set
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling getArrayMaxBufferSizes(Async)");
        }
        
        // verify the required parameter 'array' is set
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling getArrayMaxBufferSizes(Async)");
        }
        
        // verify the required parameter 'subarray' is set
        if (subarray == null) {
            throw new ApiException("Missing the required parameter 'subarray' when calling getArrayMaxBufferSizes(Async)");
        }
        
        // verify the required parameter 'contentType' is set
        if (contentType == null) {
            throw new ApiException("Missing the required parameter 'contentType' when calling getArrayMaxBufferSizes(Async)");
        }
        

        okhttp3.Call localVarCall = getArrayMaxBufferSizesCall(namespace, array, subarray, contentType, xPayer, _callback);
        return localVarCall;

    }

    /**
     * 
     * get the max buffer sizes of an array for a subarray
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param subarray CSV string of subarray to get max buffer sizes for (required)
     * @param contentType Content Type of input and return mime (required)
     * @param xPayer Name of organization or user who should be charged for this request (optional)
     * @return MaxBufferSizes
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> get the max buffer sizes of an array for a subarray </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public MaxBufferSizes getArrayMaxBufferSizes(String namespace, String array, String subarray, String contentType, String xPayer) throws ApiException {
        ApiResponse<MaxBufferSizes> localVarResp = getArrayMaxBufferSizesWithHttpInfo(namespace, array, subarray, contentType, xPayer);
        return localVarResp.getData();
    }

    /**
     * 
     * get the max buffer sizes of an array for a subarray
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param subarray CSV string of subarray to get max buffer sizes for (required)
     * @param contentType Content Type of input and return mime (required)
     * @param xPayer Name of organization or user who should be charged for this request (optional)
     * @return ApiResponse&lt;MaxBufferSizes&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> get the max buffer sizes of an array for a subarray </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<MaxBufferSizes> getArrayMaxBufferSizesWithHttpInfo(String namespace, String array, String subarray, String contentType, String xPayer) throws ApiException {
        okhttp3.Call localVarCall = getArrayMaxBufferSizesValidateBeforeCall(namespace, array, subarray, contentType, xPayer, null);
        Type localVarReturnType = new TypeToken<MaxBufferSizes>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * get the max buffer sizes of an array for a subarray
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param subarray CSV string of subarray to get max buffer sizes for (required)
     * @param contentType Content Type of input and return mime (required)
     * @param xPayer Name of organization or user who should be charged for this request (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> get the max buffer sizes of an array for a subarray </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getArrayMaxBufferSizesAsync(String namespace, String array, String subarray, String contentType, String xPayer, final ApiCallback<MaxBufferSizes> _callback) throws ApiException {

        okhttp3.Call localVarCall = getArrayMaxBufferSizesValidateBeforeCall(namespace, array, subarray, contentType, xPayer, _callback);
        Type localVarReturnType = new TypeToken<MaxBufferSizes>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getArrayMetaDataJson
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param length (optional) limit character length of returned values (optional)
     * @param endTimestamp Milliseconds since Unix epoch, metadata will use open_at functionality to open array at the specific timestamp (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> get array metadata </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getArrayMetaDataJsonCall(String namespace, String array, Integer length, Integer endTimestamp, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/arrays/{namespace}/{array}/metadata_json"
            .replaceAll("\\{" + "namespace" + "\\}", localVarApiClient.escapeString(namespace.toString()))
            .replaceAll("\\{" + "array" + "\\}", localVarApiClient.escapeString(array.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (length != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("length", length));
        }

        if (endTimestamp != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("end_timestamp", endTimestamp));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getArrayMetaDataJsonValidateBeforeCall(String namespace, String array, Integer length, Integer endTimestamp, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'namespace' is set
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling getArrayMetaDataJson(Async)");
        }
        
        // verify the required parameter 'array' is set
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling getArrayMetaDataJson(Async)");
        }
        

        okhttp3.Call localVarCall = getArrayMetaDataJsonCall(namespace, array, length, endTimestamp, _callback);
        return localVarCall;

    }

    /**
     * 
     * get metadata from the array in JSON format
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param length (optional) limit character length of returned values (optional)
     * @param endTimestamp Milliseconds since Unix epoch, metadata will use open_at functionality to open array at the specific timestamp (optional)
     * @return Object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> get array metadata </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public Object getArrayMetaDataJson(String namespace, String array, Integer length, Integer endTimestamp) throws ApiException {
        ApiResponse<Object> localVarResp = getArrayMetaDataJsonWithHttpInfo(namespace, array, length, endTimestamp);
        return localVarResp.getData();
    }

    /**
     * 
     * get metadata from the array in JSON format
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param length (optional) limit character length of returned values (optional)
     * @param endTimestamp Milliseconds since Unix epoch, metadata will use open_at functionality to open array at the specific timestamp (optional)
     * @return ApiResponse&lt;Object&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> get array metadata </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Object> getArrayMetaDataJsonWithHttpInfo(String namespace, String array, Integer length, Integer endTimestamp) throws ApiException {
        okhttp3.Call localVarCall = getArrayMetaDataJsonValidateBeforeCall(namespace, array, length, endTimestamp, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * get metadata from the array in JSON format
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param length (optional) limit character length of returned values (optional)
     * @param endTimestamp Milliseconds since Unix epoch, metadata will use open_at functionality to open array at the specific timestamp (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> get array metadata </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getArrayMetaDataJsonAsync(String namespace, String array, Integer length, Integer endTimestamp, final ApiCallback<Object> _callback) throws ApiException {

        okhttp3.Call localVarCall = getArrayMetaDataJsonValidateBeforeCall(namespace, array, length, endTimestamp, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getArrayMetadata
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> array metadata for an array </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getArrayMetadataCall(String namespace, String array, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/arrays/{namespace}/{array}/metadata"
            .replaceAll("\\{" + "namespace" + "\\}", localVarApiClient.escapeString(namespace.toString()))
            .replaceAll("\\{" + "array" + "\\}", localVarApiClient.escapeString(array.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getArrayMetadataValidateBeforeCall(String namespace, String array, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'namespace' is set
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling getArrayMetadata(Async)");
        }
        
        // verify the required parameter 'array' is set
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling getArrayMetadata(Async)");
        }
        

        okhttp3.Call localVarCall = getArrayMetadataCall(namespace, array, _callback);
        return localVarCall;

    }

    /**
     * 
     * get metadata on an array
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @return ArrayInfo
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> array metadata for an array </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ArrayInfo getArrayMetadata(String namespace, String array) throws ApiException {
        ApiResponse<ArrayInfo> localVarResp = getArrayMetadataWithHttpInfo(namespace, array);
        return localVarResp.getData();
    }

    /**
     * 
     * get metadata on an array
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @return ApiResponse&lt;ArrayInfo&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> array metadata for an array </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ArrayInfo> getArrayMetadataWithHttpInfo(String namespace, String array) throws ApiException {
        okhttp3.Call localVarCall = getArrayMetadataValidateBeforeCall(namespace, array, null);
        Type localVarReturnType = new TypeToken<ArrayInfo>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * get metadata on an array
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> array metadata for an array </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getArrayMetadataAsync(String namespace, String array, final ApiCallback<ArrayInfo> _callback) throws ApiException {

        okhttp3.Call localVarCall = getArrayMetadataValidateBeforeCall(namespace, array, _callback);
        Type localVarReturnType = new TypeToken<ArrayInfo>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getArrayMetadataCapnp
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> array metadata for an array </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getArrayMetadataCapnpCall(String namespace, String array, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/arrays/{namespace}/{array}/array_metadata"
            .replaceAll("\\{" + "namespace" + "\\}", localVarApiClient.escapeString(namespace.toString()))
            .replaceAll("\\{" + "array" + "\\}", localVarApiClient.escapeString(array.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "application/capnp"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getArrayMetadataCapnpValidateBeforeCall(String namespace, String array, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'namespace' is set
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling getArrayMetadataCapnp(Async)");
        }
        
        // verify the required parameter 'array' is set
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling getArrayMetadataCapnp(Async)");
        }
        

        okhttp3.Call localVarCall = getArrayMetadataCapnpCall(namespace, array, _callback);
        return localVarCall;

    }

    /**
     * 
     * get metadata on an array
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @return ArrayMetadata
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> array metadata for an array </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ArrayMetadata getArrayMetadataCapnp(String namespace, String array) throws ApiException {
        ApiResponse<ArrayMetadata> localVarResp = getArrayMetadataCapnpWithHttpInfo(namespace, array);
        return localVarResp.getData();
    }

    /**
     * 
     * get metadata on an array
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @return ApiResponse&lt;ArrayMetadata&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> array metadata for an array </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ArrayMetadata> getArrayMetadataCapnpWithHttpInfo(String namespace, String array) throws ApiException {
        okhttp3.Call localVarCall = getArrayMetadataCapnpValidateBeforeCall(namespace, array, null);
        Type localVarReturnType = new TypeToken<ArrayMetadata>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * get metadata on an array
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> array metadata for an array </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getArrayMetadataCapnpAsync(String namespace, String array, final ApiCallback<ArrayMetadata> _callback) throws ApiException {

        okhttp3.Call localVarCall = getArrayMetadataCapnpValidateBeforeCall(namespace, array, _callback);
        Type localVarReturnType = new TypeToken<ArrayMetadata>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getArrayNonEmptyDomain
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param contentType Content Type of input and return mime (required)
     * @param xPayer Name of organization or user who should be charged for this request (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> get the non empty domain of an array </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getArrayNonEmptyDomainCall(String namespace, String array, String contentType, String xPayer, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/arrays/{namespace}/{array}/non_empty_domain"
            .replaceAll("\\{" + "namespace" + "\\}", localVarApiClient.escapeString(namespace.toString()))
            .replaceAll("\\{" + "array" + "\\}", localVarApiClient.escapeString(array.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (contentType != null) {
            localVarHeaderParams.put("Content-Type", localVarApiClient.parameterToString(contentType));
        }

        if (xPayer != null) {
            localVarHeaderParams.put("X-Payer", localVarApiClient.parameterToString(xPayer));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getArrayNonEmptyDomainValidateBeforeCall(String namespace, String array, String contentType, String xPayer, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'namespace' is set
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling getArrayNonEmptyDomain(Async)");
        }
        
        // verify the required parameter 'array' is set
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling getArrayNonEmptyDomain(Async)");
        }
        
        // verify the required parameter 'contentType' is set
        if (contentType == null) {
            throw new ApiException("Missing the required parameter 'contentType' when calling getArrayNonEmptyDomain(Async)");
        }
        

        okhttp3.Call localVarCall = getArrayNonEmptyDomainCall(namespace, array, contentType, xPayer, _callback);
        return localVarCall;

    }

    /**
     * 
     * get the non empty domain of an array
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param contentType Content Type of input and return mime (required)
     * @param xPayer Name of organization or user who should be charged for this request (optional)
     * @return NonEmptyDomain
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> get the non empty domain of an array </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public NonEmptyDomain getArrayNonEmptyDomain(String namespace, String array, String contentType, String xPayer) throws ApiException {
        ApiResponse<NonEmptyDomain> localVarResp = getArrayNonEmptyDomainWithHttpInfo(namespace, array, contentType, xPayer);
        return localVarResp.getData();
    }

    /**
     * 
     * get the non empty domain of an array
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param contentType Content Type of input and return mime (required)
     * @param xPayer Name of organization or user who should be charged for this request (optional)
     * @return ApiResponse&lt;NonEmptyDomain&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> get the non empty domain of an array </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<NonEmptyDomain> getArrayNonEmptyDomainWithHttpInfo(String namespace, String array, String contentType, String xPayer) throws ApiException {
        okhttp3.Call localVarCall = getArrayNonEmptyDomainValidateBeforeCall(namespace, array, contentType, xPayer, null);
        Type localVarReturnType = new TypeToken<NonEmptyDomain>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * get the non empty domain of an array
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param contentType Content Type of input and return mime (required)
     * @param xPayer Name of organization or user who should be charged for this request (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> get the non empty domain of an array </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getArrayNonEmptyDomainAsync(String namespace, String array, String contentType, String xPayer, final ApiCallback<NonEmptyDomain> _callback) throws ApiException {

        okhttp3.Call localVarCall = getArrayNonEmptyDomainValidateBeforeCall(namespace, array, contentType, xPayer, _callback);
        Type localVarReturnType = new TypeToken<NonEmptyDomain>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getArrayNonEmptyDomainJson
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> get array non-empty domaim </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getArrayNonEmptyDomainJsonCall(String namespace, String array, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/arrays/{namespace}/{array}/non_empty_domain_json"
            .replaceAll("\\{" + "namespace" + "\\}", localVarApiClient.escapeString(namespace.toString()))
            .replaceAll("\\{" + "array" + "\\}", localVarApiClient.escapeString(array.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getArrayNonEmptyDomainJsonValidateBeforeCall(String namespace, String array, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'namespace' is set
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling getArrayNonEmptyDomainJson(Async)");
        }
        
        // verify the required parameter 'array' is set
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling getArrayNonEmptyDomainJson(Async)");
        }
        

        okhttp3.Call localVarCall = getArrayNonEmptyDomainJsonCall(namespace, array, _callback);
        return localVarCall;

    }

    /**
     * 
     * get non-empty domain from the array in json format
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @return Object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> get array non-empty domaim </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public Object getArrayNonEmptyDomainJson(String namespace, String array) throws ApiException {
        ApiResponse<Object> localVarResp = getArrayNonEmptyDomainJsonWithHttpInfo(namespace, array);
        return localVarResp.getData();
    }

    /**
     * 
     * get non-empty domain from the array in json format
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @return ApiResponse&lt;Object&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> get array non-empty domaim </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Object> getArrayNonEmptyDomainJsonWithHttpInfo(String namespace, String array) throws ApiException {
        okhttp3.Call localVarCall = getArrayNonEmptyDomainJsonValidateBeforeCall(namespace, array, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * get non-empty domain from the array in json format
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> get array non-empty domaim </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getArrayNonEmptyDomainJsonAsync(String namespace, String array, final ApiCallback<Object> _callback) throws ApiException {

        okhttp3.Call localVarCall = getArrayNonEmptyDomainJsonValidateBeforeCall(namespace, array, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getArraySampleData
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param samples Number of sample results to return (optional, default to 5.0)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> get array sample data </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getArraySampleDataCall(String namespace, String array, BigDecimal samples, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/arrays/{namespace}/{array}/sample"
            .replaceAll("\\{" + "namespace" + "\\}", localVarApiClient.escapeString(namespace.toString()))
            .replaceAll("\\{" + "array" + "\\}", localVarApiClient.escapeString(array.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (samples != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("samples", samples));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getArraySampleDataValidateBeforeCall(String namespace, String array, BigDecimal samples, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'namespace' is set
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling getArraySampleData(Async)");
        }
        
        // verify the required parameter 'array' is set
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling getArraySampleData(Async)");
        }
        

        okhttp3.Call localVarCall = getArraySampleDataCall(namespace, array, samples, _callback);
        return localVarCall;

    }

    /**
     * 
     * get an sample set of data from the array
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param samples Number of sample results to return (optional, default to 5.0)
     * @return ArraySample
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> get array sample data </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ArraySample getArraySampleData(String namespace, String array, BigDecimal samples) throws ApiException {
        ApiResponse<ArraySample> localVarResp = getArraySampleDataWithHttpInfo(namespace, array, samples);
        return localVarResp.getData();
    }

    /**
     * 
     * get an sample set of data from the array
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param samples Number of sample results to return (optional, default to 5.0)
     * @return ApiResponse&lt;ArraySample&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> get array sample data </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ArraySample> getArraySampleDataWithHttpInfo(String namespace, String array, BigDecimal samples) throws ApiException {
        okhttp3.Call localVarCall = getArraySampleDataValidateBeforeCall(namespace, array, samples, null);
        Type localVarReturnType = new TypeToken<ArraySample>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * get an sample set of data from the array
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param samples Number of sample results to return (optional, default to 5.0)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> get array sample data </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getArraySampleDataAsync(String namespace, String array, BigDecimal samples, final ApiCallback<ArraySample> _callback) throws ApiException {

        okhttp3.Call localVarCall = getArraySampleDataValidateBeforeCall(namespace, array, samples, _callback);
        Type localVarReturnType = new TypeToken<ArraySample>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getArraySharingPolicies
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List of all specific sharing policies </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Array does not exist or user does not have permissions to view array-sharing policies </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getArraySharingPoliciesCall(String namespace, String array, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/arrays/{namespace}/{array}/share"
            .replaceAll("\\{" + "namespace" + "\\}", localVarApiClient.escapeString(namespace.toString()))
            .replaceAll("\\{" + "array" + "\\}", localVarApiClient.escapeString(array.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getArraySharingPoliciesValidateBeforeCall(String namespace, String array, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'namespace' is set
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling getArraySharingPolicies(Async)");
        }
        
        // verify the required parameter 'array' is set
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling getArraySharingPolicies(Async)");
        }
        

        okhttp3.Call localVarCall = getArraySharingPoliciesCall(namespace, array, _callback);
        return localVarCall;

    }

    /**
     * 
     * Get all sharing details of the array
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @return List&lt;ArraySharing&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List of all specific sharing policies </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Array does not exist or user does not have permissions to view array-sharing policies </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public List<ArraySharing> getArraySharingPolicies(String namespace, String array) throws ApiException {
        ApiResponse<List<ArraySharing>> localVarResp = getArraySharingPoliciesWithHttpInfo(namespace, array);
        return localVarResp.getData();
    }

    /**
     * 
     * Get all sharing details of the array
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @return ApiResponse&lt;List&lt;ArraySharing&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List of all specific sharing policies </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Array does not exist or user does not have permissions to view array-sharing policies </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<ArraySharing>> getArraySharingPoliciesWithHttpInfo(String namespace, String array) throws ApiException {
        okhttp3.Call localVarCall = getArraySharingPoliciesValidateBeforeCall(namespace, array, null);
        Type localVarReturnType = new TypeToken<List<ArraySharing>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Get all sharing details of the array
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List of all specific sharing policies </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Array does not exist or user does not have permissions to view array-sharing policies </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getArraySharingPoliciesAsync(String namespace, String array, final ApiCallback<List<ArraySharing>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getArraySharingPoliciesValidateBeforeCall(namespace, array, _callback);
        Type localVarReturnType = new TypeToken<List<ArraySharing>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getArraysInNamespace
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> array metadata for all arrays in a namespace </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getArraysInNamespaceCall(String namespace, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/arrays/{namespace}"
            .replaceAll("\\{" + "namespace" + "\\}", localVarApiClient.escapeString(namespace.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getArraysInNamespaceValidateBeforeCall(String namespace, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'namespace' is set
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling getArraysInNamespace(Async)");
        }
        

        okhttp3.Call localVarCall = getArraysInNamespaceCall(namespace, _callback);
        return localVarCall;

    }

    /**
     * 
     * get metadata on all arrays in a namespace
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @return List&lt;ArrayInfo&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> array metadata for all arrays in a namespace </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public List<ArrayInfo> getArraysInNamespace(String namespace) throws ApiException {
        ApiResponse<List<ArrayInfo>> localVarResp = getArraysInNamespaceWithHttpInfo(namespace);
        return localVarResp.getData();
    }

    /**
     * 
     * get metadata on all arrays in a namespace
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @return ApiResponse&lt;List&lt;ArrayInfo&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> array metadata for all arrays in a namespace </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<ArrayInfo>> getArraysInNamespaceWithHttpInfo(String namespace) throws ApiException {
        okhttp3.Call localVarCall = getArraysInNamespaceValidateBeforeCall(namespace, null);
        Type localVarReturnType = new TypeToken<List<ArrayInfo>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * get metadata on all arrays in a namespace
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> array metadata for all arrays in a namespace </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getArraysInNamespaceAsync(String namespace, final ApiCallback<List<ArrayInfo>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getArraysInNamespaceValidateBeforeCall(namespace, _callback);
        Type localVarReturnType = new TypeToken<List<ArrayInfo>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getFragmentEndTimestamp
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param endTimestamp Milliseconds since Unix epoch (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> fragment end_timestamp on an array </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getFragmentEndTimestampCall(String namespace, String array, Integer endTimestamp, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/arrays/{namespace}/{array}/fragment_end_timestamp"
            .replaceAll("\\{" + "namespace" + "\\}", localVarApiClient.escapeString(namespace.toString()))
            .replaceAll("\\{" + "array" + "\\}", localVarApiClient.escapeString(array.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (endTimestamp != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("end_timestamp", endTimestamp));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getFragmentEndTimestampValidateBeforeCall(String namespace, String array, Integer endTimestamp, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'namespace' is set
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling getFragmentEndTimestamp(Async)");
        }
        
        // verify the required parameter 'array' is set
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling getFragmentEndTimestamp(Async)");
        }
        

        okhttp3.Call localVarCall = getFragmentEndTimestampCall(namespace, array, endTimestamp, _callback);
        return localVarCall;

    }

    /**
     * 
     * Get fragment end_timestamp on an array, will search for the closest end_timestamp to the timestamp asked
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param endTimestamp Milliseconds since Unix epoch (optional)
     * @return Integer
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> fragment end_timestamp on an array </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public Integer getFragmentEndTimestamp(String namespace, String array, Integer endTimestamp) throws ApiException {
        ApiResponse<Integer> localVarResp = getFragmentEndTimestampWithHttpInfo(namespace, array, endTimestamp);
        return localVarResp.getData();
    }

    /**
     * 
     * Get fragment end_timestamp on an array, will search for the closest end_timestamp to the timestamp asked
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param endTimestamp Milliseconds since Unix epoch (optional)
     * @return ApiResponse&lt;Integer&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> fragment end_timestamp on an array </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Integer> getFragmentEndTimestampWithHttpInfo(String namespace, String array, Integer endTimestamp) throws ApiException {
        okhttp3.Call localVarCall = getFragmentEndTimestampValidateBeforeCall(namespace, array, endTimestamp, null);
        Type localVarReturnType = new TypeToken<Integer>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Get fragment end_timestamp on an array, will search for the closest end_timestamp to the timestamp asked
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param endTimestamp Milliseconds since Unix epoch (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> fragment end_timestamp on an array </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getFragmentEndTimestampAsync(String namespace, String array, Integer endTimestamp, final ApiCallback<Integer> _callback) throws ApiException {

        okhttp3.Call localVarCall = getFragmentEndTimestampValidateBeforeCall(namespace, array, endTimestamp, _callback);
        Type localVarReturnType = new TypeToken<Integer>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getLastAccessedArrays
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> gets last accessed arrays </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getLastAccessedArraysCall(final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/arrays/last_accessed";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getLastAccessedArraysValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getLastAccessedArraysCall(_callback);
        return localVarCall;

    }

    /**
     * 
     * 
     * @return List&lt;LastAccessedArray&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> gets last accessed arrays </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public List<LastAccessedArray> getLastAccessedArrays() throws ApiException {
        ApiResponse<List<LastAccessedArray>> localVarResp = getLastAccessedArraysWithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * 
     * 
     * @return ApiResponse&lt;List&lt;LastAccessedArray&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> gets last accessed arrays </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<LastAccessedArray>> getLastAccessedArraysWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = getLastAccessedArraysValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<List<LastAccessedArray>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * 
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> gets last accessed arrays </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getLastAccessedArraysAsync(final ApiCallback<List<LastAccessedArray>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getLastAccessedArraysValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<List<LastAccessedArray>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for registerArray
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param arrayMetadata metadata associated with array (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> array registered successfully </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call registerArrayCall(String namespace, String array, ArrayInfoUpdate arrayMetadata, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = arrayMetadata;

        // create path and map variables
        String localVarPath = "/arrays/{namespace}/{array}/register"
            .replaceAll("\\{" + "namespace" + "\\}", localVarApiClient.escapeString(namespace.toString()))
            .replaceAll("\\{" + "array" + "\\}", localVarApiClient.escapeString(array.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call registerArrayValidateBeforeCall(String namespace, String array, ArrayInfoUpdate arrayMetadata, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'namespace' is set
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling registerArray(Async)");
        }
        
        // verify the required parameter 'array' is set
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling registerArray(Async)");
        }
        
        // verify the required parameter 'arrayMetadata' is set
        if (arrayMetadata == null) {
            throw new ApiException("Missing the required parameter 'arrayMetadata' when calling registerArray(Async)");
        }
        

        okhttp3.Call localVarCall = registerArrayCall(namespace, array, arrayMetadata, _callback);
        return localVarCall;

    }

    /**
     * 
     * register an array at a specified URI registered to the given namespace
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param arrayMetadata metadata associated with array (required)
     * @return ArrayInfo
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> array registered successfully </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ArrayInfo registerArray(String namespace, String array, ArrayInfoUpdate arrayMetadata) throws ApiException {
        ApiResponse<ArrayInfo> localVarResp = registerArrayWithHttpInfo(namespace, array, arrayMetadata);
        return localVarResp.getData();
    }

    /**
     * 
     * register an array at a specified URI registered to the given namespace
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param arrayMetadata metadata associated with array (required)
     * @return ApiResponse&lt;ArrayInfo&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> array registered successfully </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ArrayInfo> registerArrayWithHttpInfo(String namespace, String array, ArrayInfoUpdate arrayMetadata) throws ApiException {
        okhttp3.Call localVarCall = registerArrayValidateBeforeCall(namespace, array, arrayMetadata, null);
        Type localVarReturnType = new TypeToken<ArrayInfo>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * register an array at a specified URI registered to the given namespace
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param arrayMetadata metadata associated with array (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> array registered successfully </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call registerArrayAsync(String namespace, String array, ArrayInfoUpdate arrayMetadata, final ApiCallback<ArrayInfo> _callback) throws ApiException {

        okhttp3.Call localVarCall = registerArrayValidateBeforeCall(namespace, array, arrayMetadata, _callback);
        Type localVarReturnType = new TypeToken<ArrayInfo>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for shareArray
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param arraySharing Namespace and list of permissions to share with. An empty list of permissions will remove the namespace; if permissions already exist they will be deleted then new ones added. In the event of a failure, the new policies will be rolled back to prevent partial policies, and it&#39;s likely the array will not be shared with the namespace at all. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Array shared successfully </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Array does not exist or user does not have permissions to share array </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call shareArrayCall(String namespace, String array, ArraySharing arraySharing, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = arraySharing;

        // create path and map variables
        String localVarPath = "/arrays/{namespace}/{array}/share"
            .replaceAll("\\{" + "namespace" + "\\}", localVarApiClient.escapeString(namespace.toString()))
            .replaceAll("\\{" + "array" + "\\}", localVarApiClient.escapeString(array.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call shareArrayValidateBeforeCall(String namespace, String array, ArraySharing arraySharing, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'namespace' is set
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling shareArray(Async)");
        }
        
        // verify the required parameter 'array' is set
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling shareArray(Async)");
        }
        
        // verify the required parameter 'arraySharing' is set
        if (arraySharing == null) {
            throw new ApiException("Missing the required parameter 'arraySharing' when calling shareArray(Async)");
        }
        

        okhttp3.Call localVarCall = shareArrayCall(namespace, array, arraySharing, _callback);
        return localVarCall;

    }

    /**
     * 
     * Share an array with a user
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param arraySharing Namespace and list of permissions to share with. An empty list of permissions will remove the namespace; if permissions already exist they will be deleted then new ones added. In the event of a failure, the new policies will be rolled back to prevent partial policies, and it&#39;s likely the array will not be shared with the namespace at all. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Array shared successfully </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Array does not exist or user does not have permissions to share array </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public void shareArray(String namespace, String array, ArraySharing arraySharing) throws ApiException {
        shareArrayWithHttpInfo(namespace, array, arraySharing);
    }

    /**
     * 
     * Share an array with a user
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param arraySharing Namespace and list of permissions to share with. An empty list of permissions will remove the namespace; if permissions already exist they will be deleted then new ones added. In the event of a failure, the new policies will be rolled back to prevent partial policies, and it&#39;s likely the array will not be shared with the namespace at all. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Array shared successfully </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Array does not exist or user does not have permissions to share array </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> shareArrayWithHttpInfo(String namespace, String array, ArraySharing arraySharing) throws ApiException {
        okhttp3.Call localVarCall = shareArrayValidateBeforeCall(namespace, array, arraySharing, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     *  (asynchronously)
     * Share an array with a user
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param arraySharing Namespace and list of permissions to share with. An empty list of permissions will remove the namespace; if permissions already exist they will be deleted then new ones added. In the event of a failure, the new policies will be rolled back to prevent partial policies, and it&#39;s likely the array will not be shared with the namespace at all. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Array shared successfully </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Array does not exist or user does not have permissions to share array </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call shareArrayAsync(String namespace, String array, ArraySharing arraySharing, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = shareArrayValidateBeforeCall(namespace, array, arraySharing, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateArrayMetadata
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param arrayMetadata array metadata to update (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> array metadata updated successfully </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateArrayMetadataCall(String namespace, String array, ArrayInfoUpdate arrayMetadata, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = arrayMetadata;

        // create path and map variables
        String localVarPath = "/arrays/{namespace}/{array}/metadata"
            .replaceAll("\\{" + "namespace" + "\\}", localVarApiClient.escapeString(namespace.toString()))
            .replaceAll("\\{" + "array" + "\\}", localVarApiClient.escapeString(array.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateArrayMetadataValidateBeforeCall(String namespace, String array, ArrayInfoUpdate arrayMetadata, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'namespace' is set
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling updateArrayMetadata(Async)");
        }
        
        // verify the required parameter 'array' is set
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling updateArrayMetadata(Async)");
        }
        
        // verify the required parameter 'arrayMetadata' is set
        if (arrayMetadata == null) {
            throw new ApiException("Missing the required parameter 'arrayMetadata' when calling updateArrayMetadata(Async)");
        }
        

        okhttp3.Call localVarCall = updateArrayMetadataCall(namespace, array, arrayMetadata, _callback);
        return localVarCall;

    }

    /**
     * 
     * update metadata on an array
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param arrayMetadata array metadata to update (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> array metadata updated successfully </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public void updateArrayMetadata(String namespace, String array, ArrayInfoUpdate arrayMetadata) throws ApiException {
        updateArrayMetadataWithHttpInfo(namespace, array, arrayMetadata);
    }

    /**
     * 
     * update metadata on an array
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param arrayMetadata array metadata to update (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> array metadata updated successfully </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> updateArrayMetadataWithHttpInfo(String namespace, String array, ArrayInfoUpdate arrayMetadata) throws ApiException {
        okhttp3.Call localVarCall = updateArrayMetadataValidateBeforeCall(namespace, array, arrayMetadata, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     *  (asynchronously)
     * update metadata on an array
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param arrayMetadata array metadata to update (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> array metadata updated successfully </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateArrayMetadataAsync(String namespace, String array, ArrayInfoUpdate arrayMetadata, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateArrayMetadataValidateBeforeCall(namespace, array, arrayMetadata, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateArrayMetadataCapnp
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param arrayMetadataEntries List of metadata entries (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> array metadata updated successfully </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateArrayMetadataCapnpCall(String namespace, String array, ArrayMetadata arrayMetadataEntries, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = arrayMetadataEntries;

        // create path and map variables
        String localVarPath = "/arrays/{namespace}/{array}/array_metadata"
            .replaceAll("\\{" + "namespace" + "\\}", localVarApiClient.escapeString(namespace.toString()))
            .replaceAll("\\{" + "array" + "\\}", localVarApiClient.escapeString(array.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json", "application/capnp"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json", "application/capnp"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateArrayMetadataCapnpValidateBeforeCall(String namespace, String array, ArrayMetadata arrayMetadataEntries, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'namespace' is set
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling updateArrayMetadataCapnp(Async)");
        }
        
        // verify the required parameter 'array' is set
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling updateArrayMetadataCapnp(Async)");
        }
        
        // verify the required parameter 'arrayMetadataEntries' is set
        if (arrayMetadataEntries == null) {
            throw new ApiException("Missing the required parameter 'arrayMetadataEntries' when calling updateArrayMetadataCapnp(Async)");
        }
        

        okhttp3.Call localVarCall = updateArrayMetadataCapnpCall(namespace, array, arrayMetadataEntries, _callback);
        return localVarCall;

    }

    /**
     * 
     * update metadata on an array
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param arrayMetadataEntries List of metadata entries (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> array metadata updated successfully </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public void updateArrayMetadataCapnp(String namespace, String array, ArrayMetadata arrayMetadataEntries) throws ApiException {
        updateArrayMetadataCapnpWithHttpInfo(namespace, array, arrayMetadataEntries);
    }

    /**
     * 
     * update metadata on an array
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param arrayMetadataEntries List of metadata entries (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> array metadata updated successfully </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> updateArrayMetadataCapnpWithHttpInfo(String namespace, String array, ArrayMetadata arrayMetadataEntries) throws ApiException {
        okhttp3.Call localVarCall = updateArrayMetadataCapnpValidateBeforeCall(namespace, array, arrayMetadataEntries, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     *  (asynchronously)
     * update metadata on an array
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param arrayMetadataEntries List of metadata entries (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> array metadata updated successfully </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateArrayMetadataCapnpAsync(String namespace, String array, ArrayMetadata arrayMetadataEntries, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateArrayMetadataCapnpValidateBeforeCall(namespace, array, arrayMetadataEntries, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for vacuumArray
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param tiledbConfig tiledb configuration (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> array vacuumed successfully </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call vacuumArrayCall(String namespace, String array, TileDBConfig tiledbConfig, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = tiledbConfig;

        // create path and map variables
        String localVarPath = "/arrays/{namespace}/{array}/vacuum"
            .replaceAll("\\{" + "namespace" + "\\}", localVarApiClient.escapeString(namespace.toString()))
            .replaceAll("\\{" + "array" + "\\}", localVarApiClient.escapeString(array.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call vacuumArrayValidateBeforeCall(String namespace, String array, TileDBConfig tiledbConfig, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'namespace' is set
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling vacuumArray(Async)");
        }
        
        // verify the required parameter 'array' is set
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling vacuumArray(Async)");
        }
        
        // verify the required parameter 'tiledbConfig' is set
        if (tiledbConfig == null) {
            throw new ApiException("Missing the required parameter 'tiledbConfig' when calling vacuumArray(Async)");
        }
        

        okhttp3.Call localVarCall = vacuumArrayCall(namespace, array, tiledbConfig, _callback);
        return localVarCall;

    }

    /**
     * 
     * vacuum an array at a specified URI
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param tiledbConfig tiledb configuration (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> array vacuumed successfully </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public void vacuumArray(String namespace, String array, TileDBConfig tiledbConfig) throws ApiException {
        vacuumArrayWithHttpInfo(namespace, array, tiledbConfig);
    }

    /**
     * 
     * vacuum an array at a specified URI
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param tiledbConfig tiledb configuration (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> array vacuumed successfully </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> vacuumArrayWithHttpInfo(String namespace, String array, TileDBConfig tiledbConfig) throws ApiException {
        okhttp3.Call localVarCall = vacuumArrayValidateBeforeCall(namespace, array, tiledbConfig, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     *  (asynchronously)
     * vacuum an array at a specified URI
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param tiledbConfig tiledb configuration (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> array vacuumed successfully </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call vacuumArrayAsync(String namespace, String array, TileDBConfig tiledbConfig, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = vacuumArrayValidateBeforeCall(namespace, array, tiledbConfig, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}
