/*
 * TileDB Storage Platform API
 * TileDB Storage Platform REST API
 *
 * The version of the OpenAPI document: 2.2.19
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.tiledb.cloud.rest_api.api;

import io.tiledb.cloud.rest_api.ApiClient;
import io.tiledb.cloud.rest_api.ApiException;
import io.tiledb.cloud.rest_api.ApiResponse;
import io.tiledb.cloud.rest_api.Pair;
import io.tiledb.cloud.rest_api.ApiCallback;
import io.tiledb.cloud.rest_api.Configuration;

import com.google.gson.reflect.TypeToken;


import io.tiledb.cloud.rest_api.model.RegisteredTaskGraph;
import io.tiledb.cloud.rest_api.model.TaskGraphSharing;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RegisteredTaskGraphsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public RegisteredTaskGraphsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RegisteredTaskGraphsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    /**
     * Build call for deleteRegisteredTaskGraph
     * @param namespace The namespace that owns this registered UDF. (required)
     * @param name The name of the registered task graph. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Task graph successfully deleted. </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteRegisteredTaskGraphCall(String namespace, String name, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/taskgraphs/{namespace}/registered/{name}"
            .replaceAll("\\{" + "namespace" + "\\}", localVarApiClient.escapeString(namespace.toString()))
            .replaceAll("\\{" + "name" + "\\}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteRegisteredTaskGraphValidateBeforeCall(String namespace, String name, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'namespace' is set
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling deleteRegisteredTaskGraph(Async)");
        }
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteRegisteredTaskGraph(Async)");
        }
        

        okhttp3.Call localVarCall = deleteRegisteredTaskGraphCall(namespace, name, _callback);
        return localVarCall;

    }

    /**
     * 
     * Delete the given registered task graph. 
     * @param namespace The namespace that owns this registered UDF. (required)
     * @param name The name of the registered task graph. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Task graph successfully deleted. </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public void deleteRegisteredTaskGraph(String namespace, String name) throws ApiException {
        deleteRegisteredTaskGraphWithHttpInfo(namespace, name);
    }

    /**
     * 
     * Delete the given registered task graph. 
     * @param namespace The namespace that owns this registered UDF. (required)
     * @param name The name of the registered task graph. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Task graph successfully deleted. </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deleteRegisteredTaskGraphWithHttpInfo(String namespace, String name) throws ApiException {
        okhttp3.Call localVarCall = deleteRegisteredTaskGraphValidateBeforeCall(namespace, name, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     *  (asynchronously)
     * Delete the given registered task graph. 
     * @param namespace The namespace that owns this registered UDF. (required)
     * @param name The name of the registered task graph. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Task graph successfully deleted. </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteRegisteredTaskGraphAsync(String namespace, String name, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteRegisteredTaskGraphValidateBeforeCall(namespace, name, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for getRegisteredTaskGraph
     * @param namespace The namespace that owns this registered UDF. (required)
     * @param name The name of the registered task graph. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The contents of the registered task graph. </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getRegisteredTaskGraphCall(String namespace, String name, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/taskgraphs/{namespace}/registered/{name}"
            .replaceAll("\\{" + "namespace" + "\\}", localVarApiClient.escapeString(namespace.toString()))
            .replaceAll("\\{" + "name" + "\\}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getRegisteredTaskGraphValidateBeforeCall(String namespace, String name, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'namespace' is set
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling getRegisteredTaskGraph(Async)");
        }
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getRegisteredTaskGraph(Async)");
        }
        

        okhttp3.Call localVarCall = getRegisteredTaskGraphCall(namespace, name, _callback);
        return localVarCall;

    }

    /**
     * 
     * Fetch the contents of this registered task graph. 
     * @param namespace The namespace that owns this registered UDF. (required)
     * @param name The name of the registered task graph. (required)
     * @return RegisteredTaskGraph
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The contents of the registered task graph. </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public RegisteredTaskGraph getRegisteredTaskGraph(String namespace, String name) throws ApiException {
        ApiResponse<RegisteredTaskGraph> localVarResp = getRegisteredTaskGraphWithHttpInfo(namespace, name);
        return localVarResp.getData();
    }

    /**
     * 
     * Fetch the contents of this registered task graph. 
     * @param namespace The namespace that owns this registered UDF. (required)
     * @param name The name of the registered task graph. (required)
     * @return ApiResponse&lt;RegisteredTaskGraph&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The contents of the registered task graph. </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<RegisteredTaskGraph> getRegisteredTaskGraphWithHttpInfo(String namespace, String name) throws ApiException {
        okhttp3.Call localVarCall = getRegisteredTaskGraphValidateBeforeCall(namespace, name, null);
        Type localVarReturnType = new TypeToken<RegisteredTaskGraph>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Fetch the contents of this registered task graph. 
     * @param namespace The namespace that owns this registered UDF. (required)
     * @param name The name of the registered task graph. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The contents of the registered task graph. </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getRegisteredTaskGraphAsync(String namespace, String name, final ApiCallback<RegisteredTaskGraph> _callback) throws ApiException {

        okhttp3.Call localVarCall = getRegisteredTaskGraphValidateBeforeCall(namespace, name, _callback);
        Type localVarReturnType = new TypeToken<RegisteredTaskGraph>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getRegisteredTaskGraphSharingPolicies
     * @param namespace The namespace that owns the registered task graph. (required)
     * @param name The name of the task graph. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List of all specific sharing policies </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The task graph does not exist (or the user does not have permission to view policies)  </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getRegisteredTaskGraphSharingPoliciesCall(String namespace, String name, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/taskgraphs/{namespace}/registered/{name}/share"
            .replaceAll("\\{" + "namespace" + "\\}", localVarApiClient.escapeString(namespace.toString()))
            .replaceAll("\\{" + "name" + "\\}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getRegisteredTaskGraphSharingPoliciesValidateBeforeCall(String namespace, String name, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'namespace' is set
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling getRegisteredTaskGraphSharingPolicies(Async)");
        }
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getRegisteredTaskGraphSharingPolicies(Async)");
        }
        

        okhttp3.Call localVarCall = getRegisteredTaskGraphSharingPoliciesCall(namespace, name, _callback);
        return localVarCall;

    }

    /**
     * 
     * Get sharing policies for the task graph.
     * @param namespace The namespace that owns the registered task graph. (required)
     * @param name The name of the task graph. (required)
     * @return List&lt;TaskGraphSharing&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List of all specific sharing policies </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The task graph does not exist (or the user does not have permission to view policies)  </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public List<TaskGraphSharing> getRegisteredTaskGraphSharingPolicies(String namespace, String name) throws ApiException {
        ApiResponse<List<TaskGraphSharing>> localVarResp = getRegisteredTaskGraphSharingPoliciesWithHttpInfo(namespace, name);
        return localVarResp.getData();
    }

    /**
     * 
     * Get sharing policies for the task graph.
     * @param namespace The namespace that owns the registered task graph. (required)
     * @param name The name of the task graph. (required)
     * @return ApiResponse&lt;List&lt;TaskGraphSharing&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List of all specific sharing policies </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The task graph does not exist (or the user does not have permission to view policies)  </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<TaskGraphSharing>> getRegisteredTaskGraphSharingPoliciesWithHttpInfo(String namespace, String name) throws ApiException {
        okhttp3.Call localVarCall = getRegisteredTaskGraphSharingPoliciesValidateBeforeCall(namespace, name, null);
        Type localVarReturnType = new TypeToken<List<TaskGraphSharing>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Get sharing policies for the task graph.
     * @param namespace The namespace that owns the registered task graph. (required)
     * @param name The name of the task graph. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List of all specific sharing policies </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The task graph does not exist (or the user does not have permission to view policies)  </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getRegisteredTaskGraphSharingPoliciesAsync(String namespace, String name, final ApiCallback<List<TaskGraphSharing>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getRegisteredTaskGraphSharingPoliciesValidateBeforeCall(namespace, name, _callback);
        Type localVarReturnType = new TypeToken<List<TaskGraphSharing>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for registerRegisteredTaskGraph
     * @param namespace The namespace that owns this registered UDF. (required)
     * @param name The name of the registered task graph. (required)
     * @param graph Task graph to register. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Task graph registered successfully. </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call registerRegisteredTaskGraphCall(String namespace, String name, RegisteredTaskGraph graph, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = graph;

        // create path and map variables
        String localVarPath = "/taskgraphs/{namespace}/registered/{name}"
            .replaceAll("\\{" + "namespace" + "\\}", localVarApiClient.escapeString(namespace.toString()))
            .replaceAll("\\{" + "name" + "\\}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call registerRegisteredTaskGraphValidateBeforeCall(String namespace, String name, RegisteredTaskGraph graph, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'namespace' is set
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling registerRegisteredTaskGraph(Async)");
        }
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling registerRegisteredTaskGraph(Async)");
        }
        

        okhttp3.Call localVarCall = registerRegisteredTaskGraphCall(namespace, name, graph, _callback);
        return localVarCall;

    }

    /**
     * 
     * Register a task graph in the given namespace, with the given name. 
     * @param namespace The namespace that owns this registered UDF. (required)
     * @param name The name of the registered task graph. (required)
     * @param graph Task graph to register. (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Task graph registered successfully. </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public void registerRegisteredTaskGraph(String namespace, String name, RegisteredTaskGraph graph) throws ApiException {
        registerRegisteredTaskGraphWithHttpInfo(namespace, name, graph);
    }

    /**
     * 
     * Register a task graph in the given namespace, with the given name. 
     * @param namespace The namespace that owns this registered UDF. (required)
     * @param name The name of the registered task graph. (required)
     * @param graph Task graph to register. (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Task graph registered successfully. </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> registerRegisteredTaskGraphWithHttpInfo(String namespace, String name, RegisteredTaskGraph graph) throws ApiException {
        okhttp3.Call localVarCall = registerRegisteredTaskGraphValidateBeforeCall(namespace, name, graph, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     *  (asynchronously)
     * Register a task graph in the given namespace, with the given name. 
     * @param namespace The namespace that owns this registered UDF. (required)
     * @param name The name of the registered task graph. (required)
     * @param graph Task graph to register. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Task graph registered successfully. </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call registerRegisteredTaskGraphAsync(String namespace, String name, RegisteredTaskGraph graph, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = registerRegisteredTaskGraphValidateBeforeCall(namespace, name, graph, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for shareRegisteredTaskGraph
     * @param namespace The namespace that owns the registered task graph. (required)
     * @param name The name of the task graph. (required)
     * @param taskGraphSharing Namespace and list of permissions to share with. An empty list of permissions will remove the namespace; if permissions already exist they will be deleted then new ones added. In the event of a failure, the new policies will be rolled back to prevent partial policies, and it&#39;s likely the UDF will not be shared with the namespace at all.  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> UDF shared successfully </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> UDF does not exist or user does not have permissions to share UDF </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call shareRegisteredTaskGraphCall(String namespace, String name, TaskGraphSharing taskGraphSharing, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = taskGraphSharing;

        // create path and map variables
        String localVarPath = "/taskgraphs/{namespace}/registered/{name}/share"
            .replaceAll("\\{" + "namespace" + "\\}", localVarApiClient.escapeString(namespace.toString()))
            .replaceAll("\\{" + "name" + "\\}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call shareRegisteredTaskGraphValidateBeforeCall(String namespace, String name, TaskGraphSharing taskGraphSharing, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'namespace' is set
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling shareRegisteredTaskGraph(Async)");
        }
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling shareRegisteredTaskGraph(Async)");
        }
        
        // verify the required parameter 'taskGraphSharing' is set
        if (taskGraphSharing == null) {
            throw new ApiException("Missing the required parameter 'taskGraphSharing' when calling shareRegisteredTaskGraph(Async)");
        }
        

        okhttp3.Call localVarCall = shareRegisteredTaskGraphCall(namespace, name, taskGraphSharing, _callback);
        return localVarCall;

    }

    /**
     * 
     * Share a task graph.
     * @param namespace The namespace that owns the registered task graph. (required)
     * @param name The name of the task graph. (required)
     * @param taskGraphSharing Namespace and list of permissions to share with. An empty list of permissions will remove the namespace; if permissions already exist they will be deleted then new ones added. In the event of a failure, the new policies will be rolled back to prevent partial policies, and it&#39;s likely the UDF will not be shared with the namespace at all.  (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> UDF shared successfully </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> UDF does not exist or user does not have permissions to share UDF </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public void shareRegisteredTaskGraph(String namespace, String name, TaskGraphSharing taskGraphSharing) throws ApiException {
        shareRegisteredTaskGraphWithHttpInfo(namespace, name, taskGraphSharing);
    }

    /**
     * 
     * Share a task graph.
     * @param namespace The namespace that owns the registered task graph. (required)
     * @param name The name of the task graph. (required)
     * @param taskGraphSharing Namespace and list of permissions to share with. An empty list of permissions will remove the namespace; if permissions already exist they will be deleted then new ones added. In the event of a failure, the new policies will be rolled back to prevent partial policies, and it&#39;s likely the UDF will not be shared with the namespace at all.  (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> UDF shared successfully </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> UDF does not exist or user does not have permissions to share UDF </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> shareRegisteredTaskGraphWithHttpInfo(String namespace, String name, TaskGraphSharing taskGraphSharing) throws ApiException {
        okhttp3.Call localVarCall = shareRegisteredTaskGraphValidateBeforeCall(namespace, name, taskGraphSharing, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     *  (asynchronously)
     * Share a task graph.
     * @param namespace The namespace that owns the registered task graph. (required)
     * @param name The name of the task graph. (required)
     * @param taskGraphSharing Namespace and list of permissions to share with. An empty list of permissions will remove the namespace; if permissions already exist they will be deleted then new ones added. In the event of a failure, the new policies will be rolled back to prevent partial policies, and it&#39;s likely the UDF will not be shared with the namespace at all.  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> UDF shared successfully </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> UDF does not exist or user does not have permissions to share UDF </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call shareRegisteredTaskGraphAsync(String namespace, String name, TaskGraphSharing taskGraphSharing, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = shareRegisteredTaskGraphValidateBeforeCall(namespace, name, taskGraphSharing, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateRegisteredTaskGraph
     * @param namespace The namespace that owns this registered UDF. (required)
     * @param name The name of the registered task graph. (required)
     * @param graph The new contents of the task graph. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Task graph updated successfully. </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateRegisteredTaskGraphCall(String namespace, String name, RegisteredTaskGraph graph, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = graph;

        // create path and map variables
        String localVarPath = "/taskgraphs/{namespace}/registered/{name}"
            .replaceAll("\\{" + "namespace" + "\\}", localVarApiClient.escapeString(namespace.toString()))
            .replaceAll("\\{" + "name" + "\\}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateRegisteredTaskGraphValidateBeforeCall(String namespace, String name, RegisteredTaskGraph graph, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'namespace' is set
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling updateRegisteredTaskGraph(Async)");
        }
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateRegisteredTaskGraph(Async)");
        }
        

        okhttp3.Call localVarCall = updateRegisteredTaskGraphCall(namespace, name, graph, _callback);
        return localVarCall;

    }

    /**
     * 
     * Update the contents of an existing registered task graph. 
     * @param namespace The namespace that owns this registered UDF. (required)
     * @param name The name of the registered task graph. (required)
     * @param graph The new contents of the task graph. (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Task graph updated successfully. </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public void updateRegisteredTaskGraph(String namespace, String name, RegisteredTaskGraph graph) throws ApiException {
        updateRegisteredTaskGraphWithHttpInfo(namespace, name, graph);
    }

    /**
     * 
     * Update the contents of an existing registered task graph. 
     * @param namespace The namespace that owns this registered UDF. (required)
     * @param name The name of the registered task graph. (required)
     * @param graph The new contents of the task graph. (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Task graph updated successfully. </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> updateRegisteredTaskGraphWithHttpInfo(String namespace, String name, RegisteredTaskGraph graph) throws ApiException {
        okhttp3.Call localVarCall = updateRegisteredTaskGraphValidateBeforeCall(namespace, name, graph, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     *  (asynchronously)
     * Update the contents of an existing registered task graph. 
     * @param namespace The namespace that owns this registered UDF. (required)
     * @param name The name of the registered task graph. (required)
     * @param graph The new contents of the task graph. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Task graph updated successfully. </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateRegisteredTaskGraphAsync(String namespace, String name, RegisteredTaskGraph graph, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateRegisteredTaskGraphValidateBeforeCall(namespace, name, graph, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}
