/*
 * TileDB Storage Platform API
 * TileDB Storage Platform REST API
 *
 * The version of the OpenAPI document: 2.2.19
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.tiledb.cloud.rest_api.api;

import io.tiledb.cloud.rest_api.ApiCallback;
import io.tiledb.cloud.rest_api.ApiClient;
import io.tiledb.cloud.rest_api.ApiException;
import io.tiledb.cloud.rest_api.ApiResponse;
import io.tiledb.cloud.rest_api.Configuration;
import io.tiledb.cloud.rest_api.Pair;

import com.google.gson.reflect.TypeToken;


import java.time.OffsetDateTime;
import io.tiledb.cloud.rest_api.model.TaskGraphClientNodeStatus;
import io.tiledb.cloud.rest_api.model.TaskGraphLog;
import io.tiledb.cloud.rest_api.model.TaskGraphLogsData;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TaskGraphLogsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public TaskGraphLogsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TaskGraphLogsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    /**
     * Build call for createTaskGraphLog
     * @param namespace The namespace that will own this task graph log. (required)
     * @param log  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> The task graph was created. The returned TaskGraphLog will include the data the client sent, with the server-defined fields added in.  </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createTaskGraphLogCall(String namespace, TaskGraphLog log, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = log;

        // create path and map variables
        String localVarPath = "/taskgraphs/{namespace}/log"
            .replaceAll("\\{" + "namespace" + "\\}", localVarApiClient.escapeString(namespace.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createTaskGraphLogValidateBeforeCall(String namespace, TaskGraphLog log, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'namespace' is set
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling createTaskGraphLog(Async)");
        }
        
        // verify the required parameter 'log' is set
        if (log == null) {
            throw new ApiException("Missing the required parameter 'log' when calling createTaskGraphLog(Async)");
        }
        

        okhttp3.Call localVarCall = createTaskGraphLogCall(namespace, log, _callback);
        return localVarCall;

    }

    /**
     * 
     * Create a task graph log.
     * @param namespace The namespace that will own this task graph log. (required)
     * @param log  (required)
     * @return TaskGraphLog
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> The task graph was created. The returned TaskGraphLog will include the data the client sent, with the server-defined fields added in.  </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public TaskGraphLog createTaskGraphLog(String namespace, TaskGraphLog log) throws ApiException {
        ApiResponse<TaskGraphLog> localVarResp = createTaskGraphLogWithHttpInfo(namespace, log);
        return localVarResp.getData();
    }

    /**
     * 
     * Create a task graph log.
     * @param namespace The namespace that will own this task graph log. (required)
     * @param log  (required)
     * @return ApiResponse&lt;TaskGraphLog&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> The task graph was created. The returned TaskGraphLog will include the data the client sent, with the server-defined fields added in.  </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<TaskGraphLog> createTaskGraphLogWithHttpInfo(String namespace, TaskGraphLog log) throws ApiException {
        okhttp3.Call localVarCall = createTaskGraphLogValidateBeforeCall(namespace, log, null);
        Type localVarReturnType = new TypeToken<TaskGraphLog>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Create a task graph log.
     * @param namespace The namespace that will own this task graph log. (required)
     * @param log  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> The task graph was created. The returned TaskGraphLog will include the data the client sent, with the server-defined fields added in.  </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createTaskGraphLogAsync(String namespace, TaskGraphLog log, final ApiCallback<TaskGraphLog> _callback) throws ApiException {

        okhttp3.Call localVarCall = createTaskGraphLogValidateBeforeCall(namespace, log, _callback);
        Type localVarReturnType = new TypeToken<TaskGraphLog>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getTaskGraphLog
     * @param namespace The namespace that owns this task graph log. (required)
     * @param id The UUID of the task graph log entry. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Information about the execution of a single task graph. </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getTaskGraphLogCall(String namespace, String id, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/taskgraphs/{namespace}/logs/{id}"
            .replaceAll("\\{" + "namespace" + "\\}", localVarApiClient.escapeString(namespace.toString()))
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getTaskGraphLogValidateBeforeCall(String namespace, String id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'namespace' is set
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling getTaskGraphLog(Async)");
        }
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getTaskGraphLog(Async)");
        }
        

        okhttp3.Call localVarCall = getTaskGraphLogCall(namespace, id, _callback);
        return localVarCall;

    }

    /**
     * 
     * Fetch information about a single task graph execution. 
     * @param namespace The namespace that owns this task graph log. (required)
     * @param id The UUID of the task graph log entry. (required)
     * @return TaskGraphLog
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Information about the execution of a single task graph. </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public TaskGraphLog getTaskGraphLog(String namespace, String id) throws ApiException {
        ApiResponse<TaskGraphLog> localVarResp = getTaskGraphLogWithHttpInfo(namespace, id);
        return localVarResp.getData();
    }

    /**
     * 
     * Fetch information about a single task graph execution. 
     * @param namespace The namespace that owns this task graph log. (required)
     * @param id The UUID of the task graph log entry. (required)
     * @return ApiResponse&lt;TaskGraphLog&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Information about the execution of a single task graph. </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<TaskGraphLog> getTaskGraphLogWithHttpInfo(String namespace, String id) throws ApiException {
        okhttp3.Call localVarCall = getTaskGraphLogValidateBeforeCall(namespace, id, null);
        Type localVarReturnType = new TypeToken<TaskGraphLog>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Fetch information about a single task graph execution. 
     * @param namespace The namespace that owns this task graph log. (required)
     * @param id The UUID of the task graph log entry. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Information about the execution of a single task graph. </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getTaskGraphLogAsync(String namespace, String id, final ApiCallback<TaskGraphLog> _callback) throws ApiException {

        okhttp3.Call localVarCall = getTaskGraphLogValidateBeforeCall(namespace, id, _callback);
        Type localVarReturnType = new TypeToken<TaskGraphLog>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listTaskGraphLogs
     * @param namespace Include logs for this namespace. (optional)
     * @param createdBy Include logs from only this user. (optional)
     * @param search search string that will look at name. (optional)
     * @param startTime Include logs created after this time. (optional)
     * @param endTime Include logs created before this time. (optional)
     * @param page pagination offset (optional)
     * @param perPage pagination limit (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The task graph logs that matched the user&#39;s query. </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listTaskGraphLogsCall(String namespace, String createdBy, String search, OffsetDateTime startTime, OffsetDateTime endTime, Integer page, Integer perPage, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/taskgraphs/logs";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (namespace != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("namespace", namespace));
        }

        if (createdBy != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("created_by", createdBy));
        }

        if (search != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("search", search));
        }

        if (startTime != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("start_time", startTime));
        }

        if (endTime != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("end_time", endTime));
        }

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (perPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("per_page", perPage));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listTaskGraphLogsValidateBeforeCall(String namespace, String createdBy, String search, OffsetDateTime startTime, OffsetDateTime endTime, Integer page, Integer perPage, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = listTaskGraphLogsCall(namespace, createdBy, search, startTime, endTime, page, perPage, _callback);
        return localVarCall;

    }

    /**
     * 
     * Fetch the task graph logs of a namespace the user has access to. The returned entries will include only summary data, and will not include information about the individual tasks that were executed. (This information is available when requesting an individual task graph log.) Entries in the response are ordered from newest to oldest. Pagination parameters work as in other API methods; see PaginationMetadata. 
     * @param namespace Include logs for this namespace. (optional)
     * @param createdBy Include logs from only this user. (optional)
     * @param search search string that will look at name. (optional)
     * @param startTime Include logs created after this time. (optional)
     * @param endTime Include logs created before this time. (optional)
     * @param page pagination offset (optional)
     * @param perPage pagination limit (optional)
     * @return TaskGraphLogsData
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The task graph logs that matched the user&#39;s query. </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public TaskGraphLogsData listTaskGraphLogs(String namespace, String createdBy, String search, OffsetDateTime startTime, OffsetDateTime endTime, Integer page, Integer perPage) throws ApiException {
        ApiResponse<TaskGraphLogsData> localVarResp = listTaskGraphLogsWithHttpInfo(namespace, createdBy, search, startTime, endTime, page, perPage);
        return localVarResp.getData();
    }

    /**
     * 
     * Fetch the task graph logs of a namespace the user has access to. The returned entries will include only summary data, and will not include information about the individual tasks that were executed. (This information is available when requesting an individual task graph log.) Entries in the response are ordered from newest to oldest. Pagination parameters work as in other API methods; see PaginationMetadata. 
     * @param namespace Include logs for this namespace. (optional)
     * @param createdBy Include logs from only this user. (optional)
     * @param search search string that will look at name. (optional)
     * @param startTime Include logs created after this time. (optional)
     * @param endTime Include logs created before this time. (optional)
     * @param page pagination offset (optional)
     * @param perPage pagination limit (optional)
     * @return ApiResponse&lt;TaskGraphLogsData&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The task graph logs that matched the user&#39;s query. </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<TaskGraphLogsData> listTaskGraphLogsWithHttpInfo(String namespace, String createdBy, String search, OffsetDateTime startTime, OffsetDateTime endTime, Integer page, Integer perPage) throws ApiException {
        okhttp3.Call localVarCall = listTaskGraphLogsValidateBeforeCall(namespace, createdBy, search, startTime, endTime, page, perPage, null);
        Type localVarReturnType = new TypeToken<TaskGraphLogsData>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Fetch the task graph logs of a namespace the user has access to. The returned entries will include only summary data, and will not include information about the individual tasks that were executed. (This information is available when requesting an individual task graph log.) Entries in the response are ordered from newest to oldest. Pagination parameters work as in other API methods; see PaginationMetadata. 
     * @param namespace Include logs for this namespace. (optional)
     * @param createdBy Include logs from only this user. (optional)
     * @param search search string that will look at name. (optional)
     * @param startTime Include logs created after this time. (optional)
     * @param endTime Include logs created before this time. (optional)
     * @param page pagination offset (optional)
     * @param perPage pagination limit (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The task graph logs that matched the user&#39;s query. </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listTaskGraphLogsAsync(String namespace, String createdBy, String search, OffsetDateTime startTime, OffsetDateTime endTime, Integer page, Integer perPage, final ApiCallback<TaskGraphLogsData> _callback) throws ApiException {

        okhttp3.Call localVarCall = listTaskGraphLogsValidateBeforeCall(namespace, createdBy, search, startTime, endTime, page, perPage, _callback);
        Type localVarReturnType = new TypeToken<TaskGraphLogsData>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for reportClientNode
     * @param namespace The namespace that owns this task graph log. (required)
     * @param id The UUID of the task graph log entry. (required)
     * @param report The node status to report. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Status reported successfully. </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call reportClientNodeCall(String namespace, String id, TaskGraphClientNodeStatus report, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = report;

        // create path and map variables
        String localVarPath = "/taskgraphs/{namespace}/logs/{id}/report_client_node"
            .replaceAll("\\{" + "namespace" + "\\}", localVarApiClient.escapeString(namespace.toString()))
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call reportClientNodeValidateBeforeCall(String namespace, String id, TaskGraphClientNodeStatus report, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'namespace' is set
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling reportClientNode(Async)");
        }
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling reportClientNode(Async)");
        }
        
        // verify the required parameter 'report' is set
        if (report == null) {
            throw new ApiException("Missing the required parameter 'report' when calling reportClientNode(Async)");
        }
        

        okhttp3.Call localVarCall = reportClientNodeCall(namespace, id, report, _callback);
        return localVarCall;

    }

    /**
     * 
     * 
     * @param namespace The namespace that owns this task graph log. (required)
     * @param id The UUID of the task graph log entry. (required)
     * @param report The node status to report. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Status reported successfully. </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public void reportClientNode(String namespace, String id, TaskGraphClientNodeStatus report) throws ApiException {
        reportClientNodeWithHttpInfo(namespace, id, report);
    }

    /**
     * 
     * 
     * @param namespace The namespace that owns this task graph log. (required)
     * @param id The UUID of the task graph log entry. (required)
     * @param report The node status to report. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Status reported successfully. </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> reportClientNodeWithHttpInfo(String namespace, String id, TaskGraphClientNodeStatus report) throws ApiException {
        okhttp3.Call localVarCall = reportClientNodeValidateBeforeCall(namespace, id, report, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     *  (asynchronously)
     * 
     * @param namespace The namespace that owns this task graph log. (required)
     * @param id The UUID of the task graph log entry. (required)
     * @param report The node status to report. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Status reported successfully. </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call reportClientNodeAsync(String namespace, String id, TaskGraphClientNodeStatus report, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = reportClientNodeValidateBeforeCall(namespace, id, report, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateTaskGraphLog
     * @param namespace The namespace that owns this task graph log. (required)
     * @param id The UUID of the task graph log entry. (required)
     * @param log Updates to make to the task graph log. The only manual update that a client should need to make to a task graph log is to update its completion status to &#x60;succeeded&#x60;, &#x60;failed&#x60;, or &#x60;cancelled&#x60;.  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Log entry updated successfully. </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateTaskGraphLogCall(String namespace, String id, TaskGraphLog log, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = log;

        // create path and map variables
        String localVarPath = "/taskgraphs/{namespace}/logs/{id}"
            .replaceAll("\\{" + "namespace" + "\\}", localVarApiClient.escapeString(namespace.toString()))
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateTaskGraphLogValidateBeforeCall(String namespace, String id, TaskGraphLog log, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'namespace' is set
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling updateTaskGraphLog(Async)");
        }
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling updateTaskGraphLog(Async)");
        }
        
        // verify the required parameter 'log' is set
        if (log == null) {
            throw new ApiException("Missing the required parameter 'log' when calling updateTaskGraphLog(Async)");
        }
        

        okhttp3.Call localVarCall = updateTaskGraphLogCall(namespace, id, log, _callback);
        return localVarCall;

    }

    /**
     * 
     * Update information about a single task graph execution. 
     * @param namespace The namespace that owns this task graph log. (required)
     * @param id The UUID of the task graph log entry. (required)
     * @param log Updates to make to the task graph log. The only manual update that a client should need to make to a task graph log is to update its completion status to &#x60;succeeded&#x60;, &#x60;failed&#x60;, or &#x60;cancelled&#x60;.  (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Log entry updated successfully. </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public void updateTaskGraphLog(String namespace, String id, TaskGraphLog log) throws ApiException {
        updateTaskGraphLogWithHttpInfo(namespace, id, log);
    }

    /**
     * 
     * Update information about a single task graph execution. 
     * @param namespace The namespace that owns this task graph log. (required)
     * @param id The UUID of the task graph log entry. (required)
     * @param log Updates to make to the task graph log. The only manual update that a client should need to make to a task graph log is to update its completion status to &#x60;succeeded&#x60;, &#x60;failed&#x60;, or &#x60;cancelled&#x60;.  (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Log entry updated successfully. </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> updateTaskGraphLogWithHttpInfo(String namespace, String id, TaskGraphLog log) throws ApiException {
        okhttp3.Call localVarCall = updateTaskGraphLogValidateBeforeCall(namespace, id, log, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     *  (asynchronously)
     * Update information about a single task graph execution. 
     * @param namespace The namespace that owns this task graph log. (required)
     * @param id The UUID of the task graph log entry. (required)
     * @param log Updates to make to the task graph log. The only manual update that a client should need to make to a task graph log is to update its completion status to &#x60;succeeded&#x60;, &#x60;failed&#x60;, or &#x60;cancelled&#x60;.  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Log entry updated successfully. </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateTaskGraphLogAsync(String namespace, String id, TaskGraphLog log, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateTaskGraphLogValidateBeforeCall(namespace, id, log, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}
