/*
 * TileDB Storage Platform API
 * TileDB Storage Platform REST API
 *
 * The version of the OpenAPI document: 2.2.19
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.tiledb.cloud.rest_api.api;

import io.tiledb.cloud.rest_api.ApiClient;
import io.tiledb.cloud.rest_api.ApiException;
import io.tiledb.cloud.rest_api.ApiResponse;
import io.tiledb.cloud.rest_api.Pair;
import io.tiledb.cloud.rest_api.model.MultiArrayUDF;
import io.tiledb.cloud.rest_api.ApiCallback;
import io.tiledb.cloud.rest_api.Configuration;

import com.google.gson.reflect.TypeToken;


import io.tiledb.cloud.rest_api.model.ArrayEndTimestampData;

import java.io.File;
import io.tiledb.cloud.rest_api.model.GenericUDF;
import io.tiledb.cloud.rest_api.model.UDFCopied;
import io.tiledb.cloud.rest_api.model.UDFCopy;
import io.tiledb.cloud.rest_api.model.UDFInfo;
import io.tiledb.cloud.rest_api.model.UDFInfoUpdate;
import io.tiledb.cloud.rest_api.model.UDFSharing;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UdfApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public UdfApi() {
        this(Configuration.getDefaultApiClient());
    }

    public UdfApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    /**
     * Build call for deleteUDFInfo
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param name name to register UDF under (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> UDF deleted successfully </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteUDFInfoCall(String namespace, String name, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/udf/{namespace}/{name}"
            .replaceAll("\\{" + "namespace" + "\\}", localVarApiClient.escapeString(namespace.toString()))
            .replaceAll("\\{" + "name" + "\\}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteUDFInfoValidateBeforeCall(String namespace, String name, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'namespace' is set
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling deleteUDFInfo(Async)");
        }
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteUDFInfo(Async)");
        }
        

        okhttp3.Call localVarCall = deleteUDFInfoCall(namespace, name, _callback);
        return localVarCall;

    }

    /**
     * 
     * delete a registered UDF -- this will remove all sharing and can not be undone
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param name name to register UDF under (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> UDF deleted successfully </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public void deleteUDFInfo(String namespace, String name) throws ApiException {
        deleteUDFInfoWithHttpInfo(namespace, name);
    }

    /**
     * 
     * delete a registered UDF -- this will remove all sharing and can not be undone
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param name name to register UDF under (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> UDF deleted successfully </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deleteUDFInfoWithHttpInfo(String namespace, String name) throws ApiException {
        okhttp3.Call localVarCall = deleteUDFInfoValidateBeforeCall(namespace, name, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     *  (asynchronously)
     * delete a registered UDF -- this will remove all sharing and can not be undone
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param name name to register UDF under (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> UDF deleted successfully </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteUDFInfoAsync(String namespace, String name, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteUDFInfoValidateBeforeCall(namespace, name, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for getUDFInfo
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param name name to register UDF under (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> UDFInfo was retrieved successfully </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> UDF not found </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getUDFInfoCall(String namespace, String name, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/udf/{namespace}/{name}"
            .replaceAll("\\{" + "namespace" + "\\}", localVarApiClient.escapeString(namespace.toString()))
            .replaceAll("\\{" + "name" + "\\}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getUDFInfoValidateBeforeCall(String namespace, String name, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'namespace' is set
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling getUDFInfo(Async)");
        }
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getUDFInfo(Async)");
        }
        

        okhttp3.Call localVarCall = getUDFInfoCall(namespace, name, _callback);
        return localVarCall;

    }

    /**
     * 
     * get a specific UDF in the given namespace
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param name name to register UDF under (required)
     * @return UDFInfo
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> UDFInfo was retrieved successfully </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> UDF not found </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public UDFInfo getUDFInfo(String namespace, String name) throws ApiException {
        ApiResponse<UDFInfo> localVarResp = getUDFInfoWithHttpInfo(namespace, name);
        return localVarResp.getData();
    }

    /**
     * 
     * get a specific UDF in the given namespace
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param name name to register UDF under (required)
     * @return ApiResponse&lt;UDFInfo&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> UDFInfo was retrieved successfully </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> UDF not found </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<UDFInfo> getUDFInfoWithHttpInfo(String namespace, String name) throws ApiException {
        okhttp3.Call localVarCall = getUDFInfoValidateBeforeCall(namespace, name, null);
        Type localVarReturnType = new TypeToken<UDFInfo>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * get a specific UDF in the given namespace
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param name name to register UDF under (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> UDFInfo was retrieved successfully </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> UDF not found </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getUDFInfoAsync(String namespace, String name, final ApiCallback<UDFInfo> _callback) throws ApiException {

        okhttp3.Call localVarCall = getUDFInfoValidateBeforeCall(namespace, name, _callback);
        Type localVarReturnType = new TypeToken<UDFInfo>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getUDFInfoSharingPolicies
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param name name of UDFInfo (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List of all specific sharing policies </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> UDF does not exist or user does not have permissions to view array-sharing policies </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getUDFInfoSharingPoliciesCall(String namespace, String name, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/udf/{namespace}/{name}/share"
            .replaceAll("\\{" + "namespace" + "\\}", localVarApiClient.escapeString(namespace.toString()))
            .replaceAll("\\{" + "name" + "\\}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getUDFInfoSharingPoliciesValidateBeforeCall(String namespace, String name, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'namespace' is set
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling getUDFInfoSharingPolicies(Async)");
        }
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling getUDFInfoSharingPolicies(Async)");
        }
        

        okhttp3.Call localVarCall = getUDFInfoSharingPoliciesCall(namespace, name, _callback);
        return localVarCall;

    }

    /**
     * 
     * Get all sharing details of the UDF
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param name name of UDFInfo (required)
     * @return List&lt;UDFSharing&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List of all specific sharing policies </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> UDF does not exist or user does not have permissions to view array-sharing policies </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public List<UDFSharing> getUDFInfoSharingPolicies(String namespace, String name) throws ApiException {
        ApiResponse<List<UDFSharing>> localVarResp = getUDFInfoSharingPoliciesWithHttpInfo(namespace, name);
        return localVarResp.getData();
    }

    /**
     * 
     * Get all sharing details of the UDF
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param name name of UDFInfo (required)
     * @return ApiResponse&lt;List&lt;UDFSharing&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List of all specific sharing policies </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> UDF does not exist or user does not have permissions to view array-sharing policies </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<UDFSharing>> getUDFInfoSharingPoliciesWithHttpInfo(String namespace, String name) throws ApiException {
        okhttp3.Call localVarCall = getUDFInfoSharingPoliciesValidateBeforeCall(namespace, name, null);
        Type localVarReturnType = new TypeToken<List<UDFSharing>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Get all sharing details of the UDF
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param name name of UDFInfo (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> List of all specific sharing policies </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> UDF does not exist or user does not have permissions to view array-sharing policies </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getUDFInfoSharingPoliciesAsync(String namespace, String name, final ApiCallback<List<UDFSharing>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getUDFInfoSharingPoliciesValidateBeforeCall(namespace, name, _callback);
        Type localVarReturnType = new TypeToken<List<UDFSharing>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for handleCopyUDF
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param name name of UDFInfo (required)
     * @param udFCopy Input/Output information to copy a UDF (required)
     * @param X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME Optional registered access credentials to use for creation (optional)
     * @param endTimestamp Milliseconds since Unix epoch (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> UDF copied </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call handleCopyUDFCall(String namespace, String name, UDFCopy udFCopy, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, Integer endTimestamp, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = udFCopy;

        // create path and map variables
        String localVarPath = "/udf/{namespace}/{name}/copy"
            .replaceAll("\\{" + "namespace" + "\\}", localVarApiClient.escapeString(namespace.toString()))
            .replaceAll("\\{" + "name" + "\\}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (endTimestamp != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("end_timestamp", endTimestamp));
        }

        if (X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME != null) {
            localVarHeaderParams.put("X-TILEDB-CLOUD-ACCESS-CREDENTIALS-NAME", localVarApiClient.parameterToString(X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call handleCopyUDFValidateBeforeCall(String namespace, String name, UDFCopy udFCopy, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, Integer endTimestamp, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'namespace' is set
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling handleCopyUDF(Async)");
        }
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling handleCopyUDF(Async)");
        }
        
        // verify the required parameter 'udFCopy' is set
        if (udFCopy == null) {
            throw new ApiException("Missing the required parameter 'udFCopy' when calling handleCopyUDF(Async)");
        }
        

        okhttp3.Call localVarCall = handleCopyUDFCall(namespace, name, udFCopy, X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, endTimestamp, _callback);
        return localVarCall;

    }

    /**
     * 
     * Copy a tiledb udf at the specified location
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param name name of UDFInfo (required)
     * @param udFCopy Input/Output information to copy a UDF (required)
     * @param X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME Optional registered access credentials to use for creation (optional)
     * @param endTimestamp Milliseconds since Unix epoch (optional)
     * @return UDFCopied
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> UDF copied </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public UDFCopied handleCopyUDF(String namespace, String name, UDFCopy udFCopy, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, Integer endTimestamp) throws ApiException {
        ApiResponse<UDFCopied> localVarResp = handleCopyUDFWithHttpInfo(namespace, name, udFCopy, X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, endTimestamp);
        return localVarResp.getData();
    }

    /**
     * 
     * Copy a tiledb udf at the specified location
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param name name of UDFInfo (required)
     * @param udFCopy Input/Output information to copy a UDF (required)
     * @param X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME Optional registered access credentials to use for creation (optional)
     * @param endTimestamp Milliseconds since Unix epoch (optional)
     * @return ApiResponse&lt;UDFCopied&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> UDF copied </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<UDFCopied> handleCopyUDFWithHttpInfo(String namespace, String name, UDFCopy udFCopy, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, Integer endTimestamp) throws ApiException {
        okhttp3.Call localVarCall = handleCopyUDFValidateBeforeCall(namespace, name, udFCopy, X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, endTimestamp, null);
        Type localVarReturnType = new TypeToken<UDFCopied>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * Copy a tiledb udf at the specified location
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param name name of UDFInfo (required)
     * @param udFCopy Input/Output information to copy a UDF (required)
     * @param X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME Optional registered access credentials to use for creation (optional)
     * @param endTimestamp Milliseconds since Unix epoch (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> UDF copied </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call handleCopyUDFAsync(String namespace, String name, UDFCopy udFCopy, String X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, Integer endTimestamp, final ApiCallback<UDFCopied> _callback) throws ApiException {

        okhttp3.Call localVarCall = handleCopyUDFValidateBeforeCall(namespace, name, udFCopy, X_TILEDB_CLOUD_ACCESS_CREDENTIALS_NAME, endTimestamp, _callback);
        Type localVarReturnType = new TypeToken<UDFCopied>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for registerUDFInfo
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param name name to register UDF under (required)
     * @param udf UDF to register (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> UDF registered successfully </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call registerUDFInfoCall(String namespace, String name, UDFInfoUpdate udf, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = udf;

        // create path and map variables
        String localVarPath = "/udf/{namespace}/{name}"
            .replaceAll("\\{" + "namespace" + "\\}", localVarApiClient.escapeString(namespace.toString()))
            .replaceAll("\\{" + "name" + "\\}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call registerUDFInfoValidateBeforeCall(String namespace, String name, UDFInfoUpdate udf, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'namespace' is set
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling registerUDFInfo(Async)");
        }
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling registerUDFInfo(Async)");
        }
        
        // verify the required parameter 'udf' is set
        if (udf == null) {
            throw new ApiException("Missing the required parameter 'udf' when calling registerUDFInfo(Async)");
        }
        

        okhttp3.Call localVarCall = registerUDFInfoCall(namespace, name, udf, _callback);
        return localVarCall;

    }

    /**
     * 
     * register a UDF in the given namespace
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param name name to register UDF under (required)
     * @param udf UDF to register (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> UDF registered successfully </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public void registerUDFInfo(String namespace, String name, UDFInfoUpdate udf) throws ApiException {
        registerUDFInfoWithHttpInfo(namespace, name, udf);
    }

    /**
     * 
     * register a UDF in the given namespace
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param name name to register UDF under (required)
     * @param udf UDF to register (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> UDF registered successfully </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> registerUDFInfoWithHttpInfo(String namespace, String name, UDFInfoUpdate udf) throws ApiException {
        okhttp3.Call localVarCall = registerUDFInfoValidateBeforeCall(namespace, name, udf, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     *  (asynchronously)
     * register a UDF in the given namespace
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param name name to register UDF under (required)
     * @param udf UDF to register (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> UDF registered successfully </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call registerUDFInfoAsync(String namespace, String name, UDFInfoUpdate udf, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = registerUDFInfoValidateBeforeCall(namespace, name, udf, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for shareUDFInfo
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param name name of UDFInfo (required)
     * @param udfSharing Namespace and list of permissions to share with. An empty list of permissions will remove the namespace; if permissions already exist they will be deleted then new ones added. In the event of a failure, the new policies will be rolled back to prevent partial policies, and it&#39;s likely the UDF will not be shared with the namespace at all. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> UDF shared successfully </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> UDF does not exist or user does not have permissions to share UDF </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call shareUDFInfoCall(String namespace, String name, UDFSharing udfSharing, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = udfSharing;

        // create path and map variables
        String localVarPath = "/udf/{namespace}/{name}/share"
            .replaceAll("\\{" + "namespace" + "\\}", localVarApiClient.escapeString(namespace.toString()))
            .replaceAll("\\{" + "name" + "\\}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call shareUDFInfoValidateBeforeCall(String namespace, String name, UDFSharing udfSharing, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'namespace' is set
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling shareUDFInfo(Async)");
        }
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling shareUDFInfo(Async)");
        }
        
        // verify the required parameter 'udfSharing' is set
        if (udfSharing == null) {
            throw new ApiException("Missing the required parameter 'udfSharing' when calling shareUDFInfo(Async)");
        }
        

        okhttp3.Call localVarCall = shareUDFInfoCall(namespace, name, udfSharing, _callback);
        return localVarCall;

    }

    /**
     * 
     * Share a UDF with a user
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param name name of UDFInfo (required)
     * @param udfSharing Namespace and list of permissions to share with. An empty list of permissions will remove the namespace; if permissions already exist they will be deleted then new ones added. In the event of a failure, the new policies will be rolled back to prevent partial policies, and it&#39;s likely the UDF will not be shared with the namespace at all. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> UDF shared successfully </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> UDF does not exist or user does not have permissions to share UDF </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public void shareUDFInfo(String namespace, String name, UDFSharing udfSharing) throws ApiException {
        shareUDFInfoWithHttpInfo(namespace, name, udfSharing);
    }

    /**
     * 
     * Share a UDF with a user
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param name name of UDFInfo (required)
     * @param udfSharing Namespace and list of permissions to share with. An empty list of permissions will remove the namespace; if permissions already exist they will be deleted then new ones added. In the event of a failure, the new policies will be rolled back to prevent partial policies, and it&#39;s likely the UDF will not be shared with the namespace at all. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> UDF shared successfully </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> UDF does not exist or user does not have permissions to share UDF </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> shareUDFInfoWithHttpInfo(String namespace, String name, UDFSharing udfSharing) throws ApiException {
        okhttp3.Call localVarCall = shareUDFInfoValidateBeforeCall(namespace, name, udfSharing, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     *  (asynchronously)
     * Share a UDF with a user
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param name name of UDFInfo (required)
     * @param udfSharing Namespace and list of permissions to share with. An empty list of permissions will remove the namespace; if permissions already exist they will be deleted then new ones added. In the event of a failure, the new policies will be rolled back to prevent partial policies, and it&#39;s likely the UDF will not be shared with the namespace at all. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> UDF shared successfully </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> UDF does not exist or user does not have permissions to share UDF </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call shareUDFInfoAsync(String namespace, String name, UDFSharing udfSharing, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = shareUDFInfoValidateBeforeCall(namespace, name, udfSharing, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for submitGenericUDF
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param udf UDF to run (required)
     * @param acceptEncoding Encoding to use (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> UDF completed and the UDF-type specific result is returned </td><td>  * X-TILEDB-CLOUD-TASK-ID - Task ID for just completed request <br>  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  * X-TILEDB-CLOUD-TASK-ID - Task ID for just completed request <br>  </td></tr>
     </table>
     */
    public okhttp3.Call submitGenericUDFCall(String namespace, GenericUDF udf, String acceptEncoding, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = udf;

        // create path and map variables
        String localVarPath = "/udfs/generic/{namespace}"
            .replaceAll("\\{" + "namespace" + "\\}", localVarApiClient.escapeString(namespace.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", localVarApiClient.parameterToString(acceptEncoding));
        }

        final String[] localVarAccepts = {
            "application/octet-stream"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call submitGenericUDFValidateBeforeCall(String namespace, GenericUDF udf, String acceptEncoding, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'namespace' is set
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling submitGenericUDF(Async)");
        }
        
        // verify the required parameter 'udf' is set
        if (udf == null) {
            throw new ApiException("Missing the required parameter 'udf' when calling submitGenericUDF(Async)");
        }
        

        okhttp3.Call localVarCall = submitGenericUDFCall(namespace, udf, acceptEncoding, _callback);
        return localVarCall;

    }

    /**
     * 
     * submit a generic UDF in the given namespace
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param udf UDF to run (required)
     * @param acceptEncoding Encoding to use (optional)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> UDF completed and the UDF-type specific result is returned </td><td>  * X-TILEDB-CLOUD-TASK-ID - Task ID for just completed request <br>  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  * X-TILEDB-CLOUD-TASK-ID - Task ID for just completed request <br>  </td></tr>
     </table>
     */
    public File submitGenericUDF(String namespace, GenericUDF udf, String acceptEncoding) throws ApiException {
        ApiResponse<File> localVarResp = submitGenericUDFWithHttpInfo(namespace, udf, acceptEncoding);
        return localVarResp.getData();
    }

    /**
     * 
     * submit a generic UDF in the given namespace
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param udf UDF to run (required)
     * @param acceptEncoding Encoding to use (optional)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> UDF completed and the UDF-type specific result is returned </td><td>  * X-TILEDB-CLOUD-TASK-ID - Task ID for just completed request <br>  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  * X-TILEDB-CLOUD-TASK-ID - Task ID for just completed request <br>  </td></tr>
     </table>
     */
    public ApiResponse<File> submitGenericUDFWithHttpInfo(String namespace, GenericUDF udf, String acceptEncoding) throws ApiException {
        okhttp3.Call localVarCall = submitGenericUDFValidateBeforeCall(namespace, udf, acceptEncoding, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * submit a generic UDF in the given namespace
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param udf UDF to run (required)
     * @param acceptEncoding Encoding to use (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> UDF completed and the UDF-type specific result is returned </td><td>  * X-TILEDB-CLOUD-TASK-ID - Task ID for just completed request <br>  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  * X-TILEDB-CLOUD-TASK-ID - Task ID for just completed request <br>  </td></tr>
     </table>
     */
    public okhttp3.Call submitGenericUDFAsync(String namespace, GenericUDF udf, String acceptEncoding, final ApiCallback<File> _callback) throws ApiException {

        okhttp3.Call localVarCall = submitGenericUDFValidateBeforeCall(namespace, udf, acceptEncoding, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for submitMultiArrayUDF
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param udf UDF to run (required)
     * @param acceptEncoding Encoding to use (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> UDF completed and the UDF-type specific result is returned </td><td>  * X-TILEDB-CLOUD-TASK-ID - Task ID for just completed request <br>  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  * X-TILEDB-CLOUD-TASK-ID - Task ID for just completed request <br>  </td></tr>
     </table>
     */
    public okhttp3.Call submitMultiArrayUDFCall(String namespace, MultiArrayUDF udf, String acceptEncoding, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = udf;

        // create path and map variables
        String localVarPath = "/udfs/arrays/{namespace}"
            .replaceAll("\\{" + "namespace" + "\\}", localVarApiClient.escapeString(namespace.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", localVarApiClient.parameterToString(acceptEncoding));
        }

        final String[] localVarAccepts = {
            "application/octet-stream"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call submitMultiArrayUDFValidateBeforeCall(String namespace, MultiArrayUDF udf, String acceptEncoding, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'namespace' is set
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling submitMultiArrayUDF(Async)");
        }
        
        // verify the required parameter 'udf' is set
        if (udf == null) {
            throw new ApiException("Missing the required parameter 'udf' when calling submitMultiArrayUDF(Async)");
        }
        

        okhttp3.Call localVarCall = submitMultiArrayUDFCall(namespace, udf, acceptEncoding, _callback);
        return localVarCall;

    }

    /**
     * 
     * submit a multi-array UDF in the given namespace
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param udf UDF to run (required)
     * @param acceptEncoding Encoding to use (optional)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> UDF completed and the UDF-type specific result is returned </td><td>  * X-TILEDB-CLOUD-TASK-ID - Task ID for just completed request <br>  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  * X-TILEDB-CLOUD-TASK-ID - Task ID for just completed request <br>  </td></tr>
     </table>
     */
    public File submitMultiArrayUDF(String namespace, MultiArrayUDF udf, String acceptEncoding) throws ApiException {
        ApiResponse<File> localVarResp = submitMultiArrayUDFWithHttpInfo(namespace, udf, acceptEncoding);
        return localVarResp.getData();
    }

    /**
     * 
     * submit a multi-array UDF in the given namespace
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param udf UDF to run (required)
     * @param acceptEncoding Encoding to use (optional)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> UDF completed and the UDF-type specific result is returned </td><td>  * X-TILEDB-CLOUD-TASK-ID - Task ID for just completed request <br>  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  * X-TILEDB-CLOUD-TASK-ID - Task ID for just completed request <br>  </td></tr>
     </table>
     */
    public ApiResponse<File> submitMultiArrayUDFWithHttpInfo(String namespace, MultiArrayUDF udf, String acceptEncoding) throws ApiException {
        okhttp3.Call localVarCall = submitMultiArrayUDFValidateBeforeCall(namespace, udf, acceptEncoding, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * submit a multi-array UDF in the given namespace
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param udf UDF to run (required)
     * @param acceptEncoding Encoding to use (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> UDF completed and the UDF-type specific result is returned </td><td>  * X-TILEDB-CLOUD-TASK-ID - Task ID for just completed request <br>  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  * X-TILEDB-CLOUD-TASK-ID - Task ID for just completed request <br>  </td></tr>
     </table>
     */
    public okhttp3.Call submitMultiArrayUDFAsync(String namespace, MultiArrayUDF udf, String acceptEncoding, final ApiCallback<File> _callback) throws ApiException {

        okhttp3.Call localVarCall = submitMultiArrayUDFValidateBeforeCall(namespace, udf, acceptEncoding, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for submitUDF
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param udf UDF to run (required)
     * @param xPayer Name of organization or user who should be charged for this request (optional)
     * @param acceptEncoding Encoding to use (optional)
     * @param v2 flag to indicate if v2 array UDFs should be used, currently in beta testing. Setting any value will enable v2 array UDFs. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> UDF completed and the UDF-type specific result is returned </td><td>  * X-TILEDB-CLOUD-TASK-ID - Task ID for just completed request <br>  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  * X-TILEDB-CLOUD-TASK-ID - Task ID for just completed request <br>  </td></tr>
     </table>
     */
    public okhttp3.Call submitUDFCall(String namespace, String array, MultiArrayUDF udf, String xPayer, String acceptEncoding, String v2, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = udf;

        // create path and map variables
        String localVarPath = "/arrays/{namespace}/{array}/udf/submit"
            .replaceAll("\\{" + "namespace" + "\\}", localVarApiClient.escapeString(namespace.toString()))
            .replaceAll("\\{" + "array" + "\\}", localVarApiClient.escapeString(array.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (v2 != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("v2", v2));
        }

        if (xPayer != null) {
            localVarHeaderParams.put("X-Payer", localVarApiClient.parameterToString(xPayer));
        }

        if (acceptEncoding != null) {
            localVarHeaderParams.put("Accept-Encoding", localVarApiClient.parameterToString(acceptEncoding));
        }

        final String[] localVarAccepts = {
            "application/octet-stream"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call submitUDFValidateBeforeCall(String namespace, String array, MultiArrayUDF udf, String xPayer, String acceptEncoding, String v2, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'namespace' is set
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling submitUDF(Async)");
        }
        
        // verify the required parameter 'array' is set
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling submitUDF(Async)");
        }
        
        // verify the required parameter 'udf' is set
        if (udf == null) {
            throw new ApiException("Missing the required parameter 'udf' when calling submitUDF(Async)");
        }
        

        okhttp3.Call localVarCall = submitUDFCall(namespace, array, udf, xPayer, acceptEncoding, v2, _callback);
        return localVarCall;

    }

    /**
     * 
     * send a UDF to run against a specified array/URI registered to a group/project
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param udf UDF to run (required)
     * @param xPayer Name of organization or user who should be charged for this request (optional)
     * @param acceptEncoding Encoding to use (optional)
     * @param v2 flag to indicate if v2 array UDFs should be used, currently in beta testing. Setting any value will enable v2 array UDFs. (optional)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> UDF completed and the UDF-type specific result is returned </td><td>  * X-TILEDB-CLOUD-TASK-ID - Task ID for just completed request <br>  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  * X-TILEDB-CLOUD-TASK-ID - Task ID for just completed request <br>  </td></tr>
     </table>
     */
    public File submitUDF(String namespace, String array, MultiArrayUDF udf, String xPayer, String acceptEncoding, String v2) throws ApiException {
        ApiResponse<File> localVarResp = submitUDFWithHttpInfo(namespace, array, udf, xPayer, acceptEncoding, v2);
        return localVarResp.getData();
    }

    /**
     * 
     * send a UDF to run against a specified array/URI registered to a group/project
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param udf UDF to run (required)
     * @param xPayer Name of organization or user who should be charged for this request (optional)
     * @param acceptEncoding Encoding to use (optional)
     * @param v2 flag to indicate if v2 array UDFs should be used, currently in beta testing. Setting any value will enable v2 array UDFs. (optional)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> UDF completed and the UDF-type specific result is returned </td><td>  * X-TILEDB-CLOUD-TASK-ID - Task ID for just completed request <br>  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  * X-TILEDB-CLOUD-TASK-ID - Task ID for just completed request <br>  </td></tr>
     </table>
     */
    public ApiResponse<File> submitUDFWithHttpInfo(String namespace, String array, MultiArrayUDF udf, String xPayer, String acceptEncoding, String v2) throws ApiException {
        okhttp3.Call localVarCall = submitUDFValidateBeforeCall(namespace, array, udf, xPayer, acceptEncoding, v2, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * send a UDF to run against a specified array/URI registered to a group/project
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param udf UDF to run (required)
     * @param xPayer Name of organization or user who should be charged for this request (optional)
     * @param acceptEncoding Encoding to use (optional)
     * @param v2 flag to indicate if v2 array UDFs should be used, currently in beta testing. Setting any value will enable v2 array UDFs. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> UDF completed and the UDF-type specific result is returned </td><td>  * X-TILEDB-CLOUD-TASK-ID - Task ID for just completed request <br>  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  * X-TILEDB-CLOUD-TASK-ID - Task ID for just completed request <br>  </td></tr>
     </table>
     */
    public okhttp3.Call submitUDFAsync(String namespace, String array, MultiArrayUDF udf, String xPayer, String acceptEncoding, String v2, final ApiCallback<File> _callback) throws ApiException {

        okhttp3.Call localVarCall = submitUDFValidateBeforeCall(namespace, array, udf, xPayer, acceptEncoding, v2, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for udfNamespaceArrayEndTimestampsGet
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param page pagination offset (optional)
     * @param perPage pagination limit (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> list of timestamps in milliseconds, paginated </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call udfNamespaceArrayEndTimestampsGetCall(String namespace, String array, Integer page, Integer perPage, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/udf/{namespace}/{array}/end_timestamps"
            .replaceAll("\\{" + "namespace" + "\\}", localVarApiClient.escapeString(namespace.toString()))
            .replaceAll("\\{" + "array" + "\\}", localVarApiClient.escapeString(array.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (perPage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("per_page", perPage));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call udfNamespaceArrayEndTimestampsGetValidateBeforeCall(String namespace, String array, Integer page, Integer perPage, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'namespace' is set
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling udfNamespaceArrayEndTimestampsGet(Async)");
        }
        
        // verify the required parameter 'array' is set
        if (array == null) {
            throw new ApiException("Missing the required parameter 'array' when calling udfNamespaceArrayEndTimestampsGet(Async)");
        }
        

        okhttp3.Call localVarCall = udfNamespaceArrayEndTimestampsGetCall(namespace, array, page, perPage, _callback);
        return localVarCall;

    }

    /**
     * 
     * retrieve a list of timestamps from the array fragment info listing in milliseconds, paginated
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param page pagination offset (optional)
     * @param perPage pagination limit (optional)
     * @return ArrayEndTimestampData
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> list of timestamps in milliseconds, paginated </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ArrayEndTimestampData udfNamespaceArrayEndTimestampsGet(String namespace, String array, Integer page, Integer perPage) throws ApiException {
        ApiResponse<ArrayEndTimestampData> localVarResp = udfNamespaceArrayEndTimestampsGetWithHttpInfo(namespace, array, page, perPage);
        return localVarResp.getData();
    }

    /**
     * 
     * retrieve a list of timestamps from the array fragment info listing in milliseconds, paginated
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param page pagination offset (optional)
     * @param perPage pagination limit (optional)
     * @return ApiResponse&lt;ArrayEndTimestampData&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> list of timestamps in milliseconds, paginated </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ArrayEndTimestampData> udfNamespaceArrayEndTimestampsGetWithHttpInfo(String namespace, String array, Integer page, Integer perPage) throws ApiException {
        okhttp3.Call localVarCall = udfNamespaceArrayEndTimestampsGetValidateBeforeCall(namespace, array, page, perPage, null);
        Type localVarReturnType = new TypeToken<ArrayEndTimestampData>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     *  (asynchronously)
     * retrieve a list of timestamps from the array fragment info listing in milliseconds, paginated
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param array name/uri of array that is url-encoded (required)
     * @param page pagination offset (optional)
     * @param perPage pagination limit (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> list of timestamps in milliseconds, paginated </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call udfNamespaceArrayEndTimestampsGetAsync(String namespace, String array, Integer page, Integer perPage, final ApiCallback<ArrayEndTimestampData> _callback) throws ApiException {

        okhttp3.Call localVarCall = udfNamespaceArrayEndTimestampsGetValidateBeforeCall(namespace, array, page, perPage, _callback);
        Type localVarReturnType = new TypeToken<ArrayEndTimestampData>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateUDFInfo
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param name name to register UDF under (required)
     * @param udf UDF to update (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> UDF updated successfully </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateUDFInfoCall(String namespace, String name, UDFInfoUpdate udf, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = udf;

        // create path and map variables
        String localVarPath = "/udf/{namespace}/{name}"
            .replaceAll("\\{" + "namespace" + "\\}", localVarApiClient.escapeString(namespace.toString()))
            .replaceAll("\\{" + "name" + "\\}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "ApiKeyAuth", "BasicAuth" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateUDFInfoValidateBeforeCall(String namespace, String name, UDFInfoUpdate udf, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'namespace' is set
        if (namespace == null) {
            throw new ApiException("Missing the required parameter 'namespace' when calling updateUDFInfo(Async)");
        }
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateUDFInfo(Async)");
        }
        
        // verify the required parameter 'udf' is set
        if (udf == null) {
            throw new ApiException("Missing the required parameter 'udf' when calling updateUDFInfo(Async)");
        }
        

        okhttp3.Call localVarCall = updateUDFInfoCall(namespace, name, udf, _callback);
        return localVarCall;

    }

    /**
     * 
     * update an existing registered UDF in the given namespace
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param name name to register UDF under (required)
     * @param udf UDF to update (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> UDF updated successfully </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public void updateUDFInfo(String namespace, String name, UDFInfoUpdate udf) throws ApiException {
        updateUDFInfoWithHttpInfo(namespace, name, udf);
    }

    /**
     * 
     * update an existing registered UDF in the given namespace
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param name name to register UDF under (required)
     * @param udf UDF to update (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> UDF updated successfully </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> updateUDFInfoWithHttpInfo(String namespace, String name, UDFInfoUpdate udf) throws ApiException {
        okhttp3.Call localVarCall = updateUDFInfoValidateBeforeCall(namespace, name, udf, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     *  (asynchronously)
     * update an existing registered UDF in the given namespace
     * @param namespace namespace array is in (an organization name or user&#39;s username) (required)
     * @param name name to register UDF under (required)
     * @param udf UDF to update (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> UDF updated successfully </td><td>  -  </td></tr>
        <tr><td> 0 </td><td> error response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateUDFInfoAsync(String namespace, String name, UDFInfoUpdate udf, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateUDFInfoValidateBeforeCall(namespace, name, udf, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}
