/*
 * TileDB Storage Platform API
 * TileDB Storage Platform REST API
 *
 * The version of the OpenAPI document: 2.2.19
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.tiledb.cloud.rest_api.model;

import java.util.Objects;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.util.HashSet;
import java.util.Map.Entry;
import java.util.Set;

import io.tiledb.cloud.rest_api.JSON;

/**
 * key/value pair representing an array metadata map entry
 */
@ApiModel(description = "key/value pair representing an array metadata map entry")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-09-14T18:46:41.869452+03:00[Europe/Athens]")
public class ArrayMetadataEntry {
  public static final String SERIALIZED_NAME_KEY = "key";
  @SerializedName(SERIALIZED_NAME_KEY)
  private String key;

  public static final String SERIALIZED_NAME_TYPE = "type";
  @SerializedName(SERIALIZED_NAME_TYPE)
  private String type;

  public static final String SERIALIZED_NAME_VALUE_NUM = "valueNum";
  @SerializedName(SERIALIZED_NAME_VALUE_NUM)
  private Integer valueNum;

  public static final String SERIALIZED_NAME_VALUE = "value";
  @SerializedName(SERIALIZED_NAME_VALUE)
  private List<Integer> value = null;

  public static final String SERIALIZED_NAME_DEL = "del";
  @SerializedName(SERIALIZED_NAME_DEL)
  private Boolean del;

  public ArrayMetadataEntry() { 
  }

  public ArrayMetadataEntry key(String key) {
    
    this.key = key;
    return this;
  }

   /**
   * Get key
   * @return key
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public String getKey() {
    return key;
  }


  public void setKey(String key) {
    this.key = key;
  }


  public ArrayMetadataEntry type(String type) {
    
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public String getType() {
    return type;
  }


  public void setType(String type) {
    this.type = type;
  }


  public ArrayMetadataEntry valueNum(Integer valueNum) {
    
    this.valueNum = valueNum;
    return this;
  }

   /**
   * Get valueNum
   * @return valueNum
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Integer getValueNum() {
    return valueNum;
  }


  public void setValueNum(Integer valueNum) {
    this.valueNum = valueNum;
  }


  public ArrayMetadataEntry value(List<Integer> value) {
    
    this.value = value;
    return this;
  }

  public ArrayMetadataEntry addValueItem(Integer valueItem) {
    if (this.value == null) {
      this.value = new ArrayList<>();
    }
    this.value.add(valueItem);
    return this;
  }

   /**
   * Get value
   * @return value
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public List<Integer> getValue() {
    return value;
  }


  public void setValue(List<Integer> value) {
    this.value = value;
  }


  public ArrayMetadataEntry del(Boolean del) {
    
    this.del = del;
    return this;
  }

   /**
   * Get del
   * @return del
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Boolean getDel() {
    return del;
  }


  public void setDel(Boolean del) {
    this.del = del;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ArrayMetadataEntry arrayMetadataEntry = (ArrayMetadataEntry) o;
    return Objects.equals(this.key, arrayMetadataEntry.key) &&
        Objects.equals(this.type, arrayMetadataEntry.type) &&
        Objects.equals(this.valueNum, arrayMetadataEntry.valueNum) &&
        Objects.equals(this.value, arrayMetadataEntry.value) &&
        Objects.equals(this.del, arrayMetadataEntry.del);
  }

  @Override
  public int hashCode() {
    return Objects.hash(key, type, valueNum, value, del);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ArrayMetadataEntry {\n");
    sb.append("    key: ").append(toIndentedString(key)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    valueNum: ").append(toIndentedString(valueNum)).append("\n");
    sb.append("    value: ").append(toIndentedString(value)).append("\n");
    sb.append("    del: ").append(toIndentedString(del)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("key");
    openapiFields.add("type");
    openapiFields.add("valueNum");
    openapiFields.add("value");
    openapiFields.add("del");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to ArrayMetadataEntry
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (ArrayMetadataEntry.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in ArrayMetadataEntry is not found in the empty JSON string", ArrayMetadataEntry.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
//      for (Entry<String, JsonElement> entry : entries) {
//        if (!ArrayMetadataEntry.openapiFields.contains(entry.getKey())) {
//          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `ArrayMetadataEntry` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
//        }
//      }
      if (jsonObj.get("key") != null && !jsonObj.get("key").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `key` to be a primitive type in the JSON string but got `%s`", jsonObj.get("key").toString()));
      }
      if (jsonObj.get("type") != null && !jsonObj.get("type").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get("type").toString()));
      }
      // ensure the json data is an array
      if (jsonObj.get("value") != null && !jsonObj.get("value").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `value` to be an array in the JSON string but got `%s`", jsonObj.get("value").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!ArrayMetadataEntry.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'ArrayMetadataEntry' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<ArrayMetadataEntry> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(ArrayMetadataEntry.class));

       return (TypeAdapter<T>) new TypeAdapter<ArrayMetadataEntry>() {
           @Override
           public void write(JsonWriter out, ArrayMetadataEntry value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public ArrayMetadataEntry read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of ArrayMetadataEntry given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of ArrayMetadataEntry
  * @throws IOException if the JSON string is invalid with respect to ArrayMetadataEntry
  */
  public static ArrayMetadataEntry fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, ArrayMetadataEntry.class);
  }

 /**
  * Convert an instance of ArrayMetadataEntry to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

