/*
 * TileDB Storage Platform API
 * TileDB Storage Platform REST API
 *
 * The version of the OpenAPI document: 2.2.19
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.tiledb.cloud.rest_api.model;

import java.util.Objects;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import io.tiledb.cloud.rest_api.JSON;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.util.HashSet;
import java.util.Map.Entry;
import java.util.Set;

/**
 * ArraySchema during creation or retrieval
 */
@ApiModel(description = "ArraySchema during creation or retrieval")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-09-14T18:46:41.869452+03:00[Europe/Athens]")
public class ArraySchema {
  public static final String SERIALIZED_NAME_URI = "uri";
  @SerializedName(SERIALIZED_NAME_URI)
  private String uri;

  public static final String SERIALIZED_NAME_VERSION = "version";
  @SerializedName(SERIALIZED_NAME_VERSION)
  private List<Integer> version = new ArrayList<>();

  public static final String SERIALIZED_NAME_ARRAY_TYPE = "arrayType";
  @SerializedName(SERIALIZED_NAME_ARRAY_TYPE)
  private ArrayType arrayType;

  public static final String SERIALIZED_NAME_TILE_ORDER = "tileOrder";
  @SerializedName(SERIALIZED_NAME_TILE_ORDER)
  private Layout tileOrder;

  public static final String SERIALIZED_NAME_CELL_ORDER = "cellOrder";
  @SerializedName(SERIALIZED_NAME_CELL_ORDER)
  private Layout cellOrder;

  public static final String SERIALIZED_NAME_CAPACITY = "capacity";
  @SerializedName(SERIALIZED_NAME_CAPACITY)
  private Integer capacity;

  public static final String SERIALIZED_NAME_COORDS_FILTER_PIPELINE = "coordsFilterPipeline";
  @SerializedName(SERIALIZED_NAME_COORDS_FILTER_PIPELINE)
  private FilterPipeline coordsFilterPipeline;

  public static final String SERIALIZED_NAME_OFFSET_FILTER_PIPELINE = "offsetFilterPipeline";
  @SerializedName(SERIALIZED_NAME_OFFSET_FILTER_PIPELINE)
  private FilterPipeline offsetFilterPipeline;

  public static final String SERIALIZED_NAME_DOMAIN = "domain";
  @SerializedName(SERIALIZED_NAME_DOMAIN)
  private Domain domain;

  public static final String SERIALIZED_NAME_ATTRIBUTES = "attributes";
  @SerializedName(SERIALIZED_NAME_ATTRIBUTES)
  private List<Attribute> attributes = new ArrayList<>();

  public static final String SERIALIZED_NAME_ALLOWS_DUPLICATES = "allowsDuplicates";
  @SerializedName(SERIALIZED_NAME_ALLOWS_DUPLICATES)
  private Boolean allowsDuplicates;

  public ArraySchema() { 
  }

  public ArraySchema uri(String uri) {
    
    this.uri = uri;
    return this;
  }

   /**
   * URI of schema
   * @return uri
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "s3://<bucket>/test_array", value = "URI of schema")

  public String getUri() {
    return uri;
  }


  public void setUri(String uri) {
    this.uri = uri;
  }


  public ArraySchema version(List<Integer> version) {
    
    this.version = version;
    return this;
  }

  public ArraySchema addVersionItem(Integer versionItem) {
    this.version.add(versionItem);
    return this;
  }

   /**
   * file format version
   * @return version
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "[1, 3, 0]", required = true, value = "file format version")

  public List<Integer> getVersion() {
    return version;
  }


  public void setVersion(List<Integer> version) {
    this.version = version;
  }


  public ArraySchema arrayType(ArrayType arrayType) {
    
    this.arrayType = arrayType;
    return this;
  }

   /**
   * Get arrayType
   * @return arrayType
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")

  public ArrayType getArrayType() {
    return arrayType;
  }


  public void setArrayType(ArrayType arrayType) {
    this.arrayType = arrayType;
  }


  public ArraySchema tileOrder(Layout tileOrder) {
    
    this.tileOrder = tileOrder;
    return this;
  }

   /**
   * Get tileOrder
   * @return tileOrder
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")

  public Layout getTileOrder() {
    return tileOrder;
  }


  public void setTileOrder(Layout tileOrder) {
    this.tileOrder = tileOrder;
  }


  public ArraySchema cellOrder(Layout cellOrder) {
    
    this.cellOrder = cellOrder;
    return this;
  }

   /**
   * Get cellOrder
   * @return cellOrder
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")

  public Layout getCellOrder() {
    return cellOrder;
  }


  public void setCellOrder(Layout cellOrder) {
    this.cellOrder = cellOrder;
  }


  public ArraySchema capacity(Integer capacity) {
    
    this.capacity = capacity;
    return this;
  }

   /**
   * Capacity of array
   * @return capacity
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "100000", required = true, value = "Capacity of array")

  public Integer getCapacity() {
    return capacity;
  }


  public void setCapacity(Integer capacity) {
    this.capacity = capacity;
  }


  public ArraySchema coordsFilterPipeline(FilterPipeline coordsFilterPipeline) {
    
    this.coordsFilterPipeline = coordsFilterPipeline;
    return this;
  }

   /**
   * Get coordsFilterPipeline
   * @return coordsFilterPipeline
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")

  public FilterPipeline getCoordsFilterPipeline() {
    return coordsFilterPipeline;
  }


  public void setCoordsFilterPipeline(FilterPipeline coordsFilterPipeline) {
    this.coordsFilterPipeline = coordsFilterPipeline;
  }


  public ArraySchema offsetFilterPipeline(FilterPipeline offsetFilterPipeline) {
    
    this.offsetFilterPipeline = offsetFilterPipeline;
    return this;
  }

   /**
   * Get offsetFilterPipeline
   * @return offsetFilterPipeline
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")

  public FilterPipeline getOffsetFilterPipeline() {
    return offsetFilterPipeline;
  }


  public void setOffsetFilterPipeline(FilterPipeline offsetFilterPipeline) {
    this.offsetFilterPipeline = offsetFilterPipeline;
  }


  public ArraySchema domain(Domain domain) {
    
    this.domain = domain;
    return this;
  }

   /**
   * Get domain
   * @return domain
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")

  public Domain getDomain() {
    return domain;
  }


  public void setDomain(Domain domain) {
    this.domain = domain;
  }


  public ArraySchema attributes(List<Attribute> attributes) {
    
    this.attributes = attributes;
    return this;
  }

  public ArraySchema addAttributesItem(Attribute attributesItem) {
    this.attributes.add(attributesItem);
    return this;
  }

   /**
   * Attributes of array
   * @return attributes
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "Attributes of array")

  public List<Attribute> getAttributes() {
    return attributes;
  }


  public void setAttributes(List<Attribute> attributes) {
    this.attributes = attributes;
  }


  public ArraySchema allowsDuplicates(Boolean allowsDuplicates) {
    
    this.allowsDuplicates = allowsDuplicates;
    return this;
  }

   /**
   * True if the array allows coordinate duplicates. Applicable only to sparse arrays.
   * @return allowsDuplicates
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "True if the array allows coordinate duplicates. Applicable only to sparse arrays.")

  public Boolean getAllowsDuplicates() {
    return allowsDuplicates;
  }


  public void setAllowsDuplicates(Boolean allowsDuplicates) {
    this.allowsDuplicates = allowsDuplicates;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ArraySchema arraySchema = (ArraySchema) o;
    return Objects.equals(this.uri, arraySchema.uri) &&
        Objects.equals(this.version, arraySchema.version) &&
        Objects.equals(this.arrayType, arraySchema.arrayType) &&
        Objects.equals(this.tileOrder, arraySchema.tileOrder) &&
        Objects.equals(this.cellOrder, arraySchema.cellOrder) &&
        Objects.equals(this.capacity, arraySchema.capacity) &&
        Objects.equals(this.coordsFilterPipeline, arraySchema.coordsFilterPipeline) &&
        Objects.equals(this.offsetFilterPipeline, arraySchema.offsetFilterPipeline) &&
        Objects.equals(this.domain, arraySchema.domain) &&
        Objects.equals(this.attributes, arraySchema.attributes) &&
        Objects.equals(this.allowsDuplicates, arraySchema.allowsDuplicates);
  }

  @Override
  public int hashCode() {
    return Objects.hash(uri, version, arrayType, tileOrder, cellOrder, capacity, coordsFilterPipeline, offsetFilterPipeline, domain, attributes, allowsDuplicates);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ArraySchema {\n");
    sb.append("    uri: ").append(toIndentedString(uri)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    arrayType: ").append(toIndentedString(arrayType)).append("\n");
    sb.append("    tileOrder: ").append(toIndentedString(tileOrder)).append("\n");
    sb.append("    cellOrder: ").append(toIndentedString(cellOrder)).append("\n");
    sb.append("    capacity: ").append(toIndentedString(capacity)).append("\n");
    sb.append("    coordsFilterPipeline: ").append(toIndentedString(coordsFilterPipeline)).append("\n");
    sb.append("    offsetFilterPipeline: ").append(toIndentedString(offsetFilterPipeline)).append("\n");
    sb.append("    domain: ").append(toIndentedString(domain)).append("\n");
    sb.append("    attributes: ").append(toIndentedString(attributes)).append("\n");
    sb.append("    allowsDuplicates: ").append(toIndentedString(allowsDuplicates)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("uri");
    openapiFields.add("version");
    openapiFields.add("arrayType");
    openapiFields.add("tileOrder");
    openapiFields.add("cellOrder");
    openapiFields.add("capacity");
    openapiFields.add("coordsFilterPipeline");
    openapiFields.add("offsetFilterPipeline");
    openapiFields.add("domain");
    openapiFields.add("attributes");
    openapiFields.add("allowsDuplicates");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("version");
    openapiRequiredFields.add("arrayType");
    openapiRequiredFields.add("tileOrder");
    openapiRequiredFields.add("cellOrder");
    openapiRequiredFields.add("capacity");
    openapiRequiredFields.add("coordsFilterPipeline");
    openapiRequiredFields.add("offsetFilterPipeline");
    openapiRequiredFields.add("domain");
    openapiRequiredFields.add("attributes");
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to ArraySchema
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (ArraySchema.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in ArraySchema is not found in the empty JSON string", ArraySchema.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
//      for (Entry<String, JsonElement> entry : entries) {
//        if (!ArraySchema.openapiFields.contains(entry.getKey())) {
//          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `ArraySchema` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
//        }
//      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : ArraySchema.openapiRequiredFields) {
        if (jsonObj.get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
      }
      if (jsonObj.get("uri") != null && !jsonObj.get("uri").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `uri` to be a primitive type in the JSON string but got `%s`", jsonObj.get("uri").toString()));
      }
      // ensure the json data is an array
      if (jsonObj.get("version") != null && !jsonObj.get("version").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `version` to be an array in the JSON string but got `%s`", jsonObj.get("version").toString()));
      }
      // validate the optional field `coordsFilterPipeline`
      if (jsonObj.getAsJsonObject("coordsFilterPipeline") != null) {
        FilterPipeline.validateJsonObject(jsonObj.getAsJsonObject("coordsFilterPipeline"));
      }
      // validate the optional field `offsetFilterPipeline`
      if (jsonObj.getAsJsonObject("offsetFilterPipeline") != null) {
        FilterPipeline.validateJsonObject(jsonObj.getAsJsonObject("offsetFilterPipeline"));
      }
      // validate the optional field `domain`
      if (jsonObj.getAsJsonObject("domain") != null) {
        Domain.validateJsonObject(jsonObj.getAsJsonObject("domain"));
      }
      JsonArray jsonArrayattributes = jsonObj.getAsJsonArray("attributes");
      if (jsonArrayattributes != null) {
        // ensure the json data is an array
        if (!jsonObj.get("attributes").isJsonArray()) {
          throw new IllegalArgumentException(String.format("Expected the field `attributes` to be an array in the JSON string but got `%s`", jsonObj.get("attributes").toString()));
        }

        // validate the optional field `attributes` (array)
        for (int i = 0; i < jsonArrayattributes.size(); i++) {
          Attribute.validateJsonObject(jsonArrayattributes.get(i).getAsJsonObject());
        };
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!ArraySchema.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'ArraySchema' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<ArraySchema> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(ArraySchema.class));

       return (TypeAdapter<T>) new TypeAdapter<ArraySchema>() {
           @Override
           public void write(JsonWriter out, ArraySchema value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public ArraySchema read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of ArraySchema given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of ArraySchema
  * @throws IOException if the JSON string is invalid with respect to ArraySchema
  */
  public static ArraySchema fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, ArraySchema.class);
  }

 /**
  * Convert an instance of ArraySchema to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

