/*
 * TileDB Storage Platform API
 * TileDB Storage Platform REST API
 *
 * The version of the OpenAPI document: 2.2.19
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.tiledb.cloud.rest_api.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;

import io.tiledb.cloud.rest_api.JSON;
import org.openapitools.jackson.nullable.JsonNullable;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.util.HashSet;
import java.util.Map.Entry;
import java.util.Set;

/**
 * Synchronous Task to Run
 */
@ApiModel(description = "Synchronous Task to Run")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-09-14T18:46:41.869452+03:00[Europe/Athens]")
public class ArrayTask {
  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private String id;

  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_DESCRIPTION = "description";
  @SerializedName(SERIALIZED_NAME_DESCRIPTION)
  private String description;

  public static final String SERIALIZED_NAME_ARRAY_METADATA = "array_metadata";
  @SerializedName(SERIALIZED_NAME_ARRAY_METADATA)
  private ArrayInfo arrayMetadata;

  public static final String SERIALIZED_NAME_SUBARRAY = "subarray";
  @SerializedName(SERIALIZED_NAME_SUBARRAY)
  private DomainArray subarray;

  public static final String SERIALIZED_NAME_MEMORY = "memory";
  @SerializedName(SERIALIZED_NAME_MEMORY)
  private Integer memory;

  public static final String SERIALIZED_NAME_CPU = "cpu";
  @SerializedName(SERIALIZED_NAME_CPU)
  private Integer cpu;

  public static final String SERIALIZED_NAME_NAMESPACE = "namespace";
  @SerializedName(SERIALIZED_NAME_NAMESPACE)
  private String namespace;

  public static final String SERIALIZED_NAME_STATUS = "status";
  @SerializedName(SERIALIZED_NAME_STATUS)
  private ArrayTaskStatus status;

  public static final String SERIALIZED_NAME_START_TIME = "start_time";
  @SerializedName(SERIALIZED_NAME_START_TIME)
  private OffsetDateTime startTime;

  public static final String SERIALIZED_NAME_FINISH_TIME = "finish_time";
  @SerializedName(SERIALIZED_NAME_FINISH_TIME)
  private OffsetDateTime finishTime;

  public static final String SERIALIZED_NAME_COST = "cost";
  @SerializedName(SERIALIZED_NAME_COST)
  private Double cost;

  public static final String SERIALIZED_NAME_EGRESS_COST = "egress_cost";
  @SerializedName(SERIALIZED_NAME_EGRESS_COST)
  private Double egressCost;

  public static final String SERIALIZED_NAME_ACCESS_COST = "access_cost";
  @SerializedName(SERIALIZED_NAME_ACCESS_COST)
  private Double accessCost;

  public static final String SERIALIZED_NAME_QUERY_TYPE = "query_type";
  @SerializedName(SERIALIZED_NAME_QUERY_TYPE)
  private Querytype queryType;

  public static final String SERIALIZED_NAME_UDF_CODE = "udf_code";
  @SerializedName(SERIALIZED_NAME_UDF_CODE)
  private String udfCode;

  public static final String SERIALIZED_NAME_UDF_LANGUAGE = "udf_language";
  @SerializedName(SERIALIZED_NAME_UDF_LANGUAGE)
  private String udfLanguage;

  public static final String SERIALIZED_NAME_SQL_QUERY = "sql_query";
  @SerializedName(SERIALIZED_NAME_SQL_QUERY)
  private String sqlQuery;

  public static final String SERIALIZED_NAME_TYPE = "type";
  @SerializedName(SERIALIZED_NAME_TYPE)
  private ArrayTaskType type;

  public static final String SERIALIZED_NAME_ACTIVITY = "activity";
  @SerializedName(SERIALIZED_NAME_ACTIVITY)
  private List<ArrayActivityLog> activity = null;

  public static final String SERIALIZED_NAME_LOGS = "logs";
  @SerializedName(SERIALIZED_NAME_LOGS)
  private String logs;

  public static final String SERIALIZED_NAME_DURATION = "duration";
  @SerializedName(SERIALIZED_NAME_DURATION)
  private BigDecimal duration;

  public static final String SERIALIZED_NAME_SQL_INIT_COMMANDS = "sql_init_commands";
  @SerializedName(SERIALIZED_NAME_SQL_INIT_COMMANDS)
  private List<String> sqlInitCommands = null;

  public static final String SERIALIZED_NAME_SQL_PARAMETERS = "sql_parameters";
  @SerializedName(SERIALIZED_NAME_SQL_PARAMETERS)
  private List<Object> sqlParameters = null;

  public static final String SERIALIZED_NAME_RESULT_FORMAT = "result_format";
  @SerializedName(SERIALIZED_NAME_RESULT_FORMAT)
  private ResultFormat resultFormat;

  public static final String SERIALIZED_NAME_TASK_GRAPH_UUID = "task_graph_uuid";
  @SerializedName(SERIALIZED_NAME_TASK_GRAPH_UUID)
  private String taskGraphUuid;

  public static final String SERIALIZED_NAME_CLIENT_NODE_UUID = "client_node_uuid";
  @SerializedName(SERIALIZED_NAME_CLIENT_NODE_UUID)
  private String clientNodeUuid;

  public ArrayTask() { 
  }

  public ArrayTask id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * task ID
   * @return id
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "task ID")

  public String getId() {
    return id;
  }


  public void setId(String id) {
    this.id = id;
  }


  public ArrayTask name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Optional task name
   * @return name
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "subarray-multiplier", value = "Optional task name")

  public String getName() {
    return name;
  }


  public void setName(String name) {
    this.name = name;
  }


  public ArrayTask description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * Optional task description (Tasks purpose)
   * @return description
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "Return attr a1 in the subarray bounded by coordinates and multiply attr1 by 2", value = "Optional task description (Tasks purpose)")

  public String getDescription() {
    return description;
  }


  public void setDescription(String description) {
    this.description = description;
  }


  public ArrayTask arrayMetadata(ArrayInfo arrayMetadata) {
    
    this.arrayMetadata = arrayMetadata;
    return this;
  }

   /**
   * Get arrayMetadata
   * @return arrayMetadata
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public ArrayInfo getArrayMetadata() {
    return arrayMetadata;
  }


  public void setArrayMetadata(ArrayInfo arrayMetadata) {
    this.arrayMetadata = arrayMetadata;
  }


  public ArrayTask subarray(DomainArray subarray) {
    
    this.subarray = subarray;
    return this;
  }

   /**
   * Get subarray
   * @return subarray
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public DomainArray getSubarray() {
    return subarray;
  }


  public void setSubarray(DomainArray subarray) {
    this.subarray = subarray;
  }


  public ArrayTask memory(Integer memory) {
    
    this.memory = memory;
    return this;
  }

   /**
   * memory allocated to task in bytes
   * @return memory
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "1073741824", value = "memory allocated to task in bytes")

  public Integer getMemory() {
    return memory;
  }


  public void setMemory(Integer memory) {
    this.memory = memory;
  }


  public ArrayTask cpu(Integer cpu) {
    
    this.cpu = cpu;
    return this;
  }

   /**
   * millicpu allocated to task
   * @return cpu
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "4000", value = "millicpu allocated to task")

  public Integer getCpu() {
    return cpu;
  }


  public void setCpu(Integer cpu) {
    this.cpu = cpu;
  }


  public ArrayTask namespace(String namespace) {
    
    this.namespace = namespace;
    return this;
  }

   /**
   * namespace task is tied to
   * @return namespace
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "organization1", value = "namespace task is tied to")

  public String getNamespace() {
    return namespace;
  }


  public void setNamespace(String namespace) {
    this.namespace = namespace;
  }


  public ArrayTask status(ArrayTaskStatus status) {
    
    this.status = status;
    return this;
  }

   /**
   * Get status
   * @return status
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public ArrayTaskStatus getStatus() {
    return status;
  }


  public void setStatus(ArrayTaskStatus status) {
    this.status = status;
  }


  public ArrayTask startTime(OffsetDateTime startTime) {
    
    this.startTime = startTime;
    return this;
  }

   /**
   * Start time RFC3339 for job
   * @return startTime
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Start time RFC3339 for job")

  public OffsetDateTime getStartTime() {
    return startTime;
  }


  public void setStartTime(OffsetDateTime startTime) {
    this.startTime = startTime;
  }


  public ArrayTask finishTime(OffsetDateTime finishTime) {
    
    this.finishTime = finishTime;
    return this;
  }

   /**
   * Finish time RFC3339 for job
   * @return finishTime
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Finish time RFC3339 for job")

  public OffsetDateTime getFinishTime() {
    return finishTime;
  }


  public void setFinishTime(OffsetDateTime finishTime) {
    this.finishTime = finishTime;
  }


  public ArrayTask cost(Double cost) {
    
    this.cost = cost;
    return this;
  }

   /**
   * Total accumulated for task in USD, example is $0.12
   * @return cost
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "0.12", value = "Total accumulated for task in USD, example is $0.12")

  public Double getCost() {
    return cost;
  }


  public void setCost(Double cost) {
    this.cost = cost;
  }


  public ArrayTask egressCost(Double egressCost) {
    
    this.egressCost = egressCost;
    return this;
  }

   /**
   * Total accumulated for egress task in USD, example is $0.12
   * @return egressCost
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "0.12", value = "Total accumulated for egress task in USD, example is $0.12")

  public Double getEgressCost() {
    return egressCost;
  }


  public void setEgressCost(Double egressCost) {
    this.egressCost = egressCost;
  }


  public ArrayTask accessCost(Double accessCost) {
    
    this.accessCost = accessCost;
    return this;
  }

   /**
   * Cost accumulated for access task in USD, example is $0.12
   * @return accessCost
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "0.12", value = "Cost accumulated for access task in USD, example is $0.12")

  public Double getAccessCost() {
    return accessCost;
  }


  public void setAccessCost(Double accessCost) {
    this.accessCost = accessCost;
  }


  public ArrayTask queryType(Querytype queryType) {
    
    this.queryType = queryType;
    return this;
  }

   /**
   * Get queryType
   * @return queryType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Querytype getQueryType() {
    return queryType;
  }


  public void setQueryType(Querytype queryType) {
    this.queryType = queryType;
  }


  public ArrayTask udfCode(String udfCode) {
    
    this.udfCode = udfCode;
    return this;
  }

   /**
   * Optional actual code that is going to be executed
   * @return udfCode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Optional actual code that is going to be executed")

  public String getUdfCode() {
    return udfCode;
  }


  public void setUdfCode(String udfCode) {
    this.udfCode = udfCode;
  }


  public ArrayTask udfLanguage(String udfLanguage) {
    
    this.udfLanguage = udfLanguage;
    return this;
  }

   /**
   * Optional actual language used to express udf_code
   * @return udfLanguage
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Optional actual language used to express udf_code")

  public String getUdfLanguage() {
    return udfLanguage;
  }


  public void setUdfLanguage(String udfLanguage) {
    this.udfLanguage = udfLanguage;
  }


  public ArrayTask sqlQuery(String sqlQuery) {
    
    this.sqlQuery = sqlQuery;
    return this;
  }

   /**
   * Optional actual sql query that is going to be executed
   * @return sqlQuery
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Optional actual sql query that is going to be executed")

  public String getSqlQuery() {
    return sqlQuery;
  }


  public void setSqlQuery(String sqlQuery) {
    this.sqlQuery = sqlQuery;
  }


  public ArrayTask type(ArrayTaskType type) {
    
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public ArrayTaskType getType() {
    return type;
  }


  public void setType(ArrayTaskType type) {
    this.type = type;
  }


  public ArrayTask activity(List<ArrayActivityLog> activity) {
    
    this.activity = activity;
    return this;
  }

  public ArrayTask addActivityItem(ArrayActivityLog activityItem) {
    if (this.activity == null) {
      this.activity = new ArrayList<>();
    }
    this.activity.add(activityItem);
    return this;
  }

   /**
   * Array activity logs for task
   * @return activity
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Array activity logs for task")

  public List<ArrayActivityLog> getActivity() {
    return activity;
  }


  public void setActivity(List<ArrayActivityLog> activity) {
    this.activity = activity;
  }


  public ArrayTask logs(String logs) {
    
    this.logs = logs;
    return this;
  }

   /**
   * logs from array task
   * @return logs
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "logs from array task")

  public String getLogs() {
    return logs;
  }


  public void setLogs(String logs) {
    this.logs = logs;
  }


  public ArrayTask duration(BigDecimal duration) {
    
    this.duration = duration;
    return this;
  }

   /**
   * duration in nanoseconds of an array task
   * @return duration
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "3.41E+11", value = "duration in nanoseconds of an array task")

  public BigDecimal getDuration() {
    return duration;
  }


  public void setDuration(BigDecimal duration) {
    this.duration = duration;
  }


  public ArrayTask sqlInitCommands(List<String> sqlInitCommands) {
    
    this.sqlInitCommands = sqlInitCommands;
    return this;
  }

  public ArrayTask addSqlInitCommandsItem(String sqlInitCommandsItem) {
    if (this.sqlInitCommands == null) {
      this.sqlInitCommands = new ArrayList<>();
    }
    this.sqlInitCommands.add(sqlInitCommandsItem);
    return this;
  }

   /**
   * SQL queries or commands to run before main sql query
   * @return sqlInitCommands
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "SQL queries or commands to run before main sql query")

  public List<String> getSqlInitCommands() {
    return sqlInitCommands;
  }


  public void setSqlInitCommands(List<String> sqlInitCommands) {
    this.sqlInitCommands = sqlInitCommands;
  }


  public ArrayTask sqlParameters(List<Object> sqlParameters) {
    
    this.sqlParameters = sqlParameters;
    return this;
  }

  public ArrayTask addSqlParametersItem(Object sqlParametersItem) {
    if (this.sqlParameters == null) {
      this.sqlParameters = new ArrayList<>();
    }
    this.sqlParameters.add(sqlParametersItem);
    return this;
  }

   /**
   * SQL query parameters
   * @return sqlParameters
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "SQL query parameters")

  public List<Object> getSqlParameters() {
    return sqlParameters;
  }


  public void setSqlParameters(List<Object> sqlParameters) {
    this.sqlParameters = sqlParameters;
  }


  public ArrayTask resultFormat(ResultFormat resultFormat) {
    
    this.resultFormat = resultFormat;
    return this;
  }

   /**
   * Get resultFormat
   * @return resultFormat
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public ResultFormat getResultFormat() {
    return resultFormat;
  }


  public void setResultFormat(ResultFormat resultFormat) {
    this.resultFormat = resultFormat;
  }


  public ArrayTask taskGraphUuid(String taskGraphUuid) {
    
    this.taskGraphUuid = taskGraphUuid;
    return this;
  }

   /**
   * If set, the ID of the log for the task graph that this was part of. 
   * @return taskGraphUuid
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "If set, the ID of the log for the task graph that this was part of. ")

  public String getTaskGraphUuid() {
    return taskGraphUuid;
  }


  public void setTaskGraphUuid(String taskGraphUuid) {
    this.taskGraphUuid = taskGraphUuid;
  }


  public ArrayTask clientNodeUuid(String clientNodeUuid) {
    
    this.clientNodeUuid = clientNodeUuid;
    return this;
  }

   /**
   * If set, the client-defined ID of the node within this task&#39;s graph. 
   * @return clientNodeUuid
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "If set, the client-defined ID of the node within this task's graph. ")

  public String getClientNodeUuid() {
    return clientNodeUuid;
  }


  public void setClientNodeUuid(String clientNodeUuid) {
    this.clientNodeUuid = clientNodeUuid;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ArrayTask arrayTask = (ArrayTask) o;
    return Objects.equals(this.id, arrayTask.id) &&
        Objects.equals(this.name, arrayTask.name) &&
        Objects.equals(this.description, arrayTask.description) &&
        Objects.equals(this.arrayMetadata, arrayTask.arrayMetadata) &&
        Objects.equals(this.subarray, arrayTask.subarray) &&
        Objects.equals(this.memory, arrayTask.memory) &&
        Objects.equals(this.cpu, arrayTask.cpu) &&
        Objects.equals(this.namespace, arrayTask.namespace) &&
        Objects.equals(this.status, arrayTask.status) &&
        Objects.equals(this.startTime, arrayTask.startTime) &&
        Objects.equals(this.finishTime, arrayTask.finishTime) &&
        Objects.equals(this.cost, arrayTask.cost) &&
        Objects.equals(this.egressCost, arrayTask.egressCost) &&
        Objects.equals(this.accessCost, arrayTask.accessCost) &&
        Objects.equals(this.queryType, arrayTask.queryType) &&
        Objects.equals(this.udfCode, arrayTask.udfCode) &&
        Objects.equals(this.udfLanguage, arrayTask.udfLanguage) &&
        Objects.equals(this.sqlQuery, arrayTask.sqlQuery) &&
        Objects.equals(this.type, arrayTask.type) &&
        Objects.equals(this.activity, arrayTask.activity) &&
        Objects.equals(this.logs, arrayTask.logs) &&
        Objects.equals(this.duration, arrayTask.duration) &&
        Objects.equals(this.sqlInitCommands, arrayTask.sqlInitCommands) &&
        Objects.equals(this.sqlParameters, arrayTask.sqlParameters) &&
        Objects.equals(this.resultFormat, arrayTask.resultFormat) &&
        Objects.equals(this.taskGraphUuid, arrayTask.taskGraphUuid) &&
        Objects.equals(this.clientNodeUuid, arrayTask.clientNodeUuid);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, name, description, arrayMetadata, subarray, memory, cpu, namespace, status, startTime, finishTime, cost, egressCost, accessCost, queryType, udfCode, udfLanguage, sqlQuery, type, activity, logs, duration, sqlInitCommands, sqlParameters, resultFormat, taskGraphUuid, clientNodeUuid);
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ArrayTask {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    arrayMetadata: ").append(toIndentedString(arrayMetadata)).append("\n");
    sb.append("    subarray: ").append(toIndentedString(subarray)).append("\n");
    sb.append("    memory: ").append(toIndentedString(memory)).append("\n");
    sb.append("    cpu: ").append(toIndentedString(cpu)).append("\n");
    sb.append("    namespace: ").append(toIndentedString(namespace)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    startTime: ").append(toIndentedString(startTime)).append("\n");
    sb.append("    finishTime: ").append(toIndentedString(finishTime)).append("\n");
    sb.append("    cost: ").append(toIndentedString(cost)).append("\n");
    sb.append("    egressCost: ").append(toIndentedString(egressCost)).append("\n");
    sb.append("    accessCost: ").append(toIndentedString(accessCost)).append("\n");
    sb.append("    queryType: ").append(toIndentedString(queryType)).append("\n");
    sb.append("    udfCode: ").append(toIndentedString(udfCode)).append("\n");
    sb.append("    udfLanguage: ").append(toIndentedString(udfLanguage)).append("\n");
    sb.append("    sqlQuery: ").append(toIndentedString(sqlQuery)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    activity: ").append(toIndentedString(activity)).append("\n");
    sb.append("    logs: ").append(toIndentedString(logs)).append("\n");
    sb.append("    duration: ").append(toIndentedString(duration)).append("\n");
    sb.append("    sqlInitCommands: ").append(toIndentedString(sqlInitCommands)).append("\n");
    sb.append("    sqlParameters: ").append(toIndentedString(sqlParameters)).append("\n");
    sb.append("    resultFormat: ").append(toIndentedString(resultFormat)).append("\n");
    sb.append("    taskGraphUuid: ").append(toIndentedString(taskGraphUuid)).append("\n");
    sb.append("    clientNodeUuid: ").append(toIndentedString(clientNodeUuid)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("id");
    openapiFields.add("name");
    openapiFields.add("description");
    openapiFields.add("array_metadata");
    openapiFields.add("subarray");
    openapiFields.add("memory");
    openapiFields.add("cpu");
    openapiFields.add("namespace");
    openapiFields.add("status");
    openapiFields.add("start_time");
    openapiFields.add("finish_time");
    openapiFields.add("cost");
    openapiFields.add("egress_cost");
    openapiFields.add("access_cost");
    openapiFields.add("query_type");
    openapiFields.add("udf_code");
    openapiFields.add("udf_language");
    openapiFields.add("sql_query");
    openapiFields.add("type");
    openapiFields.add("activity");
    openapiFields.add("logs");
    openapiFields.add("duration");
    openapiFields.add("sql_init_commands");
    openapiFields.add("sql_parameters");
    openapiFields.add("result_format");
    openapiFields.add("task_graph_uuid");
    openapiFields.add("client_node_uuid");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to ArrayTask
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (ArrayTask.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in ArrayTask is not found in the empty JSON string", ArrayTask.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
//      for (Entry<String, JsonElement> entry : entries) {
//        if (!ArrayTask.openapiFields.contains(entry.getKey())) {
//          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `ArrayTask` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
//        }
//      }
      if (jsonObj.get("id") != null && !jsonObj.get("id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("id").toString()));
      }
      if (jsonObj.get("name") != null && !jsonObj.get("name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("name").toString()));
      }
      if (jsonObj.get("description") != null && !jsonObj.get("description").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get("description").toString()));
      }
      // validate the optional field `array_metadata`
      if (jsonObj.getAsJsonObject("array_metadata") != null) {
        ArrayInfo.validateJsonObject(jsonObj.getAsJsonObject("array_metadata"));
      }
      // validate the optional field `subarray`
      if (jsonObj.getAsJsonObject("subarray") != null) {
        DomainArray.validateJsonObject(jsonObj.getAsJsonObject("subarray"));
      }
      if (jsonObj.get("namespace") != null && !jsonObj.get("namespace").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `namespace` to be a primitive type in the JSON string but got `%s`", jsonObj.get("namespace").toString()));
      }
      if (jsonObj.get("udf_code") != null && !jsonObj.get("udf_code").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `udf_code` to be a primitive type in the JSON string but got `%s`", jsonObj.get("udf_code").toString()));
      }
      if (jsonObj.get("udf_language") != null && !jsonObj.get("udf_language").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `udf_language` to be a primitive type in the JSON string but got `%s`", jsonObj.get("udf_language").toString()));
      }
      if (jsonObj.get("sql_query") != null && !jsonObj.get("sql_query").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `sql_query` to be a primitive type in the JSON string but got `%s`", jsonObj.get("sql_query").toString()));
      }
      JsonArray jsonArrayactivity = jsonObj.getAsJsonArray("activity");
      if (jsonArrayactivity != null) {
        // ensure the json data is an array
        if (!jsonObj.get("activity").isJsonArray()) {
          throw new IllegalArgumentException(String.format("Expected the field `activity` to be an array in the JSON string but got `%s`", jsonObj.get("activity").toString()));
        }

        // validate the optional field `activity` (array)
        for (int i = 0; i < jsonArrayactivity.size(); i++) {
          ArrayActivityLog.validateJsonObject(jsonArrayactivity.get(i).getAsJsonObject());
        };
      }
      if (jsonObj.get("logs") != null && !jsonObj.get("logs").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `logs` to be a primitive type in the JSON string but got `%s`", jsonObj.get("logs").toString()));
      }
      // ensure the json data is an array
      if (jsonObj.get("sql_init_commands") != null && !jsonObj.get("sql_init_commands").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `sql_init_commands` to be an array in the JSON string but got `%s`", jsonObj.get("sql_init_commands").toString()));
      }
      // ensure the json data is an array
      if (jsonObj.get("sql_parameters") != null && !jsonObj.get("sql_parameters").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `sql_parameters` to be an array in the JSON string but got `%s`", jsonObj.get("sql_parameters").toString()));
      }
      if (jsonObj.get("task_graph_uuid") != null && !jsonObj.get("task_graph_uuid").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `task_graph_uuid` to be a primitive type in the JSON string but got `%s`", jsonObj.get("task_graph_uuid").toString()));
      }
      if (jsonObj.get("client_node_uuid") != null && !jsonObj.get("client_node_uuid").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `client_node_uuid` to be a primitive type in the JSON string but got `%s`", jsonObj.get("client_node_uuid").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!ArrayTask.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'ArrayTask' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<ArrayTask> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(ArrayTask.class));

       return (TypeAdapter<T>) new TypeAdapter<ArrayTask>() {
           @Override
           public void write(JsonWriter out, ArrayTask value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public ArrayTask read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of ArrayTask given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of ArrayTask
  * @throws IOException if the JSON string is invalid with respect to ArrayTask
  */
  public static ArrayTask fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, ArrayTask.class);
  }

 /**
  * Convert an instance of ArrayTask to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

