/*
 * TileDB Storage Platform API
 * TileDB Storage Platform REST API
 *
 * The version of the OpenAPI document: 2.2.19
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.tiledb.cloud.rest_api.model;

import java.util.Objects;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.util.HashSet;
import java.util.Map.Entry;
import java.util.Set;

import io.tiledb.cloud.rest_api.JSON;

/**
 * Represents an attribute buffer header information
 */
@ApiModel(description = "Represents an attribute buffer header information")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-09-14T18:46:41.869452+03:00[Europe/Athens]")
public class AttributeBufferHeader {
  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_FIXED_LEN_BUFFER_SIZE_IN_BYTES = "fixedLenBufferSizeInBytes";
  @SerializedName(SERIALIZED_NAME_FIXED_LEN_BUFFER_SIZE_IN_BYTES)
  private Integer fixedLenBufferSizeInBytes;

  public static final String SERIALIZED_NAME_VAR_LEN_BUFFER_SIZE_IN_BYTES = "varLenBufferSizeInBytes";
  @SerializedName(SERIALIZED_NAME_VAR_LEN_BUFFER_SIZE_IN_BYTES)
  private Integer varLenBufferSizeInBytes;

  public AttributeBufferHeader() { 
  }

  public AttributeBufferHeader name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Attribute name
   * @return name
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "attribute1", required = true, value = "Attribute name")

  public String getName() {
    return name;
  }


  public void setName(String name) {
    this.name = name;
  }


  public AttributeBufferHeader fixedLenBufferSizeInBytes(Integer fixedLenBufferSizeInBytes) {
    
    this.fixedLenBufferSizeInBytes = fixedLenBufferSizeInBytes;
    return this;
  }

   /**
   * Number of bytes in the fixed-length attribute data buffer (offsets for var-len attributes)
   * @return fixedLenBufferSizeInBytes
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "Number of bytes in the fixed-length attribute data buffer (offsets for var-len attributes)")

  public Integer getFixedLenBufferSizeInBytes() {
    return fixedLenBufferSizeInBytes;
  }


  public void setFixedLenBufferSizeInBytes(Integer fixedLenBufferSizeInBytes) {
    this.fixedLenBufferSizeInBytes = fixedLenBufferSizeInBytes;
  }


  public AttributeBufferHeader varLenBufferSizeInBytes(Integer varLenBufferSizeInBytes) {
    
    this.varLenBufferSizeInBytes = varLenBufferSizeInBytes;
    return this;
  }

   /**
   * Number of bytes in the var-length attribute data buffer
   * @return varLenBufferSizeInBytes
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "Number of bytes in the var-length attribute data buffer")

  public Integer getVarLenBufferSizeInBytes() {
    return varLenBufferSizeInBytes;
  }


  public void setVarLenBufferSizeInBytes(Integer varLenBufferSizeInBytes) {
    this.varLenBufferSizeInBytes = varLenBufferSizeInBytes;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AttributeBufferHeader attributeBufferHeader = (AttributeBufferHeader) o;
    return Objects.equals(this.name, attributeBufferHeader.name) &&
        Objects.equals(this.fixedLenBufferSizeInBytes, attributeBufferHeader.fixedLenBufferSizeInBytes) &&
        Objects.equals(this.varLenBufferSizeInBytes, attributeBufferHeader.varLenBufferSizeInBytes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, fixedLenBufferSizeInBytes, varLenBufferSizeInBytes);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AttributeBufferHeader {\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    fixedLenBufferSizeInBytes: ").append(toIndentedString(fixedLenBufferSizeInBytes)).append("\n");
    sb.append("    varLenBufferSizeInBytes: ").append(toIndentedString(varLenBufferSizeInBytes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("name");
    openapiFields.add("fixedLenBufferSizeInBytes");
    openapiFields.add("varLenBufferSizeInBytes");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("name");
    openapiRequiredFields.add("fixedLenBufferSizeInBytes");
    openapiRequiredFields.add("varLenBufferSizeInBytes");
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to AttributeBufferHeader
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (AttributeBufferHeader.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in AttributeBufferHeader is not found in the empty JSON string", AttributeBufferHeader.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
//      for (Entry<String, JsonElement> entry : entries) {
//        if (!AttributeBufferHeader.openapiFields.contains(entry.getKey())) {
//          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `AttributeBufferHeader` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
//        }
//      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : AttributeBufferHeader.openapiRequiredFields) {
        if (jsonObj.get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
      }
      if (jsonObj.get("name") != null && !jsonObj.get("name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("name").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!AttributeBufferHeader.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'AttributeBufferHeader' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<AttributeBufferHeader> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(AttributeBufferHeader.class));

       return (TypeAdapter<T>) new TypeAdapter<AttributeBufferHeader>() {
           @Override
           public void write(JsonWriter out, AttributeBufferHeader value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public AttributeBufferHeader read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of AttributeBufferHeader given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of AttributeBufferHeader
  * @throws IOException if the JSON string is invalid with respect to AttributeBufferHeader
  */
  public static AttributeBufferHeader fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, AttributeBufferHeader.class);
  }

 /**
  * Convert an instance of AttributeBufferHeader to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

